/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.cli;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.NoSuchElementException;
import org.apache.daffodil.cli.CLIConf$exi$;
import org.apache.daffodil.cli.CLIConf$generate$;
import org.apache.daffodil.cli.CLIConf$parse$;
import org.apache.daffodil.cli.CLIConf$performance$;
import org.apache.daffodil.cli.CLIConf$save$;
import org.apache.daffodil.cli.CLIConf$test$;
import org.apache.daffodil.cli.CLIConf$unparse$;
import org.apache.daffodil.cli.InfosetType$;
import org.apache.daffodil.cli.ScallopExitException;
import org.apache.daffodil.cli.ValidatorPatterns$;
import org.apache.daffodil.lib.exceptions.UnsuppressableException;
import org.apache.daffodil.lib.iapi.TDMLImplementation;
import org.apache.daffodil.lib.iapi.TDMLImplementation$;
import org.apache.daffodil.lib.iapi.URISchemaSource;
import org.apache.daffodil.lib.iapi.URISchemaSource$;
import org.apache.daffodil.lib.util.Logger$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.lib.xml.QName$;
import org.apache.daffodil.lib.xml.RefQName;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.rogach.scallop.ArgType;
import org.rogach.scallop.ScallopConf;
import org.rogach.scallop.ScallopConf$;
import org.rogach.scallop.ScallopOption;
import org.rogach.scallop.ValueConverter;
import org.rogach.scallop.exceptions.GenericScallopException;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Try;
import scala.util.control.ControlThrowable;

public class CLIConf
extends ScallopConf {
    public static final long OFFSET$6 = LazyVals$.MODULE$.getOffsetStatic(CLIConf.class.getDeclaredField("exi$lzy1"));
    public static final long OFFSET$5 = LazyVals$.MODULE$.getOffsetStatic(CLIConf.class.getDeclaredField("generate$lzy1"));
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(CLIConf.class.getDeclaredField("performance$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(CLIConf.class.getDeclaredField("test$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(CLIConf.class.getDeclaredField("save$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(CLIConf.class.getDeclaredField("unparse$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CLIConf.class.getDeclaredField("parse$lzy1"));
    private final PrintStream stdout;
    private final PrintStream stderr;
    private final int width;
    private final ScallopOption verbose;
    private final ScallopOption version;
    private volatile Object parse$lzy1;
    private volatile Object unparse$lzy1;
    private volatile Object save$lzy1;
    private volatile Object test$lzy1;
    private volatile Object performance$lzy1;
    private volatile Object generate$lzy1;
    private volatile Object exi$lzy1;

    public CLIConf(String[] arguments, PrintStream stdout, PrintStream stderr) {
        this.stdout = stdout;
        this.stderr = stderr;
        super((Seq)Predef$.MODULE$.wrapRefArray((Object[])arguments), ScallopConf$.MODULE$.$lessinit$greater$default$2());
        this.printedName_$eq("Apache Daffodil");
        this.width = 87;
        this.helpWidth(this.width());
        this.errorMessageHandler_$eq((Function1)(JProcedure1 & Serializable)message -> {
            String msg = message.indexOf("Wrong format for option 'schema'") >= 0 ? "Options are not allowed after a trailing argument" : message;
            throw new GenericScallopException(msg);
        });
        this.exitHandler_$eq((Function1)(JFunction1.mcVI.sp & Serializable)n -> {
            throw new ScallopExitException(n);
        });
        this.stdoutPrintln_$eq((Function1)(JProcedure1 & Serializable)string -> stdout.println((String)string));
        this.stderrPrintln_$eq((Function1)(JProcedure1 & Serializable)string -> stderr.println((String)string));
        this.banner(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|Usage: daffodil [GLOBAL_OPTS] <subcommand> [SUBCOMMAND_OPTS]\n            |\n            |Global Options:")));
        this.footer(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|\n            |Run 'daffodil <subcommand> --help' for subcommand specific options")));
        String version = Misc$.MODULE$.getDaffodilVersion();
        String strVers = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.printedName(), version}));
        this.version(strVers);
        this.shortSubcommandsHelp(this.shortSubcommandsHelp$default$1());
        this.verbose = this.tally(this.tally$default$1(), this.tally$default$2(), "Increment verbosity level, one level for each -v", this.tally$default$4(), this.tally$default$5(), this.tally$default$6());
        this.version = this.opt(this.opt$default$1(), this.opt$default$2(), "Show Daffodil's version", this::$init$$$anonfun$5, this.opt$default$5(), this.opt$default$6(), this.opt$default$7(), this.opt$default$8(), this.opt$default$9(), this.opt$default$10(), org.rogach.scallop.package$.MODULE$.flagConverter());
        this.addSubcommand(this.parse());
        this.addSubcommand(this.unparse());
        this.addSubcommand(this.save());
        this.addSubcommand(this.test());
        this.addSubcommand(this.performance());
        this.addSubcommand(this.generate());
        this.addSubcommand(this.exi());
        this.requireSubcommand();
        this.verify();
    }

    public <A> ValueConverter<Option<A>> optionalValueConverter(Function1<String, A> conv) {
        return new ValueConverter<Option<A>>(conv){
            private final Function1 conv$1;
            private HashMap org$rogach$scallop$ValueConverter$$parseCache;
            private final ArgType.V argType;
            {
                this.conv$1 = conv$3;
                ValueConverter.$init$((ValueConverter)this);
                this.argType = ArgType.LIST$.MODULE$;
                Statics.releaseFence();
            }

            public HashMap org$rogach$scallop$ValueConverter$$parseCache() {
                return this.org$rogach$scallop$ValueConverter$$parseCache;
            }

            public void org$rogach$scallop$ValueConverter$_setter_$org$rogach$scallop$ValueConverter$$parseCache_$eq(HashMap x$0) {
                this.org$rogach$scallop$ValueConverter$$parseCache = x$0;
            }

            public Either parse(List s) {
                List list = s;
                Nil$ nil$ = package$.MODULE$.Nil();
                List list2 = list;
                if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                    return package$.MODULE$.Right().apply((Object)None$.MODULE$);
                }
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    Tuple2 tuple2 = (Tuple2)colon2.head();
                    List list3 = colon2.next$access$1();
                    if (tuple2 != null) {
                        List list4 = (List)tuple2._2();
                        Nil$ nil$2 = package$.MODULE$.Nil();
                        List list5 = list4;
                        if (!(nil$2 != null ? !nil$2.equals(list5) : list5 != null)) {
                            Nil$ nil$3 = package$.MODULE$.Nil();
                            List list6 = list3;
                            if (!(nil$3 != null ? !nil$3.equals(list6) : list6 != null)) {
                                return package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply((Object)None$.MODULE$));
                            }
                        }
                        if (list4 instanceof .colon.colon) {
                            .colon.colon colon3 = (.colon.colon)list4;
                            List list7 = colon3.next$access$1();
                            String v = (String)colon3.head();
                            Nil$ nil$4 = package$.MODULE$.Nil();
                            List list8 = list7;
                            if (!(nil$4 != null ? !nil$4.equals(list8) : list8 != null)) {
                                Nil$ nil$5 = package$.MODULE$.Nil();
                                List list9 = list3;
                                if (!(nil$5 != null ? !nil$5.equals(list9) : list9 != null)) {
                                    Left left;
                                    try {
                                        left = package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply((Object)Some$.MODULE$.apply(this.conv$1.apply((Object)v))));
                                    }
                                    catch (ControlThrowable s2) {
                                        throw s2;
                                    }
                                    catch (UnsuppressableException u) {
                                        throw u;
                                    }
                                    catch (Exception e) {
                                        left = package$.MODULE$.Left().apply((Object)e.getMessage());
                                    }
                                    return left;
                                }
                            }
                        }
                    }
                }
                return package$.MODULE$.Left().apply((Object)"you should provide no more than one argument for this option");
            }

            public ArgType.V argType() {
                return this.argType;
            }

            public String argFormat(String name) {
                return "[" + name + "]";
            }
        };
    }

    public ValueConverter<Tuple2<String, Option<URI>>> validateConverter(ScallopOption<URISchemaSource> schema, ScallopOption<File> parser) {
        return this.singleArgConverter((Function1 & Serializable)s -> {
            String string = s;
            if (string != null) {
                List list;
                List list2;
                Option option = ValidatorPatterns$.MODULE$.DefaultArgPattern().unapplySeq((CharSequence)string);
                if (!option.isEmpty() && (list2 = (List)option.get()).lengthCompare(2) == 0) {
                    String string2 = (String)list2.apply(0);
                    String string3 = (String)list2.apply(1);
                    String name = string2;
                    String arg = string3;
                    URI uri = this.fileResourceToURI(arg).uri();
                    return Tuple2$.MODULE$.apply((Object)name, (Object)Some$.MODULE$.apply((Object)uri));
                }
                Option option2 = ValidatorPatterns$.MODULE$.NoArgsPattern().unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && (list = (List)option2.get()).lengthCompare(1) == 0) {
                    String string4;
                    String name = string4 = (String)list.apply(0);
                    return Tuple2$.MODULE$.apply((Object)name, (Object)schema.map((Function1 & Serializable)_$1 -> _$1.uri()).toOption());
                }
            }
            throw new Exception("Missing Validator name.  Must be 'xerces', 'daffodil', 'schematron', 'off', or name of a custom validator.");
        });
    }

    public ValueConverter<Enumeration.Value> infosetTypeConverter() {
        return this.singleArgConverter((Function1 & Serializable)s -> {
            Enumeration.Value value;
            try {
                value = InfosetType$.MODULE$.withName(s.toLowerCase());
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new Exception(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unrecognized infoset type: %s.  Must be one of %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{s, InfosetType$.MODULE$.values().mkString(", ")})));
            }
            return value;
        });
    }

    public ValueConverter<TDMLImplementation> implementationConverter() {
        return this.singleArgConverter((Function1 & Serializable)s -> {
            Option optImplementation = TDMLImplementation$.MODULE$.optionStringToEnum("implementation", s);
            if (!optImplementation.isDefined()) {
                throw new Exception(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Unrecognized TDML implementation '%s'.  Must be one of %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{s, Predef$.MODULE$.wrapRefArray((Object[])TDMLImplementation$.MODULE$.values()).mkString(", ")})));
            }
            return (TDMLImplementation)optImplementation.get();
        });
    }

    public RefQName qnameConvert(String s) {
        Try eQN = QName$.MODULE$.refQNameFromExtendedSyntax(s);
        return (RefQName)eQN.get();
    }

    public <A> ValueConverter<A> singleArgConverter(Function1<String, A> conv) {
        return new ValueConverter<A>(conv){
            private final Function1 conv$2;
            private HashMap org$rogach$scallop$ValueConverter$$parseCache;
            private final ArgType.V argType;
            {
                this.conv$2 = conv$4;
                ValueConverter.$init$((ValueConverter)this);
                this.argType = ArgType.SINGLE$.MODULE$;
                Statics.releaseFence();
            }

            public HashMap org$rogach$scallop$ValueConverter$$parseCache() {
                return this.org$rogach$scallop$ValueConverter$$parseCache;
            }

            public void org$rogach$scallop$ValueConverter$_setter_$org$rogach$scallop$ValueConverter$$parseCache_$eq(HashMap x$0) {
                this.org$rogach$scallop$ValueConverter$$parseCache = x$0;
            }

            public Either parse(List s) {
                List list = s;
                if (list instanceof .colon.colon) {
                    List list2;
                    .colon.colon colon2 = (.colon.colon)list;
                    Tuple2 tuple2 = (Tuple2)colon2.head();
                    List list3 = colon2.next$access$1();
                    if (tuple2 != null && (list2 = (List)tuple2._2()) instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        List list4 = colon3.next$access$1();
                        String i = (String)colon3.head();
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list5 = list4;
                        if (!(nil$ != null ? !nil$.equals(list5) : list5 != null)) {
                            Nil$ nil$2 = package$.MODULE$.Nil();
                            List list6 = list3;
                            if (!(nil$2 != null ? !nil$2.equals(list6) : list6 != null)) {
                                Left left;
                                try {
                                    left = package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply(this.conv$2.apply((Object)i)));
                                }
                                catch (ControlThrowable s2) {
                                    throw s2;
                                }
                                catch (UnsuppressableException u) {
                                    throw u;
                                }
                                catch (Throwable e) {
                                    left = package$.MODULE$.Left().apply((Object)e.getMessage());
                                }
                                return left;
                            }
                        }
                    }
                }
                Nil$ nil$ = package$.MODULE$.Nil();
                List list7 = list;
                if (!(nil$ != null ? !nil$.equals(list7) : list7 != null)) {
                    return package$.MODULE$.Right().apply((Object)None$.MODULE$);
                }
                return package$.MODULE$.Left().apply((Object)"you should provide exactly one argument for this option");
            }

            public ArgType.V argType() {
                return this.argType;
            }
        };
    }

    public ValueConverter<RefQName> rootNSConverter() {
        return org.rogach.scallop.package$.MODULE$.singleArgConverter((Function1 & Serializable)s -> this.qnameConvert((String)s), org.rogach.scallop.package$.MODULE$.singleArgConverter$default$2());
    }

    public ValueConverter<URISchemaSource> fileResourceURIConverter() {
        return this.singleArgConverter((Function1 & Serializable)s -> this.fileResourceToURI((String)s));
    }

    private URISchemaSource fileResourceToURI(String path) {
        Tuple2 tuple2;
        Option optResolved;
        Option option;
        try {
            Path p;
            URI uri = File.separatorChar == '/' || path.startsWith("/") ? new URI(null, path, null) : ((p = Paths.get(path, new String[0])).isAbsolute() || path.startsWith("\\") ? p.toUri() : new URI(null, path.replace('\\', '/'), null));
            Path contextPath = Paths.get("fakeContext.dfdl.xsd", new String[0]);
            URISchemaSource contextSource = URISchemaSource$.MODULE$.apply(contextPath.toFile(), contextPath.toUri());
            option = XMLUtils$.MODULE$.resolveSchemaLocation(uri.toString(), (Option)Some$.MODULE$.apply((Object)contextSource));
        }
        catch (Exception exception) {
            throw new Exception("Could not find file or resource " + path);
        }
        Option option2 = optResolved = option;
        if (option2 instanceof Some && (tuple2 = (Tuple2)((Some)option2).value()) != null) {
            Logger LoggerImpl_this;
            URISchemaSource uriSchemaSource = (URISchemaSource)tuple2._1();
            boolean relToAbs = BoxesRunTime.unboxToBoolean((Object)tuple2._2());
            if (relToAbs && (LoggerImpl_this = Logger$.MODULE$.log()).underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("Found relative path on classpath absolutely, did you mean /{}", (Object)path);
            }
            return uriSchemaSource;
        }
        if (None$.MODULE$.equals(option2)) {
            throw new Exception("Could not find file or resource " + path);
        }
        throw new MatchError((Object)option2);
    }

    public int width() {
        return this.width;
    }

    public ScallopOption<Object> verbose() {
        return this.verbose;
    }

    public ScallopOption<Object> version() {
        return this.version;
    }

    public final CLIConf$parse$ parse() {
        Object object = this.parse$lzy1;
        if (object instanceof CLIConf$parse$) {
            return (CLIConf$parse$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CLIConf$parse$)this.parse$lzyINIT1();
    }

    private Object parse$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.parse$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CLIConf$parse$ cLIConf$parse$ = null;
                    try {
                        cLIConf$parse$ = new CLIConf$parse$(this);
                        object2 = cLIConf$parse$ == null ? LazyVals.NullValue$.MODULE$ : cLIConf$parse$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.parse$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return cLIConf$parse$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final CLIConf$unparse$ unparse() {
        Object object = this.unparse$lzy1;
        if (object instanceof CLIConf$unparse$) {
            return (CLIConf$unparse$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CLIConf$unparse$)this.unparse$lzyINIT1();
    }

    private Object unparse$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.unparse$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CLIConf$unparse$ cLIConf$unparse$ = null;
                    try {
                        cLIConf$unparse$ = new CLIConf$unparse$(this);
                        object2 = cLIConf$unparse$ == null ? LazyVals.NullValue$.MODULE$ : cLIConf$unparse$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.unparse$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return cLIConf$unparse$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final CLIConf$save$ save() {
        Object object = this.save$lzy1;
        if (object instanceof CLIConf$save$) {
            return (CLIConf$save$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CLIConf$save$)this.save$lzyINIT1();
    }

    private Object save$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.save$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CLIConf$save$ cLIConf$save$ = null;
                    try {
                        cLIConf$save$ = new CLIConf$save$(this);
                        object2 = cLIConf$save$ == null ? LazyVals.NullValue$.MODULE$ : cLIConf$save$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.save$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return cLIConf$save$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final CLIConf$test$ test() {
        Object object = this.test$lzy1;
        if (object instanceof CLIConf$test$) {
            return (CLIConf$test$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CLIConf$test$)this.test$lzyINIT1();
    }

    private Object test$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.test$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CLIConf$test$ cLIConf$test$ = null;
                    try {
                        cLIConf$test$ = new CLIConf$test$(this);
                        object2 = cLIConf$test$ == null ? LazyVals.NullValue$.MODULE$ : cLIConf$test$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.test$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return cLIConf$test$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final CLIConf$performance$ performance() {
        Object object = this.performance$lzy1;
        if (object instanceof CLIConf$performance$) {
            return (CLIConf$performance$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CLIConf$performance$)this.performance$lzyINIT1();
    }

    private Object performance$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.performance$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CLIConf$performance$ cLIConf$performance$ = null;
                    try {
                        cLIConf$performance$ = new CLIConf$performance$(this);
                        object2 = cLIConf$performance$ == null ? LazyVals.NullValue$.MODULE$ : cLIConf$performance$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.performance$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return cLIConf$performance$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final CLIConf$generate$ generate() {
        Object object = this.generate$lzy1;
        if (object instanceof CLIConf$generate$) {
            return (CLIConf$generate$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CLIConf$generate$)this.generate$lzyINIT1();
    }

    private Object generate$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.generate$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CLIConf$generate$ cLIConf$generate$ = null;
                    try {
                        cLIConf$generate$ = new CLIConf$generate$(this);
                        object2 = cLIConf$generate$ == null ? LazyVals.NullValue$.MODULE$ : cLIConf$generate$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.generate$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return cLIConf$generate$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$5, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final CLIConf$exi$ exi() {
        Object object = this.exi$lzy1;
        if (object instanceof CLIConf$exi$) {
            return (CLIConf$exi$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (CLIConf$exi$)this.exi$lzyINIT1();
    }

    private Object exi$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.exi$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    CLIConf$exi$ cLIConf$exi$ = null;
                    try {
                        cLIConf$exi$ = new CLIConf$exi$(this);
                        object2 = cLIConf$exi$ == null ? LazyVals.NullValue$.MODULE$ : cLIConf$exi$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.exi$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return cLIConf$exi$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$6, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private final Option $init$$$anonfun$5() {
        return this.opt$default$4();
    }

    private static final Some default$1$1() {
        return Some$.MODULE$.apply((Object)InfosetType$.MODULE$.XML());
    }

    public static final Option org$apache$daffodil$cli$CLIConf$parse$$$_$$lessinit$greater$$anonfun$7() {
        return CLIConf.default$1$1();
    }

    private static final Some default$2$1() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public static final Option org$apache$daffodil$cli$CLIConf$parse$$$_$$lessinit$greater$$anonfun$13() {
        return CLIConf.default$2$1();
    }

    private static final Some default$3$1() {
        return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)"off", (Object)None$.MODULE$));
    }

    public static final Option org$apache$daffodil$cli$CLIConf$parse$$$_$$lessinit$greater$$anonfun$14() {
        return CLIConf.default$3$1();
    }

    public static final /* synthetic */ String org$apache$daffodil$cli$CLIConf$parse$$$_$$lessinit$greater$$anonfun$16(String a) {
        return a;
    }

    public static final /* synthetic */ Either org$apache$daffodil$cli$CLIConf$parse$$$_$$lessinit$greater$$anonfun$19(Option x$1, Option x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)x$2);
        if (tuple2 != null) {
            Option option = (Option)tuple2._2();
            if (tuple2._1() instanceof Some && (option instanceof Some && "-".equals(((Some)option).value()) || None$.MODULE$.equals(option))) {
                return package$.MODULE$.Left().apply((Object)"Input must not be stdin during interactive debugging");
            }
        }
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    public static final /* synthetic */ Either org$apache$daffodil$cli$CLIConf$parse$$$_$$lessinit$greater$$anonfun$20(Option x$1, Option x$2, Option x$3) {
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)x$1, (Object)x$2, (Object)x$3);
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            Option option2 = (Option)tuple3._2();
            if (option instanceof Some) {
                Enumeration.Value value = (Enumeration.Value)((Some)option).value();
                Enumeration.Value value2 = InfosetType$.MODULE$.EXI();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    if (option2 instanceof Some && BoxesRunTime.unboxToBoolean((Object)((Some)option2).value())) {
                        return package$.MODULE$.Left().apply((Object)"Streaming mode is not currently supported with EXI infosets.");
                    }
                }
                Enumeration.Value value4 = InfosetType$.MODULE$.EXISA();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    if (option2 instanceof Some && BoxesRunTime.unboxToBoolean((Object)((Some)option2).value())) {
                        return package$.MODULE$.Left().apply((Object)"Streaming mode is not currently supported with EXI infosets.");
                    }
                    if (None$.MODULE$.equals(tuple3._3())) {
                        return package$.MODULE$.Left().apply((Object)"A schema must be specified to use schema-aware compression with EXI");
                    }
                }
            }
        }
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private static final Some default$4$1() {
        return Some$.MODULE$.apply((Object)InfosetType$.MODULE$.XML());
    }

    public static final Option org$apache$daffodil$cli$CLIConf$unparse$$$_$$lessinit$greater$$anonfun$22() {
        return CLIConf.default$4$1();
    }

    private static final Some default$5$1() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public static final Option org$apache$daffodil$cli$CLIConf$unparse$$$_$$lessinit$greater$$anonfun$28() {
        return CLIConf.default$5$1();
    }

    private static final Some default$6$1() {
        return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)"off", (Object)None$.MODULE$));
    }

    public static final Option org$apache$daffodil$cli$CLIConf$unparse$$$_$$lessinit$greater$$anonfun$29() {
        return CLIConf.default$6$1();
    }

    public static final /* synthetic */ String org$apache$daffodil$cli$CLIConf$unparse$$$_$$lessinit$greater$$anonfun$31(String a) {
        return a;
    }

    public static final /* synthetic */ Either org$apache$daffodil$cli$CLIConf$unparse$$$_$$lessinit$greater$$anonfun$34(Option x$1, Option x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)x$2);
        if (tuple2 != null) {
            Option option = (Option)tuple2._2();
            if (tuple2._1() instanceof Some && (option instanceof Some && "-".equals(((Some)option).value()) || None$.MODULE$.equals(option))) {
                return package$.MODULE$.Left().apply((Object)"Input must not be stdin during interactive debugging");
            }
        }
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    public static final /* synthetic */ Either org$apache$daffodil$cli$CLIConf$unparse$$$_$$lessinit$greater$$anonfun$35(Option x$1, Option x$2, Option x$3) {
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)x$1, (Object)x$2, (Object)x$3);
        if (tuple3 != null) {
            Option option = (Option)tuple3._1();
            Option option2 = (Option)tuple3._2();
            if (option instanceof Some) {
                Enumeration.Value value = (Enumeration.Value)((Some)option).value();
                Enumeration.Value value2 = InfosetType$.MODULE$.EXI();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    if (option2 instanceof Some && BoxesRunTime.unboxToBoolean((Object)((Some)option2).value())) {
                        return package$.MODULE$.Left().apply((Object)"Streaming mode is not currently supported with EXI infosets.");
                    }
                }
                Enumeration.Value value4 = InfosetType$.MODULE$.EXISA();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    if (option2 instanceof Some && BoxesRunTime.unboxToBoolean((Object)((Some)option2).value())) {
                        return package$.MODULE$.Left().apply((Object)"Streaming mode is not currently supported with EXI infosets.");
                    }
                    if (None$.MODULE$.equals(tuple3._3())) {
                        return package$.MODULE$.Left().apply((Object)"A schema must be specified to use schema-aware compression with EXI");
                    }
                }
            }
        }
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    private static final None$ default$7$1() {
        return None$.MODULE$;
    }

    public static final Option org$apache$daffodil$cli$CLIConf$test$$$_$$lessinit$greater$$anonfun$41() {
        return CLIConf.default$7$1();
    }

    public static final /* synthetic */ String org$apache$daffodil$cli$CLIConf$test$$$_$$lessinit$greater$$anonfun$45(String a) {
        return a;
    }

    private static final Some default$8$1() {
        return Some$.MODULE$.apply((Object)InfosetType$.MODULE$.XML());
    }

    public static final Option org$apache$daffodil$cli$CLIConf$performance$$$_$$lessinit$greater$$anonfun$50() {
        return CLIConf.default$8$1();
    }

    private static final Some default$9$1() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
    }

    public static final Option org$apache$daffodil$cli$CLIConf$performance$$$_$$lessinit$greater$$anonfun$51() {
        return CLIConf.default$9$1();
    }

    private static final Some default$10$1() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
    }

    public static final Option org$apache$daffodil$cli$CLIConf$performance$$$_$$lessinit$greater$$anonfun$56() {
        return CLIConf.default$10$1();
    }

    private static final Some default$11$1() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public static final Option org$apache$daffodil$cli$CLIConf$performance$$$_$$lessinit$greater$$anonfun$57() {
        return CLIConf.default$11$1();
    }

    private static final Some default$12$1() {
        return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)"off", (Object)None$.MODULE$));
    }

    public static final Option org$apache$daffodil$cli$CLIConf$performance$$$_$$lessinit$greater$$anonfun$58() {
        return CLIConf.default$12$1();
    }

    public static final /* synthetic */ Either org$apache$daffodil$cli$CLIConf$performance$$$_$$lessinit$greater$$anonfun$60(Option x$1, Option x$2) {
        Option option;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)x$2);
        if (tuple2 != null && (option = (Option)tuple2._1()) instanceof Some) {
            Enumeration.Value value = InfosetType$.MODULE$.EXISA();
            Object object = ((Some)option).value();
            if (!(value != null ? !value.equals(object) : object != null) && None$.MODULE$.equals(tuple2._2())) {
                return package$.MODULE$.Left().apply((Object)"A schema must be specified to use schema-aware compression with EXI");
            }
        }
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    public static final String org$apache$daffodil$cli$CLIConf$generate$$$_$c$$superArg$1$$anonfun$1() {
        return "c";
    }

    private static final Some default$14$1() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public static final Option org$apache$daffodil$cli$CLIConf$exi$$$_$$lessinit$greater$$anonfun$67() {
        return CLIConf.default$14$1();
    }
}

