/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.commons.text.lookup.XmlStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.SetSystemProperty;

class XmlStringLookupTest {
    static final String DATA = "Hello World!";
    static final Map<String, Boolean> EMPTY_MAP = Collections.emptyMap();
    private static final Path CURRENT_PATH = Paths.get("", new String[0]);
    private static final Path ABSENT_PATH = Paths.get("does not exist at all", new String[0]);
    static final String DOC_DIR = "src/test/resources/org/apache/commons/text/";
    private static final String DOC_RELATIVE = "src/test/resources/org/apache/commons/text/document.xml";
    private static final String DOC_ROOT = "/document.xml";

    XmlStringLookupTest() {
    }

    static void assertLookup(StringLookup xmlStringLookup) {
        Assertions.assertNotNull((Object)xmlStringLookup);
        Assertions.assertInstanceOf(XmlStringLookup.class, (Object)xmlStringLookup);
        Assertions.assertEquals((Object)DATA, (Object)xmlStringLookup.apply("src/test/resources/org/apache/commons/text/document.xml:/root/path/to/node"));
        Assertions.assertNull((Object)xmlStringLookup.apply(null));
    }

    @Test
    void testBadXPath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> XmlStringLookup.INSTANCE.apply("docName"));
    }

    @Test
    void testExternalEntityOff() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new XmlStringLookup(XmlStringLookup.DEFAULT_XML_FEATURES, EMPTY_MAP, new Path[0]).apply("src/test/resources/org/apache/commons/text/document-entity-ref.xml:/document/content"));
    }

    @Test
    void testExternalEntityOn() {
        String key = "src/test/resources/org/apache/commons/text/document-entity-ref.xml:/document/content";
        Assertions.assertEquals((Object)DATA, (Object)new XmlStringLookup(EMPTY_MAP, EMPTY_MAP, new Path[0]).apply("src/test/resources/org/apache/commons/text/document-entity-ref.xml:/document/content").trim());
        Assertions.assertEquals((Object)DATA, (Object)new XmlStringLookup(EMPTY_MAP, XmlStringLookup.DEFAULT_XPATH_FEATURES, new Path[0]).apply("src/test/resources/org/apache/commons/text/document-entity-ref.xml:/document/content").trim());
    }

    @Test
    void testInterpolatorExternalDtdOff() {
        StringSubstitutor stringSubstitutor = StringSubstitutor.createInterpolator();
        Assertions.assertThrows(IllegalArgumentException.class, () -> stringSubstitutor.replace("${xml:src/test/resources/org/apache/commons/text/document-external-dtd.xml:/document/content}"));
    }

    @Test
    @SetSystemProperty(key="javax.xml.accessExternalDTD", value="file")
    void testInterpolatorExternalDtdOn() {
        StringSubstitutor stringSubstitutor = StringSubstitutor.createInterpolator();
        Assertions.assertEquals((Object)"This is an external entity.", (Object)stringSubstitutor.replace("${xml:src/test/resources/org/apache/commons/text/document-external-dtd.xml:/document/content}").trim());
    }

    @Test
    void testInterpolatorExternalEntityOff() {
        StringSubstitutor stringSubstitutor = StringSubstitutor.createInterpolator();
        Assertions.assertThrows(IllegalArgumentException.class, () -> stringSubstitutor.replace("${xml:src/test/resources/org/apache/commons/text/document-entity-ref.xml:/document/content}"));
    }

    @Test
    @SetSystemProperty(key="javax.xml.accessExternalDTD", value="file")
    void testInterpolatorExternalEntityOffOverride() {
        StringSubstitutor stringSubstitutor = StringSubstitutor.createInterpolator();
        Assertions.assertEquals((Object)DATA, (Object)stringSubstitutor.replace("${xml:src/test/resources/org/apache/commons/text/document-entity-ref.xml:/document/content}").trim());
    }

    @Test
    void testInterpolatorExternalEntityOn() {
        StringSubstitutor stringSubstitutor = StringSubstitutor.createInterpolator();
        Assertions.assertThrows(IllegalArgumentException.class, () -> stringSubstitutor.replace("${xml:src/test/resources/org/apache/commons/text/document-entity-ref.xml:/document/content}"));
    }

    @Test
    void testInterpolatorExternalEntityOnOverride() {
        StringSubstitutor stringSubstitutor = StringSubstitutor.createInterpolator();
        Assertions.assertThrows(IllegalArgumentException.class, () -> stringSubstitutor.replace("${xml:src/test/resources/org/apache/commons/text/document-entity-ref.xml:/document/content}"));
    }

    @Test
    void testInterpolatorSecureOnBla() {
        StringSubstitutor stringSubstitutor = StringSubstitutor.createInterpolator();
        Assertions.assertThrows(IllegalArgumentException.class, () -> stringSubstitutor.replace("${xml:src/test/resources/org/apache/commons/text/bla.xml:/document/content}"));
    }

    @Test
    void testMissingXPath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> XmlStringLookup.INSTANCE.apply("src/test/resources/org/apache/commons/text/document.xml:!JUNK!"));
    }

    @Test
    void testNoFeatures() {
        String xpath = "/root/path/to/node";
        Assertions.assertEquals((Object)DATA, (Object)new XmlStringLookup(EMPTY_MAP, EMPTY_MAP, new Path[0]).apply("src/test/resources/org/apache/commons/text/document.xml:/root/path/to/node"));
        Assertions.assertEquals((Object)DATA, (Object)new XmlStringLookup(EMPTY_MAP, EMPTY_MAP, new Path[0]).apply("src/test/resources/org/apache/commons/text/document.xml:/root/path/to/node"));
        Assertions.assertEquals((Object)DATA, (Object)new XmlStringLookup(EMPTY_MAP, EMPTY_MAP, new Path[]{CURRENT_PATH, ABSENT_PATH}).apply("src/test/resources/org/apache/commons/text/document.xml:/root/path/to/node"));
        Assertions.assertEquals((Object)DATA, (Object)new XmlStringLookup(EMPTY_MAP, EMPTY_MAP, new Path[]{ABSENT_PATH, CURRENT_PATH}).apply("src/test/resources/org/apache/commons/text/document.xml:/root/path/to/node"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new XmlStringLookup(EMPTY_MAP, EMPTY_MAP, new Path[]{ABSENT_PATH}).apply("/document.xml:/root/path/to/node"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new XmlStringLookup(EMPTY_MAP, EMPTY_MAP, new Path[]{CURRENT_PATH}).apply("/document.xml:/root/path/to/node"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new XmlStringLookup(EMPTY_MAP, EMPTY_MAP, new Path[]{ABSENT_PATH, CURRENT_PATH}).apply("/document.xml:/root/path/to/node"));
    }

    @Test
    void testNoFeaturesDefault() {
        HashMap<String, Boolean> features = new HashMap<String, Boolean>(1);
        features.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        XmlStringLookupTest.assertLookup((StringLookup)new XmlStringLookup(EMPTY_MAP, features, new Path[0]));
    }

    @Test
    void testNull() {
        Assertions.assertNull((Object)XmlStringLookup.INSTANCE.apply(null));
    }

    @Test
    void testOne() {
        XmlStringLookupTest.assertLookup((StringLookup)XmlStringLookup.INSTANCE);
    }

    @Test
    void testToString() {
        Assertions.assertFalse((boolean)XmlStringLookup.INSTANCE.toString().isEmpty());
    }
}

