/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.text.similarity.CosineDistance;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class CosineDistanceTest {
    private static CosineDistance cosineDistance;

    @BeforeAll
    public static void setUp() {
        cosineDistance = new CosineDistance();
    }

    @Test
    public void testCosineDistance() {
        Assertions.assertThat((Double)this.roundValue(cosineDistance.apply((CharSequence)"the house", (CharSequence)"da house"))).isEqualTo((Object)0.5);
        Assertions.assertThat((Double)this.roundValue(cosineDistance.apply((CharSequence)"AB", (CharSequence)"AB"))).isEqualTo((Object)0.0);
        Assertions.assertThat((Double)this.roundValue(cosineDistance.apply((CharSequence)"AB", (CharSequence)"BA"))).isEqualTo((Object)1.0);
        Assertions.assertThat((Double)this.roundValue(cosineDistance.apply((CharSequence)"the boy was from tamana shi, kumamoto ken, and the girl was from rio de janeiro, rio", (CharSequence)"the boy was from tamana shi, kumamoto, and the boy was from rio de janeiro, rio de janeiro"))).isEqualTo((Object)0.08);
    }

    private Double roundValue(Double value) {
        return new BigDecimal(value).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }
}

