/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.Waiter;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class WaiterFactory<K>
implements PooledObjectFactory<Waiter>,
KeyedPooledObjectFactory<K, Waiter> {
    private static final Integer ZERO = 0;
    private static final Integer ONE = 1;
    private final long activateLatency;
    private final long destroyLatency;
    private final long makeLatency;
    private final long passivateLatency;
    private final long validateLatency;
    private final long waiterLatency;
    private final double passivateInvalidationProbability;
    private long activeCount;
    private final Map<K, Integer> activeCounts = new HashMap<K, Integer>();
    private final long maxActive;
    private final long maxActivePerKey;

    public WaiterFactory(long activateLatency, long destroyLatency, long makeLatency, long passivateLatency, long validateLatency, long waiterLatency) {
        this(activateLatency, destroyLatency, makeLatency, passivateLatency, validateLatency, waiterLatency, Long.MAX_VALUE, Long.MAX_VALUE, 0.0);
    }

    public WaiterFactory(long activateLatency, long destroyLatency, long makeLatency, long passivateLatency, long validateLatency, long waiterLatency, long maxActive) {
        this(activateLatency, destroyLatency, makeLatency, passivateLatency, validateLatency, waiterLatency, maxActive, Long.MAX_VALUE, 0.0);
    }

    public WaiterFactory(long activateLatency, long destroyLatency, long makeLatency, long passivateLatency, long validateLatency, long waiterLatency, long maxActive, long maxActivePerKey, double passivateInvalidationProbability) {
        this.activateLatency = activateLatency;
        this.destroyLatency = destroyLatency;
        this.makeLatency = makeLatency;
        this.passivateLatency = passivateLatency;
        this.validateLatency = validateLatency;
        this.waiterLatency = waiterLatency;
        this.maxActive = maxActive;
        this.maxActivePerKey = maxActivePerKey;
        this.passivateInvalidationProbability = passivateInvalidationProbability;
    }

    public void activateObject(K key, PooledObject<Waiter> obj) {
        this.activateObject(obj);
    }

    public void activateObject(PooledObject<Waiter> obj) {
        this.doWait(this.activateLatency);
        ((Waiter)obj.getObject()).setActive(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(K key, PooledObject<Waiter> obj) {
        this.destroyObject(obj);
        WaiterFactory waiterFactory = this;
        synchronized (waiterFactory) {
            this.activeCounts.computeIfPresent(key, (k, v) -> v - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyObject(PooledObject<Waiter> obj) {
        this.doWait(this.destroyLatency);
        ((Waiter)obj.getObject()).setValid(false);
        ((Waiter)obj.getObject()).setActive(false);
        WaiterFactory waiterFactory = this;
        synchronized (waiterFactory) {
            --this.activeCount;
        }
    }

    protected void doWait(long latency) {
        if (latency == 0L) {
            return;
        }
        Waiter.sleepQuietly(latency);
    }

    public synchronized long getMaxActive() {
        return this.maxActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledObject<Waiter> makeObject() {
        WaiterFactory waiterFactory = this;
        synchronized (waiterFactory) {
            if (this.activeCount >= this.maxActive) {
                throw new IllegalStateException("Too many active instances: " + this.activeCount + " in circulation with maxActive = " + this.maxActive);
            }
            ++this.activeCount;
        }
        this.doWait(this.makeLatency);
        return new DefaultPooledObject((Object)new Waiter(false, true, this.waiterLatency));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PooledObject<Waiter> makeObject(K key) {
        WaiterFactory waiterFactory = this;
        synchronized (waiterFactory) {
            this.activeCounts.merge(key, ONE, (v1, v2) -> {
                if ((long)v1.intValue() >= this.maxActivePerKey) {
                    throw new IllegalStateException("Too many active instances for key = " + key + ": " + v1 + " in circulation with maxActivePerKey = " + this.maxActivePerKey);
                }
                return v1 + 1;
            });
        }
        return this.makeObject();
    }

    public void passivateObject(K key, PooledObject<Waiter> obj) {
        this.passivateObject(obj);
    }

    public void passivateObject(PooledObject<Waiter> obj) {
        ((Waiter)obj.getObject()).setActive(false);
        this.doWait(this.passivateLatency);
        if (Math.random() < this.passivateInvalidationProbability) {
            ((Waiter)obj.getObject()).setValid(false);
        }
    }

    public synchronized void reset() {
        this.activeCount = 0L;
        if (this.activeCounts.isEmpty()) {
            return;
        }
        this.activeCounts.keySet().forEach(key -> this.activeCounts.put(key, ZERO));
    }

    public boolean validateObject(K key, PooledObject<Waiter> obj) {
        return this.validateObject(obj);
    }

    public boolean validateObject(PooledObject<Waiter> obj) {
        this.doWait(this.validateLatency);
        return ((Waiter)obj.getObject()).isValid();
    }
}

