/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.tree.ConfigurationNodeVisitor;
import org.apache.commons.configuration2.tree.ConfigurationNodeVisitorAdapter;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeKeyResolver;
import org.apache.commons.configuration2.tree.NodeSelector;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.apache.commons.configuration2.tree.NodeTreeWalker;
import org.apache.commons.configuration2.tree.ReferenceNodeHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestInMemoryNodeModelReferences {
    private NodeKeyResolver<ImmutableNode> resolver;
    private InMemoryNodeModel model;

    private Collection<ImmutableNode> collectNodes(ImmutableNode root) {
        final HashSet<ImmutableNode> nodes = new HashSet<ImmutableNode>();
        NodeTreeWalker.INSTANCE.walkBFS((Object)root, (ConfigurationNodeVisitor)new ConfigurationNodeVisitorAdapter<ImmutableNode>(){

            public void visitBeforeChildren(ImmutableNode node, NodeHandler<ImmutableNode> handler) {
                nodes.add(node);
            }
        }, this.model.getNodeHandler());
        return nodes;
    }

    private Map<ImmutableNode, String> createReferences() {
        Collection<ImmutableNode> nodes = this.collectNodes(NodeStructureHelper.ROOT_AUTHORS_TREE);
        nodes.remove(NodeStructureHelper.ROOT_AUTHORS_TREE);
        HashMap<ImmutableNode, String> refs = new HashMap<ImmutableNode, String>();
        for (ImmutableNode node : nodes) {
            refs.put(node, node.getNodeName());
        }
        return refs;
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.resolver = NodeStructureHelper.createResolverMock();
        NodeStructureHelper.prepareResolveKeyForQueries(this.resolver);
        NodeStructureHelper.prepareResolveAddKeys(this.resolver);
        this.model = new InMemoryNodeModel();
        Map<ImmutableNode, String> references = this.createReferences();
        this.model.mergeRoot(NodeStructureHelper.ROOT_AUTHORS_TREE, null, references, (Object)NodeStructureHelper.ROOT_AUTHORS_TREE.getNodeName(), this.resolver);
    }

    @Test
    void testMergeRootOverrideName() {
        ImmutableNode node = NodeStructureHelper.createNode("newNode", null);
        String newName = "newRootNode";
        this.model.mergeRoot(node, "newRootNode", null, null, this.resolver);
        ImmutableNode root = (ImmutableNode)this.model.getNodeHandler().getRootNode();
        Assertions.assertEquals((Object)"newRootNode", (Object)root.getNodeName());
    }

    @Test
    void testMergeRootReference() {
        Long rootRef = 20140404210508L;
        ImmutableNode node = NodeStructureHelper.createNode("newNode", null);
        this.model.mergeRoot(node, null, null, (Object)rootRef, this.resolver);
        ReferenceNodeHandler refHandler = this.model.getReferenceNodeHandler();
        ImmutableNode checkNode = NodeStructureHelper.nodeForKey(this.model, "Simmons/Ilium");
        Assertions.assertEquals((Object)checkNode.getNodeName(), (Object)refHandler.getReference(checkNode));
        Assertions.assertEquals((Object)rootRef, (Object)refHandler.getReference((ImmutableNode)refHandler.getRootNode()));
    }

    @Test
    void testMergeRootWithAttributes() {
        ImmutableNode node = new ImmutableNode.Builder().addAttribute("key", (Object)"value").create();
        this.model.mergeRoot(node, null, null, null, this.resolver);
        ImmutableNode root = (ImmutableNode)this.model.getNodeHandler().getRootNode();
        Assertions.assertEquals(Collections.singletonMap("key", "value"), (Object)root.getAttributes());
    }

    @Test
    void testMergeRootWithValue() {
        ImmutableNode node = NodeStructureHelper.createNode("newNode", "test");
        this.model.mergeRoot(node, null, null, null, this.resolver);
        ImmutableNode root = (ImmutableNode)this.model.getNodeHandler().getRootNode();
        Assertions.assertEquals((Object)NodeStructureHelper.ROOT_AUTHORS_TREE.getNodeName(), (Object)root.getNodeName());
        Assertions.assertEquals((Object)"test", (Object)root.getValue());
    }

    @Test
    void testQueryReferences() {
        ReferenceNodeHandler handler = this.model.getReferenceNodeHandler();
        Collection<ImmutableNode> nodes = this.collectNodes((ImmutableNode)handler.getRootNode());
        for (ImmutableNode node : nodes) {
            Assertions.assertEquals((Object)node.getNodeName(), (Object)handler.getReference(node));
        }
    }

    @Test
    void testQueryReferencesAfterUpdate() {
        this.model.addProperty("Simmons.Hyperion", Collections.singleton("Lamia"), this.resolver);
        ReferenceNodeHandler handler = this.model.getReferenceNodeHandler();
        Assertions.assertEquals((Object)"Hyperion", (Object)handler.getReference(NodeStructureHelper.nodeForKey(this.model, "Simmons/Hyperion")));
        Assertions.assertEquals((Object)"Simmons", (Object)handler.getReference(NodeStructureHelper.nodeForKey(this.model, "Simmons")));
    }

    @Test
    void testQueryReferenceUnknown() {
        ReferenceNodeHandler handler = this.model.getReferenceNodeHandler();
        Assertions.assertNull((Object)handler.getReference(new ImmutableNode.Builder().create()));
    }

    @Test
    void testQueryRemovedReferencesAfterRemove() {
        this.model.clearTree("Simmons", this.resolver);
        ReferenceNodeHandler handler = this.model.getReferenceNodeHandler();
        List removedRefs = handler.removedReferences();
        int authorIdx = 2;
        for (int i = 0; i < NodeStructureHelper.worksLength(2); ++i) {
            Assertions.assertTrue((boolean)removedRefs.contains(NodeStructureHelper.work(2, i)), (String)("Work not found: " + i));
            for (int j = 0; j < NodeStructureHelper.personaeLength(2, i); ++j) {
                Assertions.assertTrue((boolean)removedRefs.contains(NodeStructureHelper.persona(2, i, j)), (String)("Persona not found: " + j));
            }
        }
    }

    @Test
    void testQueryRemovedReferencesEmpty() {
        ReferenceNodeHandler handler = this.model.getReferenceNodeHandler();
        Assertions.assertTrue((boolean)handler.removedReferences().isEmpty());
    }

    @Test
    void testRemovedReferencesModify() {
        this.model.clearTree("Simmons", this.resolver);
        ReferenceNodeHandler handler = this.model.getReferenceNodeHandler();
        List removedRefs = handler.removedReferences();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> removedRefs.add("another one"));
    }

    @Test
    void testReplaceRoot() {
        NodeSelector selector = new NodeSelector("Simmons.Hyperion");
        this.model.trackNode(selector, this.resolver);
        ImmutableNode trackedNode = this.model.getTrackedNode(selector);
        this.model.addProperty("Simmons.Hyperion.Lamia", Collections.singleton("new person"), this.resolver);
        this.model.replaceRoot(NodeStructureHelper.ROOT_AUTHORS_TREE, this.resolver);
        ImmutableNode node = this.model.getTrackedNode(selector);
        Assertions.assertEquals((Object)trackedNode, (Object)node);
        Assertions.assertFalse((boolean)this.model.isTrackedNodeDetached(selector));
        Assertions.assertNull((Object)this.model.getReferenceNodeHandler().getReference(trackedNode));
    }

    @Test
    void testReplaceRootNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.model.replaceRoot(null, this.resolver));
    }
}

