/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.UnmodifiableIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class UnmodifiableIteratorTest<E>
extends AbstractIteratorTest<E> {
    protected String[] testArray = new String[]{"One", "Two", "Three"};
    protected List<E> testList;

    @Override
    public Iterator<E> makeEmptyIterator() {
        return UnmodifiableIterator.unmodifiableIterator(Collections.emptyList().iterator());
    }

    @Override
    public Iterator<E> makeObject() {
        return UnmodifiableIterator.unmodifiableIterator(this.testList.iterator());
    }

    @BeforeEach
    protected void setUp() throws Exception {
        this.testList = new ArrayList<Object>(Arrays.asList((Object[])this.testArray));
    }

    @Override
    public boolean supportsRemove() {
        return false;
    }

    @Test
    public void testDecorateFactory() {
        Iterator<E> it = this.makeObject();
        Assertions.assertSame((Object)it, (Object)UnmodifiableIterator.unmodifiableIterator((Iterator)it));
        it = this.testList.iterator();
        Assertions.assertNotSame(it, (Object)UnmodifiableIterator.unmodifiableIterator(it));
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableIterator.unmodifiableIterator(null));
    }

    @Test
    public void testIterator() {
        Assertions.assertTrue((boolean)(this.makeEmptyIterator() instanceof Unmodifiable));
    }
}

