/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.swing;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.BindingExpression;
import org.apache.cayenne.swing.BindingFactory;
import org.apache.cayenne.swing.ObjectBinding;

public class TableBindingBuilder {
    protected BindingBuilder helper;
    protected List columns;

    public TableBindingBuilder(BindingFactory factory, Object context) {
        this(new BindingBuilder(factory, context));
    }

    public TableBindingBuilder(BindingBuilder helper) {
        this.helper = helper;
    }

    public ObjectBinding bindToTable(JTable table, String listBinding) {
        int width = this.columns != null ? this.columns.size() : 0;
        String[] headers = new String[width];
        BindingExpression[] expressions = new BindingExpression[width];
        Class[] classes = new Class[width];
        boolean[] editableState = new boolean[width];
        Object[] sampleLongValues = new Object[width];
        for (int i = 0; i < width; ++i) {
            ColumnDescriptor descriptor = (ColumnDescriptor)this.columns.get(i);
            headers[i] = descriptor.header;
            expressions[i] = descriptor.expression;
            classes[i] = descriptor.columnClass;
            editableState[i] = descriptor.editable;
            sampleLongValues[i] = descriptor.sampleLongValue;
        }
        ObjectBinding binding = this.helper.getFactory().bindToTable(table, listBinding, headers, expressions, classes, editableState, sampleLongValues);
        return this.helper.initBinding(binding, this.helper.getDelegate());
    }

    public void addColumn(String header, String expression, Class columnClass, boolean editable) {
        this.addColumn(header, expression, columnClass, editable, null);
    }

    public void addColumn(String header, String expression, Class columnClass, boolean editable, Object sampleLongValue) {
        if (this.columns == null) {
            this.columns = new ArrayList();
        }
        this.columns.add(new ColumnDescriptor(header, new BindingExpression(expression), columnClass, editable, sampleLongValue));
    }

    final class ColumnDescriptor {
        String header;
        BindingExpression expression;
        boolean editable;
        Class columnClass;
        Object sampleLongValue;

        ColumnDescriptor(String header, BindingExpression expression, Class columnClass, boolean editable, Object sampleLongValue) {
            this.header = header;
            this.expression = expression;
            this.editable = editable;
            this.columnClass = columnClass;
            this.sampleLongValue = sampleLongValue;
        }
    }
}

