/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import org.apache.cassandra.sidecar.utils.DigestAlgorithm;
import org.apache.cassandra.sidecar.utils.DigestAlgorithmProvider;
import org.apache.commons.codec.digest.XXHash32;

public class XXHash32Provider
implements DigestAlgorithmProvider {
    @Override
    public DigestAlgorithm get(int seed) {
        return new Lz4XXHash32(seed);
    }

    public static class Lz4XXHash32
    implements DigestAlgorithm {
        private final XXHash32 xxHash32;

        Lz4XXHash32(int seed) {
            this.xxHash32 = new XXHash32(seed);
        }

        @Override
        public void update(byte[] buf, int off, int len) {
            this.xxHash32.update(buf, off, len);
        }

        @Override
        public String digest() {
            return Long.toHexString(this.xxHash32.getValue());
        }

        @Override
        public void close() {
        }
    }
}

