/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.ext.web.handler.HttpException;
import java.io.File;
import java.util.regex.Pattern;
import org.apache.cassandra.sidecar.cluster.InstancesMetadata;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.handlers.data.SSTableUploadRequestParam;
import org.apache.cassandra.sidecar.handlers.data.SSTableUploads;
import org.apache.cassandra.sidecar.utils.BaseFileSystem;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class SSTableUploadsPathBuilder
extends BaseFileSystem {
    private static final Pattern UPLOAD_ID_PATTERN = Pattern.compile("[0-9a-fA-F\\-:]{36,110}");

    @Inject
    public SSTableUploadsPathBuilder(Vertx vertx, InstancesMetadata instancesMetadata, CassandraInputValidator validator, ExecutorPools executorPools) {
        super(vertx.fileSystem(), instancesMetadata, validator, executorPools);
    }

    public <T extends SSTableUploads> Future<String> build(String host, T request) {
        return this.validate(request).compose(validRequest -> this.resolveUploadIdDirectory(host, request.uploadId())).compose(stagingDirectory -> this.resolveUploadDirectory((String)stagingDirectory, request.keyspace().name(), request.table().name()));
    }

    public Future<String> resolveStagingDirectory(String host) {
        InstanceMetadata instanceMeta = this.instancesMetadata.instanceFromHost(host);
        return this.ensureDirectoryExists(StringUtils.removeEnd((String)instanceMeta.stagingDir(), (String)File.separator));
    }

    public Future<String> resolveUploadIdDirectory(String host, String uploadId) {
        return this.validateUploadId(uploadId).compose(validUploadId -> this.resolveStagingDirectory(host)).compose(this::isValidDirectory).compose(directory -> Future.succeededFuture((Object)(directory + File.separatorChar + uploadId)));
    }

    protected Future<String> resolveUploadDirectory(String stagingDirectory, String keyspace, String tableName) {
        String uploadDirectory = StringUtils.removeEnd((String)stagingDirectory, (String)File.separator) + File.separatorChar + keyspace + File.separatorChar + tableName;
        return Future.succeededFuture((Object)uploadDirectory);
    }

    protected Future<String> validateUploadId(String uploadId) {
        if (!UPLOAD_ID_PATTERN.matcher(uploadId).matches()) {
            return Future.failedFuture((Throwable)new IllegalArgumentException("Invalid upload id is supplied, uploadId=" + uploadId));
        }
        return Future.succeededFuture((Object)uploadId);
    }

    protected <T extends SSTableUploads> Future<T> validate(T request) {
        return this.validateUploadId(request.uploadId()).compose(validUploadId -> {
            try {
                this.validator.validateKeyspaceName(request.keyspace().name());
                this.validator.validateTableName(request.table().name());
                if (request instanceof SSTableUploadRequestParam) {
                    this.validator.validateComponentName(((SSTableUploadRequestParam)request).component());
                }
            }
            catch (HttpException | NullPointerException exception) {
                return Future.failedFuture((Throwable)exception);
            }
            return Future.succeededFuture((Object)request);
        });
    }
}

