/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authentication;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.sidecar.acl.IdentityToRoleCache;
import org.apache.cassandra.sidecar.acl.authentication.JwtRoleProcessor;

public class JwtRoleProcessorImpl
implements JwtRoleProcessor {
    private static final String SUB_KEY = "sub";
    private static final String IDENTITY_KEY = "identity";
    private static final String IDENTITIES_KEY = "identities";
    private final IdentityToRoleCache identityToRoleCache;

    public JwtRoleProcessorImpl(IdentityToRoleCache identityToRoleCache) {
        this.identityToRoleCache = identityToRoleCache;
    }

    @Override
    public List<String> processRoles(JsonObject decodedToken) {
        String identity = decodedToken.getString(IDENTITY_KEY);
        if (identity != null || (identity = decodedToken.getString(SUB_KEY)) != null) {
            String role = (String)this.identityToRoleCache.get(identity);
            return role != null ? List.of(role) : List.of();
        }
        JsonArray identityKeyArray = decodedToken.getJsonArray(IDENTITIES_KEY);
        ArrayList<String> roles = new ArrayList<String>();
        if (identityKeyArray != null) {
            for (String i : identityKeyArray.getList()) {
                String roleFromIdentity = (String)this.identityToRoleCache.get(i);
                if (roleFromIdentity == null) continue;
                roles.add(roleFromIdentity);
            }
        }
        return List.copyOf(roles);
    }
}

