/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.datastax.driver.core.TypeCodec;
import com.google.common.base.Objects;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.cassandra.cql3.functions.AbstractFunction;
import org.apache.cassandra.cql3.functions.AggregateFunction;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.functions.UDHelper;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.schema.Functions;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.ProtocolVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDAggregate
extends AbstractFunction
implements AggregateFunction {
    protected static final Logger logger = LoggerFactory.getLogger(UDAggregate.class);
    private final AbstractType<?> stateType;
    private final TypeCodec stateTypeCodec;
    private final TypeCodec returnTypeCodec;
    protected final ByteBuffer initcond;
    private final ScalarFunction stateFunction;
    private final ScalarFunction finalFunction;

    public UDAggregate(FunctionName name, List<AbstractType<?>> argTypes, AbstractType<?> returnType, ScalarFunction stateFunc, ScalarFunction finalFunc, ByteBuffer initcond) {
        super(name, argTypes, returnType);
        this.stateFunction = stateFunc;
        this.finalFunction = finalFunc;
        this.stateType = stateFunc != null ? stateFunc.returnType() : null;
        this.stateTypeCodec = this.stateType != null ? UDHelper.codecFor(UDHelper.driverType(this.stateType)) : null;
        this.returnTypeCodec = returnType != null ? UDHelper.codecFor(UDHelper.driverType(returnType)) : null;
        this.initcond = initcond;
    }

    public static UDAggregate create(Functions functions, FunctionName name, List<AbstractType<?>> argTypes, AbstractType<?> returnType, FunctionName stateFunc, FunctionName finalFunc, AbstractType<?> stateType, ByteBuffer initcond) throws InvalidRequestException {
        ArrayList stateTypes = new ArrayList(argTypes.size() + 1);
        stateTypes.add(stateType);
        stateTypes.addAll(argTypes);
        List<AbstractType<?>> finalTypes = Collections.singletonList(stateType);
        return new UDAggregate(name, argTypes, returnType, UDAggregate.resolveScalar(functions, name, stateFunc, stateTypes), finalFunc != null ? UDAggregate.resolveScalar(functions, name, finalFunc, finalTypes) : null, initcond);
    }

    public static UDAggregate createBroken(FunctionName name, List<AbstractType<?>> argTypes, AbstractType<?> returnType, ByteBuffer initcond, final InvalidRequestException reason) {
        return new UDAggregate(name, argTypes, returnType, null, null, initcond){

            @Override
            public AggregateFunction.Aggregate newAggregate() throws InvalidRequestException {
                throw new InvalidRequestException(String.format("Aggregate '%s' exists but hasn't been loaded successfully for the following reason: %s. Please see the server log for more details", this, reason.getMessage()));
            }
        };
    }

    @Override
    public boolean hasReferenceTo(Function function) {
        return this.stateFunction == function || this.finalFunction == function;
    }

    @Override
    public void addFunctionsTo(List<Function> functions) {
        functions.add(this);
        if (this.stateFunction != null) {
            this.stateFunction.addFunctionsTo(functions);
            if (this.finalFunction != null) {
                this.finalFunction.addFunctionsTo(functions);
            }
        }
    }

    @Override
    public boolean isAggregate() {
        return true;
    }

    @Override
    public boolean isNative() {
        return false;
    }

    public ScalarFunction stateFunction() {
        return this.stateFunction;
    }

    public ScalarFunction finalFunction() {
        return this.finalFunction;
    }

    public ByteBuffer initialCondition() {
        return this.initcond;
    }

    public AbstractType<?> stateType() {
        return this.stateType;
    }

    @Override
    public AggregateFunction.Aggregate newAggregate() throws InvalidRequestException {
        return new AggregateFunction.Aggregate(){
            private long stateFunctionCount;
            private long stateFunctionDuration;
            private Object state;
            private boolean needsInit = true;

            @Override
            public void addInput(ProtocolVersion protocolVersion, List<ByteBuffer> values) throws InvalidRequestException {
                this.maybeInit(protocolVersion);
                long startTime = System.nanoTime();
                ++this.stateFunctionCount;
                if (UDAggregate.this.stateFunction instanceof UDFunction) {
                    UDFunction udf = (UDFunction)UDAggregate.this.stateFunction;
                    if (udf.isCallableWrtNullable(values)) {
                        this.state = udf.executeForAggregate(protocolVersion, this.state, values);
                    }
                } else {
                    throw new UnsupportedOperationException("UDAs only support UDFs");
                }
                this.stateFunctionDuration += (System.nanoTime() - startTime) / 1000L;
            }

            private void maybeInit(ProtocolVersion protocolVersion) {
                if (this.needsInit) {
                    this.state = UDAggregate.this.initcond != null ? UDHelper.deserialize(UDAggregate.this.stateTypeCodec, protocolVersion, UDAggregate.this.initcond.duplicate()) : null;
                    this.stateFunctionDuration = 0L;
                    this.stateFunctionCount = 0L;
                    this.needsInit = false;
                }
            }

            @Override
            public ByteBuffer compute(ProtocolVersion protocolVersion) throws InvalidRequestException {
                this.maybeInit(protocolVersion);
                Tracing.trace("Executed UDA {}: {} call(s) to state function {} in {}\u03bcs", UDAggregate.this.name(), this.stateFunctionCount, UDAggregate.this.stateFunction.name(), this.stateFunctionDuration);
                if (UDAggregate.this.finalFunction == null) {
                    return UDFunction.decompose((TypeCodec<Object>)UDAggregate.this.stateTypeCodec, protocolVersion, this.state);
                }
                if (UDAggregate.this.finalFunction instanceof UDFunction) {
                    UDFunction udf = (UDFunction)UDAggregate.this.finalFunction;
                    Object result = udf.executeForAggregate(protocolVersion, this.state, Collections.emptyList());
                    return UDFunction.decompose((TypeCodec<Object>)UDAggregate.this.returnTypeCodec, protocolVersion, result);
                }
                throw new UnsupportedOperationException("UDAs only support UDFs");
            }

            @Override
            public void reset() {
                this.needsInit = true;
            }
        };
    }

    private static ScalarFunction resolveScalar(Functions functions, FunctionName aName, FunctionName fName, List<AbstractType<?>> argTypes) throws InvalidRequestException {
        Optional<Function> fun = functions.find(fName, argTypes);
        if (!fun.isPresent()) {
            throw new InvalidRequestException(String.format("Referenced state function '%s %s' for aggregate '%s' does not exist", fName, Arrays.toString(UDHelper.driverTypes(argTypes)), aName));
        }
        if (!(fun.get() instanceof ScalarFunction)) {
            throw new InvalidRequestException(String.format("Referenced state function '%s %s' for aggregate '%s' is not a scalar function", fName, Arrays.toString(UDHelper.driverTypes(argTypes)), aName));
        }
        return (ScalarFunction)fun.get();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof UDAggregate)) {
            return false;
        }
        UDAggregate that = (UDAggregate)o;
        return Objects.equal((Object)this.name, (Object)that.name) && Functions.typesMatch(this.argTypes, that.argTypes) && Functions.typesMatch(this.returnType, that.returnType) && Objects.equal((Object)this.stateFunction, (Object)that.stateFunction) && Objects.equal((Object)this.finalFunction, (Object)that.finalFunction) && (this.stateType == that.stateType || this.stateType != null && this.stateType.equals(that.stateType, true)) && Objects.equal((Object)this.initcond, (Object)that.initcond);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, Functions.typeHashCode(this.argTypes), Functions.typeHashCode(this.returnType), this.stateFunction, this.finalFunction, this.stateType, this.initcond});
    }
}

