/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.auth;

import javax.servlet.http.HttpServletRequest;
import org.apache.zookeeper.server.auth.IPAuthenticationProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class IPAuthenticationProviderTest {
    private HttpServletRequest request;

    @Before
    public void setUp() throws Exception {
        System.clearProperty("zookeeper.IPAuthenticationProvider.usexforwardedfor");
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
    }

    @After
    public void tearDown() {
        System.clearProperty("zookeeper.IPAuthenticationProvider.usexforwardedfor");
    }

    @Test
    public void testGetClientIPAddressSkipXForwardedFor() {
        System.setProperty("zookeeper.IPAuthenticationProvider.usexforwardedfor", "false");
        ((HttpServletRequest)Mockito.doReturn((Object)"192.168.1.1").when((Object)this.request)).getRemoteAddr();
        ((HttpServletRequest)Mockito.doReturn((Object)"192.168.1.2,192.168.1.3,192.168.1.4").when((Object)this.request)).getHeader("X-Forwarded-For");
        String clientIp = IPAuthenticationProvider.getClientIPAddress((HttpServletRequest)this.request);
        Assert.assertEquals((Object)"192.168.1.1", (Object)clientIp);
    }

    @Test
    public void testGetClientIPAddressDefaultBehaviour() {
        System.clearProperty("zookeeper.IPAuthenticationProvider.usexforwardedfor");
        ((HttpServletRequest)Mockito.doReturn((Object)"192.168.1.1").when((Object)this.request)).getRemoteAddr();
        ((HttpServletRequest)Mockito.doReturn((Object)"192.168.1.2,192.168.1.3,192.168.1.4").when((Object)this.request)).getHeader("X-Forwarded-For");
        String clientIp = IPAuthenticationProvider.getClientIPAddress((HttpServletRequest)this.request);
        Assert.assertEquals((Object)"192.168.1.1", (Object)clientIp);
    }

    @Test
    public void testGetClientIPAddressWithXForwardedFor() {
        System.setProperty("zookeeper.IPAuthenticationProvider.usexforwardedfor", "true");
        ((HttpServletRequest)Mockito.doReturn((Object)"192.168.1.1").when((Object)this.request)).getRemoteAddr();
        ((HttpServletRequest)Mockito.doReturn((Object)"192.168.1.2,192.168.1.3,192.168.1.4").when((Object)this.request)).getHeader("X-Forwarded-For");
        String clientIp = IPAuthenticationProvider.getClientIPAddress((HttpServletRequest)this.request);
        Assert.assertEquals((Object)"192.168.1.2", (Object)clientIp);
    }

    @Test
    public void testGetClientIPAddressMissingXForwardedFor() {
        System.setProperty("zookeeper.IPAuthenticationProvider.usexforwardedfor", "false");
        ((HttpServletRequest)Mockito.doReturn((Object)"192.168.1.1").when((Object)this.request)).getRemoteAddr();
        String clientIp = IPAuthenticationProvider.getClientIPAddress((HttpServletRequest)this.request);
        Assert.assertEquals((Object)"192.168.1.1", (Object)clientIp);
    }
}

