/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.marshaller.factory;

import jakarta.jws.soap.SOAPBinding;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.ws.Holder;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.description.ParameterDescription;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.marshaller.MethodMarshaller;
import org.apache.axis2.jaxws.marshaller.impl.alt.DocLitBareMethodMarshaller;
import org.apache.axis2.jaxws.marshaller.impl.alt.DocLitBareMinimalMethodMarshaller;
import org.apache.axis2.jaxws.marshaller.impl.alt.DocLitWrappedMethodMarshaller;
import org.apache.axis2.jaxws.marshaller.impl.alt.DocLitWrappedMinimalMethodMarshaller;
import org.apache.axis2.jaxws.marshaller.impl.alt.DocLitWrappedPlusMethodMarshaller;
import org.apache.axis2.jaxws.marshaller.impl.alt.RPCLitMethodMarshaller;
import org.apache.axis2.jaxws.message.databinding.JAXBUtils;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescription;
import org.apache.axis2.jaxws.runtime.description.marshal.MarshalServiceRuntimeDescriptionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MethodMarshallerFactory {
    private static Log log = LogFactory.getLog(MethodMarshallerFactory.class);

    private MethodMarshallerFactory() {
    }

    private static MethodMarshaller createMethodMarshaller(SOAPBinding.Style style, SOAPBinding.ParameterStyle paramStyle, SUBTYPE subType, boolean isClient) {
        if (style == SOAPBinding.Style.RPC) {
            return new RPCLitMethodMarshaller();
        }
        if (paramStyle == SOAPBinding.ParameterStyle.WRAPPED) {
            if (subType == SUBTYPE.PLUS) {
                return new DocLitWrappedPlusMethodMarshaller();
            }
            if (subType == SUBTYPE.MINIMAL) {
                return new DocLitWrappedMinimalMethodMarshaller();
            }
            return new DocLitWrappedMethodMarshaller();
        }
        if (paramStyle == SOAPBinding.ParameterStyle.BARE) {
            if (subType == SUBTYPE.MINIMAL) {
                return new DocLitBareMinimalMethodMarshaller();
            }
            return new DocLitBareMethodMarshaller();
        }
        return null;
    }

    public static MethodMarshaller getMarshaller(OperationDescription op, boolean isClient) {
        return MethodMarshallerFactory.getMarshaller(op, isClient, null);
    }

    public static MethodMarshaller getMarshaller(OperationDescription op, boolean isClient, ClassLoader cl) {
        ServiceDescription serviceDesc = op.getEndpointInterfaceDescription().getEndpointDescription().getServiceDescription();
        MarshalServiceRuntimeDescription marshalDesc = MarshalServiceRuntimeDescriptionFactory.get(serviceDesc);
        MethodMarshaller marshaller = null;
        if (op.getSoapBindingStyle() == SOAPBinding.Style.DOCUMENT) {
            marshaller = MethodMarshallerFactory.createDocLitMethodMarshaller(op, isClient, cl);
        } else if (op.getSoapBindingStyle() == SOAPBinding.Style.RPC) {
            marshaller = MethodMarshallerFactory.createRPCLitMethodMarshaller(isClient);
        }
        return marshaller;
    }

    private static MethodMarshaller createDocLitMethodMarshaller(OperationDescription op, boolean isClient, ClassLoader cl) {
        SOAPBinding.ParameterStyle parameterStyle = null;
        SUBTYPE subType = SUBTYPE.NORMAL;
        if (MethodMarshallerFactory.isDocLitBare(op)) {
            if (MethodMarshallerFactory.isDocLitBareMinimal(op, cl)) {
                subType = SUBTYPE.MINIMAL;
            }
            parameterStyle = SOAPBinding.ParameterStyle.BARE;
        } else {
            if (MethodMarshallerFactory.isDocLitWrappedMinimal(op)) {
                subType = SUBTYPE.MINIMAL;
            } else if (MethodMarshallerFactory.isDocLitWrappedPlus(op)) {
                subType = SUBTYPE.PLUS;
            }
            parameterStyle = SOAPBinding.ParameterStyle.WRAPPED;
        }
        return MethodMarshallerFactory.createMethodMarshaller(SOAPBinding.Style.DOCUMENT, parameterStyle, subType, isClient);
    }

    private static MethodMarshaller createRPCLitMethodMarshaller(boolean isClient) {
        return MethodMarshallerFactory.createMethodMarshaller(SOAPBinding.Style.RPC, SOAPBinding.ParameterStyle.WRAPPED, SUBTYPE.NORMAL, isClient);
    }

    protected static boolean isDocLitBare(OperationDescription op) {
        SOAPBinding.ParameterStyle methodParamStyle = op.getSoapBindingParameterStyle();
        if (methodParamStyle != null) {
            return methodParamStyle == SOAPBinding.ParameterStyle.BARE;
        }
        SOAPBinding.ParameterStyle SEIParamStyle = op.getEndpointInterfaceDescription().getSoapBindingParameterStyle();
        return SEIParamStyle == SOAPBinding.ParameterStyle.BARE;
    }

    protected static boolean isDocLitWrapped(OperationDescription op) {
        SOAPBinding.ParameterStyle methodParamStyle = op.getSoapBindingParameterStyle();
        if (methodParamStyle != null) {
            return methodParamStyle == SOAPBinding.ParameterStyle.WRAPPED;
        }
        SOAPBinding.ParameterStyle SEIParamStyle = op.getEndpointInterfaceDescription().getSoapBindingParameterStyle();
        return SEIParamStyle == SOAPBinding.ParameterStyle.WRAPPED;
    }

    protected static boolean isDocLitWrappedPlus(OperationDescription op) {
        if (MethodMarshallerFactory.isDocLitWrapped(op)) {
            if (op.isResultHeader()) {
                return true;
            }
            ParameterDescription[] pds = op.getParameterDescriptions();
            for (int i = 0; i < pds.length; ++i) {
                if (!pds[i].isHeader()) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isDocLitBareMinimal(OperationDescription op, ClassLoader cl) {
        return MethodMarshallerFactory.isDocLitBare(op) && !MethodMarshallerFactory.isContextPathConstruction(op, cl);
    }

    private static boolean isContextPathConstruction(OperationDescription op, ClassLoader cl) {
        ServiceDescription serviceDesc = op.getEndpointInterfaceDescription().getEndpointDescription().getServiceDescription();
        MarshalServiceRuntimeDescription marshalDesc = MarshalServiceRuntimeDescriptionFactory.get(serviceDesc);
        Holder holder = new Holder();
        try {
            JAXBContext jAXBContext = JAXBUtils.getJAXBContext(marshalDesc.getPackages(), (Holder<JAXBUtils.CONSTRUCTION_TYPE>)holder, marshalDesc.getPackagesKey(), cl, null);
        }
        catch (JAXBException e) {
            throw ExceptionFactory.makeWebServiceException((Throwable)e);
        }
        return holder.value == JAXBUtils.CONSTRUCTION_TYPE.BY_CONTEXT_PATH;
    }

    protected static boolean isDocLitWrappedMinimal(OperationDescription op) {
        if (MethodMarshallerFactory.isDocLitWrapped(op)) {
            ServiceDescription serviceDesc = op.getEndpointInterfaceDescription().getEndpointDescription().getServiceDescription();
            MarshalServiceRuntimeDescription marshalDesc = MarshalServiceRuntimeDescriptionFactory.get(serviceDesc);
            String requestWrapper = marshalDesc.getRequestWrapperClassName(op);
            if (op.isOneWay()) {
                if (!MethodMarshallerFactory.exists(requestWrapper)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"OneWay Request wrapper class name is NULL.");
                    }
                    return true;
                }
                return false;
            }
            if (!MethodMarshallerFactory.exists(requestWrapper)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Request wrapper class name is NULL.");
                }
                return true;
            }
            String responseWrapper = marshalDesc.getResponseWrapperClassName(op);
            if (!MethodMarshallerFactory.exists(responseWrapper)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Response wrapper class name is NULL.");
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean exists(String className) {
        return className != null && className.length() != 0;
    }

    private static enum SUBTYPE {
        NORMAL,
        PLUS,
        MINIMAL;

    }
}

