/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;

public class ProcessTree {
    private static final Log LOG = LogFactory.getLog(ProcessTree.class);
    public static final boolean isSetsidAvailable = ProcessTree.isSetsidSupported();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSetsidSupported() {
        Shell shexec = null;
        boolean setsidSupported = true;
        try {
            String[] args = new String[]{"setsid", "bash", "-c", "echo $$"};
            shexec = new Shell.ShellCommandExecutor(args);
            ((Shell.ShellCommandExecutor)shexec).execute();
        }
        catch (IOException ioe) {
            LOG.warn("setsid is not available on this machine. So not using it.");
            setsidSupported = false;
        }
        finally {
            LOG.info("setsid exited with exit code " + shexec.getExitCode());
        }
        return setsidSupported;
    }

    private static void sigKillInCurrentThread(String pid, boolean isProcessGroup, long sleepTimeBeforeSigKill) {
        if (isProcessGroup || ProcessTree.isAlive(pid)) {
            try {
                Thread.sleep(sleepTimeBeforeSigKill);
            }
            catch (InterruptedException i) {
                LOG.warn("Thread sleep is interrupted.");
            }
            if (isProcessGroup) {
                ProcessTree.killProcessGroup(pid, Signal.KILL);
            } else {
                ProcessTree.killProcess(pid, Signal.KILL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killProcess(String pid, Signal signal) {
        if (!ProcessTree.isAlive(pid)) {
            return;
        }
        String[] args = new String[]{"kill", "-" + signal.getValue(), pid};
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(args);
        try {
            shexec.execute();
        }
        catch (IOException e) {
            LOG.warn("Error sending signal " + (Object)((Object)signal) + " to process " + pid + " ." + StringUtils.stringifyException(e));
        }
        finally {
            LOG.info("Killing process " + pid + " with signal " + (Object)((Object)signal) + ". Exit code " + shexec.getExitCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killProcessGroup(String pgrpId, Signal signal) {
        if (!ProcessTree.isProcessGroupAlive(pgrpId)) {
            return;
        }
        String[] args = new String[]{"kill", "-" + signal.getValue(), "-" + pgrpId};
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(args);
        try {
            shexec.execute();
        }
        catch (IOException e) {
            LOG.warn("Error sending signal " + (Object)((Object)signal) + " to process group " + pgrpId + " ." + StringUtils.stringifyException(e));
        }
        finally {
            LOG.info("Killing process group" + pgrpId + " with signal " + (Object)((Object)signal) + ". Exit code " + shexec.getExitCode());
        }
    }

    public static boolean isAlive(String pid) {
        Shell.ShellCommandExecutor shexec = null;
        try {
            String[] args = new String[]{"kill", "-0", pid};
            shexec = new Shell.ShellCommandExecutor(args);
            shexec.execute();
        }
        catch (Shell.ExitCodeException ee) {
            return false;
        }
        catch (IOException ioe) {
            LOG.warn("Error executing shell command " + Arrays.toString(shexec.getExecString()) + ioe);
            return false;
        }
        return shexec.getExitCode() == 0;
    }

    public static boolean isProcessGroupAlive(String pgrpId) {
        Shell.ShellCommandExecutor shexec = null;
        try {
            String[] args = new String[]{"kill", "-0", "-" + pgrpId};
            shexec = new Shell.ShellCommandExecutor(args);
            shexec.execute();
        }
        catch (Shell.ExitCodeException ee) {
            return false;
        }
        catch (IOException ioe) {
            LOG.warn("Error executing shell command " + Arrays.toString(shexec.getExecString()) + ioe);
            return false;
        }
        return shexec.getExitCode() == 0;
    }

    static class SigKillThread
    extends Thread {
        private String pid = null;
        private boolean isProcessGroup = false;
        private final long sleepTimeBeforeSigKill;

        private SigKillThread(String pid, boolean isProcessGroup, long interval) {
            this.pid = pid;
            this.isProcessGroup = isProcessGroup;
            this.setName(this.getClass().getName() + "-" + pid);
            this.sleepTimeBeforeSigKill = interval;
        }

        @Override
        public void run() {
            ProcessTree.sigKillInCurrentThread(this.pid, this.isProcessGroup, this.sleepTimeBeforeSigKill);
        }
    }

    public static enum Signal {
        QUIT(3),
        KILL(9),
        TERM(15);

        private int value;

        private Signal(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

