/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.sasl;

import org.apache.activemq.artemis.protocol.amqp.sasl.PlainSASLResult;
import org.apache.activemq.artemis.protocol.amqp.sasl.SASLResult;
import org.apache.activemq.artemis.protocol.amqp.sasl.ServerSASL;

public class ServerSASLPlain
implements ServerSASL {
    public static final String NAME = "PLAIN";
    private SASLResult result = null;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte[] processSASL(byte[] data) {
        String username = null;
        String password = null;
        String bytes = new String(data);
        String[] credentials = bytes.split(Character.toString('\u0000'));
        switch (credentials.length) {
            case 2: {
                username = credentials[0];
                password = credentials[1];
                break;
            }
            case 3: {
                username = credentials[1];
                password = credentials[2];
                break;
            }
        }
        boolean success = this.authenticate(username, password);
        this.result = new PlainSASLResult(success, username, password);
        return null;
    }

    @Override
    public SASLResult result() {
        return this.result;
    }

    @Override
    public void done() {
    }

    protected boolean authenticate(String user, String password) {
        return true;
    }
}

