/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.TypeConverter;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public final class HttpUtil {
    private static final int INTERNAL_SERVER_ERROR = 500;
    private static final int OK = 200;
    private static final int NO_CONTENT = 204;

    private HttpUtil() {
    }

    public static int determineResponseCode(Exchange camelExchange, Object body) {
        int codeToUse;
        boolean failed = camelExchange.isFailed();
        int defaultCode = failed ? 500 : 200;
        Message message = camelExchange.getMessage();
        Integer currentCode = (Integer)message.getHeader("CamelHttpResponseCode", Integer.class);
        int n = codeToUse = currentCode == null ? defaultCode : currentCode;
        if (codeToUse != 500 && (body == null || body instanceof String && ((String)body).isBlank())) {
            codeToUse = currentCode == null ? 204 : currentCode;
        }
        return codeToUse;
    }

    @Deprecated(since="4.3.0")
    public static String getCharsetFromContentType(String contentType) {
        int index;
        if (contentType != null && (index = contentType.indexOf("charset=")) > 0) {
            String charset = contentType.substring(index + 8);
            if (charset.contains(";")) {
                charset = StringHelper.before((String)charset, (String)";");
            }
            return IOHelper.normalizeCharset((String)charset);
        }
        return null;
    }

    public static void setCharsetFromContentType(String contentType, Exchange exchange) {
        String charset = HttpUtil.getCharsetFromContentType(contentType);
        if (charset != null) {
            exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)IOHelper.normalizeCharset((String)charset));
        }
    }

    public static String recreateUrl(Map<String, Object> map, String url) {
        String query = URISupport.createQueryString(map);
        if (!query.isEmpty()) {
            url = (String)url + "?" + query;
        }
        return url;
    }

    public static void addCommonFilters(Set<String> filterSet) {
        filterSet.add("content-length");
        filterSet.add("content-type");
        filterSet.add("host");
        filterSet.add("cache-control");
        filterSet.add("connection");
        filterSet.add("date");
        filterSet.add("pragma");
        filterSet.add("trailer");
        filterSet.add("transfer-encoding");
        filterSet.add("upgrade");
        filterSet.add("via");
        filterSet.add("warning");
    }

    public static boolean isStatusCodeOk(int statusCode, String okStatusCodeRange) {
        String[] ranges;
        for (String range : ranges = okStatusCodeRange.split(",")) {
            boolean ok;
            if (range.contains("-")) {
                int from = Integer.parseInt(StringHelper.before((String)range, (String)"-"));
                int to = Integer.parseInt(StringHelper.after((String)range, (String)"-"));
                ok = statusCode >= from && statusCode <= to;
            } else {
                int exact = Integer.parseInt(range);
                boolean bl = ok = exact == statusCode;
            }
            if (!ok) continue;
            return true;
        }
        return false;
    }

    public static boolean parseStatusRange(String range, BiConsumer<Integer, Integer> consumer) {
        if (range.contains("-")) {
            String minRangeStr = StringHelper.before((String)range, (String)"-");
            String maxRangeStr = StringHelper.after((String)range, (String)"-");
            if (minRangeStr == null || maxRangeStr == null) {
                return false;
            }
            int minOkRange = Integer.parseInt(minRangeStr);
            int maxOkRange = Integer.parseInt(maxRangeStr);
            consumer.accept(minOkRange, maxOkRange);
            return true;
        }
        return false;
    }

    public static void applyHeader(HeaderFilterStrategy headerFilterStrategy, Exchange exchange, Iterator<?> it, TypeConverter tc, String key, BiConsumer<List<String>, String> consumer) {
        String firstValue = null;
        ArrayList<String> values = null;
        while (it.hasNext()) {
            String headerValue = (String)tc.convertTo(String.class, it.next());
            if (headerValue == null || headerFilterStrategy.applyFilterToCamelHeaders(key, (Object)headerValue, exchange)) continue;
            if (firstValue == null) {
                firstValue = headerValue;
                continue;
            }
            if (values == null) {
                values = new ArrayList<String>();
                values.add(firstValue);
            }
            values.add(headerValue);
        }
        consumer.accept(values, firstValue);
    }

    public static boolean filterCheck(String templateUri, String queryParameters, String headerName, boolean answer) {
        if (!answer) {
            String token;
            if (templateUri != null && templateUri.contains(token = "{" + headerName + "}")) {
                answer = true;
            }
            if (!answer && queryParameters != null && queryParameters.contains(token = "=%7B" + headerName + "%7D")) {
                answer = true;
            }
        }
        return answer;
    }
}

