/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.StreamCache;
import org.apache.camel.StreamCacheException;
import org.apache.camel.spi.BrowsableVariableRepository;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.support.service.ServiceSupport;

public abstract class AbstractVariableRepository
extends ServiceSupport
implements BrowsableVariableRepository,
CamelContextAware {
    private final Map<String, Object> variables = new ConcurrentHashMap<String, Object>(8);
    private CamelContext camelContext;
    private StreamCachingStrategy strategy;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Object getVariable(String name) {
        Object answer = this.variables.get(name);
        if (answer instanceof StreamCache) {
            StreamCache sc = (StreamCache)answer;
            sc.reset();
        }
        return answer;
    }

    public void setVariable(String name, Object value) {
        StreamCache sc;
        if (value != null && this.strategy != null && (sc = this.convertToStreamCache(value)) != null) {
            value = sc;
        }
        if (value != null) {
            this.variables.put(name, value);
        } else {
            this.variables.remove(name);
        }
    }

    public boolean hasVariables() {
        return !this.variables.isEmpty();
    }

    public int size() {
        return this.variables.size();
    }

    public Stream<String> names() {
        return this.variables.keySet().stream();
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> map) {
        this.variables.putAll(map);
    }

    public void clear() {
        this.variables.clear();
    }

    public Object removeVariable(String name) {
        if (!this.hasVariables()) {
            return null;
        }
        return this.variables.remove(name);
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.camelContext != null && this.camelContext.isStreamCaching().booleanValue()) {
            this.strategy = this.camelContext.getStreamCachingStrategy();
        }
    }

    protected StreamCache convertToStreamCache(Object body) {
        if (body == null) {
            return null;
        }
        if (body instanceof StreamCache) {
            StreamCache sc = (StreamCache)body;
            sc.reset();
            return sc;
        }
        return this.tryStreamCache(body);
    }

    protected StreamCache tryStreamCache(Object body) {
        try {
            return this.strategy.cache(body);
        }
        catch (Exception e) {
            throw new StreamCacheException(body, (Throwable)e);
        }
    }
}

