/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.xml.bind.model.concrete;

import javax.xml.namespace.QName;
import org.jvnet.jaxb.lang.Validate;
import org.jvnet.jaxb.xml.bind.model.MClassRef;
import org.jvnet.jaxb.xml.bind.model.MClassTypeInfoVisitor;
import org.jvnet.jaxb.xml.bind.model.MContainer;
import org.jvnet.jaxb.xml.bind.model.MCustomizations;
import org.jvnet.jaxb.xml.bind.model.MPackageInfo;
import org.jvnet.jaxb.xml.bind.model.MTypeInfoVisitor;
import org.jvnet.jaxb.xml.bind.model.concrete.CMCustomizations;
import org.jvnet.jaxb.xml.bind.model.origin.MClassRefOrigin;
import org.jvnet.jaxb.xml.bind.model.util.XmlTypeUtils;

public class CMClassRef<T, C extends T>
implements MClassRef<T, C> {
    private CMCustomizations customizations = new CMCustomizations();
    private final MClassRefOrigin origin;
    private final C targetType;
    private final Class<?> targetClass;
    private final MPackageInfo _package;
    private final String name;
    private final String localName;
    private final MContainer container;
    private final QName typeName;

    public CMClassRef(MClassRefOrigin origin, C targetType, Class<?> targetClass, MPackageInfo _package, MContainer container, String localName) {
        Validate.notNull(origin);
        Validate.notNull(targetType);
        Validate.notNull(_package);
        Validate.notNull(localName);
        this.origin = origin;
        this.targetType = targetType;
        this.name = _package.getPackagedName(localName);
        this.localName = localName;
        this._package = _package;
        this.container = container;
        this.targetClass = targetClass;
        this.typeName = targetClass == null ? null : XmlTypeUtils.getTypeName(targetClass);
    }

    @Override
    public MClassRefOrigin getOrigin() {
        return this.origin;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public C getTargetType() {
        return this.targetType;
    }

    @Override
    public QName getTypeName() {
        return this.typeName;
    }

    @Override
    public boolean isSimpleType() {
        return false;
    }

    @Override
    public <V> V acceptTypeInfoVisitor(MTypeInfoVisitor<T, C, V> visitor) {
        return visitor.visitClassRef(this);
    }

    @Override
    public MCustomizations getCustomizations() {
        return this.customizations;
    }

    @Override
    public MPackageInfo getPackageInfo() {
        return this._package;
    }

    @Override
    public MContainer getContainer() {
        return this.container;
    }

    @Override
    public String getContainerLocalName(String delimiter) {
        String localName = this.getLocalName();
        if (localName == null) {
            return null;
        }
        MContainer container = this.getContainer();
        if (container == null) {
            return localName;
        }
        String containerLocalName = container.getContainerLocalName(delimiter);
        return containerLocalName == null ? localName : containerLocalName + delimiter + localName;
    }

    public C getTargetClass() {
        return this.targetType;
    }

    @Override
    public <V> V acceptClassTypeInfoVisitor(MClassTypeInfoVisitor<T, C, V> visitor) {
        return visitor.visitClassRef(this);
    }
}

