/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSConstants;
import javax.jmdns.impl.tasks.DNSTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Responder
extends DNSTask {
    private final Logger logger = LoggerFactory.getLogger(Responder.class);
    private final DNSIncoming dnsIncoming;
    private final InetAddress inetAddress;
    private final int port;
    private final boolean unicast;

    public Responder(JmDNSImpl jmDNSImpl, DNSIncoming in, InetAddress addr, int port) {
        super(jmDNSImpl);
        this.dnsIncoming = in;
        this.inetAddress = addr;
        this.port = port;
        this.unicast = port != DNSConstants.MDNS_PORT;
    }

    @Override
    public String getName() {
        return "Responder(" + (this.getDns() != null ? this.getDns().getName() : "") + ")";
    }

    @Override
    public String toString() {
        return super.toString() + " incoming: " + this.dnsIncoming;
    }

    @Override
    public void start(Timer timer) {
        int delay;
        boolean iAmTheOnlyOne = true;
        for (DNSQuestion dNSQuestion : this.dnsIncoming.getQuestions()) {
            this.logger.trace("{}.start() question={}", (Object)this.getName(), (Object)dNSQuestion);
            iAmTheOnlyOne = dNSQuestion.iAmTheOnlyOne(this.getDns());
            if (iAmTheOnlyOne) continue;
            break;
        }
        int n = delay = iAmTheOnlyOne && !this.dnsIncoming.isTruncated() ? 0 : 20 + JmDNSImpl.getRandom().nextInt(96) - this.dnsIncoming.elapseSinceArrival();
        if (delay < 0) {
            delay = 0;
        }
        this.logger.trace("{}.start() Responder chosen delay={}", (Object)this.getName(), (Object)delay);
        if (!this.getDns().isCanceling() && !this.getDns().isCanceled()) {
            timer.schedule((TimerTask)this, delay);
        }
    }

    @Override
    public void run() {
        this.getDns().respondToQuery(this.dnsIncoming);
        HashSet<DNSQuestion> questions = new HashSet<DNSQuestion>();
        HashSet<DNSRecord> answers = new HashSet<DNSRecord>();
        if (this.getDns().isAnnounced()) {
            try {
                for (DNSQuestion dNSQuestion : this.dnsIncoming.getQuestions()) {
                    this.logger.debug("{}.run() JmDNS responding to: {}", (Object)this.getName(), (Object)dNSQuestion);
                    if (this.unicast) {
                        questions.add(dNSQuestion);
                    }
                    dNSQuestion.addAnswers(this.getDns(), answers);
                }
                long now = System.currentTimeMillis();
                for (DNSRecord dNSRecord : this.dnsIncoming.getAnswers()) {
                    if (!dNSRecord.isStale(now)) continue;
                    answers.remove(dNSRecord);
                    this.logger.debug("{} - JmDNS Responder Known Answer Removed", (Object)this.getName());
                }
                if (!answers.isEmpty()) {
                    this.logger.debug("{}.run() JmDNS responding", (Object)this.getName());
                    DNSOutgoing out = new DNSOutgoing(33792, !this.unicast, this.dnsIncoming.getSenderUDPPayload());
                    out.setDestination(new InetSocketAddress(this.inetAddress, this.port));
                    out.setId(this.dnsIncoming.getId());
                    for (DNSQuestion question : questions) {
                        if (question == null) continue;
                        out = this.addQuestion(out, question);
                    }
                    for (DNSRecord answer : answers) {
                        if (answer == null) continue;
                        out = this.addAnswer(out, this.dnsIncoming, answer);
                    }
                    if (!out.isEmpty()) {
                        this.getDns().send(out);
                    }
                }
            }
            catch (Throwable e) {
                this.logger.warn("{}.run() exception ", (Object)this.getName(), (Object)e);
                this.getDns().close();
            }
        }
    }
}

