/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.Traceable;
import org.apache.camel.processor.BaseProcessorSupport;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;

public class StreamCachingProcessor
extends BaseProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            StreamCache streamCache;
            Object body = exchange.getIn().getBody();
            if (!(body instanceof StreamCache) && (streamCache = (StreamCache)exchange.getContext().getTypeConverter().convertTo(StreamCache.class, exchange, body)) != null) {
                exchange.getIn().setBody((Object)streamCache);
            }
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    public String getTraceLabel() {
        return "cache";
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }
}

