/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.model.language.XPathExpression;
import org.apache.camel.model.language.XQueryExpression;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Namespaces {
    public static final String DEFAULT_NAMESPACE = "http://camel.apache.org/schema/spring";
    public static final String IN_NAMESPACE = "http://camel.apache.org/xml/in/";
    public static final String OUT_NAMESPACE = "http://camel.apache.org/xml/out/";
    public static final String FUNCTION_NAMESPACE = "http://camel.apache.org/xml/function/";
    public static final String SYSTEM_PROPERTIES_NAMESPACE = "http://camel.apache.org/xml/variables/system-properties";
    public static final String ENVIRONMENT_VARIABLES = "http://camel.apache.org/xml/variables/environment-variables";
    public static final String EXCHANGE_PROPERTY = "http://camel.apache.org/xml/variables/exchange-property";
    private Map<String, String> namespaces = new HashMap<String, String>();

    public Namespaces(Element element) {
        this.add(element);
    }

    public Namespaces(String prefix, String uri) {
        this.add(prefix, uri);
    }

    public static boolean isMatchingNamespaceOrEmptyNamespace(String namespaceURI, String expectedNamespace) {
        return ObjectHelper.isEmpty(namespaceURI) || namespaceURI.equals(expectedNamespace);
    }

    public Namespaces add(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
        return this;
    }

    public Namespaces add(Element element) {
        Node parentNode = element.getParentNode();
        if (parentNode instanceof Element) {
            this.add((Element)parentNode);
        }
        NamedNodeMap attributes = element.getAttributes();
        int size = attributes.getLength();
        for (int i = 0; i < size; ++i) {
            Attr node = (Attr)attributes.item(i);
            String name = node.getName();
            if (!name.startsWith("xmlns:")) continue;
            String prefix = name.substring("xmlns:".length());
            String uri = node.getValue();
            this.add(prefix, uri);
        }
        return this;
    }

    @Deprecated
    public XPathExpression xpath(String expression) {
        XPathExpression answer = new XPathExpression(expression);
        this.configure(answer);
        return answer;
    }

    @Deprecated
    public XPathExpression xpath(String expression, Class<?> resultType) {
        XPathExpression answer = this.xpath(expression);
        answer.setResultType(resultType);
        return answer;
    }

    @Deprecated
    public XQueryExpression xquery(String expression) {
        XQueryExpression answer = new XQueryExpression(expression);
        this.configure(answer);
        return answer;
    }

    @Deprecated
    public XQueryExpression xquery(String expression, Class<?> resultType) {
        XQueryExpression answer = new XQueryExpression(expression);
        answer.setResultType(resultType);
        this.configure(answer);
        return answer;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void configure(NamespaceAware namespaceAware) {
        namespaceAware.setNamespaces(this.getNamespaces());
    }
}

