/*
 * Decompiled with CFR 0.152.
 */
package com.parctechnologies.eclipse.visualisation.viewers;

import att.grappa.Element;
import com.parctechnologies.eclipse.Atom;
import com.parctechnologies.eclipse.CompoundTerm;
import com.parctechnologies.eclipse.CompoundTermImpl;
import com.parctechnologies.eclipse.visualisation.BatchGoal;
import com.parctechnologies.eclipse.visualisation.ElementType;
import com.parctechnologies.eclipse.visualisation.SymRef;
import com.parctechnologies.eclipse.visualisation.UpdateEvent;
import com.parctechnologies.eclipse.visualisation.Viewer;
import com.parctechnologies.eclipse.visualisation.ViewletAction;
import com.parctechnologies.eclipse.visualisation.ViewletData;
import com.parctechnologies.eclipse.visualisation.ViewletDataStore;
import com.parctechnologies.eclipse.visualisation.ViewletFactory;
import com.parctechnologies.eclipse.visualisation.ViewletRange;
import com.parctechnologies.eclipse.visualisation.ViewletType;
import com.parctechnologies.eclipse.visualisation.ViewletTypeRangeCommand;
import com.parctechnologies.eclipse.visualisation.viewers.HoldIcon;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractViewletType
implements ViewletType,
ViewletFactory {
    private SymRef symRef;
    protected static final String ELEMENT_EXECUTE_STRING = "viewable_element_execute";
    protected static final String CHANGEABLE_ELEMENT_EXECUTE_STRING = "viewable_changeable_execute";
    protected String changeableSolver;

    public AbstractViewletType(String string) {
        this.changeableSolver = string;
    }

    @Override
    public boolean canBuildFrom(ElementType elementType) {
        return true;
    }

    @Override
    public abstract ViewletData build();

    @Override
    public abstract String getDescription();

    @Override
    public void setSymRef(SymRef symRef) {
        this.symRef = symRef;
    }

    @Override
    public SymRef getSymRef() {
        return this.symRef;
    }

    @Override
    public abstract TableCellRenderer getTableCellRenderer();

    abstract Class getCustomRendererClass();

    @Override
    public abstract void customizeElement(ViewletDataStore var1, List var2, Element var3);

    protected CompoundTerm composeElementGoal(Object object, CompoundTerm compoundTerm, CompoundTerm compoundTerm2) {
        if (this.changeableSolver == null) {
            return new CompoundTermImpl(":", (Object)new Atom("vc_support"), (Object)new CompoundTermImpl(ELEMENT_EXECUTE_STRING, (Object)compoundTerm, (Object)new CompoundTermImpl("element", object), (Object)compoundTerm2));
        }
        return new CompoundTermImpl(":", (Object)new Atom("vc_support"), (Object)new CompoundTermImpl(CHANGEABLE_ELEMENT_EXECUTE_STRING, (Object)compoundTerm, (Object)new CompoundTermImpl("element", object), (Object)compoundTerm2, (Object)new Atom(this.changeableSolver)));
    }

    protected CompoundTerm decomposeElementGoal(CompoundTerm compoundTerm) {
        return ((CompoundTermImpl)compoundTerm).argCT(2).argCT(3);
    }

    @Override
    public BatchGoal collectPreBuildGoal(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
        return null;
    }

    @Override
    public void startBuild(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, List list) {
    }

    @Override
    public void stopBuild() {
    }

    @Override
    public BatchGoal collectPreUpdateGoal(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, UpdateEvent updateEvent) {
        return null;
    }

    @Override
    public void startUpdate(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange, List list, UpdateEvent updateEvent) {
    }

    @Override
    public void stopUpdate(Viewer viewer, ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
    }

    @Override
    public Collection getActions(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
        LinkedList<ViewletAction> linkedList = new LinkedList<ViewletAction>();
        if (viewletRange != null & !viewletRange.isEmpty()) {
            linkedList.add(new ToggleHoldAction().createCompoundAction(viewletDataStore, viewletRange));
        }
        return linkedList;
    }

    private void toggleHold(ViewletDataStore viewletDataStore, ViewletRange viewletRange, boolean bl) {
        for (List list : viewletRange) {
            ViewletData viewletData = viewletDataStore.getViewletDataAt(list);
            viewletData.setHoldsOnUpdates(bl);
            viewletDataStore.setViewletDataAt(list, viewletData);
        }
        viewletDataStore.fireViewletRangeUpdated(viewletRange);
    }

    protected class ToggleHoldAction
    extends ViewletAction {
        ToggleHoldAction() {
            super("Hold on updates");
            this.putValue("Name", "Hold on updates");
            this.putValue("LongDescription", "Change whether control is held by the visualisation client during element updates");
            this.putValue("ShortDescription", "Change whether control is held on updates");
            this.putValue("SmallIcon", new HoldIcon(20, 20));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        public ViewletAction createCompoundAction(ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
            boolean bl = true;
            Iterator iterator = viewletDataStore.getViewletDataIterator(viewletRange);
            while (iterator.hasNext()) {
                ViewletData viewletData = (ViewletData)iterator.next();
                if (viewletData.getHoldsOnUpdates()) continue;
                bl = false;
                break;
            }
            return new CompoundToggleHoldAction(!bl, viewletDataStore, viewletRange);
        }
    }

    public static class ToggleHoldCommand
    extends ViewletTypeRangeCommand {
        boolean newValue;

        public ToggleHoldCommand(ViewletType viewletType, ViewletDataStore viewletDataStore, ViewletRange viewletRange, boolean bl) {
            super(viewletType, viewletDataStore, viewletRange);
            this.newValue = bl;
        }

        @Override
        public void postRecordIssue() {
            ((AbstractViewletType)this.getViewletType()).toggleHold(this.getViewletDataStore(), this.getViewletRange(), this.newValue);
        }
    }

    private class CompoundToggleHoldAction
    extends ToggleHoldAction {
        private boolean newValue;
        private ViewletRange range;
        private ViewletDataStore store;

        CompoundToggleHoldAction(boolean bl, ViewletDataStore viewletDataStore, ViewletRange viewletRange) {
            this.newValue = bl;
            this.range = viewletRange;
            this.store = viewletDataStore;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new ToggleHoldCommand(AbstractViewletType.this, this.store, this.range, this.newValue).issue();
        }
    }
}

