/*
 * Decompiled with CFR 0.152.
 */
package ie.ucc.cccc.viz;

import ie.ucc.cccc.viz.InvariantType;
import ie.ucc.cccc.viz.NodeType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Node {
    private NodeType type;
    private int id;
    private int parent;
    private String name = "";
    private int size;
    private int value = 0;
    private String choice = "";
    private List<Node> children = new ArrayList<Node>();
    private boolean allFailedBelow;
    private int totalDecendent;
    private int totalFailures;
    private int lastDecendent;
    private InvariantType invariantType = InvariantType.TRUE;

    public String toString() {
        return "(Node id " + this.id + " p " + this.parent + " s " + this.size + " v " + this.value + " choice " + this.choice + ")";
    }

    public Node(NodeType nodeType, int n) {
        this.type = nodeType;
        this.id = n;
        this.parent = -1;
    }

    public Node(NodeType nodeType, int n, int n2) {
        this.type = nodeType;
        this.id = n;
        this.parent = n2;
    }

    public Node(NodeType nodeType, int n, int n2, String string, int n3, int n4) {
        this.type = nodeType;
        this.id = n;
        this.parent = n2;
        this.name = string;
        this.size = n3;
        this.value = n4;
    }

    public Node(NodeType nodeType, int n, int n2, String string, int n3, String string2) {
        this.type = nodeType;
        this.id = n;
        this.parent = n2;
        this.name = string;
        this.size = n3;
        this.choice = string2;
    }

    public NodeType getType() {
        return this.type;
    }

    public int getId() {
        return this.id;
    }

    public int getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public int getValue() {
        return this.value;
    }

    public String getChoice() {
        return this.choice;
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public boolean isAllFailedBelow() {
        return this.allFailedBelow;
    }

    public int getTotalDecendent() {
        return this.totalDecendent;
    }

    public int getTotalFailures() {
        return this.totalFailures;
    }

    public int getLastDecendent() {
        return this.lastDecendent;
    }

    public void setType(NodeType nodeType) {
        this.type = nodeType;
    }

    public InvariantType getInvariantType() {
        return this.invariantType;
    }

    public void setInvariantType(InvariantType invariantType) {
        this.invariantType = invariantType;
    }

    public void addChild(Node node) {
        this.children.add(node);
    }

    public void count() {
        switch (this.type) {
            case FAIL: 
            case FAILC: {
                this.allFailedBelow = true;
                this.totalDecendent = 0;
                this.totalFailures = 1;
                this.lastDecendent = this.id;
                break;
            }
            case SUCC: 
            case SUCCC: {
                this.allFailedBelow = false;
                this.totalDecendent = 0;
                this.totalFailures = 0;
                this.lastDecendent = this.id;
                break;
            }
            case TRY: 
            case TRYC: 
            case ROOT: {
                Iterator<Node> iterator = this.children.iterator();
                this.allFailedBelow = true;
                this.totalDecendent = 1;
                this.totalFailures = 0;
                this.lastDecendent = this.id;
                while (iterator.hasNext()) {
                    Node node = iterator.next();
                    node.count();
                    this.allFailedBelow = this.allFailedBelow && node.isAllFailedBelow();
                    this.totalDecendent += node.getTotalDecendent();
                    this.totalFailures += node.getTotalFailures();
                    this.lastDecendent = Math.max(this.lastDecendent, node.getLastDecendent());
                }
                break;
            }
            default: {
                System.out.println("Wrong node type");
            }
        }
    }
}

