/*
 * Decompiled with CFR 0.152.
 */
package ie.ucc.cccc.viz;

import ie.ucc.cccc.viz.Node;
import ie.ucc.cccc.viz.ValueKey;
import ie.ucc.cccc.viz.ValueMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

public class TreeValues {
    static ValueMap tryMap;
    static ValueMap failMap;

    public static TreeValues graph(Node node) {
        TreeValues treeValues = new TreeValues();
        tryMap = new ValueMap();
        failMap = new ValueMap();
        treeValues.recordNodes(node);
        return treeValues;
    }

    public void recordNodes(Node node) {
        this.recordNode(node);
        if (node.getChildren().size() > 0) {
            for (Node node2 : node.getChildren()) {
                this.recordNodes(node2);
            }
        }
    }

    public void recordNode(Node node) {
        switch (node.getType()) {
            case ROOT: {
                break;
            }
            case TRY: 
            case TRYC: {
                tryMap.increment(node.getName(), node.getValue());
                break;
            }
            case FAIL: 
            case FAILC: {
                failMap.increment(node.getName(), node.getValue());
                break;
            }
            case SUCC: 
            case SUCCC: {
                break;
            }
            default: {
                System.out.println("Unexpected node type");
            }
        }
    }

    public void plot(String string, String string2) {
        try {
            File file = new File(string, string2);
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            printWriter.println("Fail");
            printWriter.println("INTEGER");
            for (Map.Entry<ValueKey, Integer> entry : failMap.getMap().entrySet()) {
                printWriter.println(String.valueOf(entry.getValue()) + "  " + entry.getKey().getName() + " " + entry.getKey().getValue());
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("no luck");
        }
    }
}

