/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.ActionMap;
import components.JComponentModifier;
import components.JToolbarButton;
import components.MissingListenerException;
import components.MyInternalFrame;
import components.SVGInputHandler;
import components.SquiggleInputHandler;
import components.SquiggleInputHandlerFilter;
import components.ToolBarFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyVetoException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.SwingHelpUtilities;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.batik.util.Service;
import org.apache.batik.util.resources.ResourceManager;

public class InternalFrame
extends JFrame
implements ActionListener,
ActionMap {
    public static final int FILESSTARTPOS = 2;
    public static final int NOFILEITEMS = 4;
    public static final String ABOUT_ACTION = "AboutAction";
    public static final String OPEN_ACTION = "OpenAction";
    public static final String OPEN_LOCATION_ACTION = "OpenLocationAction";
    public static final String NEW_WINDOW_ACTION = "NewWindowAction";
    public static final String RELOAD_ACTION = "ReloadAction";
    public static final String SAVE_AS_ACTION = "SaveAsAction";
    public static final String BACK_ACTION = "BackAction";
    public static final String FORWARD_ACTION = "ForwardAction";
    public static final String MOVIE_SETUP_ACTION = "MovieSetupAction";
    public static final String END_BACK_ACTION = "EndBackAction";
    public static final String END_FORWARD_ACTION = "EndForwardAction";
    public static final String FAST_FORWARD_ACTION = "FastForwardAction";
    public static final String REWIND_ACTION = "RewindAction";
    public static final String FULL_SCREEN_ACTION = "FullScreenAction";
    public static final String PRINT_ACTION = "PrintAction";
    public static final String EXPORT_AS_JPG_ACTION = "ExportAsJPGAction";
    public static final String EXPORT_AS_PNG_ACTION = "ExportAsPNGAction";
    public static final String EXPORT_AS_TIFF_ACTION = "ExportAsTIFFAction";
    public static final String PREFERENCES_ACTION = "PreferencesAction";
    public static final String CLOSE_ACTION = "CloseAction";
    public static final String VIEW_SOURCE_ACTION = "ViewSourceAction";
    public static final String EXIT_ACTION = "ExitAction";
    public static final String RESET_TRANSFORM_ACTION = "ResetTransformAction";
    public static final String ZOOM_IN_ACTION = "ZoomInAction";
    public static final String ZOOM_OUT_ACTION = "ZoomOutAction";
    public static final String PREVIOUS_TRANSFORM_ACTION = "PreviousTransformAction";
    public static final String NEXT_TRANSFORM_ACTION = "NextTransformAction";
    public static final String USE_STYLESHEET_ACTION = "UseStylesheetAction";
    public static final String PLAY_ACTION = "PlayAction";
    public static final String PAUSE_ACTION = "PauseAction";
    public static final String STOP_ACTION = "StopAction";
    public static final String MONITOR_ACTION = "MonitorAction";
    public static final String DOM_VIEWER_ACTION = "DOMViewerAction";
    public static final String SET_TRANSFORM_ACTION = "SetTransformAction";
    public static final String FIND_DIALOG_ACTION = "FindDialogAction";
    public static final String THUMBNAIL_DIALOG_ACTION = "ThumbnailDialogAction";
    public static final String FLUSH_ACTION = "FlushAction";
    public static final String TOGGLE_DEBUGGER_ACTION = "ToggleDebuggerAction";
    public static String initfilename;
    private HelpSet hs;
    private HelpBroker hb;
    private URL hsURL;
    JDesktopPane desktop;
    JSlider slide_images = new JSlider();
    int WhichIndex = 0;
    String LeftFileName;
    String ThePath;
    Dimension OldSize = null;
    MyInternalFrame left;
    MyInternalFrame right;
    JMenuBar TheMenuBar = null;
    boolean doSlideradjust = true;
    protected BackAction backAction = new BackAction();
    protected EndBackAction endbackAction = new EndBackAction();
    protected ForwardAction forwardAction = new ForwardAction();
    protected EndForwardAction endforwardAction = new EndForwardAction();
    protected FastForwardAction fastforwardAction = new FastForwardAction();
    protected RewindAction rewindAction = new RewindAction();
    protected StopAction stopAction = new StopAction();
    protected MovieSetupAction moviesetupAction = new MovieSetupAction();
    public static final String RESOURCES = "components.resources.GUI";
    protected static ResourceBundle bundle;
    protected static ResourceManager resources;
    protected Map listeners = new HashMap();
    protected static Vector handlers;
    Collection FileNames = new LinkedList();
    Object[] FileNamesarr = null;
    MyActionListener timeraction = new MyActionListener();
    boolean timeractive = false;
    int TheTimerDelay = 400;
    Timer TheTimer = new Timer(this.TheTimerDelay, this.timeraction);
    boolean GoBack = false;

    @Override
    public Action getAction(String string) throws MissingListenerException {
        Action action = (Action)this.listeners.get(string);
        if (action == null) {
            throw new MissingListenerException("Can't find action.", RESOURCES, string);
        }
        return action;
    }

    public InternalFrame() {
        super("ECLiPSe Visualizer");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ThePath = System.getProperty("user.dir");
        int n = 50;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(n, n, dimension.width - n * 2, dimension.height - n * 2);
        this.listeners.put(OPEN_ACTION, new OpenAction());
        this.listeners.put(BACK_ACTION, this.backAction);
        this.listeners.put(END_BACK_ACTION, this.endbackAction);
        this.listeners.put(FORWARD_ACTION, this.forwardAction);
        this.listeners.put(END_FORWARD_ACTION, this.endforwardAction);
        this.listeners.put(MOVIE_SETUP_ACTION, this.moviesetupAction);
        this.listeners.put(REWIND_ACTION, this.rewindAction);
        this.listeners.put(FAST_FORWARD_ACTION, this.fastforwardAction);
        this.listeners.put(STOP_ACTION, this.stopAction);
        this.listeners.put(THUMBNAIL_DIALOG_ACTION, new ThumbnailDialogAction());
        this.desktop = new JDesktopPane();
        this.left = this.createFrame();
        this.right = this.createFrame();
        this.left.setSize((dimension.width - n * 3) / 2, dimension.height - n * 4);
        this.left.setLocation(0, 0);
        this.right.setSize((dimension.width - n * 3) / 2, dimension.height - n * 4);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.right.setLocation((dimension.width - n * 3) / 2, 30);
        ToolBarFactory toolBarFactory = new ToolBarFactory(bundle, this);
        JToolBar jToolBar = toolBarFactory.createJToolBar("ToolBar");
        jToolBar.setFloatable(false);
        jPanel.add((Component)jToolBar, "North");
        for (int i = 0; i < 10; ++i) {
            Component component = jToolBar.getComponentAtIndex(i);
            if (component == null) continue;
            try {
                JToolbarButton jToolbarButton = (JToolbarButton)component;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        jPanel.add((Component)this.slide_images, "South");
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)this.desktop, "Center");
        this.TheMenuBar = this.createMenuBar();
        this.setJMenuBar(this.TheMenuBar);
        this.desktop.setDragMode(1);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = InternalFrame.this.desktop.getSize();
                if (InternalFrame.this.OldSize != null) {
                    Dimension dimension2 = InternalFrame.this.left.getSize();
                    Dimension dimension3 = InternalFrame.this.right.getSize();
                    int n = (int)(dimension.getWidth() * dimension2.getWidth() / InternalFrame.this.OldSize.getWidth());
                    int n2 = (int)(dimension.getHeight() * dimension2.getHeight() / InternalFrame.this.OldSize.getHeight());
                    InternalFrame.this.left.setSize(n, n2);
                    int n3 = (int)(dimension.getWidth() * dimension3.getWidth() / InternalFrame.this.OldSize.getWidth());
                    int n4 = (int)(dimension.getHeight() * dimension3.getHeight() / InternalFrame.this.OldSize.getHeight());
                    InternalFrame.this.right.setSize(n3, n4);
                    InternalFrame.this.left.setLocation(0, 0);
                    InternalFrame.this.right.setLocation(n, 0);
                } else {
                    InternalFrame.this.left.setSize((int)(dimension.getWidth() / 2.0), (int)dimension.getHeight());
                    InternalFrame.this.right.setSize((int)(dimension.getWidth() / 2.0), (int)dimension.getHeight());
                    InternalFrame.this.right.setLocation((int)(dimension.getWidth() / 2.0), 0);
                }
                InternalFrame.this.OldSize = dimension;
            }
        });
        this.slide_images.setValue(1);
        this.slide_images.setMaximum(100);
        this.slide_images.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (InternalFrame.this.doSlideradjust) {
                    float f = jSlider.getValue();
                    float f2 = f / 100.0f;
                    Iterator iterator = InternalFrame.this.FileNames.iterator();
                    int n = InternalFrame.this.FileNames.size();
                    if (n == 0) {
                        return;
                    }
                    int n2 = (int)((float)n * f2);
                    n2 = (double)f > 0.0 ? (int)f - 1 : 0;
                    int n3 = 0;
                    boolean bl = false;
                    if (jSlider.getValueIsAdjusting()) {
                        // empty if block
                    }
                    if (!jSlider.getValueIsAdjusting()) {
                        // empty if block
                    }
                    iterator = InternalFrame.this.FileNames.iterator();
                    String[] stringArray = (String[])InternalFrame.this.FileNamesarr[n2];
                    InternalFrame.this.WhichIndex = n2;
                    InternalFrame.this.LeftFileName = stringArray[0];
                    String string = "file:///" + InternalFrame.this.ThePath + stringArray[0];
                    String string2 = "file:///" + InternalFrame.this.ThePath + stringArray[1];
                    InternalFrame.this.left.setURI(string);
                    InternalFrame.this.right.setURI(string2);
                    ++n3;
                } else {
                    InternalFrame.this.doSlideradjust = true;
                }
            }
        });
        if (initfilename != null) {
            this.fileopen(initfilename, true);
        }
    }

    protected JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(68);
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Open");
        jMenuItem.setMnemonic(79);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        jMenuItem.setActionCommand("open");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        try {
            FileReader fileReader = new FileReader("history.hist");
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            try {
                String string;
                for (int i = 0; (string = bufferedReader.readLine()) != null && i < 4 && string.length() >= 2; ++i) {
                    int n = string.lastIndexOf("/");
                    if (n == -1) {
                        n = string.lastIndexOf("\\");
                    }
                    jMenuItem = new JMenuItem(string.substring(n + 1));
                    jMenuItem.setActionCommand("visited");
                    jMenuItem.setToolTipText(string);
                    jMenuItem.addActionListener(this);
                    jMenu.add(jMenuItem);
                }
                fileReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            jMenu.addSeparator();
            jMenuItem = new JMenuItem("Quit");
            jMenuItem.setMnemonic(81);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 8));
            jMenuItem.setActionCommand("quit");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            jMenu = new JMenu("Help");
            jMenu.setMnemonic(68);
            jMenuBar.add(jMenu);
            jMenuItem = new JMenuItem("Contents");
            jMenuItem.setMnemonic(72);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(72, 8));
            jMenuItem.setActionCommand("help");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        return jMenuBar;
    }

    public static synchronized void registerHandler(SquiggleInputHandler squiggleInputHandler) {
        Vector vector = InternalFrame.getHandlers();
        vector.addElement(squiggleInputHandler);
    }

    protected static Vector getHandlers() {
        if (handlers != null) {
            return handlers;
        }
        handlers = new Vector();
        InternalFrame.registerHandler(new SVGInputHandler());
        Iterator iterator = Service.providers(SquiggleInputHandler.class);
        while (iterator.hasNext()) {
            SquiggleInputHandler squiggleInputHandler = (SquiggleInputHandler)iterator.next();
            InternalFrame.registerHandler(squiggleInputHandler);
        }
        return handlers;
    }

    public void fileopen(String string, boolean bl) {
        JFileChooser jFileChooser = null;
        File file = null;
        if (string == null) {
            jFileChooser = new JFileChooser(this.ThePath);
            jFileChooser.setFileHidingEnabled(false);
            jFileChooser.setFileSelectionMode(0);
            for (SquiggleInputHandler squiggleInputHandler : InternalFrame.getHandlers()) {
                jFileChooser.addChoosableFileFilter(new SquiggleInputHandlerFilter(squiggleInputHandler));
            }
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                file = jFileChooser.getSelectedFile();
            }
        } else {
            file = new File(string);
        }
        if (file != null) {
            try {
                FileReader fileReader = new FileReader(file);
                this.FileNames.clear();
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                try {
                    String string2;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        int n = string2.indexOf(32);
                        String string3 = string2.substring(0, n);
                        String string4 = string2.substring(n + 1, string2.length());
                        String string5 = file.getAbsolutePath();
                        n = string5.lastIndexOf(92);
                        if (n == -1) {
                            n = string5.lastIndexOf(47);
                        }
                        this.ThePath = string5 = string5.substring(0, n + 1);
                        this.FileNames.add(new String[]{string3, string4});
                    }
                    fileReader.close();
                    this.FileNamesarr = this.FileNames.toArray();
                    this.slide_images.setValue(1);
                    this.slide_images.setMaximum(this.FileNames.size());
                    this.left.SetVeryFirst(true);
                    this.right.SetVeryFirst(true);
                    if (bl) {
                        int n;
                        JMenu jMenu = this.TheMenuBar.getMenu(0);
                        int n2 = jMenu.getItemCount();
                        int n3 = 2;
                        boolean bl2 = false;
                        if (n2 - 4 >= 4) {
                            bl2 = true;
                            jMenu.remove(jMenu.getItem(5));
                        }
                        if ((n = (string2 = file.getName()).lastIndexOf("/")) == -1) {
                            n = string2.lastIndexOf("\\");
                        }
                        JMenuItem jMenuItem = new JMenuItem(file.getName());
                        jMenuItem.setActionCommand("visited");
                        jMenuItem.setToolTipText(file.getAbsolutePath());
                        jMenuItem.addActionListener(this);
                        jMenu.add((Component)jMenuItem, 2);
                        FileWriter fileWriter = new FileWriter("history.hist");
                        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                        n2 = jMenu.getItemCount();
                        for (n3 = 2; n3 < n2 - 2; ++n3) {
                            jMenuItem = jMenu.getItem(n3);
                            bufferedWriter.write(jMenuItem.getToolTipText());
                            bufferedWriter.newLine();
                        }
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("open".equals(actionEvent.getActionCommand())) {
            this.fileopen(null, true);
        }
        if ("visited".equals(actionEvent.getActionCommand())) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getToolTipText();
            this.fileopen(string, false);
        }
        if ("help".equals(actionEvent.getActionCommand())) {
            this.openHelp();
        }
    }

    public void openHelp() {
        String string = "/javahelp/docs/helpset.hs";
        try {
            SwingHelpUtilities.setContentViewerUI((String)"components.ExternalLinkContentViewerUI");
            URL uRL = this.getClass().getResource(string);
            this.hs = new HelpSet(null, uRL);
        }
        catch (Exception exception) {
            return;
        }
        this.hb = this.hs.createHelpBroker();
        this.hb.setDisplayed(true);
    }

    protected MyInternalFrame createFrame() {
        MyInternalFrame myInternalFrame = new MyInternalFrame();
        myInternalFrame.setVisible(true);
        this.desktop.add(myInternalFrame);
        try {
            myInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return myInternalFrame;
    }

    protected void quit() {
        System.exit(0);
    }

    private static void createAndShowGUI() {
        JFrame.setDefaultLookAndFeelDecorated(false);
        InternalFrame internalFrame = new InternalFrame();
        internalFrame.setDefaultCloseOperation(3);
        internalFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 0) {
            initfilename = stringArray[0];
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InternalFrame.createAndShowGUI();
            }
        });
    }

    static {
        bundle = ResourceBundle.getBundle(RESOURCES, Locale.getDefault());
        resources = new ResourceManager(bundle);
    }

    public class BackAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (InternalFrame.this.FileNames.size() > 0 && InternalFrame.this.WhichIndex != 0) {
                --InternalFrame.this.WhichIndex;
                float f = InternalFrame.this.slide_images.getValue();
                float f2 = f / 100.0f;
                int n = InternalFrame.this.FileNames.size();
                int n2 = (int)((float)n * f2);
                InternalFrame.this.doSlideradjust = false;
                InternalFrame.this.slide_images.setValue(InternalFrame.this.WhichIndex);
                String[] stringArray = (String[])((LinkedList)InternalFrame.this.FileNames).get(InternalFrame.this.WhichIndex);
                String string = "file:///" + InternalFrame.this.ThePath + stringArray[0];
                String string2 = "file:///" + InternalFrame.this.ThePath + stringArray[1];
                InternalFrame.this.left.setURI(string);
                InternalFrame.this.right.setURI(string2);
            }
        }

        @Override
        public void addJComponent(JComponent jComponent) {
        }

        protected void update() {
        }
    }

    public class EndBackAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (InternalFrame.this.timeractive) {
                InternalFrame.this.TheTimer.stop();
                InternalFrame.this.timeractive = false;
            }
            if (InternalFrame.this.FileNames.size() > 0) {
                InternalFrame.this.WhichIndex = 0;
                InternalFrame.this.doSlideradjust = false;
                InternalFrame.this.slide_images.setValue(InternalFrame.this.WhichIndex);
                String[] stringArray = (String[])((LinkedList)InternalFrame.this.FileNames).get(InternalFrame.this.WhichIndex);
                String string = "file:///" + InternalFrame.this.ThePath + stringArray[0];
                String string2 = "file:///" + InternalFrame.this.ThePath + stringArray[1];
                InternalFrame.this.left.setURI(string);
                InternalFrame.this.right.setURI(string2);
            }
        }
    }

    public class ForwardAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (InternalFrame.this.FileNames.size() > 0 && InternalFrame.this.WhichIndex != InternalFrame.this.FileNames.size() - 1) {
                ++InternalFrame.this.WhichIndex;
                float f = InternalFrame.this.slide_images.getValue();
                float f2 = f / 100.0f;
                int n = InternalFrame.this.FileNames.size();
                int n2 = (int)((float)n * f2);
                InternalFrame.this.doSlideradjust = false;
                InternalFrame.this.slide_images.setValue(InternalFrame.this.WhichIndex);
                String[] stringArray = (String[])((LinkedList)InternalFrame.this.FileNames).get(InternalFrame.this.WhichIndex);
                String string = "file:///" + InternalFrame.this.ThePath + stringArray[0];
                String string2 = "file:///" + InternalFrame.this.ThePath + stringArray[1];
                InternalFrame.this.left.setURI(string);
                InternalFrame.this.right.setURI(string2);
            }
        }

        @Override
        public void addJComponent(JComponent jComponent) {
        }

        protected void update() {
        }
    }

    public class EndForwardAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (InternalFrame.this.timeractive) {
                InternalFrame.this.TheTimer.stop();
                InternalFrame.this.timeractive = false;
            }
            if (InternalFrame.this.FileNames.size() > 0) {
                InternalFrame.this.WhichIndex = InternalFrame.this.FileNames.size() - 1;
                InternalFrame.this.doSlideradjust = false;
                InternalFrame.this.slide_images.setValue(InternalFrame.this.WhichIndex);
                String[] stringArray = (String[])((LinkedList)InternalFrame.this.FileNames).get(InternalFrame.this.WhichIndex);
                String string = "file:///" + InternalFrame.this.ThePath + stringArray[0];
                String string2 = "file:///" + InternalFrame.this.ThePath + stringArray[1];
                InternalFrame.this.left.setURI(string);
                InternalFrame.this.right.setURI(string2);
            }
        }
    }

    public class FastForwardAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (InternalFrame.this.FileNames.size() == 0) {
                return;
            }
            if (!InternalFrame.this.timeractive) {
                InternalFrame.this.TheTimer.start();
                InternalFrame.this.timeractive = true;
            }
            InternalFrame.this.GoBack = false;
        }

        @Override
        public void addJComponent(JComponent jComponent) {
        }

        protected void update() {
        }
    }

    public class RewindAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (InternalFrame.this.FileNames.size() == 0) {
                return;
            }
            if (!InternalFrame.this.timeractive) {
                InternalFrame.this.TheTimer.start();
                InternalFrame.this.timeractive = true;
            }
            InternalFrame.this.GoBack = true;
        }

        @Override
        public void addJComponent(JComponent jComponent) {
        }

        protected void update() {
        }
    }

    public class StopAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InternalFrame.this.TheTimer.stop();
            InternalFrame.this.timeractive = false;
        }
    }

    public class MovieSetupAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = new Object[]{"500", "1000", "1500", "2000", "2500"};
            String string = (String)JOptionPane.showInputDialog(InternalFrame.this.desktop, "Select the delay between documents in milliseconds\n", "Customized Dialog", -1, null, objectArray, "" + InternalFrame.this.TheTimerDelay);
            if (string != null && string.length() > 2) {
                InternalFrame.this.TheTimerDelay = Integer.valueOf(string);
                InternalFrame.this.TheTimer.setDelay(InternalFrame.this.TheTimerDelay);
                return;
            }
        }
    }

    class MyActionListener
    implements ActionListener {
        MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (InternalFrame.this.GoBack) {
                if (InternalFrame.this.WhichIndex == 0) {
                    InternalFrame.this.timeractive = false;
                    InternalFrame.this.TheTimer.stop();
                } else {
                    InternalFrame.this.backAction.actionPerformed(null);
                }
            } else if (InternalFrame.this.WhichIndex == InternalFrame.this.FileNames.size() - 1) {
                InternalFrame.this.timeractive = false;
                InternalFrame.this.TheTimer.stop();
            } else {
                InternalFrame.this.forwardAction.actionPerformed(null);
            }
        }
    }

    public class OpenAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InternalFrame.this.fileopen(null, true);
        }
    }

    public class ThumbnailDialogAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class ExitAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

