/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.special;

import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.ContinuedFraction;
import org.apache.commons.math3.util.FastMath;

public class Gamma {
    public static final double GAMMA = 0.5772156649015329;
    public static final double LANCZOS_G = 4.7421875;
    private static final double DEFAULT_EPSILON = 1.0E-14;
    private static final double[] LANCZOS = new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};
    private static final double HALF_LOG_2_PI = 0.5 * FastMath.log(Math.PI * 2);
    private static final double SQRT_TWO_PI = 2.5066282746310007;
    private static final double C_LIMIT = 49.0;
    private static final double S_LIMIT = 1.0E-5;
    private static final double INV_GAMMA1P_M1_A0 = 6.116095104481416E-9;
    private static final double INV_GAMMA1P_M1_A1 = 6.247308301164655E-9;
    private static final double INV_GAMMA1P_M1_B1 = 0.203610414066807;
    private static final double INV_GAMMA1P_M1_B2 = 0.026620534842894922;
    private static final double INV_GAMMA1P_M1_B3 = 4.939449793824468E-4;
    private static final double INV_GAMMA1P_M1_B4 = -8.514194324403149E-6;
    private static final double INV_GAMMA1P_M1_B5 = -6.4304548177935305E-6;
    private static final double INV_GAMMA1P_M1_B6 = 9.926418406727737E-7;
    private static final double INV_GAMMA1P_M1_B7 = -6.077618957228252E-8;
    private static final double INV_GAMMA1P_M1_B8 = 1.9575583661463974E-10;
    private static final double INV_GAMMA1P_M1_P0 = 6.116095104481416E-9;
    private static final double INV_GAMMA1P_M1_P1 = 6.8716741130671986E-9;
    private static final double INV_GAMMA1P_M1_P2 = 6.820161668496171E-10;
    private static final double INV_GAMMA1P_M1_P3 = 4.686843322948848E-11;
    private static final double INV_GAMMA1P_M1_P4 = 1.5728330277104463E-12;
    private static final double INV_GAMMA1P_M1_P5 = -1.2494415722763663E-13;
    private static final double INV_GAMMA1P_M1_P6 = 4.343529937408594E-15;
    private static final double INV_GAMMA1P_M1_Q1 = 0.3056961078365221;
    private static final double INV_GAMMA1P_M1_Q2 = 0.054642130860422966;
    private static final double INV_GAMMA1P_M1_Q3 = 0.004956830093825887;
    private static final double INV_GAMMA1P_M1_Q4 = 2.6923694661863613E-4;
    private static final double INV_GAMMA1P_M1_C = -0.42278433509846713;
    private static final double INV_GAMMA1P_M1_C0 = 0.5772156649015329;
    private static final double INV_GAMMA1P_M1_C1 = -0.6558780715202539;
    private static final double INV_GAMMA1P_M1_C2 = -0.04200263503409524;
    private static final double INV_GAMMA1P_M1_C3 = 0.16653861138229148;
    private static final double INV_GAMMA1P_M1_C4 = -0.04219773455554433;
    private static final double INV_GAMMA1P_M1_C5 = -0.009621971527876973;
    private static final double INV_GAMMA1P_M1_C6 = 0.0072189432466631;
    private static final double INV_GAMMA1P_M1_C7 = -0.0011651675918590652;
    private static final double INV_GAMMA1P_M1_C8 = -2.1524167411495098E-4;
    private static final double INV_GAMMA1P_M1_C9 = 1.280502823881162E-4;
    private static final double INV_GAMMA1P_M1_C10 = -2.013485478078824E-5;
    private static final double INV_GAMMA1P_M1_C11 = -1.2504934821426706E-6;
    private static final double INV_GAMMA1P_M1_C12 = 1.133027231981696E-6;
    private static final double INV_GAMMA1P_M1_C13 = -2.056338416977607E-7;

    private Gamma() {
    }

    public static double logGamma(double x2) {
        double ret;
        if (Double.isNaN(x2) || x2 <= 0.0) {
            ret = Double.NaN;
        } else {
            if (x2 < 0.5) {
                return Gamma.logGamma1p(x2) - FastMath.log(x2);
            }
            if (x2 <= 2.5) {
                return Gamma.logGamma1p(x2 - 0.5 - 0.5);
            }
            if (x2 <= 8.0) {
                int n2 = (int)FastMath.floor(x2 - 1.5);
                double prod = 1.0;
                for (int i2 = 1; i2 <= n2; ++i2) {
                    prod *= x2 - (double)i2;
                }
                return Gamma.logGamma1p(x2 - (double)(n2 + 1)) + FastMath.log(prod);
            }
            double sum = Gamma.lanczos(x2);
            double tmp = x2 + 4.7421875 + 0.5;
            ret = (x2 + 0.5) * FastMath.log(tmp) - tmp + HALF_LOG_2_PI + FastMath.log(sum / x2);
        }
        return ret;
    }

    public static double regularizedGammaP(double a2, double x2) {
        return Gamma.regularizedGammaP(a2, x2, 1.0E-14, Integer.MAX_VALUE);
    }

    public static double regularizedGammaP(double a2, double x2, double epsilon, int maxIterations) {
        double ret;
        if (Double.isNaN(a2) || Double.isNaN(x2) || a2 <= 0.0 || x2 < 0.0) {
            ret = Double.NaN;
        } else if (x2 == 0.0) {
            ret = 0.0;
        } else if (x2 >= a2 + 1.0) {
            ret = 1.0 - Gamma.regularizedGammaQ(a2, x2, epsilon, maxIterations);
        } else {
            double sum;
            double an;
            double n2 = 0.0;
            for (sum = an = 1.0 / a2; FastMath.abs(an / sum) > epsilon && n2 < (double)maxIterations && sum < Double.POSITIVE_INFINITY; sum += (an *= x2 / (a2 + (n2 += 1.0)))) {
            }
            if (n2 >= (double)maxIterations) {
                throw new MaxCountExceededException(maxIterations);
            }
            ret = Double.isInfinite(sum) ? 1.0 : FastMath.exp(-x2 + a2 * FastMath.log(x2) - Gamma.logGamma(a2)) * sum;
        }
        return ret;
    }

    public static double regularizedGammaQ(double a2, double x2) {
        return Gamma.regularizedGammaQ(a2, x2, 1.0E-14, Integer.MAX_VALUE);
    }

    public static double regularizedGammaQ(final double a2, double x2, double epsilon, int maxIterations) {
        double ret;
        if (Double.isNaN(a2) || Double.isNaN(x2) || a2 <= 0.0 || x2 < 0.0) {
            ret = Double.NaN;
        } else if (x2 == 0.0) {
            ret = 1.0;
        } else if (x2 < a2 + 1.0) {
            ret = 1.0 - Gamma.regularizedGammaP(a2, x2, epsilon, maxIterations);
        } else {
            ContinuedFraction cf = new ContinuedFraction(){

                protected double getA(int n2, double x2) {
                    return 2.0 * (double)n2 + 1.0 - a2 + x2;
                }

                protected double getB(int n2, double x2) {
                    return (double)n2 * (a2 - (double)n2);
                }
            };
            ret = 1.0 / cf.evaluate(x2, epsilon, maxIterations);
            ret = FastMath.exp(-x2 + a2 * FastMath.log(x2) - Gamma.logGamma(a2)) * ret;
        }
        return ret;
    }

    public static double digamma(double x2) {
        if (Double.isNaN(x2) || Double.isInfinite(x2)) {
            return x2;
        }
        if (x2 > 0.0 && x2 <= 1.0E-5) {
            return -0.5772156649015329 - 1.0 / x2;
        }
        if (x2 >= 49.0) {
            double inv = 1.0 / (x2 * x2);
            return FastMath.log(x2) - 0.5 / x2 - inv * (0.08333333333333333 + inv * (0.008333333333333333 - inv / 252.0));
        }
        return Gamma.digamma(x2 + 1.0) - 1.0 / x2;
    }

    public static double trigamma(double x2) {
        if (Double.isNaN(x2) || Double.isInfinite(x2)) {
            return x2;
        }
        if (x2 > 0.0 && x2 <= 1.0E-5) {
            return 1.0 / (x2 * x2);
        }
        if (x2 >= 49.0) {
            double inv = 1.0 / (x2 * x2);
            return 1.0 / x2 + inv / 2.0 + inv / x2 * (0.16666666666666666 - inv * (0.03333333333333333 + inv / 42.0));
        }
        return Gamma.trigamma(x2 + 1.0) + 1.0 / (x2 * x2);
    }

    public static double lanczos(double x2) {
        double sum = 0.0;
        for (int i2 = LANCZOS.length - 1; i2 > 0; --i2) {
            sum += LANCZOS[i2] / (x2 + (double)i2);
        }
        return sum + LANCZOS[0];
    }

    public static double invGamma1pm1(double x2) {
        double ret;
        double t2;
        if (x2 < -0.5) {
            throw new NumberIsTooSmallException(x2, (Number)-0.5, true);
        }
        if (x2 > 1.5) {
            throw new NumberIsTooLargeException(x2, (Number)1.5, true);
        }
        double d2 = t2 = x2 <= 0.5 ? x2 : x2 - 0.5 - 0.5;
        if (t2 < 0.0) {
            double a2 = 6.116095104481416E-9 + t2 * 6.247308301164655E-9;
            double b2 = 1.9575583661463974E-10;
            b2 = -6.077618957228252E-8 + t2 * b2;
            b2 = 9.926418406727737E-7 + t2 * b2;
            b2 = -6.4304548177935305E-6 + t2 * b2;
            b2 = -8.514194324403149E-6 + t2 * b2;
            b2 = 4.939449793824468E-4 + t2 * b2;
            b2 = 0.026620534842894922 + t2 * b2;
            b2 = 0.203610414066807 + t2 * b2;
            b2 = 1.0 + t2 * b2;
            double c2 = -2.056338416977607E-7 + t2 * (a2 / b2);
            c2 = 1.133027231981696E-6 + t2 * c2;
            c2 = -1.2504934821426706E-6 + t2 * c2;
            c2 = -2.013485478078824E-5 + t2 * c2;
            c2 = 1.280502823881162E-4 + t2 * c2;
            c2 = -2.1524167411495098E-4 + t2 * c2;
            c2 = -0.0011651675918590652 + t2 * c2;
            c2 = 0.0072189432466631 + t2 * c2;
            c2 = -0.009621971527876973 + t2 * c2;
            c2 = -0.04219773455554433 + t2 * c2;
            c2 = 0.16653861138229148 + t2 * c2;
            c2 = -0.04200263503409524 + t2 * c2;
            c2 = -0.6558780715202539 + t2 * c2;
            c2 = -0.42278433509846713 + t2 * c2;
            ret = x2 > 0.5 ? t2 * c2 / x2 : x2 * (c2 + 0.5 + 0.5);
        } else {
            double p2 = 4.343529937408594E-15;
            p2 = -1.2494415722763663E-13 + t2 * p2;
            p2 = 1.5728330277104463E-12 + t2 * p2;
            p2 = 4.686843322948848E-11 + t2 * p2;
            p2 = 6.820161668496171E-10 + t2 * p2;
            p2 = 6.8716741130671986E-9 + t2 * p2;
            p2 = 6.116095104481416E-9 + t2 * p2;
            double q2 = 2.6923694661863613E-4;
            q2 = 0.004956830093825887 + t2 * q2;
            q2 = 0.054642130860422966 + t2 * q2;
            q2 = 0.3056961078365221 + t2 * q2;
            q2 = 1.0 + t2 * q2;
            double c3 = -2.056338416977607E-7 + p2 / q2 * t2;
            c3 = 1.133027231981696E-6 + t2 * c3;
            c3 = -1.2504934821426706E-6 + t2 * c3;
            c3 = -2.013485478078824E-5 + t2 * c3;
            c3 = 1.280502823881162E-4 + t2 * c3;
            c3 = -2.1524167411495098E-4 + t2 * c3;
            c3 = -0.0011651675918590652 + t2 * c3;
            c3 = 0.0072189432466631 + t2 * c3;
            c3 = -0.009621971527876973 + t2 * c3;
            c3 = -0.04219773455554433 + t2 * c3;
            c3 = 0.16653861138229148 + t2 * c3;
            c3 = -0.04200263503409524 + t2 * c3;
            c3 = -0.6558780715202539 + t2 * c3;
            c3 = 0.5772156649015329 + t2 * c3;
            ret = x2 > 0.5 ? t2 / x2 * (c3 - 0.5 - 0.5) : x2 * c3;
        }
        return ret;
    }

    public static double logGamma1p(double x2) throws NumberIsTooSmallException, NumberIsTooLargeException {
        if (x2 < -0.5) {
            throw new NumberIsTooSmallException(x2, (Number)-0.5, true);
        }
        if (x2 > 1.5) {
            throw new NumberIsTooLargeException(x2, (Number)1.5, true);
        }
        return -FastMath.log1p(Gamma.invGamma1pm1(x2));
    }

    public static double gamma(double x2) {
        double ret;
        if (x2 == FastMath.rint(x2) && x2 <= 0.0) {
            return Double.NaN;
        }
        double absX = FastMath.abs(x2);
        if (absX <= 20.0) {
            if (x2 >= 1.0) {
                double prod = 1.0;
                double t2 = x2;
                while (t2 > 2.5) {
                    prod *= (t2 -= 1.0);
                }
                ret = prod / (1.0 + Gamma.invGamma1pm1(t2 - 1.0));
            } else {
                double prod = x2;
                double t3 = x2;
                while (t3 < -0.5) {
                    prod *= (t3 += 1.0);
                }
                ret = 1.0 / (prod * (1.0 + Gamma.invGamma1pm1(t3)));
            }
        } else {
            double y2 = absX + 4.7421875 + 0.5;
            double gammaAbs = 2.5066282746310007 / absX * FastMath.pow(y2, absX + 0.5) * FastMath.exp(-y2) * Gamma.lanczos(absX);
            ret = x2 > 0.0 ? gammaAbs : -Math.PI / (x2 * FastMath.sin(Math.PI * x2) * gammaAbs);
        }
        return ret;
    }
}

