/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.report.html;

import de.treichels.hott.model.BaseModel;
import de.treichels.hott.model.HelicopterModel;
import de.treichels.hott.model.WingedModel;
import de.treichels.hott.report.html.CurveImageGenerator;
import de.treichels.hott.report.html.DummyCurveImageGenerator;
import de.treichels.hott.report.html.FreeMarkerExceptionHandler;
import de.treichels.hott.report.html.FreeMarkerHexConverter;
import de.treichels.hott.report.html.FreeMarkerHtmlSafeDirective;
import de.treichels.hott.report.html.HTMLReport$WhenMappings;
import de.treichels.hott.report.html.ReportException;
import de.treichels.hott.voice.VoiceFile;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import tornadofx.ResourceLookup;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ&\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/treichels/hott/report/html/HTMLReport;", "", "()V", "CONFIGURATION", "Lfreemarker/template/Configuration;", "CURVE_IMAGE_GENERATOR", "Lde/treichels/hott/report/html/CurveImageGenerator;", "generateHTML", "", "model", "Lde/treichels/hott/model/BaseModel;", "name", "title", "version", "voiceFile", "Lde/treichels/hott/voice/VoiceFile;", "genetateHTML", "templateName", "rootMap", "", "setSuppressExceptions", "", "suppress", "", "HoTT-Report-HTML"})
public final class HTMLReport {
    private static final Configuration CONFIGURATION;
    private static CurveImageGenerator CURVE_IMAGE_GENERATOR;
    @NotNull
    public static final HTMLReport INSTANCE;

    @NotNull
    public final String generateHTML(@NotNull BaseModel model) throws IOException, ReportException {
        String string2;
        Intrinsics.checkNotNullParameter(model, "model");
        CONFIGURATION.setClassForTemplateLoading(HTMLReport.class, "templates/hott");
        Map<String, Object> rootMap = MapsKt.mutableMapOf(new Pair<String, BaseModel>("model", model), new Pair<String, CurveImageGenerator>("png", CURVE_IMAGE_GENERATOR));
        BaseModel baseModel = model;
        if (baseModel instanceof WingedModel) {
            rootMap.put("wingedModel", model);
        } else if (baseModel instanceof HelicopterModel) {
            rootMap.put("helicopterModel", model);
        }
        switch (HTMLReport$WhenMappings.$EnumSwitchMapping$0[model.getTransmitterType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string2 = "mc-32.xhtml";
                break;
            }
            case 7: 
            case 8: {
                string2 = "mx-16.xhtml";
                break;
            }
            case 9: {
                string2 = "mz-24.xhtml";
                break;
            }
            default: {
                return "<html><head>Not Implemented</head><body><h1>" + model.getTransmitterType() + " is not yet supported!</h1></body></html>";
            }
        }
        String template = string2;
        return this.genetateHTML(template, rootMap);
    }

    @NotNull
    public final String generateHTML(@NotNull String name, @NotNull String title2, @NotNull String version, @NotNull VoiceFile voiceFile) throws IOException {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(title2, "title");
        Intrinsics.checkNotNullParameter(version, "version");
        Intrinsics.checkNotNullParameter(voiceFile, "voiceFile");
        CONFIGURATION.setClassForTemplateLoading(HTMLReport.class, "templates/hott");
        HashMap rootMap = new HashMap();
        ((Map)rootMap).put("name", name);
        ((Map)rootMap).put("title", title2);
        ((Map)rootMap).put("version", version);
        ((Map)rootMap).put("voicefile", voiceFile);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Template template = CONFIGURATION.getTemplate("voicefile.ftl");
        try {
            template.process(rootMap, new OutputStreamWriter((OutputStream)baos, "UTF-8"));
        }
        catch (TemplateException e2) {
            throw (Throwable)new ReportException(e2);
        }
        String string2 = baos.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "baos.toString()");
        return string2;
    }

    private final String genetateHTML(String templateName, Map<String, Object> rootMap) throws IOException {
        String string2;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Template template = CONFIGURATION.getTemplate(templateName);
            rootMap.put("hex", new FreeMarkerHexConverter());
            rootMap.put("htmlsafe", new FreeMarkerHtmlSafeDirective());
            String string3 = new File(System.getProperty("program.dir", ".")).toURI().toURL().toString();
            Intrinsics.checkNotNullExpressionValue(string3, "File(System.getProperty(\u2026oURI().toURL().toString()");
            rootMap.put("programDir", string3);
            String string4 = new File(System.getProperty("java.io.tmpdir"), "Arial.ttf").toURI().toURL().toString();
            Intrinsics.checkNotNullExpressionValue(string4, "File(System.getProperty(\u2026oURI().toURL().toString()");
            rootMap.put("fontFile", string4);
            String string5 = System.getProperty("program.version", "Unknown");
            Intrinsics.checkNotNullExpressionValue(string5, "System.getProperty(\"program.version\", \"Unknown\")");
            rootMap.put("version", string5);
            template.process(rootMap, new OutputStreamWriter((OutputStream)baos, "UTF-8"));
            String string6 = baos.toString();
            Intrinsics.checkNotNullExpressionValue(string6, "baos.toString()");
            string2 = string6;
        }
        catch (TemplateException e2) {
            throw (Throwable)new ReportException(e2);
        }
        return string2;
    }

    public final void setSuppressExceptions(boolean suppress) {
        CONFIGURATION.setTemplateExceptionHandler(suppress ? (TemplateExceptionHandler)new FreeMarkerExceptionHandler() : TemplateExceptionHandler.DEBUG_HANDLER);
    }

    private HTMLReport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        HTMLReport hTMLReport;
        INSTANCE = hTMLReport = new HTMLReport();
        CONFIGURATION = new Configuration(Configuration.VERSION_2_3_27);
        ServiceLoader<CurveImageGenerator> serviceLoader = ServiceLoader.load(CurveImageGenerator.class);
        Intrinsics.checkNotNullExpressionValue(serviceLoader, "ServiceLoader.load(Curve\u2026ageGenerator::class.java)");
        CurveImageGenerator curveImageGenerator = (CurveImageGenerator)CollectionsKt.firstOrNull((Iterable)serviceLoader);
        if (curveImageGenerator == null) {
            curveImageGenerator = new DummyCurveImageGenerator();
        }
        CURVE_IMAGE_GENERATOR = curveImageGenerator;
        CONFIGURATION.setEncoding(Locale.getDefault(), "UTF-8");
        CONFIGURATION.setObjectWrapper(new DefaultObjectWrapper(Configuration.VERSION_2_3_27));
        File fontFile = new File(System.getProperty("java.io.tmpdir"), "Arial.ttf");
        Closeable closeable = new ResourceLookup(INSTANCE).stream("Arial.ttf");
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            int n2;
            InputStream inputStream2 = (InputStream)closeable;
            boolean bl3 = false;
            Closeable closeable2 = new FileOutputStream(fontFile);
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                FileOutputStream outputStream = (FileOutputStream)closeable2;
                boolean bl6 = false;
                n2 = IOUtils.copy(inputStream2, (OutputStream)outputStream);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            int n3 = n2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }
}

