/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.qrcode;

import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharacterSetECI {
    private static HashMap<String, CharacterSetECI> NAME_TO_ECI;
    private final String encodingName;
    private final int value;

    private static void initialize() {
        HashMap<String, CharacterSetECI> n2 = new HashMap<String, CharacterSetECI>(29);
        CharacterSetECI.addCharacterSet(0, "Cp437", n2);
        CharacterSetECI.addCharacterSet(1, new String[]{"ISO8859_1", "ISO-8859-1"}, n2);
        CharacterSetECI.addCharacterSet(2, "Cp437", n2);
        CharacterSetECI.addCharacterSet(3, new String[]{"ISO8859_1", "ISO-8859-1"}, n2);
        CharacterSetECI.addCharacterSet(4, new String[]{"ISO8859_2", "ISO-8859-2"}, n2);
        CharacterSetECI.addCharacterSet(5, new String[]{"ISO8859_3", "ISO-8859-3"}, n2);
        CharacterSetECI.addCharacterSet(6, new String[]{"ISO8859_4", "ISO-8859-4"}, n2);
        CharacterSetECI.addCharacterSet(7, new String[]{"ISO8859_5", "ISO-8859-5"}, n2);
        CharacterSetECI.addCharacterSet(8, new String[]{"ISO8859_6", "ISO-8859-6"}, n2);
        CharacterSetECI.addCharacterSet(9, new String[]{"ISO8859_7", "ISO-8859-7"}, n2);
        CharacterSetECI.addCharacterSet(10, new String[]{"ISO8859_8", "ISO-8859-8"}, n2);
        CharacterSetECI.addCharacterSet(11, new String[]{"ISO8859_9", "ISO-8859-9"}, n2);
        CharacterSetECI.addCharacterSet(12, new String[]{"ISO8859_10", "ISO-8859-10"}, n2);
        CharacterSetECI.addCharacterSet(13, new String[]{"ISO8859_11", "ISO-8859-11"}, n2);
        CharacterSetECI.addCharacterSet(15, new String[]{"ISO8859_13", "ISO-8859-13"}, n2);
        CharacterSetECI.addCharacterSet(16, new String[]{"ISO8859_14", "ISO-8859-14"}, n2);
        CharacterSetECI.addCharacterSet(17, new String[]{"ISO8859_15", "ISO-8859-15"}, n2);
        CharacterSetECI.addCharacterSet(18, new String[]{"ISO8859_16", "ISO-8859-16"}, n2);
        CharacterSetECI.addCharacterSet(20, new String[]{"SJIS", "Shift_JIS"}, n2);
        NAME_TO_ECI = n2;
    }

    private CharacterSetECI(int value, String encodingName) {
        this.encodingName = encodingName;
        this.value = value;
    }

    public String getEncodingName() {
        return this.encodingName;
    }

    public int getValue() {
        return this.value;
    }

    private static void addCharacterSet(int value, String encodingName, HashMap<String, CharacterSetECI> n2) {
        CharacterSetECI eci = new CharacterSetECI(value, encodingName);
        n2.put(encodingName, eci);
    }

    private static void addCharacterSet(int value, String[] encodingNames, HashMap<String, CharacterSetECI> n2) {
        CharacterSetECI eci = new CharacterSetECI(value, encodingNames[0]);
        for (int i2 = 0; i2 < encodingNames.length; ++i2) {
            n2.put(encodingNames[i2], eci);
        }
    }

    public static CharacterSetECI getCharacterSetECIByName(String name) {
        if (NAME_TO_ECI == null) {
            CharacterSetECI.initialize();
        }
        return NAME_TO_ECI.get(name);
    }
}

