/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock.normalizer.processor;

import com.monstarmike.tlmreader.datablock.RxBlock;
import com.monstarmike.tlmreader.datablock.normalizer.processor.AbstractProcessor;

public class InvalidCountsProcessor
extends AbstractProcessor<RxBlock> {
    private double lessThan10Percent = 0.1;
    private int countA = 0;
    private int countB = 0;
    private int countL = 0;
    private int countR = 0;
    private int totalCount = 0;

    @Override
    public void preprocess(RxBlock rxBlock) {
        if (rxBlock.hasValidDataLostPacketsReceiverA()) {
            ++this.countA;
        }
        if (rxBlock.hasValidDataLostPacketsReceiverB()) {
            ++this.countB;
        }
        if (rxBlock.hasValidDataLostPacketsReceiverL()) {
            ++this.countL;
        }
        if (rxBlock.hasValidDataLostPacketsReceiverR()) {
            ++this.countR;
        }
        ++this.totalCount;
    }

    @Override
    public boolean isBad(RxBlock rxBlock) {
        boolean remove = false;
        boolean badBlock = true;
        if (rxBlock.hasValidDataLostPacketsReceiverA()) {
            if (this.calculatePercent(this.countA) < this.lessThan10Percent) {
                remove = true;
            }
            badBlock = false;
        }
        if (rxBlock.hasValidDataLostPacketsReceiverB()) {
            if (this.calculatePercent(this.countB) < this.lessThan10Percent) {
                remove = true;
            }
            badBlock = false;
        }
        if (rxBlock.hasValidDataLostPacketsReceiverL()) {
            if (this.calculatePercent(this.countL) < this.lessThan10Percent) {
                remove = true;
            }
            badBlock = false;
        }
        if (rxBlock.hasValidDataLostPacketsReceiverR()) {
            if (this.calculatePercent(this.countR) < this.lessThan10Percent) {
                remove = true;
            }
            badBlock = false;
        }
        return badBlock || remove;
    }

    @Override
    public Class<RxBlock> getClassOfDataBlock() {
        return RxBlock.class;
    }

    private double calculatePercent(int count) {
        return (double)count / (double)this.totalCount;
    }
}

