/*
 * Decompiled with CFR 0.152.
 */
package gde.device.skyrc;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.device.resource.DeviceXmlResource;
import gde.device.skyrc.MC3000Dialog;
import gde.device.skyrc.MC3000GathererThread;
import gde.device.skyrc.MC3000UsbPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.io.DataParser;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.usb.UsbClaimException;
import javax.usb.UsbException;
import javax.xml.bind.JAXBException;

public class MC3000
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(MC3000.class.getName());
    final DataExplorer application;
    final Settings settings;
    final MC3000Dialog dialog;
    final MC3000UsbPort usbPort;
    protected String[] STATUS_MODE;
    protected String[] USAGE_MODE_LI;
    protected String[] USAGE_MODE_NI;
    protected String[] USAGE_MODE_ZN;
    protected String[] USAGE_MODE_PB;
    protected String[] BATTERY_TYPE;
    static final String[] cellTypeNames = new String[]{"LiIon", "LiFe", "LiIo4.35", "NiMH", "NiCd", "NiZn", "Eneloop", "RAM", "LTO"};
    static final String[] cycleModeNames = new String[]{"C>D", "C>D>C", "D>C", "D>C>D"};
    static final String[] operationModeLi = new String[]{"Charge", "Refresh", "Storage", "Discharge", "Cycle"};
    static final String[] operationModeNi = new String[]{"Charge", "Refresh", "Break_in", "Discharge", "Cycle"};
    static final String[] operationModeZnRAM = new String[]{"Charge", "Refresh", "Discharge", "Cycle"};
    static final String[] cellModelNames111 = new String[]{"Std AA", "Lite AAA", "Lite AAA", "Std AAA", "Std AAA", "Pro/XX AAA", "Pro/XX AAA", "Lite AA", "Std AA", "Plus AA", "Pro/XX AA", "Std C", "Std C", "Std D", "OFF"};
    static final int[] cellModelCapacity111 = new int[]{0, 700, 720, 900, 960, 1000, 1080, 1200, 2000, 2400, 3000, 3800, 3840, 7200};
    static final String[] cellModelNames112 = new String[]{"Std AA", "Lite AAA", "Lite AAA", "Std AAA", "Std AAA", "Pro/XX AAA", "Pro/XX AAA", "Lite AA", "Lite AA", "Std AA", "Std AA", "Plus AA", "Plus AA", "Pro/XX AA", "Pro/XX AA", "Std C", "Std C", "Std D", "Std D", "OFF"};
    static final int[] cellModelCapacity112 = new int[]{0, 600, 720, 800, 960, 900, 1080, 1000, 1200, 2000, 2400, 2200, 2640, 2500, 3000, 3200, 3840, 6000, 7200};
    static final String[] trickleTimeValues = new String[]{"OFF", "End", "Rest"};
    SystemSettings systemSettings;

    public MC3000(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.skyrc.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.STATUS_MODE = new String[]{Messages.getString((String)"GDE_MSGT3600"), Messages.getString((String)"GDE_MSGT3601"), Messages.getString((String)"GDE_MSGT3602"), Messages.getString((String)"GDE_MSGT3603"), Messages.getString((String)"GDE_MSGT3604"), Messages.getString((String)"GDE_MSGT3605")};
        this.USAGE_MODE_LI = new String[]{Messages.getString((String)"GDE_MSGT3610"), Messages.getString((String)"GDE_MSGT3611"), Messages.getString((String)"GDE_MSGT3612"), Messages.getString((String)"GDE_MSGT3613"), Messages.getString((String)"GDE_MSGT3614")};
        this.USAGE_MODE_NI = new String[]{Messages.getString((String)"GDE_MSGT3620"), Messages.getString((String)"GDE_MSGT3621"), Messages.getString((String)"GDE_MSGT3622"), Messages.getString((String)"GDE_MSGT3623"), Messages.getString((String)"GDE_MSGT3624")};
        this.USAGE_MODE_ZN = new String[]{Messages.getString((String)"GDE_MSGT3620"), Messages.getString((String)"GDE_MSGT3621"), Messages.getString((String)"GDE_MSGT3623"), Messages.getString((String)"GDE_MSGT3624"), Messages.getString((String)"GDE_MSGT3624")};
        this.BATTERY_TYPE = new String[]{Messages.getString((String)"GDE_MSGT3640"), Messages.getString((String)"GDE_MSGT3641"), Messages.getString((String)"GDE_MSGT3642"), Messages.getString((String)"GDE_MSGT3643"), Messages.getString((String)"GDE_MSGT3644"), Messages.getString((String)"GDE_MSGT3645"), Messages.getString((String)"GDE_MSGT3646"), Messages.getString((String)"GDE_MSGT3647"), Messages.getString((String)"GDE_MSGT3686")};
        this.application = DataExplorer.getInstance();
        this.settings = Settings.getInstance();
        this.usbPort = new MC3000UsbPort(this, this.application);
        this.dialog = new MC3000Dialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
    }

    public MC3000(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.skyrc.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.STATUS_MODE = new String[]{Messages.getString((String)"GDE_MSGT3600"), Messages.getString((String)"GDE_MSGT3601"), Messages.getString((String)"GDE_MSGT3602"), Messages.getString((String)"GDE_MSGT3603"), Messages.getString((String)"GDE_MSGT3604"), Messages.getString((String)"GDE_MSGT3605")};
        this.USAGE_MODE_LI = new String[]{Messages.getString((String)"GDE_MSGT3610"), Messages.getString((String)"GDE_MSGT3611"), Messages.getString((String)"GDE_MSGT3612"), Messages.getString((String)"GDE_MSGT3613"), Messages.getString((String)"GDE_MSGT3614")};
        this.USAGE_MODE_NI = new String[]{Messages.getString((String)"GDE_MSGT3620"), Messages.getString((String)"GDE_MSGT3621"), Messages.getString((String)"GDE_MSGT3622"), Messages.getString((String)"GDE_MSGT3623"), Messages.getString((String)"GDE_MSGT3624")};
        this.USAGE_MODE_ZN = new String[]{Messages.getString((String)"GDE_MSGT3620"), Messages.getString((String)"GDE_MSGT3621"), Messages.getString((String)"GDE_MSGT3623"), Messages.getString((String)"GDE_MSGT3624"), Messages.getString((String)"GDE_MSGT3624")};
        this.BATTERY_TYPE = new String[]{Messages.getString((String)"GDE_MSGT3640"), Messages.getString((String)"GDE_MSGT3641"), Messages.getString((String)"GDE_MSGT3642"), Messages.getString((String)"GDE_MSGT3643"), Messages.getString((String)"GDE_MSGT3644"), Messages.getString((String)"GDE_MSGT3645"), Messages.getString((String)"GDE_MSGT3646"), Messages.getString((String)"GDE_MSGT3647"), Messages.getString((String)"GDE_MSGT3686")};
        this.application = DataExplorer.getInstance();
        this.settings = Settings.getInstance();
        this.usbPort = new MC3000UsbPort(this, this.application);
        this.dialog = new MC3000Dialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, "", "");
        }
    }

    public DeviceDialog getDialog() {
        return this.dialog;
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    public int getLovDataByteSize() {
        return 86;
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int channelConfigNumber = recordSet.getChannelConfigNumber();
        int displayableCounter = 0;
        boolean configChanged = this.isChangePropery();
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            MeasurementType measurement = this.getMeasurement(channelConfigNumber, i);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, record.getName() + " = " + DeviceXmlResource.getInstance().getReplacement(this.getMeasurementNames(channelConfigNumber)[i]));
            }
            if (record.isActive() && record.isActive() != measurement.isActive()) {
                record.setActive(Boolean.valueOf(measurement.isActive()));
                record.setVisible(measurement.isActive());
                record.setDisplayable(measurement.isActive());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "switch " + record.getName() + " to " + measurement.isActive());
                }
            }
            if (includeReasonableDataCheck) {
                record.setDisplayable(record.hasReasonableData() && measurement.isActive());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, record.getName() + " hasReasonableData " + record.hasReasonableData());
                }
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "add to displayable counter: " + record.getName());
            }
            ++displayableCounter;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "displayableCounter = " + displayableCounter);
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
        this.setChangePropery(configChanged);
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
    }

    public MC3000UsbPort getCommunicationPort() {
        return this.usbPort;
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION};
    }

    public void open_closeCommPort() {
        block22: {
            if (this.usbPort != null) {
                if (!this.usbPort.isConnected()) {
                    try {
                        Channel activChannel = Channels.getInstance().getActiveChannel();
                        if (activChannel == null) break block22;
                        ((MC3000Dialog)this.getDialog()).dataGatherThread = new MC3000GathererThread(this.application, this, this.usbPort, activChannel.getNumber(), (MC3000Dialog)this.getDialog());
                        try {
                            if (((MC3000Dialog)this.getDialog()).dataGatherThread != null && this.usbPort.isConnected()) {
                                this.systemSettings = new SystemSettings(this, this.usbPort.getSystemSettings());
                                WaitTimer.delay((long)100L);
                                ((MC3000Dialog)this.getDialog()).dataGatherThread.start();
                            } else {
                                this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                            }
                        }
                        catch (Throwable e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                    catch (UsbClaimException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0051", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName() + " : " + e.getMessage()}));
                        try {
                            if (this.usbPort != null && this.usbPort.isConnected()) {
                                this.usbPort.closeUsbPort(null);
                            }
                        }
                        catch (UsbException ex) {
                            log.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    catch (UsbException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0050"));
                        try {
                            if (this.usbPort != null && this.usbPort.isConnected()) {
                                this.usbPort.closeUsbPort(null);
                            }
                        }
                        catch (UsbException ex) {
                            log.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    catch (ApplicationConfigurationException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                        this.application.getDeviceSelectionDialog().open();
                    }
                    catch (Throwable e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                    }
                } else {
                    if (((MC3000Dialog)this.getDialog()).dataGatherThread != null) {
                        ((MC3000Dialog)this.getDialog()).dataGatherThread.stopDataGatheringThread(false, null);
                    }
                    try {
                        WaitTimer.delay((long)1000L);
                        if (this.usbPort != null && this.usbPort.isConnected()) {
                            this.usbPort.closeUsbPort(null);
                        }
                    }
                    catch (UsbException e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
        }
    }

    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        block9: {
            block8: {
                int chargeCorrection = this.getProcessingType(dataBuffer) == 3 || (this.getProcessingType(dataBuffer) == 1 || this.getProcessingType(dataBuffer) == 2 || this.getProcessingType(dataBuffer) == 4) && this.getProcessingStatus(dataBuffer) == 2 ? -1 : 1;
                points[0] = DataParser.parse2Short((byte)dataBuffer[9], (byte)dataBuffer[8]) * 1000;
                points[1] = DataParser.parse2Short((byte)dataBuffer[11], (byte)dataBuffer[10]) * 1000 * chargeCorrection;
                points[2] = DataParser.parse2Short((byte)dataBuffer[13], (byte)dataBuffer[12]) * 1000;
                if (this.systemSettings == null || this.systemSettings.getFirmwareVersionAsInt() > 105) break block8;
                points[3] = Double.valueOf((double)points[0] / 1000.0 * (double)points[1] / 1000.0 * (double)chargeCorrection).intValue();
                switch (dataBuffer[1]) {
                    case 0: {
                        points[4] = points[4] + Double.valueOf((double)points[0] / 1000.0 * (double)points[1] / 1000.0 * (double)chargeCorrection / 3600.0 + 0.5).intValue();
                        break;
                    }
                    case 1: {
                        points[4] = 0;
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "reset Energy");
                            break;
                        }
                        break block9;
                    }
                    default: {
                        points[4] = points[4];
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "untouche Energy");
                            break;
                        }
                        break block9;
                    }
                }
                break block9;
            }
            points[3] = DataParser.parse2Short((byte)dataBuffer[23], (byte)dataBuffer[22]) * 1000;
            points[4] = DataParser.parse2Short((byte)dataBuffer[21], (byte)dataBuffer[20]) * 1000;
        }
        if (this.systemSettings != null && this.systemSettings.getFirmwareVersionAsInt() >= 111) {
            points[2] = points[2] + dataBuffer[24] * 100;
        }
        points[5] = DataParser.parse2Short((byte)dataBuffer[15], (byte)dataBuffer[14]) * 1000;
        points[6] = DataParser.parse2Short((byte)dataBuffer[17], (byte)dataBuffer[16]) * 1000;
        points[7] = DataParser.parse2Short((byte)dataBuffer[19], (byte)dataBuffer[18]) * 1000;
        if (this.systemSettings != null && this.systemSettings.getFirmwareVersionAsInt() >= 114) {
            points[8] = DataParser.parse2Short((byte)dataBuffer[26], (byte)dataBuffer[25]) * 1000;
        }
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().threadId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
            int j = 0;
            int k = 0;
            while (j < points.length) {
                points[j] = ((convertBuffer[k] & 0xFF) << 24) + ((convertBuffer[k + 1] & 0xFF) << 16) + ((convertBuffer[k + 2] & 0xFF) << 8) + ((convertBuffer[k + 3] & 0xFF) << 0);
                ++j;
                k += 4;
            }
            recordSet.addPoints(points);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 2500 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double offset = record.getOffset();
                double reduction = record.getReduction();
                double factor = record.getFactor();
                dataTableRow[index + 1] = record.getDecimalFormat().format(offset + ((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = (value - reduction) * factor + offset;
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double newValue = (value - offset) / factor + reduction;
        log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public int getCurrentSmoothIndex() {
        return 1;
    }

    public boolean isProcessing(int outletNum, byte[] dataBuffer) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "isProcessing = " + dataBuffer[5]);
        }
        if (this.settings.isReduceChargeDischarge() && !this.isContinuousRecordSet()) {
            return dataBuffer[5] > 0 && dataBuffer[5] < 3;
        }
        return dataBuffer[5] > 0 && dataBuffer[5] <= 4;
    }

    public int getProcessingStatus(byte[] dataBuffer) {
        return dataBuffer[5];
    }

    public boolean isProcessingStatusStandByOrFinished(byte[] dataBuffer) {
        return dataBuffer[5] == 0 || dataBuffer[5] == 4;
    }

    public String getProcessingStatusName(byte[] dataBuffer) {
        return this.isContinuousRecordSet() ? Messages.getString((String)"GDE_MSGT3606") : this.STATUS_MODE[dataBuffer[5]];
    }

    protected boolean isContinuousRecordSet() {
        return this.settings.isContinuousRecordSet() || this.application.getActiveDevice().getName().contains("-Set");
    }

    public String getProcessingBatteryTypeName(byte[] dataBuffer) {
        return this.BATTERY_TYPE[dataBuffer[2]];
    }

    public int getProcessingType(byte[] dataBuffer) {
        return dataBuffer[3];
    }

    public int getBatteryType(byte[] dataBuffer) {
        return dataBuffer[2];
    }

    public String getProcessingTypeName(byte[] dataBuffer) {
        String processTypeName = "";
        switch (this.getBatteryType(dataBuffer)) {
            case 0: 
            case 1: 
            case 2: {
                processTypeName = this.USAGE_MODE_LI[this.getProcessingType(dataBuffer)];
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                processTypeName = this.USAGE_MODE_NI[this.getProcessingType(dataBuffer)];
                break;
            }
            case 5: 
            case 7: {
                processTypeName = this.USAGE_MODE_ZN[this.getProcessingType(dataBuffer)];
            }
        }
        return this.isContinuousRecordSet() ? Messages.getString((String)"GDE_MSGT3606") : processTypeName;
    }

    public int getCycleNumber(int outletNum, byte[] dataBuffer) {
        return dataBuffer[4];
    }

    public int[] getCellVoltageOrdinals() {
        switch (Channels.getInstance().getActiveChannelNumber()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new int[]{0, 2};
            }
        }
        return new int[]{-1, -1};
    }

    public String getHardwareString() {
        return this.systemSettings.getHardwareVersion();
    }

    public String getFirmwareString() {
        return this.systemSettings.getFirmwareVersion();
    }

    public int getFirmwareVersionAsInt() {
        return this.systemSettings.getFirmwareVersionAsInt();
    }

    public String getTemperatureUnit() {
        return this.systemSettings.getTemperatureUnit() == 0 ? "\u00b0C" : "\u00b0F";
    }

    public byte getBatteryMemoryNumber(int slotNumber) {
        try {
            this.systemSettings = new SystemSettings(this, this.usbPort.getSystemSettings());
        }
        catch (Exception e) {
            return 0;
        }
        switch (slotNumber) {
            case 1: {
                return this.systemSettings.getSlot1programmNumber();
            }
            case 2: {
                return this.systemSettings.getSlot2programmNumber();
            }
            case 3: {
                return this.systemSettings.getSlot3programmNumber();
            }
            case 4: {
                return this.systemSettings.getSlot4programmNumber();
            }
        }
        return 0;
    }

    public String getFileBaseDir() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected class SystemSettings {
        byte currentSlotNumber;
        byte slot1programmNumber;
        byte slot2programmNumber;
        byte slot3programmNumber;
        byte slot4programmNumber;
        byte userInterfaceMode;
        byte temperatureUnit;
        byte beepTone;
        boolean isHideLiFe;
        boolean isHideLiIon435;
        boolean isHideEneloop;
        boolean isHideNiZn;
        byte LCDoffTime;
        byte minVoltage;
        byte[] machineId = new byte[16];
        boolean isHideRAM;

        public SystemSettings(MC3000 this$0, byte[] buffer) {
            this.currentSlotNumber = buffer[2];
            this.slot1programmNumber = buffer[3];
            this.slot2programmNumber = buffer[4];
            this.slot3programmNumber = buffer[5];
            this.slot4programmNumber = buffer[6];
            this.userInterfaceMode = buffer[7];
            this.temperatureUnit = buffer[8];
            this.beepTone = buffer[9];
            this.isHideLiFe = buffer[10] == 1;
            this.isHideLiIon435 = buffer[11] == 1;
            this.isHideEneloop = buffer[12] == 1;
            this.isHideNiZn = buffer[13] == 1;
            this.LCDoffTime = buffer[14];
            this.minVoltage = buffer[15];
            for (int i = 0; i < 15; ++i) {
                this.machineId[i] = buffer[i + 16];
            }
            this.isHideRAM = buffer[32] == 1;
        }

        public String getFirmwareVersion() {
            return String.format("Firmware : %d.%02d", this.machineId[11], this.machineId[12]);
        }

        public int getFirmwareVersionAsInt() {
            return Integer.valueOf(String.format("%d%02d", this.machineId[11], this.machineId[12]));
        }

        public String getHardwareVersion() {
            return String.format("Hardware : %d.%d", this.machineId[13] / 10, this.machineId[13] % 10);
        }

        public int getHardwareVersionAsInt() {
            return this.machineId[13];
        }

        public byte getCurrentSlotNumber() {
            return this.currentSlotNumber;
        }

        public void setCurrentSlotNumber(byte currentSlotNumber) {
            this.currentSlotNumber = currentSlotNumber;
        }

        public byte getUserInterfaceMode() {
            return this.userInterfaceMode;
        }

        public void setUserInterfaceMode(byte userInterfaceMode) {
            this.userInterfaceMode = userInterfaceMode;
        }

        public byte getTemperatureUnit() {
            return this.temperatureUnit;
        }

        public void setTemperatureUnit(byte temperatureUnit) {
            this.temperatureUnit = temperatureUnit;
        }

        public byte getBeepTone() {
            return this.beepTone;
        }

        public boolean isHideLiFe() {
            return this.isHideLiFe;
        }

        public void setHideLiFe(boolean isHideLiFe) {
            this.isHideLiFe = isHideLiFe;
        }

        public boolean isHideLiIon435() {
            return this.isHideLiIon435;
        }

        public void setHideLiIon435(boolean isHideLiIon435) {
            this.isHideLiIon435 = isHideLiIon435;
        }

        public boolean isHideEneloop() {
            return this.isHideEneloop;
        }

        public boolean isHideNiZn() {
            return this.isHideNiZn;
        }

        public boolean isHideRAM() {
            return this.isHideRAM;
        }

        public byte getLCDoffTime() {
            return this.LCDoffTime;
        }

        public void setLCDoffTime(byte lCDoffTime) {
            this.LCDoffTime = lCDoffTime;
        }

        public byte getMinVoltage() {
            return this.minVoltage;
        }

        public void setMinVoltage(byte minVoltage) {
            this.minVoltage = minVoltage;
        }

        public byte getSlot1programmNumber() {
            return (byte)(this.slot1programmNumber + 1);
        }

        public byte getSlot2programmNumber() {
            return (byte)(this.slot2programmNumber + 1);
        }

        public byte getSlot3programmNumber() {
            return (byte)(this.slot3programmNumber + 1);
        }

        public byte getSlot4programmNumber() {
            return (byte)(this.slot4programmNumber + 1);
        }
    }

    protected class SlotSettings {
        byte[] slotBuffer = new byte[64];
        int firmwareVersion;
        byte slotNumber;
        byte busyTag;
        byte batteryType;
        byte operationMode;
        byte[] capacity;
        byte[] chargeCurrent;
        byte[] dischargeCurrent;
        byte[] dischargeCutVoltage;
        byte[] chargeEndVoltage;
        byte[] dischargeReduceCurrent;
        byte[] chargeEndCurrent;
        byte numberCycle;
        byte chargeRestingTime;
        byte cycleMode;
        byte peakSenseVoltage;
        byte trickleCurrent;
        byte[] restartVoltage;
        byte cutTemperature;
        byte[] cutTime;
        byte temperatureUnit;
        byte dischargeRestingTime;
        byte trickleTime;

        public SlotSettings(MC3000 this$0, byte[] buffer, int firmware) throws Exception {
            if (MC3000UsbPort.calculateCheckSum(buffer) == buffer[buffer.length - 1]) {
                System.arraycopy(buffer, 0, this.slotBuffer, 0, buffer.length);
                this.firmwareVersion = firmware;
                this.slotNumber = buffer[1];
                this.busyTag = buffer[2];
                this.batteryType = buffer[3];
                this.operationMode = buffer[4];
                this.capacity = new byte[]{buffer[5], buffer[6]};
                this.chargeCurrent = new byte[]{buffer[7], buffer[8]};
                this.dischargeCurrent = new byte[]{buffer[9], buffer[10]};
                this.dischargeCutVoltage = new byte[]{buffer[11], buffer[12]};
                this.chargeEndVoltage = new byte[]{buffer[13], buffer[14]};
                this.chargeEndCurrent = new byte[]{buffer[15], buffer[16]};
                this.dischargeReduceCurrent = new byte[]{buffer[17], buffer[18]};
                this.numberCycle = buffer[19];
                this.chargeRestingTime = buffer[20];
                this.cycleMode = buffer[21];
                this.peakSenseVoltage = buffer[22];
                this.trickleCurrent = buffer[23];
                this.restartVoltage = new byte[]{buffer[24], buffer[25]};
                this.cutTemperature = buffer[26];
                this.cutTime = new byte[]{buffer[27], buffer[28]};
                this.temperatureUnit = buffer[29];
                if (this.firmwareVersion > 111) {
                    this.trickleTime = buffer[30];
                    this.dischargeRestingTime = buffer[31];
                } else {
                    this.trickleTime = 0;
                    this.dischargeRestingTime = 0;
                }
            } else {
                log.log(Level.SEVERE, Messages.getString((String)"GDE_MSGE3600"));
                WaitTimer.delay((long)500L);
                this$0.application.openMessageDialogAsync(this$0.application.getShell(), Messages.getString((String)"GDE_MSGE3600"));
                throw new Exception(Messages.getString((String)"GDE_MSGE3600"));
            }
            log.log(Level.FINE, this.toString());
        }

        public SlotSettings(MC3000 this$0, SlotSettings slotSettings) {
            System.arraycopy(slotSettings.getBuffer(), 0, this.slotBuffer, 0, slotSettings.getBuffer().length);
            this.firmwareVersion = slotSettings.firmwareVersion;
            this.slotNumber = slotSettings.slotNumber;
            this.busyTag = slotSettings.busyTag;
            this.batteryType = slotSettings.batteryType;
            this.operationMode = slotSettings.operationMode;
            this.capacity = (byte[])slotSettings.capacity.clone();
            this.chargeCurrent = (byte[])slotSettings.chargeCurrent.clone();
            this.dischargeCurrent = (byte[])slotSettings.dischargeCurrent.clone();
            this.dischargeCutVoltage = (byte[])slotSettings.dischargeCutVoltage.clone();
            this.chargeEndVoltage = (byte[])slotSettings.chargeEndVoltage.clone();
            this.dischargeReduceCurrent = (byte[])slotSettings.dischargeReduceCurrent.clone();
            this.chargeEndCurrent = (byte[])slotSettings.chargeEndCurrent.clone();
            this.numberCycle = slotSettings.numberCycle;
            this.chargeRestingTime = slotSettings.chargeRestingTime;
            this.cycleMode = slotSettings.cycleMode;
            this.peakSenseVoltage = slotSettings.peakSenseVoltage;
            this.trickleCurrent = slotSettings.trickleCurrent;
            this.restartVoltage = (byte[])slotSettings.restartVoltage.clone();
            this.cutTemperature = slotSettings.cutTemperature;
            this.cutTime = (byte[])slotSettings.cutTime.clone();
            this.temperatureUnit = slotSettings.temperatureUnit;
            if (this.firmwareVersion > 111) {
                this.trickleTime = slotSettings.trickleTime;
                this.dischargeRestingTime = slotSettings.dischargeRestingTime;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, this.toString());
            }
        }

        public boolean isBusy() {
            return this.busyTag == 1;
        }

        public String toString() {
            if (this.firmwareVersion <= 111) {
                return String.format(" slot#=%02d busy=%b BATT TYPE=%02d MODE=%02d CAPACITY=%04d C.CURRENT=%04d D.CURRENT=%04d CUT VOLT=%04d TARGET VOLT=%04d D.REDUCE=%04d TERMINATION=%04d CYCLE COUNT=%02d C.RESTING=%02d CYCLE MODE=%d DELTA PEAK=%02d TRICKLE C=%02d RESTART VOLT=%03d CUT TEMP=%02d CUT TIME=%03d temeratureUnit=%d", this.slotNumber, this.busyTag == 1, this.batteryType, this.operationMode, this.getCapacity(), this.getChargeCurrent(), this.getDischargeCurrent(), this.getDischargeCutVoltage(), this.getChargeEndVoltage(), this.getDischargeReduceCurrent(), this.getChargeEndCurrent(), this.numberCycle, this.chargeRestingTime & 0xFF, this.cycleMode, this.peakSenseVoltage, this.trickleCurrent, this.getRestartVoltage(), this.cutTemperature, this.getCutTime(), this.temperatureUnit);
            }
            return String.format(" slot#=%02d busy=%b BATT TYPE=%02d MODE=%02d CAPACITY=%04d C.CURRENT=%04d D.CURRENT=%04d CUT VOLT=%04d TARGET VOLT=%04d D.REDUCE=%04d TERMINATION=%04d CYCLE COUNT=%02d C.RESTING=%02d D.RESTING=%02d CYCLE MODE=%d DELTA PEAK=%02d TRICKLE C=%02d TRICKLE TIME=%s RESTART VOLT=%03d CUT TEMP=%02d CUT TIME=%03d temeratureUnit=%d", this.slotNumber, this.busyTag == 1, this.batteryType, this.operationMode, this.getCapacity(), this.getChargeCurrent(), this.getDischargeCurrent(), this.getDischargeCutVoltage(), this.getChargeEndVoltage(), this.getDischargeReduceCurrent(), this.getChargeEndCurrent(), this.numberCycle, this.chargeRestingTime & 0xFF, this.dischargeRestingTime & 0xFF, this.cycleMode, this.peakSenseVoltage, this.trickleCurrent, this.trickleTime == 0 ? "OFF" : (this.trickleTime == 1 ? "END" : "Rest"), this.getRestartVoltage(), this.cutTemperature, this.getCutTime(), this.temperatureUnit);
        }

        public String toString4Tip(boolean isToolTip, byte systemTemperatureUnit) {
            StringBuilder sb = new StringBuilder();
            sb.append(Messages.getString((String)"GDE_MSGT3682")).append(cellTypeNames[this.batteryType]).append(GDE.LINE_SEPARATOR);
            this.appendOperationMode(sb.append(Messages.getString((String)"GDE_MSGT3683")));
            sb.append(GDE.LINE_SEPARATOR);
            this.appendCapacityModelNominal(sb);
            if (((this.batteryType <= 4 || this.batteryType == 6 || this.batteryType == 8) && this.operationMode != 3 || (this.batteryType == 5 || this.batteryType == 7) && this.operationMode != 2) && this.getChargeCurrent() != 0) {
                sb.append(String.format(Locale.ENGLISH, "%-14s %4.2fA", Messages.getString((String)"GDE_MSGT3661"), (double)this.getChargeCurrent() / 1000.0)).append(GDE.LINE_SEPARATOR);
            } else if (!isToolTip) {
                sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3661"))).append(GDE.LINE_SEPARATOR);
            }
            if (this.operationMode != 0 && this.getDischargeCurrent() != 0) {
                sb.append(String.format(Locale.ENGLISH, "%-13s -%4.2fA", Messages.getString((String)"GDE_MSGT3662"), (double)this.getDischargeCurrent() / 1000.0)).append(GDE.LINE_SEPARATOR);
            } else if (!isToolTip) {
                sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3662"))).append(GDE.LINE_SEPARATOR);
            }
            if ((this.batteryType <= 4 || this.batteryType == 6 || this.batteryType == 8) && this.operationMode != 3 || (this.batteryType == 5 || this.batteryType == 7) && this.operationMode != 2) {
                sb.append(String.format(Locale.ENGLISH, "%-14s %dmin", Messages.getString((String)"GDE_MSGT3663"), this.chargeRestingTime & 0xFF)).append(GDE.LINE_SEPARATOR);
            } else if (!isToolTip) {
                sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3663"))).append(GDE.LINE_SEPARATOR);
            }
            if (this.operationMode != 0) {
                if (this.firmwareVersion > 111) {
                    sb.append(String.format(Locale.ENGLISH, "%-14s %dmin", Messages.getString((String)"GDE_MSGT3664"), this.dischargeRestingTime & 0xFF)).append(GDE.LINE_SEPARATOR);
                } else {
                    sb.append(String.format(Locale.ENGLISH, "%-14s %dmin (FW <=1.11 = %s)", Messages.getString((String)"GDE_MSGT3664"), this.chargeRestingTime & 0xFF, Messages.getString((String)"GDE_MSGT3663"))).append(GDE.LINE_SEPARATOR);
                }
            } else if (!isToolTip) {
                sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3664"), this.dischargeRestingTime & 0xFF)).append(GDE.LINE_SEPARATOR);
            }
            this.appendCycleCountCycleMode(sb, isToolTip);
            if ((this.batteryType <= 2 || this.batteryType == 8) && this.operationMode != 3 || (this.batteryType == 3 || this.batteryType == 4 || this.batteryType == 6) && this.operationMode != 2 && this.operationMode != 3 || (this.batteryType == 5 || this.batteryType == 7) && this.operationMode != 2) {
                sb.append(String.format(Locale.ENGLISH, "%-14s %4.2fV", Messages.getString((String)"GDE_MSGT3667"), (double)this.getChargeEndVoltage() / 1000.0)).append(GDE.LINE_SEPARATOR);
            } else if (!isToolTip) {
                sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3667"))).append(GDE.LINE_SEPARATOR);
            }
            this.appendCcCvTerminationCurrent(sb, isToolTip);
            this.appendNiProcessEndDetectionValues(sb, isToolTip);
            this.appendRestartVoltage(sb, isToolTip);
            this.appendDischargeReductionCurrent(sb, isToolTip);
            if (this.operationMode == 0 || this.operationMode == 2 && (this.batteryType < 3 || this.batteryType == 8)) {
                if (!isToolTip) {
                    sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3671"))).append(GDE.LINE_SEPARATOR);
                }
            } else {
                sb.append(String.format(Locale.ENGLISH, "%-14s %4.2fV", Messages.getString((String)"GDE_MSGT3671"), (double)this.getDischargeCutVoltage() / 1000.0)).append(GDE.LINE_SEPARATOR);
            }
            switch (systemTemperatureUnit) {
                case 1: {
                    if (this.getCutTemperature(systemTemperatureUnit) >= 68) {
                        sb.append(String.format(Locale.ENGLISH, "%-14s %d%s", Messages.getString((String)"GDE_MSGT3672"), this.getCutTemperature(systemTemperatureUnit), systemTemperatureUnit == 0 ? "\u00b0C" : "\u00b0F"));
                        break;
                    }
                    sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3672")));
                    break;
                }
                default: {
                    if (this.getCutTemperature(systemTemperatureUnit) >= 20) {
                        sb.append(String.format(Locale.ENGLISH, "%-14s %d%s", Messages.getString((String)"GDE_MSGT3672"), this.getCutTemperature(systemTemperatureUnit), systemTemperatureUnit == 0 ? "\u00b0C" : "\u00b0F"));
                        break;
                    }
                    sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3672")));
                }
            }
            if ((this.batteryType == 3 || this.batteryType == 4 || this.batteryType == 6) && this.operationMode == 2) {
                if (!isToolTip) {
                    sb.append(GDE.LINE_SEPARATOR).append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3673")));
                }
            } else if (this.getCutTime() == 0) {
                sb.append(GDE.LINE_SEPARATOR).append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3673")));
            } else {
                sb.append(GDE.LINE_SEPARATOR).append(String.format(Locale.ENGLISH, "%-14s %dmin", Messages.getString((String)"GDE_MSGT3673"), this.getCutTime()));
            }
            return sb.toString();
        }

        private void appendDischargeReductionCurrent(StringBuilder sb, boolean isToolTip) {
            block0 : switch (this.batteryType) {
                default: {
                    switch (this.operationMode) {
                        case 0: {
                            if (isToolTip) break block0;
                            sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3670"))).append(GDE.LINE_SEPARATOR);
                            break;
                        }
                        default: {
                            if (this.getDischargeReduceCurrent() == 0) {
                                sb.append(String.format(Locale.ENGLISH, "%-13s -Zero", Messages.getString((String)"GDE_MSGT3670"))).append(GDE.LINE_SEPARATOR);
                                break;
                            }
                            if (this.getDischargeReduceCurrent() >= this.getDischargeCurrent()) {
                                sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3670"))).append(GDE.LINE_SEPARATOR);
                                break;
                            }
                            sb.append(String.format(Locale.ENGLISH, "%-13s -%3.2fA", Messages.getString((String)"GDE_MSGT3670"), (double)this.getDischargeReduceCurrent() / 1000.0)).append(GDE.LINE_SEPARATOR);
                            break;
                        }
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    switch (this.operationMode) {
                        case 0: 
                        case 2: {
                            if (isToolTip) break block0;
                            sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3670"))).append(GDE.LINE_SEPARATOR);
                            break;
                        }
                        default: {
                            if (this.getDischargeReduceCurrent() == 0) {
                                sb.append(String.format(Locale.ENGLISH, "%-13s -Zero", Messages.getString((String)"GDE_MSGT3670"))).append(GDE.LINE_SEPARATOR);
                                break;
                            }
                            if (this.getDischargeReduceCurrent() >= this.getDischargeCurrent()) {
                                sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3670"))).append(GDE.LINE_SEPARATOR);
                                break;
                            }
                            sb.append(String.format(Locale.ENGLISH, "%-13s -%3.2fA", Messages.getString((String)"GDE_MSGT3670"), (double)this.getDischargeReduceCurrent() / 1000.0)).append(GDE.LINE_SEPARATOR);
                            break;
                        }
                    }
                    break;
                }
                case 5: 
                case 7: {
                    switch (this.operationMode) {
                        case 0: {
                            if (isToolTip) break block0;
                            sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3670"))).append(GDE.LINE_SEPARATOR);
                            break block0;
                        }
                        default: {
                            if (this.getDischargeReduceCurrent() == 0) {
                                sb.append(String.format(Locale.ENGLISH, "%-13s -Zero", Messages.getString((String)"GDE_MSGT3670"))).append(GDE.LINE_SEPARATOR);
                                break block0;
                            }
                            if (this.getDischargeReduceCurrent() >= this.getDischargeCurrent()) {
                                sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3670"))).append(GDE.LINE_SEPARATOR);
                                break block0;
                            }
                            sb.append(String.format(Locale.ENGLISH, "%-13s -%3.2fA", Messages.getString((String)"GDE_MSGT3670"), (double)this.getDischargeReduceCurrent() / 1000.0)).append(GDE.LINE_SEPARATOR);
                        }
                    }
                }
            }
        }

        private void appendRestartVoltage(StringBuilder sb, boolean isToolTip) {
            block0 : switch (this.batteryType) {
                default: {
                    switch (this.operationMode) {
                        case 2: 
                        case 3: {
                            if (isToolTip) break block0;
                            sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3669"))).append(GDE.LINE_SEPARATOR);
                            break;
                        }
                        default: {
                            if (this.getRestartVoltage() != 0) {
                                sb.append(String.format(Locale.ENGLISH, "%-14s %4.2fV", Messages.getString((String)"GDE_MSGT3669"), (double)this.getRestartVoltage() / 1000.0)).append(GDE.LINE_SEPARATOR);
                                break;
                            }
                            sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3669"))).append(GDE.LINE_SEPARATOR);
                            break;
                        }
                    }
                    break;
                }
                case 5: 
                case 7: {
                    switch (this.operationMode) {
                        case 2: {
                            if (isToolTip) break block0;
                            sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3669"))).append(GDE.LINE_SEPARATOR);
                            break block0;
                        }
                        default: {
                            if (this.getRestartVoltage() != 0) {
                                sb.append(String.format(Locale.ENGLISH, "%-14s %4.2fV", Messages.getString((String)"GDE_MSGT3669"), (double)this.getRestartVoltage() / 1000.0)).append(GDE.LINE_SEPARATOR);
                                break block0;
                            }
                            sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3669"))).append(GDE.LINE_SEPARATOR);
                        }
                    }
                }
            }
        }

        private void appendNiProcessEndDetectionValues(StringBuilder sb, boolean isToolTip) {
            block0 : switch (this.batteryType) {
                case 0: 
                case 1: 
                case 2: 
                case 5: 
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    switch (this.operationMode) {
                        case 2: 
                        case 3: {
                            if (isToolTip) break block0;
                            sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3674"))).append(GDE.LINE_SEPARATOR);
                            sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3675"))).append(GDE.LINE_SEPARATOR);
                            sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3676"))).append(GDE.LINE_SEPARATOR);
                            break block0;
                        }
                        default: {
                            if (this.peakSenseVoltage == 0) {
                                sb.append(String.format(Locale.ENGLISH, "%-14s 0dV", Messages.getString((String)"GDE_MSGT3674"))).append(GDE.LINE_SEPARATOR);
                            } else {
                                sb.append(String.format(Locale.ENGLISH, "%-14s %dmV", Messages.getString((String)"GDE_MSGT3674"), this.peakSenseVoltage)).append(GDE.LINE_SEPARATOR);
                            }
                            if (this.trickleCurrent != 0) {
                                sb.append(String.format(Locale.ENGLISH, "%-14s %dmA", Messages.getString((String)"GDE_MSGT3675"), this.trickleCurrent * 10)).append(GDE.LINE_SEPARATOR);
                            } else {
                                sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3675"))).append(GDE.LINE_SEPARATOR);
                            }
                            if (this.firmwareVersion > 111) {
                                sb.append(String.format(Locale.ENGLISH, "%-14s %s", Messages.getString((String)"GDE_MSGT3676"), trickleTimeValues[this.trickleTime])).append(GDE.LINE_SEPARATOR);
                                break block0;
                            }
                            sb.append(String.format(Locale.ENGLISH, "%-14s ?? FW <=1.11", Messages.getString((String)"GDE_MSGT3676"))).append(GDE.LINE_SEPARATOR);
                        }
                    }
                }
            }
        }

        private void appendCcCvTerminationCurrent(StringBuilder sb, boolean isToolTip) {
            block0 : switch (this.batteryType) {
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                default: {
                    switch (this.operationMode) {
                        case 3: {
                            if (isToolTip) break block0;
                            sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3668"))).append(GDE.LINE_SEPARATOR);
                            break;
                        }
                        default: {
                            if (this.getChargeEndCurrent() == 0) {
                                sb.append(String.format(Locale.ENGLISH, "%-14s Zero", Messages.getString((String)"GDE_MSGT3668"))).append(GDE.LINE_SEPARATOR);
                                break;
                            }
                            if (this.getChargeEndCurrent() >= this.getChargeCurrent()) {
                                sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3668"))).append(GDE.LINE_SEPARATOR);
                                break;
                            }
                            sb.append(String.format(Locale.ENGLISH, "%-14s %4.2fA", Messages.getString((String)"GDE_MSGT3668"), (double)this.getChargeEndCurrent() / 1000.0)).append(GDE.LINE_SEPARATOR);
                            break;
                        }
                    }
                    break;
                }
                case 5: 
                case 7: {
                    switch (this.operationMode) {
                        case 2: {
                            if (isToolTip) break block0;
                            sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3668"))).append(GDE.LINE_SEPARATOR);
                            break block0;
                        }
                        default: {
                            if (this.getChargeEndCurrent() == 0) {
                                sb.append(String.format(Locale.ENGLISH, "%-14s Zero", Messages.getString((String)"GDE_MSGT3668"))).append(GDE.LINE_SEPARATOR);
                                break block0;
                            }
                            if (this.getChargeEndCurrent() >= this.getChargeCurrent()) {
                                sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3668"))).append(GDE.LINE_SEPARATOR);
                                break block0;
                            }
                            sb.append(String.format(Locale.ENGLISH, "%-14s %4.2fA", Messages.getString((String)"GDE_MSGT3668"), (double)this.getChargeEndCurrent() / 1000.0)).append(GDE.LINE_SEPARATOR);
                        }
                    }
                }
            }
        }

        private void appendCycleCountCycleMode(StringBuilder sb, boolean isToolTip) {
            block0 : switch (this.batteryType) {
                default: {
                    switch (this.operationMode) {
                        case 1: {
                            sb.append(String.format(Locale.ENGLISH, "%-14s %d", Messages.getString((String)"GDE_MSGT3665"), 1)).append(GDE.LINE_SEPARATOR);
                            sb.append(String.format(Locale.ENGLISH, "%-14s %s", Messages.getString((String)"GDE_MSGT3666"), cycleModeNames[1])).append(GDE.LINE_SEPARATOR);
                            break block0;
                        }
                        case 4: {
                            sb.append(String.format(Locale.ENGLISH, "%-14s %d", Messages.getString((String)"GDE_MSGT3665"), this.numberCycle)).append(GDE.LINE_SEPARATOR);
                            sb.append(String.format(Locale.ENGLISH, "%-14s %s", Messages.getString((String)"GDE_MSGT3666"), this.getCycleModeString())).append(GDE.LINE_SEPARATOR);
                            break block0;
                        }
                    }
                    if (isToolTip) break;
                    sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3665"))).append(GDE.LINE_SEPARATOR);
                    sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3666"), this.getCycleModeString())).append(GDE.LINE_SEPARATOR);
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    switch (this.operationMode) {
                        case 1: {
                            sb.append(String.format(Locale.ENGLISH, "%-14s %d", Messages.getString((String)"GDE_MSGT3665"), 1)).append(GDE.LINE_SEPARATOR);
                            sb.append(String.format(Locale.ENGLISH, "%-14s %s", Messages.getString((String)"GDE_MSGT3666"), cycleModeNames[1])).append(GDE.LINE_SEPARATOR);
                            break block0;
                        }
                        case 2: {
                            if (!isToolTip) {
                                sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3665"))).append(GDE.LINE_SEPARATOR);
                            }
                            sb.append(String.format(Locale.ENGLISH, "%-14s %s", Messages.getString((String)"GDE_MSGT3666"), this.cycleMode == 0 ? cycleModeNames[1] : cycleModeNames[3])).append(GDE.LINE_SEPARATOR);
                            break block0;
                        }
                        case 4: {
                            sb.append(String.format(Locale.ENGLISH, "%-14s %d", Messages.getString((String)"GDE_MSGT3665"), this.numberCycle)).append(GDE.LINE_SEPARATOR);
                            sb.append(String.format(Locale.ENGLISH, "%-14s %s", Messages.getString((String)"GDE_MSGT3666"), this.getCycleModeString())).append(GDE.LINE_SEPARATOR);
                            break block0;
                        }
                    }
                    if (isToolTip) break;
                    sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3665"))).append(GDE.LINE_SEPARATOR);
                    sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3666"), this.getCycleModeString())).append(GDE.LINE_SEPARATOR);
                    break;
                }
                case 5: 
                case 7: {
                    switch (this.operationMode) {
                        case 1: {
                            sb.append(String.format(Locale.ENGLISH, "%-14s %d", Messages.getString((String)"GDE_MSGT3665"), 1)).append(GDE.LINE_SEPARATOR);
                            sb.append(String.format(Locale.ENGLISH, "%-14s %s", Messages.getString((String)"GDE_MSGT3666"), cycleModeNames[1])).append(GDE.LINE_SEPARATOR);
                            break block0;
                        }
                        case 3: {
                            sb.append(String.format(Locale.ENGLISH, "%-14s %d", Messages.getString((String)"GDE_MSGT3665"), this.numberCycle)).append(GDE.LINE_SEPARATOR);
                            sb.append(String.format(Locale.ENGLISH, "%-14s %s", Messages.getString((String)"GDE_MSGT3666"), this.getCycleModeString())).append(GDE.LINE_SEPARATOR);
                            break block0;
                        }
                    }
                    if (isToolTip) break;
                    sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3665"))).append(GDE.LINE_SEPARATOR);
                    sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3666"), this.getCycleModeString())).append(GDE.LINE_SEPARATOR);
                }
            }
        }

        private void appendCapacityModelNominal(StringBuilder sb) {
            block0 : switch (this.batteryType) {
                default: {
                    if (this.getCapacity() == 0) {
                        sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3660"))).append(GDE.LINE_SEPARATOR);
                        break;
                    }
                    sb.append(String.format(Locale.ENGLISH, "%-14s %dmAh", Messages.getString((String)"GDE_MSGT3660"), this.getCapacity())).append(GDE.LINE_SEPARATOR);
                    break;
                }
                case 3: 
                case 4: {
                    switch (this.operationMode) {
                        case 2: {
                            sb.append(String.format(Locale.ENGLISH, "%-14s %dmAh", Messages.getString((String)"GDE_MSGT3685"), this.getCapacity())).append(GDE.LINE_SEPARATOR);
                            break block0;
                        }
                    }
                    if (this.getCapacity() == 0) {
                        sb.append(String.format(Locale.ENGLISH, "%-14s OFF", Messages.getString((String)"GDE_MSGT3660"))).append(GDE.LINE_SEPARATOR);
                        break;
                    }
                    sb.append(String.format(Locale.ENGLISH, "%-14s %dmAh", Messages.getString((String)"GDE_MSGT3660"), this.getCapacity())).append(GDE.LINE_SEPARATOR);
                    break;
                }
                case 6: {
                    int i;
                    if (this.firmwareVersion <= 111) {
                        for (i = 0; this.batteryType == 6 && i < cellModelCapacity111.length && this.getCapacity() != cellModelCapacity111[i]; ++i) {
                        }
                        sb.append(String.format(Locale.ENGLISH, "%-14s %s", Messages.getString((String)"GDE_MSGT3684"), cellModelNames111[i])).append(GDE.LINE_SEPARATOR);
                        break;
                    }
                    while (i < cellModelCapacity112.length && this.getCapacity() != cellModelCapacity112[i]) {
                        ++i;
                    }
                    sb.append(String.format(Locale.ENGLISH, "%-14s %s", Messages.getString((String)"GDE_MSGT3684"), cellModelNames112[i])).append(GDE.LINE_SEPARATOR);
                }
            }
        }

        public String toString4View() {
            StringBuilder sb = new StringBuilder();
            sb.append(cellTypeNames[this.batteryType]).append(" ").append(" ");
            this.appendOperationMode(sb);
            sb.append(" ").append(" ");
            block0 : switch (this.batteryType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    switch (this.operationMode) {
                        case 0: {
                            sb.append(String.format(Locale.ENGLISH, "%4.2fA", (double)this.getChargeCurrent() / 1000.0));
                            break;
                        }
                        case 1: {
                            sb.append(String.format(Locale.ENGLISH, "-%4.2f/%4.2fA", (double)this.getDischargeCurrent() / 1000.0, (double)this.getChargeCurrent() / 1000.0));
                            break;
                        }
                        case 2: {
                            block10 : switch (this.batteryType) {
                                case 6: {
                                    if (this.firmwareVersion <= 111) {
                                        for (i = 0; i < cellModelCapacity111.length; ++i) {
                                            if (this.getCapacity() != cellModelCapacity111[i]) continue;
                                            sb.append(cellModelNames111[i]);
                                            break block10;
                                        }
                                    } else {
                                        while (i < cellModelCapacity112.length) {
                                            if (this.getCapacity() == cellModelCapacity112[i]) {
                                                sb.append(cellModelNames112[i]);
                                                break block10;
                                            }
                                            ++i;
                                        }
                                    }
                                    break block0;
                                }
                                case 0: 
                                case 1: 
                                case 2: 
                                case 8: {
                                    sb.append(String.format(Locale.ENGLISH, "%3.2fV", (double)this.getChargeEndVoltage() / 1000.0));
                                    break;
                                }
                                default: {
                                    sb.append(String.format(Locale.ENGLISH, "%dmAh", this.getCapacity()));
                                    break;
                                }
                            }
                            break block0;
                        }
                        case 3: {
                            sb.append(String.format(Locale.ENGLISH, "-%4.2fA", (double)this.getDischargeCurrent() / 1000.0));
                            break;
                        }
                        case 4: {
                            sb.append(String.format(Locale.ENGLISH, "-%4.2f/%4.2fA", (double)this.getDischargeCurrent() / 1000.0, (double)this.getChargeCurrent() / 1000.0));
                            sb.append(String.format("  N=%d (%s)", this.numberCycle, this.getCycleModeString()));
                            break;
                        }
                    }
                    break;
                }
                default: {
                    switch (this.operationMode) {
                        case 0: {
                            sb.append(String.format(Locale.ENGLISH, "%4.2fA", (double)this.getChargeCurrent() / 1000.0));
                            break block0;
                        }
                        case 1: {
                            sb.append(String.format(Locale.ENGLISH, "-%4.2f/%4.2fA", (double)this.getDischargeCurrent() / 1000.0, (double)this.getChargeCurrent() / 1000.0));
                            break block0;
                        }
                        case 2: {
                            sb.append(String.format(Locale.ENGLISH, "-%4.2fA", (double)this.getDischargeCurrent() / 1000.0));
                            break block0;
                        }
                        case 3: {
                            sb.append(String.format(Locale.ENGLISH, "-%4.2f/%4.2fA", (double)this.getDischargeCurrent() / 1000.0, (double)this.getChargeCurrent() / 1000.0));
                            sb.append(String.format("  N=%d (%s)", this.numberCycle, this.getCycleModeString()));
                            break block0;
                        }
                    }
                }
            }
            return sb.toString().trim();
        }

        private void appendOperationMode(StringBuilder sb) {
            switch (this.batteryType) {
                default: {
                    sb.append(operationModeLi[this.operationMode]);
                    break;
                }
                case 5: 
                case 7: {
                    sb.append(operationModeZnRAM[this.operationMode]);
                    break;
                }
                case 3: 
                case 4: {
                    sb.append(operationModeNi[this.operationMode]);
                    break;
                }
                case 6: {
                    sb.append(operationModeNi[this.operationMode]);
                }
            }
        }

        public byte[] getBuffer() {
            return this.slotBuffer;
        }

        public byte[] getBuffer(byte newSlotNumber, int firmwareAsNumber, byte systemTemperatureUnit) {
            byte[] reducedBuffer = new byte[64];
            if (firmwareAsNumber <= 111) {
                reducedBuffer[0] = 15;
                reducedBuffer[1] = 29;
                reducedBuffer[2] = 17;
                reducedBuffer[3] = 0;
                reducedBuffer[4] = newSlotNumber;
                reducedBuffer[5] = this.batteryType;
                reducedBuffer[6] = (byte)(this.getCapacity() / 100);
                reducedBuffer[7] = this.operationMode;
                System.arraycopy(this.slotBuffer, 7, reducedBuffer, 8, 17);
                reducedBuffer[25] = this.cutTemperature;
                System.arraycopy(this.slotBuffer, 27, reducedBuffer, 26, 2);
                System.arraycopy(this.slotBuffer, 24, reducedBuffer, 28, 2);
                reducedBuffer[30] = MC3000UsbPort.calculateCheckSum(reducedBuffer, reducedBuffer[1]);
                reducedBuffer[31] = -1;
                reducedBuffer[32] = -1;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])reducedBuffer, (int)64));
                    log.log(Level.FINE, String.format("slot#=%02d BATT TYPE=%02d MODE=%02d CAPACITY=%04d C.CURRENT=%04d D.CURRENT=%04d D.REDUCE=%04d TARGET VOLT=%04d D.REDUCE=%04d TERMINATION=%04d CYCLE COUNT=%02d C.RESTING=%02d CYCLE MODE=%d DELTA PEAK=%02d TRICKLE C=%02d CUT TEMP=%02d CUT TIME=%03d RESTART VOLT=%04d", reducedBuffer[4], reducedBuffer[5], this.operationMode, (reducedBuffer[6] & 0xFF) * 100, this.getChargeCurrent(), this.getDischargeCurrent(), this.getDischargeReduceCurrent(), this.getChargeEndVoltage(), this.getDischargeReduceCurrent(), this.getChargeEndCurrent(), this.numberCycle, this.chargeRestingTime & 0xFF, this.cycleMode, this.peakSenseVoltage, this.trickleCurrent, this.cutTemperature, DataParser.parse2UnsignedShort((byte)reducedBuffer[27], (byte)reducedBuffer[26]), DataParser.parse2UnsignedShort((byte)reducedBuffer[29], (byte)reducedBuffer[28])));
                }
            } else {
                reducedBuffer[0] = 15;
                reducedBuffer[1] = 32;
                reducedBuffer[2] = 17;
                reducedBuffer[3] = 0;
                reducedBuffer[4] = newSlotNumber;
                reducedBuffer[5] = this.batteryType;
                System.arraycopy(this.slotBuffer, 5, reducedBuffer, 6, 2);
                reducedBuffer[8] = this.operationMode;
                System.arraycopy(this.slotBuffer, 7, reducedBuffer, 9, 14);
                reducedBuffer[23] = this.dischargeRestingTime;
                reducedBuffer[24] = this.cycleMode;
                reducedBuffer[25] = this.peakSenseVoltage;
                reducedBuffer[26] = this.trickleCurrent;
                reducedBuffer[27] = this.trickleTime;
                reducedBuffer[28] = (byte)this.getCutTemperature(systemTemperatureUnit);
                System.arraycopy(this.slotBuffer, 27, reducedBuffer, 29, 2);
                System.arraycopy(this.slotBuffer, 24, reducedBuffer, 31, 2);
                reducedBuffer[33] = MC3000UsbPort.calculateCheckSum(reducedBuffer, reducedBuffer[1]);
                reducedBuffer[34] = -1;
                reducedBuffer[35] = -1;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, StringHelper.byte2Hex2CharString((byte[])reducedBuffer, (int)64));
                    log.log(Level.FINE, String.format("slot#=%02d BATT TYPE=%02d MODE=%02d CAPACITY=%04d C.CURRENT=%04d D.CURRENT=%04d D.REDUCE=%04d TARGET VOLT=%04d D.REDUCE=%04d TERMINATION=%04d CYCLE COUNT=%02d C.RESTING=%02d CYCLE MODE=%d DELTA PEAK=%02d TRICKLE C=%02d CUT TEMP=%02d CUT TIME=%03d RESTART VOLT=%04d", reducedBuffer[4], reducedBuffer[5], this.operationMode, (reducedBuffer[6] & 0xFF) * 100, this.getChargeCurrent(), this.getDischargeCurrent(), this.getDischargeReduceCurrent(), this.getChargeEndVoltage(), this.getDischargeReduceCurrent(), this.getChargeEndCurrent(), this.numberCycle, this.chargeRestingTime & 0xFF, this.cycleMode, this.peakSenseVoltage, this.trickleCurrent, this.getCutTemperature(systemTemperatureUnit), DataParser.parse2UnsignedShort((byte)reducedBuffer[27], (byte)reducedBuffer[26]), DataParser.parse2UnsignedShort((byte)reducedBuffer[29], (byte)reducedBuffer[28])));
                }
            }
            return reducedBuffer;
        }

        public void setSlotNumber(byte newSlotNumber) {
            this.slotNumber = newSlotNumber;
            this.slotBuffer[1] = newSlotNumber;
            this.setCheckSum(MC3000UsbPort.calculateCheckSum(this.slotBuffer));
        }

        public int getSlotNumber() {
            return this.slotNumber;
        }

        public byte getBatteryType() {
            return this.batteryType;
        }

        public byte getOperatinoMode() {
            return this.operationMode;
        }

        public int getCapacity() {
            return DataParser.parse2UnsignedShort((byte)this.capacity[1], (byte)this.capacity[0]);
        }

        public int getChargeCurrent() {
            return DataParser.parse2UnsignedShort((byte)this.chargeCurrent[1], (byte)this.chargeCurrent[0]);
        }

        public int getDischargeCurrent() {
            return DataParser.parse2UnsignedShort((byte)this.dischargeCurrent[1], (byte)this.dischargeCurrent[0]);
        }

        public int getDischargeCutVoltage() {
            return DataParser.parse2UnsignedShort((byte)this.dischargeCutVoltage[1], (byte)this.dischargeCutVoltage[0]);
        }

        public int getChargeEndVoltage() {
            return DataParser.parse2UnsignedShort((byte)this.chargeEndVoltage[1], (byte)this.chargeEndVoltage[0]);
        }

        public int getDischargeReduceCurrent() {
            return DataParser.parse2UnsignedShort((byte)this.dischargeReduceCurrent[1], (byte)this.dischargeReduceCurrent[0]);
        }

        public int getChargeEndCurrent() {
            return DataParser.parse2UnsignedShort((byte)this.chargeEndCurrent[1], (byte)this.chargeEndCurrent[0]);
        }

        public short getNumberCycle() {
            return this.numberCycle;
        }

        public short getChargeRestingTime() {
            return (short)(this.chargeRestingTime & 0xFF);
        }

        public byte getCycleMode() {
            return this.cycleMode;
        }

        public String getCycleModeString() {
            return cycleModeNames[this.cycleMode];
        }

        public short getEndDeltaVoltage() {
            return (short)(this.peakSenseVoltage & 0xFF);
        }

        public short getTrickleCurrent() {
            return (short)(this.trickleCurrent & 0xFF);
        }

        public short getCutTemperature(byte systemtemperatureUnit) {
            switch (systemtemperatureUnit) {
                case 1: {
                    if (this.temperatureUnit == 0) {
                        return (short)((double)(this.cutTemperature & 0xFF) * 1.8 + 32.0);
                    }
                    return (short)(this.cutTemperature & 0xFF);
                }
            }
            if (this.temperatureUnit == 0) {
                return (short)(this.cutTemperature & 0xFF);
            }
            return (short)((double)((this.cutTemperature & 0xFF) - 32) / 1.8);
        }

        public int getCutTime() {
            return DataParser.parse2UnsignedShort((byte)this.cutTime[1], (byte)this.cutTime[0]);
        }

        public int getRestartVoltage() {
            return DataParser.parse2UnsignedShort((byte)this.restartVoltage[1], (byte)this.restartVoltage[0]);
        }

        public void setCheckSum(byte newChecksum) {
            this.slotBuffer[this.slotBuffer.length - 1] = newChecksum;
        }
    }
}

