#!/bin/sh

# Copyright (C) 2004, 2005 Valery Reznic
# This file is part of the Elf Statifier project
# 
# This project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License.
# See LICENSE file in the doc directory.

[ $# -ne 3 -o "x$1" = "x" -o "x$2" = "x" -o "x$3" = "x" ] && {
	echo "Usage: $0 <RegList> <AwkCode> <Output>" 1>&2
	exit 1
}

RegList=$1
AwkCode=$2
Output=$3

{
	echo "#"                                                          &&
	echo "# Do not change this file. It was generated by '$0'"        &&
	echo "# from '$AwkCode' and '$RegList'."                          &&
	echo "#"                                                          &&
	cat $AwkCode                                                      &&
	echo                                                              &&
	awk -vKAV='"' '
		BEGIN {
			print "# Registers List"
			print "BEGIN {"
			print "\treg_max = 0"
		}
		{
			if ($1 ~ "#") next;
			if (NF == 0)  next;
			print "\tP[reg_max++] = " KAV tolower($1) KAV;
		}
		END {
			print "}"
		}
	' < $RegList &&
	:
} > $Output || exit
exit 0
