/*
# Docsis cable modem diagnostics (cmdiag)
#
# Copyright (C) 2006-2007 Emil Penchev
#
# This program is free software, distributed under the terms of
# the GNU General Public License 2.0
#
*/

#ifndef GLOBALS_H 
#define GLOBALS_H

/* Define option names */

#define CMIP "-cm"
#define CMTSIP "-ct"
#define CM_STRING "-cms"
#define CMTS_STRING "-cts"

/* Screen Size */
#define COLS 125
#define ROWS 43

/* Colors */
#define BLACK 0
#define RED 1
#define GREEN 2
#define WHITE 7

/* Gauge Ranges Downstream Power Level*/
/* Start positions for the colors */

#define DS_BAR_LENGHT 60
#define DS_MAX_PARTS 5

#define DS_BAR_LOW_RED_LEN 15
#define DS_BAR_LOW_WHITE_LEN 5 
#define DS_BAR_MIDDLE_GREEN_LEN 20 
#define DS_BAR_HIGH_WHITE_LEN 5 
#define DS_BAR_HIGH_RED_LEN 15 

/* Gauge Ranges for Upstream Power Level */

#define US_BAR_LENGHT 60
#define US_MAX_PARTS 5

#define US_BAR_LOW_RED_LEN 10
#define US_BAR_LOW_WHITE_LEN 10
#define US_BAR_MIDDLE_GREEN_LEN 20
#define US_BAR_HIGH_WHITE_LEN 10
#define US_BAR_HIGH_RED_LEN 10

/* Gauge Ranges for Downstream SNR */
#define SNR_BAR_LENGHT 50
#define SNR_MAX_PARTS 3

#define SNR_BAR_RED_LEN 10
#define SNR_BAR_WHITE_LEN 10
#define SNR_BAR_GREEN_LEN 30

/* Gauge Error Rate Ranges  */
#define ERR_RATE_BAR_LENGHT 40
#define ERR_RATE_MAX_PARTS 3

#define ERR_RATE_BAR_GREEN_LEN 5 
#define ERR_RATE_BAR_WHITE_LEN 10
#define ERR_RATE_BAR_RED_LEN 25

/* Data Bar Range */
#define DAT_BAR_LENGHT 40 

/* SNMP OIDs */
#define CM_VER "1.3.6.1.2.1.1.1.0"
#define CM_UPTIME "1.3.6.1.2.1.1.3.0"
#define CM_US_FREQ "1.3.6.1.2.1.10.127.1.1.2.1.2.4"
#define CM_DS_FREQ "1.3.6.1.2.1.10.127.1.1.1.1.2.3"
#define CM_DS_CHANNELID "1.3.6.1.2.1.10.127.1.1.1.1.1.3"
#define CM_US_CHANNELID "1.3.6.1.2.1.10.127.1.1.2.1.1.4"
#define CM_DS_LEVEL "1.3.6.1.2.1.10.127.1.1.1.1.6.3"

#define CM_US_LEVEL "1.3.6.1.2.1.10.127.1.2.2.1.3.2"
#define CM_DS_SNR "1.3.6.1.2.1.10.127.1.1.4.1.5.3"
#define CM_RF_RESETS "1.3.6.1.2.1.10.127.1.2.2.1.4.2"
#define CM_RECV_INVALID_RANGING_RESPONSES "1.3.6.1.2.1.10.127.1.2.2.1.8.2"
#define CM_RECV_INVALID_REGISTRATION_RESPONSES "1.3.6.1.2.1.10.127.1.2.2.1.9.2"
#define CM_CMTS_ABORTED_RANGINGS "1.3.6.1.2.1.10.127.1.2.2.1.14.2"
#define CM_MAC "IF-MIB::ifPhysAddress.2"
//This is in Hz
#define CM_DS_CHANNEL_WIDTH "1.3.6.1.2.1.10.127.1.1.1.1.3.3"
#define CM_US_CHANNEL_WIDTH "1.3.6.1.2.1.10.127.1.1.2.1.3.4"
// 3->QAM64 4->QAM256
#define CM_DS_MODULATION "1.3.6.1.2.1.10.127.1.1.1.1.4.3"

//Must multiply to 8 to get this in bits otherwise you get bytes
//Performance on the RF and Ethernet Interfaces
#define CM_DS_RF_BYTES     "IF-MIB::ifInOctets.3"
#define CM_US_RF_BYTES     "IF-MIB::ifOutOctets.4"
#define CM_DS_RF_ERR_BYTES "IF-MIB::ifInErrors.3"
#define CM_US_RF_ERR_BYTES "IF-MIB::ifOutErrors.4"
#define CM_DS_ETH_BYTES    "IF-MIB::ifInOctets.1"
#define CM_US_ETH_BYTES    "IF-MIB::ifOutOctets.1"

//Codewords received on this channel without error
#define SIGQ_UNERROREDS "1.3.6.1.2.1.10.127.1.1.4.1.2.3"
//Codewords received on this channel with correctable errors
#define SIGQ_CORRECTEDS "1.3.6.1.2.1.10.127.1.1.4.1.3.3"
//Codewords received on this channel with uncorrectable errors
#define SIGQ_UNCORRECTEDS "1.3.6.1.2.1.10.127.1.1.4.1.4.3"

//This Staff you get from the CMTS
#define CM_US_SNR ".1.3.6.1.2.1.10.127.1.3.3.1.13"
#define CM_SID "1.3.6.1.2.1.10.127.1.3.7.1.2"
#define CMTS_CM_RX_POWER "1.3.6.1.2.1.10.127.1.3.3.1.6"

 
#endif




