/*
# Docsis cable modem diagnostics (cmdiag)
#
# Copyright (C) 2006-2007 Emil Penchev
#
# This program is free software, distributed under the terms of
# the GNU General Public License 2.0
#
*/


#include <curses.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "globals.h"
#include "func.h"

void usage()
{
	printf("Usage: cmdiag -cm <IP> -cms <string> -ct <IP> -cts <string> \n");
	printf("-cm <IP> Cable modem IP address. \n");
	printf("-cms <string> Cable modem SNMP community string, this option is mandatory. \n");
	printf("-ct <IP> CMTS IP address which the cable modem is connected to, if this is not set some parameters are not to be fetched. \n");
	printf("-cts <string> CMTS SNMP community string, you can't omit this if -ct is set. \n");
	printf("Example: cmdiag -cm 192.168.0.2 -cms public -ct 192.168.0.1 -cts private \n");
	printf("Or: cmdiag -cm 192.168.0.2 -cms public \n");
}

void usage_screen()
{
	printf("This program requires a screen size of at least 125 columns by 43 lines \n");
	printf("Please resize your window \n");
}

int screen_size_check()
{
	int x=-1, y=-1;
	WINDOW *w=initscr();
	if(w == NULL)
		return(1);
	
	x=w->_maxx - w->_curx;
	y=w->_maxy - w->_cury;
	
	endwin();
	//printf("Console is %d x %d\n",x,y);
	if ( (x < COLS) || (y < ROWS)) {
		printf("Console is %d x %d\n",x,y);
		usage_screen();
		exit(0);
	}

	return(1);
}

char * get_cmd_option(int arg_c, char ** arg_v, char * option)
{
	int op_c = 1;
	char * op_value = NULL;
	
	if(arg_v[1] == NULL) {
		usage();
		exit(0);
	}
	/* Must have at least 2 option args with 2 option values */
	if (arg_c < 5) {
		usage();
		exit(0);
	}
	if (arg_v[5]) {
		if (!arg_v[7]) {
			usage();
			exit(0);
		}
	}
	while (op_c < arg_c) {
		if (strcmp(arg_v[op_c], option) == 0) {
			if (arg_v[op_c + 1])
				op_value = arg_v[op_c + 1];
		}
		op_c++;
	}
	if (!op_value) {
		if (((strcmp(option, CMIP)) == 0) || ((strcmp(option, CM_STRING)) == 0)) {
			usage();
			exit(0);
		}
	}
		
	return op_value;
}







