/*
 *   JSampler - a java front-end for LinuxSampler
 *
 *   Copyright (C) 2005-2008 Grigor Iliev <grigor@grigoriliev.com>
 *
 *   This file is part of JSampler.
 *
 *   JSampler is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License version 2
 *   as published by the Free Software Foundation.
 *
 *   JSampler is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with JSampler; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA  02111-1307  USA
 */

package org.jsampler.view.classic;

import javax.swing.ImageIcon;


/**
 * This class contains all pixmap resources needed by <b>JS Classic</b> view.
 * @author Grigor Iliev
 */
public class Res {
	
	/** Forbits the instantiation of this class. */
	private Res() { }
	
	protected final static ImageIcon appIcon
		= new ImageIcon(Res.class.getResource("res/icons/app-icon.png"));
	
	protected final static ImageIcon iconClose8
		= new ImageIcon(Res.class.getResource("res/icons/close8.png"));
	
	protected final static ImageIcon iconNew16
		= new ImageIcon(Res.class.getResource("res/icons/new16.png"));
	
	protected final static ImageIcon iconEdit16
		= new ImageIcon(Res.class.getResource("res/icons/edit16.png"));
	
	protected final static ImageIcon iconCopy16
		= new ImageIcon(Res.class.getResource("res/icons/Copy16.gif"));
	
	protected final static ImageIcon iconDelete16
		= new ImageIcon(Res.class.getResource("res/icons/delete16.png"));
	
	protected final static ImageIcon iconProps16
		= new ImageIcon(Res.class.getResource("res/icons/Properties16.gif"));
	
	protected final static ImageIcon iconUp16
		= new ImageIcon(Res.class.getResource("res/icons/Up16.gif"));
	
	protected final static ImageIcon iconDown16
		= new ImageIcon(Res.class.getResource("res/icons/Down16.gif"));
	
	protected final static ImageIcon iconBack16
		= new ImageIcon(Res.class.getResource("res/icons/Back16.gif"));
	
	protected final static ImageIcon iconForward16
		= new ImageIcon(Res.class.getResource("res/icons/Forward16.gif"));
	
	protected final static ImageIcon iconAudioProps16
		= new ImageIcon(Res.class.getResource("res/icons/Import16.gif"));
	
	protected final static ImageIcon iconVolume16
		= new ImageIcon(Res.class.getResource("res/icons/Volume16.png"));
	
	protected final static ImageIcon iconFolder16
		= new ImageIcon(Res.class.getResource("res/icons/folder16.png"));
	
	protected final static ImageIcon iconFolderOpen16
		= new ImageIcon(Res.class.getResource("res/icons/folder_open16.png"));
	
	protected final static ImageIcon iconInstrument16
		= new ImageIcon(Res.class.getResource("res/icons/instr16.png"));
	
	protected final static ImageIcon iconExport16
		= new ImageIcon(Res.class.getResource("res/icons/save16.png"));
	
	protected final static ImageIcon iconDb16
		= new ImageIcon(Res.class.getResource("res/icons/collection16.png"));
	
	protected final static ImageIcon iconReload16
		= new ImageIcon(Res.class.getResource("res/icons/reload16.png"));
	
	protected final static ImageIcon iconPreferences16
		= new ImageIcon(Res.class.getResource("res/icons/preferences16.png"));
	
	protected final static ImageIcon iconTabNew22
		= new ImageIcon(Res.class.getResource("res/icons/tab_new22.png"));
	
	protected final static ImageIcon iconTabRemove22
		= new ImageIcon(Res.class.getResource("res/icons/tab_remove22.png"));
	
	protected final static ImageIcon iconTabMoveLeft22
		= new ImageIcon(Res.class.getResource("res/icons/tab_move_left22.png"));
	
	protected final static ImageIcon iconTabMoveRight22
		= new ImageIcon(Res.class.getResource("res/icons/tab_move_right22.png"));
	
	protected final static ImageIcon iconFxSends22
		= new ImageIcon(Res.class.getResource("res/icons/fx_sends22.png"));
	
	protected final static ImageIcon iconVolume22
		= new ImageIcon(Res.class.getResource("res/icons/Volume22.png"));
	
	protected final static ImageIcon iconFind22
		= new ImageIcon(Res.class.getResource("res/icons/Find22.png"));
	
	protected final static ImageIcon iconGoUp22
		= new ImageIcon(Res.class.getResource("res/icons/GoUp22.png"));
	
	protected final static ImageIcon iconGoBack22
		= new ImageIcon(Res.class.getResource("res/icons/GoBack22.png"));
	
	protected final static ImageIcon iconGoForward22
		= new ImageIcon(Res.class.getResource("res/icons/GoForward22.png"));
	
	protected final static ImageIcon iconUp24
		= new ImageIcon(Res.class.getResource("res/icons/Up22.png"));
	
	protected final static ImageIcon iconDown24
		= new ImageIcon(Res.class.getResource("res/icons/Down22.png"));
	
	protected final static ImageIcon iconFolderOpen22
		= new ImageIcon(Res.class.getResource("res/icons/folder_open22.png"));
	
	protected final static ImageIcon iconPreferences22
		= new ImageIcon(Res.class.getResource("res/icons/Preferences22.png"));
	
	protected final static ImageIcon iconReload22
		= new ImageIcon(Res.class.getResource("res/icons/reload22.png"));
	
	protected final static ImageIcon iconNew24
		= new ImageIcon(Res.class.getResource("res/icons/New24.png"));
	
	protected final static ImageIcon iconCopy24
		= new ImageIcon(Res.class.getResource("res/icons/Copy24.png"));
	
	protected final static ImageIcon iconDelete24
		= new ImageIcon(Res.class.getResource("res/icons/Delete24.png"));
	
	protected final static ImageIcon iconMidi24
		= new ImageIcon(Res.class.getResource("res/icons/midi24.png"));
	
	protected final static ImageIcon iconVol24
		= new ImageIcon(Res.class.getResource("res/icons/Vol24.png"));
	
	protected final static ImageIcon iconExportSession32
		= new ImageIcon(Res.class.getResource("res/icons/Save32.png"));
	
	protected final static ImageIcon iconLoadScript32
		= new ImageIcon(Res.class.getResource("res/icons/Open32.png"));
	
	protected final static ImageIcon iconReset32
		= new ImageIcon(Res.class.getResource("res/icons/purge.png"));
	
	protected final static ImageIcon iconReload32
		= new ImageIcon(Res.class.getResource("res/icons/reload32.png"));
	
	protected final static ImageIcon iconInfo32
		= new ImageIcon(Res.class.getResource("res/icons/info32.png"));
	
	protected final static ImageIcon iconPreferences32
		= new ImageIcon(Res.class.getResource("res/icons/Preferences32.png"));
	
	protected final static ImageIcon iconDb32
		= new ImageIcon(Res.class.getResource("res/icons/db32.png"));
	
	protected final static ImageIcon iconWarning32
		= new ImageIcon(Res.class.getResource("res/icons/warning32.png"));
	
	protected final static ImageIcon iconQuestion32
		= new ImageIcon(Res.class.getResource("res/icons/question32.png"));
	
	protected final static ImageIcon iconLinuxSamplerLogo
		= new ImageIcon(Res.class.getResource("res/LinuxSampler-logo.png"));
	
}
