/*
 *   cmap.c
 *
 *   (C) Richard Drummond 2001-2007
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */

#include "defs.h"
#include "cmap.h"

ColorMap *ColorMap_alloc( __u32 length )
{
  void     *tmp;
  ColorMap *cmap;

  if( (tmp = malloc( sizeof(ColorMap)+sizeof(__u16)*length*4 )) )
  {
    cmap = (ColorMap*) tmp;

    cmap->len    = length;
    cmap->start  = 0;
    cmap->red    = (__u16 *)(tmp + sizeof(ColorMap));
    cmap->green  = cmap->red + length;
    cmap->blue   = cmap->green + length;
    cmap->transp = cmap->blue + length;

    return cmap;
  }
  else
    return 0;
}

void ColorMap_free( ColorMap *cmap )
{
    free( cmap );
}

/*
 * RGB components for the default framebuffer pens
 */
static __u16 red16[] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0xaaaa, 0xaaaa, 0xaaaa, 0xaaaa,
    0x5555, 0x5555, 0x5555, 0x5555, 0xffff, 0xffff, 0xffff, 0xffff
};
static __u16 green16[] = {
    0x0000, 0x0000, 0xaaaa, 0xaaaa, 0x0000, 0x0000, 0x5555, 0xaaaa,
    0x5555, 0x5555, 0xffff, 0xffff, 0x5555, 0x5555, 0xffff, 0xffff
};
static __u16 blue16[] = {
    0x0000, 0xaaaa, 0x0000, 0xaaaa, 0x0000, 0xaaaa, 0x0000, 0xaaaa,
    0x5555, 0xffff, 0x5555, 0xffff, 0x5555, 0xffff, 0x5555, 0xffff
};


/*
 * Copy the 16 default framebuffer pens into the
 * specified ColorMap instance.
 */
int ColorMap_copyDefault16( ColorMap *cmap )
{
   int ret;

   if( (ret = cmap->len >= 16) )
   {
     int i;

     for( i = 15; i>=0; i-- )
     {
       cmap->red[i]    = red16[i];
       cmap->green[i]  = green16[i];
       cmap->blue[i]   = blue16[i];
       cmap->transp[i] = 0;
     }
   }
   return ret;
}

#ifdef DEBUG
void ColorMap_dump( ColorMap *cmap, FILE *stream )
{
  unsigned int i=0;

  fprintf( stream, "start:%d\nlen:%d\n", cmap->start, cmap->len );

  for( ; i<cmap->len; i++ )
  {
    fprintf( stream, "%3d R:%04x G:%04x B:%04x\n",
                  i, cmap->red[i], cmap->green[i], cmap->blue[i] );
  }
}
#endif
