/*
 * Decompiled with CFR 0.152.
 */
package com.nexwave.nsidita;

import com.nexwave.nsidita.DirFilter;
import java.io.File;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirList {
    ArrayList<File> listFiles = null;
    ArrayList<String> listFilesRelTo = null;
    String[] topicFiles = null;
    public static final int MAX_DEPTH = 10;

    public DirList(File inputDir, String regexp, int depth) {
        try {
            this.listFiles = new ArrayList();
            if (regexp == null) {
                for (File f : inputDir.listFiles()) {
                    if (!f.isDirectory()) {
                        this.listFiles.add(f);
                        continue;
                    }
                    if (depth >= 10) continue;
                    DirList nsiDoc = new DirList(f, regexp, depth + 1);
                    this.listFiles.addAll(new ArrayList<File>(nsiDoc.getListFiles()));
                }
            } else {
                for (File f : inputDir.listFiles(new DirFilter(regexp))) {
                    this.listFiles.add(f);
                }
                for (File f : inputDir.listFiles(new DirFilter(".*"))) {
                    if (!f.isDirectory() || depth >= 10) continue;
                    DirList nsiDoc = new DirList(f, regexp, depth + 1);
                    this.listFiles.addAll(new ArrayList<File>(nsiDoc.getListFiles()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<File> getListFiles() {
        return this.listFiles;
    }

    public ArrayList<String> getListFilesRelTo(String projectDir) {
        if (this.listFiles == null) {
            return null;
        }
        this.listFilesRelTo = new ArrayList();
        for (File ftemp : this.listFiles) {
            String stemp = ftemp.getPath();
            int i = stemp.indexOf(projectDir);
            if (i != 0) {
                System.out.println("the documentation root does not match with the documentation input!");
                return null;
            }
            int ad = 1;
            if (stemp.equals(projectDir)) {
                ad = 0;
            }
            stemp = stemp.substring(i + projectDir.length() + ad);
            this.listFilesRelTo.add(stemp);
        }
        return this.listFilesRelTo;
    }
}

