/* CheckDataModelIterator.c generated by valac 0.22.1, the Vala compiler
 * generated from CheckDataModelIterator.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdadata Unit Tests
 * Copyright (C) Daniel Espinosa Ortiz 2011 <esodan@gmail.com>
 * 
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgda/libgda.h>
#include <libgda/data/libgdadata.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define CHECK_TYPE_TESTS (check_tests_get_type ())
#define CHECK_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHECK_TYPE_TESTS, CheckTests))
#define CHECK_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHECK_TYPE_TESTS, CheckTestsClass))
#define CHECK_IS_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHECK_TYPE_TESTS))
#define CHECK_IS_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHECK_TYPE_TESTS))
#define CHECK_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHECK_TYPE_TESTS, CheckTestsClass))

typedef struct _CheckTests CheckTests;
typedef struct _CheckTestsClass CheckTestsClass;
typedef struct _CheckTestsPrivate CheckTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gee_lazy_unref0(var) ((var == NULL) ? NULL : (var = (gee_lazy_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _CheckTests {
	GObject parent_instance;
	CheckTestsPrivate * priv;
};

struct _CheckTestsClass {
	GObjectClass parent_class;
};

struct _CheckTestsPrivate {
	GdaConnection* connection;
	GdaDataDbRecordCollection* itermodel;
};

struct _Block1Data {
	int _ref_count_;
	CheckTests * self;
	gchar* ts;
};


static gpointer check_tests_parent_class = NULL;

GType check_tests_get_type (void) G_GNUC_CONST;
#define CHECK_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHECK_TYPE_TESTS, CheckTestsPrivate))
enum  {
	CHECK_TESTS_DUMMY_PROPERTY
};
static CheckTests* check_tests_new (void);
static CheckTests* check_tests_construct (GType object_type);
gint check_tests_iterating (CheckTests* self, GError** error);
gint check_tests_choping (CheckTests* self);
gint check_tests_filtering (CheckTests* self);
static gboolean __lambda2_ (CheckTests* self, GdaDataDbRecord* g);
static gboolean ___lambda2__gee_predicate (gconstpointer g, gpointer self);
gint check_tests_streaming (CheckTests* self);
static GeeTraversableStream __lambda3_ (CheckTests* self, GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gchar* ______lambda4_ (Block1Data* _data1_);
static gpointer _______lambda4__gee_lazy_func (gpointer self);
static GeeTraversableStream ___lambda3__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
gint check_tests_InitIter (CheckTests* self, GError** error);
gint check_tests_main (gchar** args, int args_length1);
static void check_tests_finalize (GObject* obj);


static CheckTests* check_tests_construct (GType object_type) {
	CheckTests * self = NULL;
	GError * _inner_error_ = NULL;
	self = (CheckTests*) g_object_new (object_type, NULL);
	{
		FILE* _tmp0_ = NULL;
		GdaConnection* _tmp1_ = NULL;
		GdaConnection* _tmp2_ = NULL;
		FILE* _tmp3_ = NULL;
		GdaConnection* _tmp4_ = NULL;
		GdaConnection* _tmp5_ = NULL;
		GdaConnection* _tmp6_ = NULL;
		GdaConnection* _tmp7_ = NULL;
		GdaConnection* _tmp8_ = NULL;
		GdaConnection* _tmp9_ = NULL;
		GdaConnection* _tmp10_ = NULL;
		GdaConnection* _tmp11_ = NULL;
		g_unlink ("datamodeliterator.db");
		_tmp0_ = stdout;
		fprintf (_tmp0_, "Creating Database...\n");
		_tmp2_ = gda_connection_open_from_string ("SQLite", "DB_DIR=.;DB_NAME=datamodeliterator", NULL, GDA_CONNECTION_OPTIONS_NONE, &_inner_error_);
		_tmp1_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_g_object_unref0 (self->priv->connection);
		self->priv->connection = _tmp1_;
		_tmp3_ = stdout;
		fprintf (_tmp3_, "Creating table 'user'...\n");
		_tmp4_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp4_, "CREATE TABLE user (id int PRIMARY KEY, name string, city string)", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp5_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp5_, "INSERT INTO user (id, name, city) VALUES (1, \"Daniel\", \"Mexico\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp6_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp6_, "INSERT INTO user (id, name, city) VALUES (2, \"Jhon\", \"USA\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp7_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp7_, "INSERT INTO user (id, name, city) VALUES (3, \"James\", \"Germany\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp8_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp8_, "INSERT INTO user (id, name, city) VALUES (4, \"Jack\", \"United Kindom" \
"\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp9_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp9_, "INSERT INTO user (id, name, city) VALUES (5, \"Elsy\", \"España\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp10_ = self->priv->connection;
		gda_connection_execute_non_select_command (_tmp10_, "INSERT INTO user (id, name, city) VALUES (6, \"Mayo\", \"Mexico\")", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp11_ = self->priv->connection;
		gda_connection_update_meta_store (_tmp11_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = stdout;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		fprintf (_tmp12_, "Couln't create temporary database...\nERROR: %s\n", _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


static CheckTests* check_tests_new (void) {
	return check_tests_construct (CHECK_TYPE_TESTS);
}


gint check_tests_iterating (CheckTests* self, GError** error) {
	gint result = 0;
	gint fails = 0;
	FILE* _tmp0_ = NULL;
	gint i = 0;
	FILE* _tmp1_ = NULL;
	GeeIterator* iter = NULL;
	GdaDataDbRecordCollection* _tmp2_ = NULL;
	GeeIterator* _tmp3_ = NULL;
	GeeIterator* _tmp4_ = NULL;
	gboolean _tmp28_ = FALSE;
	gint _tmp29_ = 0;
	gboolean _tmp31_ = FALSE;
	FILE* _tmp41_ = NULL;
	gboolean _tmp57_ = FALSE;
	gint _tmp58_ = 0;
	gboolean _tmp60_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	fails = 0;
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> TESTING: Iterating over all Records in DataModel using foreach...\n");
	i = 0;
	_tmp1_ = stdout;
	fprintf (_tmp1_, "Iterating using a Gee.Iterator...\n");
	i = 0;
	_tmp2_ = self->priv->itermodel;
	_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
	iter = _tmp3_;
	_tmp4_ = iter;
	if (_tmp4_ == NULL) {
		FILE* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		_tmp5_ = stdout;
		_tmp6_ = fails;
		fails = _tmp6_ + 1;
		_tmp7_ = fails;
		_tmp8_ = g_strdup_printf ("%i", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("----- FAIL ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, "\n", NULL);
		_tmp13_ = _tmp12_;
		fprintf (_tmp5_, "%s", _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	}
	while (TRUE) {
		GeeIterator* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		gchar* t2 = NULL;
		GeeIterator* _tmp16_ = NULL;
		gpointer _tmp17_ = NULL;
		GdaDataDbRecord* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		_tmp14_ = iter;
		_tmp15_ = gee_iterator_next (_tmp14_);
		if (!_tmp15_) {
			break;
		}
		_tmp16_ = iter;
		_tmp17_ = gee_iterator_get (_tmp16_);
		_tmp18_ = (GdaDataDbRecord*) _tmp17_;
		_tmp19_ = gda_data_db_record_to_string (_tmp18_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		t2 = _tmp20_;
		_tmp21_ = t2;
		if (_tmp21_ == NULL) {
			gint _tmp22_ = 0;
			_tmp22_ = fails;
			fails = _tmp22_ + 1;
			_g_free0 (t2);
			break;
		} else {
			FILE* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			_tmp23_ = stdout;
			_tmp24_ = t2;
			_tmp25_ = g_strconcat (_tmp24_, "\n", NULL);
			_tmp26_ = _tmp25_;
			fprintf (_tmp23_, "%s", _tmp26_);
			_g_free0 (_tmp26_);
			_tmp27_ = i;
			i = _tmp27_ + 1;
		}
		_g_free0 (t2);
	}
	_tmp29_ = fails;
	if (_tmp29_ > 0) {
		_tmp28_ = TRUE;
	} else {
		gint _tmp30_ = 0;
		_tmp30_ = i;
		_tmp28_ = _tmp30_ != 6;
	}
	_tmp31_ = _tmp28_;
	if (_tmp31_) {
		FILE* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		_tmp32_ = stdout;
		_tmp33_ = fails;
		_tmp34_ = g_strdup_printf ("%i", _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strconcat ("----- FAIL ", _tmp35_, NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat (_tmp37_, "\n", NULL);
		_tmp39_ = _tmp38_;
		fprintf (_tmp32_, "%s", _tmp39_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
	} else {
		FILE* _tmp40_ = NULL;
		_tmp40_ = stdout;
		fprintf (_tmp40_, "+++++ PASS\n");
	}
	_tmp41_ = stdout;
	fprintf (_tmp41_, "Iterating using foreach instruction...\n");
	i = 0;
	{
		GeeIterator* _r_it = NULL;
		GdaDataDbRecordCollection* _tmp42_ = NULL;
		GeeIterator* _tmp43_ = NULL;
		_tmp42_ = self->priv->itermodel;
		_tmp43_ = gee_iterable_iterator ((GeeIterable*) _tmp42_);
		_r_it = _tmp43_;
		while (TRUE) {
			GeeIterator* _tmp44_ = NULL;
			gboolean _tmp45_ = FALSE;
			GdaDataDbRecord* r = NULL;
			GeeIterator* _tmp46_ = NULL;
			gpointer _tmp47_ = NULL;
			gchar* t = NULL;
			GdaDataDbRecord* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			const gchar* _tmp50_ = NULL;
			gint _tmp52_ = 0;
			FILE* _tmp53_ = NULL;
			const gchar* _tmp54_ = NULL;
			gchar* _tmp55_ = NULL;
			gchar* _tmp56_ = NULL;
			_tmp44_ = _r_it;
			_tmp45_ = gee_iterator_next (_tmp44_);
			if (!_tmp45_) {
				break;
			}
			_tmp46_ = _r_it;
			_tmp47_ = gee_iterator_get (_tmp46_);
			r = (GdaDataDbRecord*) _tmp47_;
			_tmp48_ = r;
			_tmp49_ = gda_data_db_record_to_string (_tmp48_);
			t = _tmp49_;
			_tmp50_ = t;
			if (_tmp50_ == NULL) {
				gint _tmp51_ = 0;
				_tmp51_ = fails;
				fails = _tmp51_ + 1;
				_g_free0 (t);
				_g_object_unref0 (r);
				break;
			}
			_tmp52_ = i;
			i = _tmp52_ + 1;
			_tmp53_ = stdout;
			_tmp54_ = t;
			_tmp55_ = g_strconcat (_tmp54_, "\n", NULL);
			_tmp56_ = _tmp55_;
			fprintf (_tmp53_, "%s", _tmp56_);
			_g_free0 (_tmp56_);
			_g_free0 (t);
			_g_object_unref0 (r);
		}
		_g_object_unref0 (_r_it);
	}
	_tmp58_ = fails;
	if (_tmp58_ > 0) {
		_tmp57_ = TRUE;
	} else {
		gint _tmp59_ = 0;
		_tmp59_ = i;
		_tmp57_ = _tmp59_ != 6;
	}
	_tmp60_ = _tmp57_;
	if (_tmp60_) {
		FILE* _tmp61_ = NULL;
		gint _tmp62_ = 0;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		gchar* _tmp65_ = NULL;
		gchar* _tmp66_ = NULL;
		gchar* _tmp67_ = NULL;
		gchar* _tmp68_ = NULL;
		_tmp61_ = stdout;
		_tmp62_ = fails;
		_tmp63_ = g_strdup_printf ("%i", _tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = g_strconcat ("----- FAIL ", _tmp64_, NULL);
		_tmp66_ = _tmp65_;
		_tmp67_ = g_strconcat (_tmp66_, "\n", NULL);
		_tmp68_ = _tmp67_;
		fprintf (_tmp61_, "%s", _tmp68_);
		_g_free0 (_tmp68_);
		_g_free0 (_tmp66_);
		_g_free0 (_tmp64_);
	} else {
		FILE* _tmp69_ = NULL;
		_tmp69_ = stdout;
		fprintf (_tmp69_, "+++++ PASS\n");
	}
	result = fails;
	_g_object_unref0 (iter);
	return result;
}


gint check_tests_choping (CheckTests* self) {
	gint result = 0;
	gint fails = 0;
	FILE* _tmp0_ = NULL;
	FILE* _tmp1_ = NULL;
	GeeIterator* iter = NULL;
	GdaDataDbRecordCollection* _tmp2_ = NULL;
	GeeIterator* _tmp3_ = NULL;
	gint i = 0;
	gboolean _tmp33_ = FALSE;
	gint _tmp34_ = 0;
	gboolean _tmp36_ = FALSE;
	FILE* _tmp47_ = NULL;
	GeeIterator* iter2 = NULL;
	GdaDataDbRecordCollection* _tmp48_ = NULL;
	GeeIterator* _tmp49_ = NULL;
	gint _tmp92_ = 0;
	FILE* _tmp104_ = NULL;
	GeeIterator* iter3 = NULL;
	GdaDataDbRecordCollection* _tmp105_ = NULL;
	GeeIterator* _tmp106_ = NULL;
	GeeIterator* _tmp107_ = NULL;
	gboolean _tmp108_ = FALSE;
	FILE* _tmp131_ = NULL;
	GeeIterator* iter4 = NULL;
	GdaDataDbRecordCollection* _tmp132_ = NULL;
	GeeIterator* _tmp133_ = NULL;
	GeeIterator* _tmp134_ = NULL;
	gboolean _tmp135_ = FALSE;
	FILE* _tmp158_ = NULL;
	GeeIterator* iter5 = NULL;
	GdaDataDbRecordCollection* _tmp159_ = NULL;
	GeeIterator* _tmp160_ = NULL;
	GeeIterator* _tmp161_ = NULL;
	gboolean _tmp162_ = FALSE;
	gint _tmp185_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	fails = 0;
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> TESTING: Chopping...\n");
	_tmp1_ = stdout;
	fprintf (_tmp1_, " to get from the 2nd DbRecord to the 6th...\n");
	_tmp2_ = self->priv->itermodel;
	_tmp3_ = gee_traversable_chop ((GeeTraversable*) _tmp2_, 1, -1);
	iter = _tmp3_;
	i = 0;
	while (TRUE) {
		GeeIterator* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		FILE* _tmp6_ = NULL;
		GeeIterator* _tmp7_ = NULL;
		gpointer _tmp8_ = NULL;
		GdaDataDbRecord* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		GValue* _tmp15_ = NULL;
		GeeIterator* _tmp16_ = NULL;
		gpointer _tmp17_ = NULL;
		GdaDataDbRecord* _tmp18_ = NULL;
		GValue* _tmp19_ = NULL;
		GValue* _tmp20_ = NULL;
		gchar* name = NULL;
		gchar* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		_tmp4_ = iter;
		_tmp5_ = gee_iterator_next (_tmp4_);
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = stdout;
		_tmp7_ = iter;
		_tmp8_ = gee_iterator_get (_tmp7_);
		_tmp9_ = (GdaDataDbRecord*) _tmp8_;
		_tmp10_ = gda_data_db_record_to_string (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, "\n", NULL);
		_tmp13_ = _tmp12_;
		fprintf (_tmp6_, "%s", _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_object_unref0 (_tmp9_);
		_tmp14_ = i;
		i = _tmp14_ + 1;
		_tmp16_ = iter;
		_tmp17_ = gee_iterator_get (_tmp16_);
		_tmp18_ = (GdaDataDbRecord*) _tmp17_;
		_tmp19_ = gda_data_db_record_get_value (_tmp18_, "name", &_inner_error_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_tmp15_ = _tmp20_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp21_ = g_strdup (g_value_get_string (_tmp15_));
		name = _tmp21_;
		_tmp22_ = i;
		switch (_tmp22_) {
			case 1:
			{
				const gchar* _tmp23_ = NULL;
				_tmp23_ = name;
				if (g_strcmp0 (_tmp23_, "Jhon") != 0) {
					gint _tmp24_ = 0;
					_tmp24_ = fails;
					fails = _tmp24_ + 1;
				}
				break;
			}
			case 2:
			{
				const gchar* _tmp25_ = NULL;
				_tmp25_ = name;
				if (g_strcmp0 (_tmp25_, "James") != 0) {
					gint _tmp26_ = 0;
					_tmp26_ = fails;
					fails = _tmp26_ + 1;
				}
				break;
			}
			case 3:
			{
				const gchar* _tmp27_ = NULL;
				_tmp27_ = name;
				if (g_strcmp0 (_tmp27_, "Jack") != 0) {
					gint _tmp28_ = 0;
					_tmp28_ = fails;
					fails = _tmp28_ + 1;
				}
				break;
			}
			case 4:
			{
				const gchar* _tmp29_ = NULL;
				_tmp29_ = name;
				if (g_strcmp0 (_tmp29_, "Elsy") != 0) {
					gint _tmp30_ = 0;
					_tmp30_ = fails;
					fails = _tmp30_ + 1;
				}
				break;
			}
			case 5:
			{
				const gchar* _tmp31_ = NULL;
				_tmp31_ = name;
				if (g_strcmp0 (_tmp31_, "Mayo") != 0) {
					gint _tmp32_ = 0;
					_tmp32_ = fails;
					fails = _tmp32_ + 1;
				}
				break;
			}
			default:
			break;
		}
		_g_free0 (name);
	}
	_tmp34_ = fails;
	if (_tmp34_ != 0) {
		_tmp33_ = TRUE;
	} else {
		gint _tmp35_ = 0;
		_tmp35_ = i;
		_tmp33_ = _tmp35_ != 5;
	}
	_tmp36_ = _tmp33_;
	if (_tmp36_) {
		FILE* _tmp37_ = NULL;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		_tmp37_ = stdout;
		_tmp38_ = fails;
		fails = _tmp38_ + 1;
		_tmp39_ = fails;
		_tmp40_ = g_strdup_printf ("%i", _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_strconcat ("----- FAIL: ", _tmp41_, NULL);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strconcat (_tmp43_, "\n", NULL);
		_tmp45_ = _tmp44_;
		fprintf (_tmp37_, "%s", _tmp45_);
		_g_free0 (_tmp45_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp41_);
	} else {
		FILE* _tmp46_ = NULL;
		_tmp46_ = stdout;
		fprintf (_tmp46_, "+++++ PASS\n");
	}
	_tmp47_ = stdout;
	fprintf (_tmp47_, "Choping to get the 4th to 5th DbRecords...\n");
	_tmp48_ = self->priv->itermodel;
	_tmp49_ = gee_traversable_chop ((GeeTraversable*) _tmp48_, 3, 2);
	iter2 = _tmp49_;
	i = 0;
	while (TRUE) {
		GeeIterator* _tmp50_ = NULL;
		gboolean _tmp51_ = FALSE;
		gint _tmp52_ = 0;
		FILE* _tmp53_ = NULL;
		GeeIterator* _tmp54_ = NULL;
		gpointer _tmp55_ = NULL;
		GdaDataDbRecord* _tmp56_ = NULL;
		gchar* _tmp57_ = NULL;
		gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		GValue* _tmp61_ = NULL;
		GeeIterator* _tmp62_ = NULL;
		gpointer _tmp63_ = NULL;
		GdaDataDbRecord* _tmp64_ = NULL;
		GValue* _tmp65_ = NULL;
		GValue* _tmp66_ = NULL;
		gchar* name2 = NULL;
		gchar* _tmp67_ = NULL;
		gint _tmp68_ = 0;
		gint _tmp80_ = 0;
		_tmp50_ = iter2;
		_tmp51_ = gee_iterator_next (_tmp50_);
		if (!_tmp51_) {
			break;
		}
		_tmp52_ = i;
		i = _tmp52_ + 1;
		_tmp53_ = stdout;
		_tmp54_ = iter2;
		_tmp55_ = gee_iterator_get (_tmp54_);
		_tmp56_ = (GdaDataDbRecord*) _tmp55_;
		_tmp57_ = gda_data_db_record_to_string (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = g_strconcat (_tmp58_, "\n", NULL);
		_tmp60_ = _tmp59_;
		fprintf (_tmp53_, "%s", _tmp60_);
		_g_free0 (_tmp60_);
		_g_free0 (_tmp58_);
		_g_object_unref0 (_tmp56_);
		_tmp62_ = iter2;
		_tmp63_ = gee_iterator_get (_tmp62_);
		_tmp64_ = (GdaDataDbRecord*) _tmp63_;
		_tmp65_ = gda_data_db_record_get_value (_tmp64_, "name", &_inner_error_);
		_tmp66_ = _tmp65_;
		_g_object_unref0 (_tmp64_);
		_tmp61_ = _tmp66_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (iter2);
			_g_object_unref0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_tmp67_ = g_strdup (g_value_get_string (_tmp61_));
		name2 = _tmp67_;
		_tmp68_ = i;
		if (_tmp68_ == 1) {
			const gchar* _tmp69_ = NULL;
			_tmp69_ = name2;
			if (g_strcmp0 (_tmp69_, "Jack") != 0) {
				gint _tmp70_ = 0;
				FILE* _tmp71_ = NULL;
				gint _tmp72_ = 0;
				gint _tmp73_ = 0;
				gchar* _tmp74_ = NULL;
				gchar* _tmp75_ = NULL;
				gchar* _tmp76_ = NULL;
				gchar* _tmp77_ = NULL;
				gchar* _tmp78_ = NULL;
				gchar* _tmp79_ = NULL;
				_tmp70_ = fails;
				fails = _tmp70_ + 1;
				_tmp71_ = stdout;
				_tmp72_ = fails;
				fails = _tmp72_ + 1;
				_tmp73_ = fails;
				_tmp74_ = g_strdup_printf ("%i", _tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = g_strconcat ("----- FAIL: ", _tmp75_, NULL);
				_tmp77_ = _tmp76_;
				_tmp78_ = g_strconcat (_tmp77_, "\n", NULL);
				_tmp79_ = _tmp78_;
				fprintf (_tmp71_, "%s", _tmp79_);
				_g_free0 (_tmp79_);
				_g_free0 (_tmp77_);
				_g_free0 (_tmp75_);
				_g_free0 (name2);
				break;
			}
		}
		_tmp80_ = i;
		if (_tmp80_ == 2) {
			const gchar* _tmp81_ = NULL;
			_tmp81_ = name2;
			if (g_strcmp0 (_tmp81_, "Elsy") != 0) {
				gint _tmp82_ = 0;
				FILE* _tmp83_ = NULL;
				gint _tmp84_ = 0;
				gint _tmp85_ = 0;
				gchar* _tmp86_ = NULL;
				gchar* _tmp87_ = NULL;
				gchar* _tmp88_ = NULL;
				gchar* _tmp89_ = NULL;
				gchar* _tmp90_ = NULL;
				gchar* _tmp91_ = NULL;
				_tmp82_ = fails;
				fails = _tmp82_ + 1;
				_tmp83_ = stdout;
				_tmp84_ = fails;
				fails = _tmp84_ + 1;
				_tmp85_ = fails;
				_tmp86_ = g_strdup_printf ("%i", _tmp85_);
				_tmp87_ = _tmp86_;
				_tmp88_ = g_strconcat ("----- FAIL: ", _tmp87_, NULL);
				_tmp89_ = _tmp88_;
				_tmp90_ = g_strconcat (_tmp89_, "\n", NULL);
				_tmp91_ = _tmp90_;
				fprintf (_tmp83_, "%s", _tmp91_);
				_g_free0 (_tmp91_);
				_g_free0 (_tmp89_);
				_g_free0 (_tmp87_);
				_g_free0 (name2);
				break;
			}
		}
		_g_free0 (name2);
	}
	_tmp92_ = i;
	if (_tmp92_ != 2) {
		gint _tmp93_ = 0;
		FILE* _tmp94_ = NULL;
		gint _tmp95_ = 0;
		gint _tmp96_ = 0;
		gchar* _tmp97_ = NULL;
		gchar* _tmp98_ = NULL;
		gchar* _tmp99_ = NULL;
		gchar* _tmp100_ = NULL;
		gchar* _tmp101_ = NULL;
		gchar* _tmp102_ = NULL;
		_tmp93_ = fails;
		fails = _tmp93_ + 1;
		_tmp94_ = stdout;
		_tmp95_ = fails;
		fails = _tmp95_ + 1;
		_tmp96_ = fails;
		_tmp97_ = g_strdup_printf ("%i", _tmp96_);
		_tmp98_ = _tmp97_;
		_tmp99_ = g_strconcat ("----- FAIL: ", _tmp98_, NULL);
		_tmp100_ = _tmp99_;
		_tmp101_ = g_strconcat (_tmp100_, "\n", NULL);
		_tmp102_ = _tmp101_;
		fprintf (_tmp94_, "%s", _tmp102_);
		_g_free0 (_tmp102_);
		_g_free0 (_tmp100_);
		_g_free0 (_tmp98_);
	} else {
		FILE* _tmp103_ = NULL;
		_tmp103_ = stdout;
		fprintf (_tmp103_, "+++++ PASS\n");
	}
	_tmp104_ = stdout;
	fprintf (_tmp104_, "Choping offset = 7 must fail...\n");
	_tmp105_ = self->priv->itermodel;
	_tmp106_ = gee_traversable_chop ((GeeTraversable*) _tmp105_, 7, -1);
	iter3 = _tmp106_;
	_tmp107_ = iter3;
	_tmp108_ = gee_iterator_has_next (_tmp107_);
	if (_tmp108_) {
		FILE* _tmp109_ = NULL;
		gint _tmp110_ = 0;
		gint _tmp111_ = 0;
		gchar* _tmp112_ = NULL;
		gchar* _tmp113_ = NULL;
		gchar* _tmp114_ = NULL;
		gchar* _tmp115_ = NULL;
		gchar* _tmp116_ = NULL;
		gchar* _tmp117_ = NULL;
		_tmp109_ = stdout;
		_tmp110_ = fails;
		fails = _tmp110_ + 1;
		_tmp111_ = fails;
		_tmp112_ = g_strdup_printf ("%i", _tmp111_);
		_tmp113_ = _tmp112_;
		_tmp114_ = g_strconcat ("----- FAIL: ", _tmp113_, NULL);
		_tmp115_ = _tmp114_;
		_tmp116_ = g_strconcat (_tmp115_, "\n", NULL);
		_tmp117_ = _tmp116_;
		fprintf (_tmp109_, "%s", _tmp117_);
		_g_free0 (_tmp117_);
		_g_free0 (_tmp115_);
		_g_free0 (_tmp113_);
	} else {
		GeeIterator* _tmp118_ = NULL;
		gboolean _tmp119_ = FALSE;
		gint _tmp129_ = 0;
		_tmp118_ = iter3;
		_tmp119_ = gee_iterator_next (_tmp118_);
		if (_tmp119_) {
			FILE* _tmp120_ = NULL;
			gint _tmp121_ = 0;
			gint _tmp122_ = 0;
			gchar* _tmp123_ = NULL;
			gchar* _tmp124_ = NULL;
			gchar* _tmp125_ = NULL;
			gchar* _tmp126_ = NULL;
			gchar* _tmp127_ = NULL;
			gchar* _tmp128_ = NULL;
			_tmp120_ = stdout;
			_tmp121_ = fails;
			fails = _tmp121_ + 1;
			_tmp122_ = fails;
			_tmp123_ = g_strdup_printf ("%i", _tmp122_);
			_tmp124_ = _tmp123_;
			_tmp125_ = g_strconcat ("----- FAIL: ", _tmp124_, NULL);
			_tmp126_ = _tmp125_;
			_tmp127_ = g_strconcat (_tmp126_, "\n", NULL);
			_tmp128_ = _tmp127_;
			fprintf (_tmp120_, "%s", _tmp128_);
			_g_free0 (_tmp128_);
			_g_free0 (_tmp126_);
			_g_free0 (_tmp124_);
		}
		_tmp129_ = fails;
		if (_tmp129_ == 0) {
			FILE* _tmp130_ = NULL;
			_tmp130_ = stdout;
			fprintf (_tmp130_, "+++++ PASS\n");
		}
	}
	_tmp131_ = stdout;
	fprintf (_tmp131_, "Choping offset = 6 length = 0 must fail...\n");
	_tmp132_ = self->priv->itermodel;
	_tmp133_ = gee_traversable_chop ((GeeTraversable*) _tmp132_, 6, 0);
	iter4 = _tmp133_;
	_tmp134_ = iter4;
	_tmp135_ = gee_iterator_has_next (_tmp134_);
	if (_tmp135_) {
		FILE* _tmp136_ = NULL;
		gint _tmp137_ = 0;
		gint _tmp138_ = 0;
		gchar* _tmp139_ = NULL;
		gchar* _tmp140_ = NULL;
		gchar* _tmp141_ = NULL;
		gchar* _tmp142_ = NULL;
		gchar* _tmp143_ = NULL;
		gchar* _tmp144_ = NULL;
		_tmp136_ = stdout;
		_tmp137_ = fails;
		fails = _tmp137_ + 1;
		_tmp138_ = fails;
		_tmp139_ = g_strdup_printf ("%i", _tmp138_);
		_tmp140_ = _tmp139_;
		_tmp141_ = g_strconcat ("----- FAIL: ", _tmp140_, NULL);
		_tmp142_ = _tmp141_;
		_tmp143_ = g_strconcat (_tmp142_, "\n", NULL);
		_tmp144_ = _tmp143_;
		fprintf (_tmp136_, "%s", _tmp144_);
		_g_free0 (_tmp144_);
		_g_free0 (_tmp142_);
		_g_free0 (_tmp140_);
	} else {
		GeeIterator* _tmp145_ = NULL;
		gboolean _tmp146_ = FALSE;
		gint _tmp156_ = 0;
		_tmp145_ = iter4;
		_tmp146_ = gee_iterator_next (_tmp145_);
		if (_tmp146_) {
			FILE* _tmp147_ = NULL;
			gint _tmp148_ = 0;
			gint _tmp149_ = 0;
			gchar* _tmp150_ = NULL;
			gchar* _tmp151_ = NULL;
			gchar* _tmp152_ = NULL;
			gchar* _tmp153_ = NULL;
			gchar* _tmp154_ = NULL;
			gchar* _tmp155_ = NULL;
			_tmp147_ = stdout;
			_tmp148_ = fails;
			fails = _tmp148_ + 1;
			_tmp149_ = fails;
			_tmp150_ = g_strdup_printf ("%i", _tmp149_);
			_tmp151_ = _tmp150_;
			_tmp152_ = g_strconcat ("----- FAIL: ", _tmp151_, NULL);
			_tmp153_ = _tmp152_;
			_tmp154_ = g_strconcat (_tmp153_, "\n", NULL);
			_tmp155_ = _tmp154_;
			fprintf (_tmp147_, "%s", _tmp155_);
			_g_free0 (_tmp155_);
			_g_free0 (_tmp153_);
			_g_free0 (_tmp151_);
		}
		_tmp156_ = fails;
		if (_tmp156_ == 0) {
			FILE* _tmp157_ = NULL;
			_tmp157_ = stdout;
			fprintf (_tmp157_, "+++++ PASS\n");
		}
	}
	_tmp158_ = stdout;
	fprintf (_tmp158_, "Choping offset = 5 length = 1...\n");
	_tmp159_ = self->priv->itermodel;
	_tmp160_ = gee_traversable_chop ((GeeTraversable*) _tmp159_, 5, 1);
	iter5 = _tmp160_;
	_tmp161_ = iter5;
	_tmp162_ = gee_iterator_next (_tmp161_);
	if (!_tmp162_) {
		FILE* _tmp163_ = NULL;
		gint _tmp164_ = 0;
		gint _tmp165_ = 0;
		gchar* _tmp166_ = NULL;
		gchar* _tmp167_ = NULL;
		gchar* _tmp168_ = NULL;
		gchar* _tmp169_ = NULL;
		gchar* _tmp170_ = NULL;
		gchar* _tmp171_ = NULL;
		_tmp163_ = stdout;
		_tmp164_ = fails;
		fails = _tmp164_ + 1;
		_tmp165_ = fails;
		_tmp166_ = g_strdup_printf ("%i", _tmp165_);
		_tmp167_ = _tmp166_;
		_tmp168_ = g_strconcat ("----- FAIL: ", _tmp167_, NULL);
		_tmp169_ = _tmp168_;
		_tmp170_ = g_strconcat (_tmp169_, "\n", NULL);
		_tmp171_ = _tmp170_;
		fprintf (_tmp163_, "%s", _tmp171_);
		_g_free0 (_tmp171_);
		_g_free0 (_tmp169_);
		_g_free0 (_tmp167_);
	} else {
		GeeIterator* _tmp172_ = NULL;
		gboolean _tmp173_ = FALSE;
		gint _tmp183_ = 0;
		_tmp172_ = iter5;
		_tmp173_ = gee_iterator_next (_tmp172_);
		if (_tmp173_) {
			FILE* _tmp174_ = NULL;
			gint _tmp175_ = 0;
			gint _tmp176_ = 0;
			gchar* _tmp177_ = NULL;
			gchar* _tmp178_ = NULL;
			gchar* _tmp179_ = NULL;
			gchar* _tmp180_ = NULL;
			gchar* _tmp181_ = NULL;
			gchar* _tmp182_ = NULL;
			_tmp174_ = stdout;
			_tmp175_ = fails;
			fails = _tmp175_ + 1;
			_tmp176_ = fails;
			_tmp177_ = g_strdup_printf ("%i", _tmp176_);
			_tmp178_ = _tmp177_;
			_tmp179_ = g_strconcat ("----- FAIL: ", _tmp178_, NULL);
			_tmp180_ = _tmp179_;
			_tmp181_ = g_strconcat (_tmp180_, "\n", NULL);
			_tmp182_ = _tmp181_;
			fprintf (_tmp174_, "%s", _tmp182_);
			_g_free0 (_tmp182_);
			_g_free0 (_tmp180_);
			_g_free0 (_tmp178_);
		}
		_tmp183_ = fails;
		if (_tmp183_ == 0) {
			FILE* _tmp184_ = NULL;
			_tmp184_ = stdout;
			fprintf (_tmp184_, "+++++ PASS\n");
		}
	}
	_tmp185_ = fails;
	if (_tmp185_ == 0) {
		FILE* _tmp186_ = NULL;
		_tmp186_ = stdout;
		fprintf (_tmp186_, "%s", "+++++ PASS: " "\n");
	}
	result = fails;
	_g_object_unref0 (iter5);
	_g_object_unref0 (iter4);
	_g_object_unref0 (iter3);
	_g_object_unref0 (iter2);
	_g_object_unref0 (iter);
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gboolean __lambda2_ (CheckTests* self, GdaDataDbRecord* g) {
	gboolean result = FALSE;
	gboolean ret = FALSE;
	gboolean _tmp23_ = FALSE;
	g_return_val_if_fail (g != NULL, FALSE);
	ret = FALSE;
	{
		GeeIterator* _fl_it = NULL;
		GdaDataDbRecord* _tmp0_ = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_ = NULL;
		GeeCollection* _tmp3_ = NULL;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_ = NULL;
		_tmp0_ = g;
		_tmp1_ = gda_data_db_record_get_fields (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_fl_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			GdaDataDbField* fl = NULL;
			GeeIterator* _tmp8_ = NULL;
			gpointer _tmp9_ = NULL;
			gchar* t = NULL;
			GdaDataDbField* _tmp10_ = NULL;
			GValue* _tmp11_ = NULL;
			GValue* _tmp12_ = NULL;
			GValue _tmp13_ = {0};
			gchar* _tmp14_ = NULL;
			FILE* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			_tmp6_ = _fl_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _fl_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			fl = (GdaDataDbField*) _tmp9_;
			_tmp10_ = fl;
			_tmp11_ = gda_data_db_field_get_value (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = *_tmp12_;
			_tmp14_ = gda_value_stringify (&_tmp13_);
			t = _tmp14_;
			_tmp15_ = stdout;
			_tmp16_ = t;
			_tmp17_ = g_strconcat ("Value to check: ", _tmp16_, NULL);
			_tmp18_ = _tmp17_;
			fprintf (_tmp15_, "%s", _tmp18_);
			_g_free0 (_tmp18_);
			_tmp19_ = t;
			_tmp20_ = string_contains (_tmp19_, "J");
			if (_tmp20_) {
				FILE* _tmp21_ = NULL;
				ret = TRUE;
				_tmp21_ = stdout;
				fprintf (_tmp21_, "...SELECTED\n");
				_g_free0 (t);
				_g_object_unref0 (fl);
				break;
			} else {
				FILE* _tmp22_ = NULL;
				ret = FALSE;
				_tmp22_ = stdout;
				fprintf (_tmp22_, "...REJECTED\n");
			}
			_g_free0 (t);
			_g_object_unref0 (fl);
		}
		_g_object_unref0 (_fl_it);
	}
	_tmp23_ = ret;
	if (_tmp23_) {
		FILE* _tmp24_ = NULL;
		GdaDataDbRecord* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		_tmp24_ = stdout;
		_tmp25_ = g;
		_tmp26_ = gda_data_db_record_to_string (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat ("SELECTED ROW: \n", _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat (_tmp29_, "\n", NULL);
		_tmp31_ = _tmp30_;
		fprintf (_tmp24_, "%s", _tmp31_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
	}
	result = ret;
	return result;
}


static gboolean ___lambda2__gee_predicate (gconstpointer g, gpointer self) {
	gboolean result;
	result = __lambda2_ (self, g);
	return result;
}


gint check_tests_filtering (CheckTests* self) {
	gint result = 0;
	gint fails = 0;
	FILE* _tmp0_ = NULL;
	GeeIterator* iter = NULL;
	GdaDataDbRecordCollection* _tmp1_ = NULL;
	GeeIterator* _tmp2_ = NULL;
	FILE* _tmp3_ = NULL;
	gint i = 0;
	gint _tmp24_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	fails = 0;
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> TESTING: Filtering Records: Any field type STRING with a letter 'J" \
"'...\n");
	_tmp1_ = self->priv->itermodel;
	_tmp2_ = gee_traversable_filter ((GeeTraversable*) _tmp1_, ___lambda2__gee_predicate, g_object_ref (self), g_object_unref);
	iter = _tmp2_;
	_tmp3_ = stdout;
	fprintf (_tmp3_, "\nPrinting Filtered Values...\n");
	i = 0;
	while (TRUE) {
		GeeIterator* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		FILE* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		GeeIterator* _tmp15_ = NULL;
		gpointer _tmp16_ = NULL;
		GdaDataDbRecord* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		_tmp4_ = iter;
		_tmp5_ = gee_iterator_next (_tmp4_);
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = stdout;
		_tmp7_ = i;
		i = _tmp7_ + 1;
		_tmp8_ = i;
		_tmp9_ = g_strdup_printf ("%i", _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat ("Row", _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp12_, ":\n", NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = iter;
		_tmp16_ = gee_iterator_get (_tmp15_);
		_tmp17_ = (GdaDataDbRecord*) _tmp16_;
		_tmp18_ = gda_data_db_record_to_string (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp14_, _tmp19_, NULL);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strconcat (_tmp21_, "\n", NULL);
		_tmp23_ = _tmp22_;
		fprintf (_tmp6_, "%s", _tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_object_unref0 (_tmp17_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
	}
	_tmp24_ = i;
	if (_tmp24_ != 3) {
		FILE* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		_tmp25_ = stdout;
		_tmp26_ = fails;
		fails = _tmp26_ + 1;
		_tmp27_ = fails;
		_tmp28_ = g_strdup_printf ("%i", _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat ("----- FAIL", _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strconcat (_tmp31_, "\n", NULL);
		_tmp33_ = _tmp32_;
		fprintf (_tmp25_, "%s", _tmp33_);
		_g_free0 (_tmp33_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
	} else {
		FILE* _tmp34_ = NULL;
		_tmp34_ = stdout;
		fprintf (_tmp34_, "+++++ PASS\n");
	}
	result = fails;
	_g_object_unref0 (iter);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		CheckTests * self;
		self = _data1_->self;
		_g_free0 (_data1_->ts);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gchar* ______lambda4_ (Block1Data* _data1_) {
	CheckTests * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = _data1_->self;
	_tmp0_ = _data1_->ts;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gpointer _______lambda4__gee_lazy_func (gpointer self) {
	gpointer result;
	result = ______lambda4_ (self);
	return result;
}


static GeeTraversableStream __lambda3_ (CheckTests* self, GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy) {
	GeeLazy* _vala_lazy = NULL;
	GeeTraversableStream result = 0;
	GeeTraversableStream _tmp0_ = 0;
	_tmp0_ = state;
	switch (_tmp0_) {
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			_gee_lazy_unref0 (_vala_lazy);
			_vala_lazy = NULL;
			result = GEE_TRAVERSABLE_STREAM_CONTINUE;
			_gee_lazy_unref0 (g);
			if (lazy) {
				*lazy = _vala_lazy;
			} else {
				_gee_lazy_unref0 (_vala_lazy);
			}
			return result;
			break;
		}
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
		{
			GdaDataDbRecord* r = NULL;
			GeeLazy* _tmp1_ = NULL;
			gconstpointer _tmp2_ = NULL;
			GdaDataDbRecord* _tmp3_ = NULL;
			GdaDataDbRecord* _tmp4_ = NULL;
			_tmp1_ = g;
			_tmp2_ = gee_lazy_get_value (_tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = _g_object_ref0 ((GdaDataDbRecord*) _tmp3_);
			r = _tmp4_;
			{
				GeeIterator* _f_it = NULL;
				GdaDataDbRecord* _tmp5_ = NULL;
				GeeCollection* _tmp6_ = NULL;
				GeeCollection* _tmp7_ = NULL;
				GeeCollection* _tmp8_ = NULL;
				GeeIterator* _tmp9_ = NULL;
				GeeIterator* _tmp10_ = NULL;
				_tmp5_ = r;
				_tmp6_ = gda_data_db_record_get_fields (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = _tmp7_;
				_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
				_tmp10_ = _tmp9_;
				_g_object_unref0 (_tmp8_);
				_f_it = _tmp10_;
				while (TRUE) {
					GeeIterator* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					GdaDataDbField* f = NULL;
					GeeIterator* _tmp13_ = NULL;
					gpointer _tmp14_ = NULL;
					GdaDataDbField* _tmp15_ = NULL;
					GValue* _tmp16_ = NULL;
					GValue* _tmp17_ = NULL;
					GType _tmp18_ = 0UL;
					_tmp11_ = _f_it;
					_tmp12_ = gee_iterator_next (_tmp11_);
					if (!_tmp12_) {
						break;
					}
					_tmp13_ = _f_it;
					_tmp14_ = gee_iterator_get (_tmp13_);
					f = (GdaDataDbField*) _tmp14_;
					_tmp15_ = f;
					_tmp16_ = gda_data_db_field_get_value (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = G_VALUE_TYPE (_tmp17_);
					if (_tmp18_ == G_TYPE_STRING) {
						Block1Data* _data1_;
						FILE* _tmp19_ = NULL;
						GdaDataDbField* _tmp20_ = NULL;
						const gchar* _tmp21_ = NULL;
						const gchar* _tmp22_ = NULL;
						GdaDataDbField* _tmp23_ = NULL;
						GValue* _tmp24_ = NULL;
						GValue* _tmp25_ = NULL;
						GValue _tmp26_ = {0};
						gchar* _tmp27_ = NULL;
						gchar* _tmp28_ = NULL;
						GdaDataDbField* _tmp29_ = NULL;
						GValue* _tmp30_ = NULL;
						GValue* _tmp31_ = NULL;
						GValue _tmp32_ = {0};
						gchar* _tmp33_ = NULL;
						GeeLazy* _tmp34_ = NULL;
						_data1_ = g_slice_new0 (Block1Data);
						_data1_->_ref_count_ = 1;
						_data1_->self = g_object_ref (self);
						_tmp19_ = stdout;
						_tmp20_ = f;
						_tmp21_ = gda_data_db_field_get_name (_tmp20_);
						_tmp22_ = _tmp21_;
						_tmp23_ = f;
						_tmp24_ = gda_data_db_field_get_value (_tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = *_tmp25_;
						_tmp27_ = gda_value_stringify (&_tmp26_);
						_tmp28_ = _tmp27_;
						fprintf (_tmp19_, "Field (%s) =  %s\n", _tmp22_, _tmp28_);
						_g_free0 (_tmp28_);
						_tmp29_ = f;
						_tmp30_ = gda_data_db_field_get_value (_tmp29_);
						_tmp31_ = _tmp30_;
						_tmp32_ = *_tmp31_;
						_tmp33_ = gda_value_stringify (&_tmp32_);
						_data1_->ts = _tmp33_;
						_tmp34_ = gee_lazy_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _______lambda4__gee_lazy_func, block1_data_ref (_data1_), block1_data_unref);
						_gee_lazy_unref0 (_vala_lazy);
						_vala_lazy = _tmp34_;
						block1_data_unref (_data1_);
						_data1_ = NULL;
					}
					_g_object_unref0 (f);
				}
				_g_object_unref0 (_f_it);
			}
			result = GEE_TRAVERSABLE_STREAM_YIELD;
			_g_object_unref0 (r);
			_gee_lazy_unref0 (g);
			if (lazy) {
				*lazy = _vala_lazy;
			} else {
				_gee_lazy_unref0 (_vala_lazy);
			}
			return result;
			_g_object_unref0 (r);
			break;
		}
		default:
		break;
	}
	result = GEE_TRAVERSABLE_STREAM_END;
	_gee_lazy_unref0 (g);
	if (lazy) {
		*lazy = _vala_lazy;
	} else {
		_gee_lazy_unref0 (_vala_lazy);
	}
	return result;
}


static GeeTraversableStream ___lambda3__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda3_ (self, state, g, lazy);
	return result;
}


gint check_tests_streaming (CheckTests* self) {
	gint result = 0;
	gint fails = 0;
	FILE* _tmp0_ = NULL;
	GeeIterator* iter = NULL;
	GdaDataDbRecordCollection* _tmp1_ = NULL;
	GeeIterator* _tmp2_ = NULL;
	FILE* _tmp3_ = NULL;
	GeeArrayList* l = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GeeArrayList* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	GeeArrayList* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	GeeArrayList* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	GeeArrayList* _tmp27_ = NULL;
	gboolean _tmp28_ = FALSE;
	gint _tmp30_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	fails = 0;
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> TESTING: Streaming Values: First DbRecord's field type STRING will" \
" be YIELDED...\n");
	_tmp1_ = self->priv->itermodel;
	_tmp2_ = gee_traversable_stream ((GeeTraversable*) _tmp1_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, ___lambda3__gee_stream_func, g_object_ref (self), g_object_unref);
	iter = _tmp2_;
	_tmp3_ = stdout;
	fprintf (_tmp3_, "Printing Streamed Values...\n");
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	l = _tmp4_;
	while (TRUE) {
		GeeIterator* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gchar* v = NULL;
		GeeIterator* _tmp7_ = NULL;
		gpointer _tmp8_ = NULL;
		GeeArrayList* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		FILE* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp5_ = iter;
		_tmp6_ = gee_iterator_next (_tmp5_);
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = iter;
		_tmp8_ = gee_iterator_get (_tmp7_);
		v = (gchar*) _tmp8_;
		_tmp9_ = l;
		_tmp10_ = v;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp10_);
		_tmp11_ = stdout;
		_tmp12_ = v;
		_tmp13_ = g_strconcat (_tmp12_, "\n", NULL);
		_tmp14_ = _tmp13_;
		fprintf (_tmp11_, "%s", _tmp14_);
		_g_free0 (_tmp14_);
		_g_free0 (v);
	}
	_tmp15_ = l;
	_tmp16_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp15_, "Daniel");
	if (!_tmp16_) {
		gint _tmp17_ = 0;
		_tmp17_ = fails;
		fails = _tmp17_ + 1;
	}
	_tmp18_ = l;
	_tmp19_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp18_, "Jhon");
	if (!_tmp19_) {
		gint _tmp20_ = 0;
		_tmp20_ = fails;
		fails = _tmp20_ + 1;
	}
	_tmp21_ = l;
	_tmp22_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp21_, "Jack");
	if (!_tmp22_) {
		gint _tmp23_ = 0;
		_tmp23_ = fails;
		fails = _tmp23_ + 1;
	}
	_tmp24_ = l;
	_tmp25_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp24_, "Elsy");
	if (!_tmp25_) {
		gint _tmp26_ = 0;
		_tmp26_ = fails;
		fails = _tmp26_ + 1;
	}
	_tmp27_ = l;
	_tmp28_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp27_, "Mayo");
	if (!_tmp28_) {
		gint _tmp29_ = 0;
		_tmp29_ = fails;
		fails = _tmp29_ + 1;
	}
	_tmp30_ = fails;
	if (_tmp30_ > 0) {
		FILE* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		_tmp31_ = stdout;
		_tmp32_ = fails;
		fails = _tmp32_ + 1;
		_tmp33_ = fails;
		_tmp34_ = g_strdup_printf ("%i", _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strconcat ("----- FAIL", _tmp35_, NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat (_tmp37_, "\n", NULL);
		_tmp39_ = _tmp38_;
		fprintf (_tmp31_, "%s", _tmp39_);
		_g_free0 (_tmp39_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
	} else {
		FILE* _tmp40_ = NULL;
		_tmp40_ = stdout;
		fprintf (_tmp40_, "+++++ PASS\n");
	}
	result = fails;
	_g_object_unref0 (l);
	_g_object_unref0 (iter);
	return result;
}


gint check_tests_InitIter (CheckTests* self, GError** error) {
	gint result = 0;
	FILE* _tmp0_ = NULL;
	gint fails = 0;
	GdaDataModel* model = NULL;
	GdaConnection* _tmp1_ = NULL;
	GdaDataModel* _tmp2_ = NULL;
	FILE* _tmp3_ = NULL;
	GdaDataTable* t = NULL;
	GdaDataTable* _tmp4_ = NULL;
	GdaDataTable* _tmp5_ = NULL;
	GdaConnection* _tmp6_ = NULL;
	GdaDataTable* _tmp7_ = NULL;
	FILE* _tmp8_ = NULL;
	FILE* _tmp9_ = NULL;
	GdaDataTable* _tmp10_ = NULL;
	GdaDataRecordCollection* _tmp11_ = NULL;
	FILE* _tmp12_ = NULL;
	FILE* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = stdout;
	fprintf (_tmp0_, ">>> INITIALIZING: DbRecordCollection/RecordCollection\n");
	fails = 0;
	_tmp1_ = self->priv->connection;
	_tmp2_ = gda_connection_execute_select_command (_tmp1_, "SELECT * FROM user ORDER BY id", &_inner_error_);
	model = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	_tmp3_ = stdout;
	fprintf (_tmp3_, "Setting up Table...");
	_tmp4_ = gda_data_table_new ();
	t = _tmp4_;
	_tmp5_ = t;
	_tmp6_ = self->priv->connection;
	gda_data_db_object_set_connection ((GdaDataDbObject*) _tmp5_, _tmp6_);
	_tmp7_ = t;
	gda_data_db_named_object_set_name ((GdaDataDbNamedObject*) _tmp7_, "user");
	_tmp8_ = stdout;
	fprintf (_tmp8_, "+++++ PASS\n");
	_tmp9_ = stdout;
	fprintf (_tmp9_, "Setting up DbRecordCollection...");
	_tmp10_ = t;
	_tmp11_ = gda_data_record_collection_new (model, (GdaDataDbTable*) _tmp10_);
	_g_object_unref0 (self->priv->itermodel);
	self->priv->itermodel = (GdaDataDbRecordCollection*) _tmp11_;
	_tmp12_ = stdout;
	fprintf (_tmp12_, "+++++ PASS\n");
	_tmp13_ = stdout;
	_tmp14_ = gda_data_model_dump_as_string (model);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat ("DataModel rows:\n", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	fprintf (_tmp13_, "%s", _tmp17_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	result = fails;
	_g_object_unref0 (t);
	_g_object_unref0 (model);
	return result;
}


gint check_tests_main (gchar** args, int args_length1) {
	gint result = 0;
	FILE* _tmp0_ = NULL;
	gint failures = 0;
	CheckTests* app = NULL;
	CheckTests* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	CheckTests* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	CheckTests* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	CheckTests* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	CheckTests* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	CheckTests* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	GError * _inner_error_ = NULL;
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Checking Gda.DataModelIterator implementation...\n");
	failures = 0;
	_tmp1_ = check_tests_new ();
	app = _tmp1_;
	_tmp3_ = app;
	_tmp4_ = check_tests_InitIter (_tmp3_, &_inner_error_);
	_tmp2_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (app);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp5_ = failures;
	failures = _tmp5_ + _tmp2_;
	_tmp7_ = app;
	_tmp8_ = check_tests_iterating (_tmp7_, &_inner_error_);
	_tmp6_ = _tmp8_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (app);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp9_ = failures;
	failures = _tmp9_ + _tmp6_;
	_tmp10_ = failures;
	_tmp11_ = app;
	_tmp12_ = check_tests_streaming (_tmp11_);
	failures = _tmp10_ + _tmp12_;
	_tmp13_ = failures;
	_tmp14_ = app;
	_tmp15_ = check_tests_filtering (_tmp14_);
	failures = _tmp13_ + _tmp15_;
	_tmp16_ = failures;
	_tmp17_ = app;
	_tmp18_ = check_tests_choping (_tmp17_);
	failures = _tmp16_ + _tmp18_;
	_tmp20_ = failures;
	if (_tmp20_ != 0) {
		_tmp19_ = 1;
	} else {
		_tmp19_ = 0;
	}
	_tmp21_ = _tmp19_;
	result = _tmp21_;
	_g_object_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return check_tests_main (argv, argc);
}


static void check_tests_class_init (CheckTestsClass * klass) {
	check_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheckTestsPrivate));
	G_OBJECT_CLASS (klass)->finalize = check_tests_finalize;
}


static void check_tests_instance_init (CheckTests * self) {
	self->priv = CHECK_TESTS_GET_PRIVATE (self);
}


static void check_tests_finalize (GObject* obj) {
	CheckTests * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHECK_TYPE_TESTS, CheckTests);
	_g_object_unref0 (self->priv->connection);
	_g_object_unref0 (self->priv->itermodel);
	G_OBJECT_CLASS (check_tests_parent_class)->finalize (obj);
}


GType check_tests_get_type (void) {
	static volatile gsize check_tests_type_id__volatile = 0;
	if (g_once_init_enter (&check_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheckTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) check_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheckTests), 0, (GInstanceInitFunc) check_tests_instance_init, NULL };
		GType check_tests_type_id;
		check_tests_type_id = g_type_register_static (G_TYPE_OBJECT, "CheckTests", &g_define_type_info, 0);
		g_once_init_leave (&check_tests_type_id__volatile, check_tests_type_id);
	}
	return check_tests_type_id__volatile;
}



