/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#include "DiscWrapperMain.h"


void DiscWrapperFrame::AddToRedoList(int URAct)  // Save the state before change
{

    /**
    Label actions:
        0: Label
        1: XY (place)
        2: calss
        3: rotate
        4: align
        5: font
        6: colour
        7: bend
        8: created
        9: deleted

    List actions:
        0: __Label__ !Obsolote! (not used)
        1: XY (place)
        2: list
        3: font
        4: colour
        5: created
        6: deleted

    Image actions:
        0: scale
        1: XY (place)
        2: rotate
        3: up
        4: down
        5: created
        6: deleted
        7: fit hor./ver.
    **/

    MenuItem11->Enable(true);
    MenuItem12->Enable(false);

    UR_Current = UR_Max = UR_Current + 2;

    int i, Cpage = GetCurrentPage();
    int URT_Page[UR_Max], URT_Tool[UR_Max], URT_Id[UR_Max], URT_Act[UR_Max], URVT_int1[UR_Max], URVT_int2[UR_Max], URVT_int3[UR_Max], URVT_int4[UR_Max], URVT_int5[UR_Max], URVT_int6[UR_Max];
    wxString URVT_string[UR_Max];
    wxFontData URVT_font[UR_Max];
    wxColourData URVT_colour[UR_Max];

    if ( UR_Max-2 > 0 )
    {
        for ( i = 0 ; i < UR_Max-2 ; i++ )
        {
            URT_Page[i] = UR_Page[i];
            URT_Tool[i] = UR_Tool[i];
            URT_Id[i] = UR_Id[i];
            URT_Act[i] = UR_Act[i];
            URVT_string[i] = URV_string[i];
            URVT_int1[i] = URV_int1[i];
            URVT_int2[i] = URV_int2[i];
            URVT_int3[i] = URV_int3[i];
            URVT_int4[i] = URV_int4[i];
            URVT_int5[i] = URV_int5[i];
            URVT_int6[i] = URV_int6[i];
            URVT_font[i] = URV_font[i];
            URVT_colour[i] = URV_colour[i];
        }

        delete[] UR_Page;
        delete[] UR_Tool;
        delete[] UR_Id;
        delete[] UR_Act;
        delete[] URV_string;
        delete[] URV_int1;
        delete[] URV_int2;
        delete[] URV_int3;
        delete[] URV_int4;
        delete[] URV_int5;
        delete[] URV_int6;
        delete[] URV_font;
        delete[] URV_colour;
    }

    UR_Page = new int[UR_Max];
    UR_Tool = new int[UR_Max];
    UR_Id = new int[UR_Max];
    UR_Act = new int[UR_Max];
    URV_string = new wxString[UR_Max];
    URV_int1 = new int[UR_Max];
    URV_int2 = new int[UR_Max];
    URV_int3 = new int[UR_Max];
    URV_int4 = new int[UR_Max];
    URV_int5 = new int[UR_Max];
    URV_int6 = new int[UR_Max];
    URV_font = new wxFontData[UR_Max];
    URV_colour = new wxColourData[UR_Max];

    if ( UR_Max-2 > 0 )
    {
        for ( i = 0 ; i < UR_Max-2 ; i++ )
        {
            UR_Page[i] = URT_Page[i];
            UR_Tool[i] = URT_Tool[i];
            UR_Id[i] = URT_Id[i];
            UR_Act[i] = URT_Act[i];
            URV_string[i] = URVT_string[i];
            URV_int1[i] = URVT_int1[i];
            URV_int2[i] = URVT_int2[i];
            URV_int3[i] = URVT_int3[i];
            URV_int4[i] = URVT_int4[i];
            URV_int5[i] = URVT_int5[i];
            URV_int6[i] = URVT_int6[i];
            URV_font[i] = URVT_font[i];
            URV_colour[i] = URVT_colour[i];
        }
    }


    UR_Id[UR_Max-2] = SelectedItem;
    UR_Act[UR_Max-2] = URAct;

    UR_Page[UR_Max-2] = Cpage;
    switch(ActiveTool){
        case 1:
            UR_Tool[UR_Max-2] = 1;

            switch(URAct){
                case 0:
                    URV_string[UR_Max-2] = UR_stringT;
                    break;
                case 1:
                    URV_int1[UR_Max-2] = UR_int1T;
                    URV_int2[UR_Max-2] = UR_int2T;
                    break;
                case 2:
                    URV_int1[UR_Max-2] = Database->Page[Cpage].labels[SelectedItem].Class;
                    break;
                case 3:
                    URV_int1[UR_Max-2] = UR_int1T;
                    break;
                case 4:
                    URV_int1[UR_Max-2] = Database->Page[Cpage].labels[SelectedItem].Align;
                    break;
                case 5:
                    URV_font[UR_Max-2] = Database->Page[Cpage].labels[SelectedItem].Font;
                    break;
                case 6:
                    URV_colour[UR_Max-2] = Database->Page[Cpage].labels[SelectedItem].Colour;
                    break;
                case 7:
                    URV_int1[UR_Max-2] = Database->Page[Cpage].labels[SelectedItem].Bend;
                    URV_int2[UR_Max-2] = Database->Page[Cpage].labels[SelectedItem].Angle;
                    break;
                case 8:
                    URV_int1[UR_Max-2] = Database->Page[Cpage].labels[SelectedItem].X;
                    URV_int2[UR_Max-2] = Database->Page[Cpage].labels[SelectedItem].Y;
                    break;
                case 9:
                    URV_string[UR_Max-2] = Database->Page[Cpage].labels[SelectedItem].L;
                    URV_int1[UR_Max-2] = Database->Page[Cpage].labels[SelectedItem].X;
                    URV_int2[UR_Max-2] = Database->Page[Cpage].labels[SelectedItem].Y;
                    URV_int3[UR_Max-2] = Database->Page[Cpage].labels[SelectedItem].Class;
                    URV_int4[UR_Max-2] = Database->Page[Cpage].labels[SelectedItem].Angle;
                    URV_int5[UR_Max-2] = Database->Page[Cpage].labels[SelectedItem].Align;
                    URV_int6[UR_Max-2] = Database->Page[Cpage].labels[SelectedItem].Bend;
                    URV_font[UR_Max-2] = Database->Page[Cpage].labels[SelectedItem].Font;
                    URV_colour[UR_Max-2] = Database->Page[Cpage].labels[SelectedItem].Colour;

                    UR_IndexCorrection = SelectedItem;
                    break;
            }
            break;
        case 2:
            UR_Tool[UR_Max-2] = 2;

            switch(URAct){
                case 0:
                    //Unused
                    break;
                case 1:
                    URV_int1[UR_Max-2] = UR_int1T;
                    URV_int2[UR_Max-2] = UR_int2T;
                    break;
                case 2:
                    URV_string[UR_Max-2] = UR_stringT;
                    break;
                case 3:
                    URV_font[UR_Max-2] = Database->Page[Cpage].lists[SelectedItem].Font;
                    break;
                case 4:
                    URV_colour[UR_Max-2] = Database->Page[Cpage].lists[SelectedItem].Colour;
                    break;
                case 5:
                    URV_int1[UR_Max-2] = Database->Page[Cpage].lists[SelectedItem].X;
                    URV_int2[UR_Max-2] = Database->Page[Cpage].lists[SelectedItem].Y;
                    for ( i = 0 ; i < Database->Page[Cpage].lists[SelectedItem].L.GetCount() ; i++ )
                    {
                        if ( i != 0 )
                            URV_string[UR_Max-2] += _T("\n");
                        URV_string[UR_Max-2] += Database->Page[Cpage].lists[SelectedItem].L.Item(i);
                    }
                    break;
                case 6:
                    URV_int1[UR_Max-2] = Database->Page[Cpage].lists[SelectedItem].X;
                    URV_int2[UR_Max-2] = Database->Page[Cpage].lists[SelectedItem].Y;
                    URV_font[UR_Max-2] = Database->Page[Cpage].lists[SelectedItem].Font;
                    URV_colour[UR_Max-2] = Database->Page[Cpage].lists[SelectedItem].Colour;
                    for ( i = 0 ; i < Database->Page[Cpage].lists[SelectedItem].L.GetCount() ; i++ )
                    {
                        if ( i != 0 )
                            URV_string[UR_Max-2] += _T("\n");
                        URV_string[UR_Max-2] += Database->Page[Cpage].lists[SelectedItem].L.Item(i);
                    }

                    UR_IndexCorrection = SelectedItem;
                    break;
            }
            break;
        case 3:
            UR_Tool[UR_Max-2] = 3;

            switch(URAct){
                case 0:
                    URV_int1[UR_Max-2] = UR_int1T;
                    break;
                case 1:
                    URV_int1[UR_Max-2] = UR_int1T;
                    URV_int2[UR_Max-2] = UR_int2T;
                    break;
                case 2:
                    URV_int1[UR_Max-2] = UR_int1T;
                    break;
                case 3:
                    i = 0;
                    while ( Database->Page[Cpage].ImageOrder[i] != SelectedItem )
                        i++;
                    URV_int1[UR_Max-2] = i;
                    break;
                case 4:
                    i = 0;
                    while ( Database->Page[Cpage].ImageOrder[i] != SelectedItem )
                        i++;
                    URV_int1[UR_Max-2] = i;
                    break;
                case 5:
                    URV_int1[UR_Max-2] = Database->Page[Cpage].images[SelectedItem].X;
                    URV_int2[UR_Max-2] = Database->Page[Cpage].images[SelectedItem].Y;
                    URV_string[UR_Max-2] = Database->Page[Cpage].images[SelectedItem].Path;
                    break;
                case 6:
                    URV_int1[UR_Max-2] = Database->Page[Cpage].images[SelectedItem].X;
                    URV_int2[UR_Max-2] = Database->Page[Cpage].images[SelectedItem].Y;
                    URV_int3[UR_Max-2] = Database->Page[Cpage].images[SelectedItem].Scale;
                    URV_int4[UR_Max-2] = Database->Page[Cpage].images[SelectedItem].Rotate;
                    i = 0;
                    while ( Database->Page[Cpage].ImageOrder[i] != SelectedItem )
                        i++;
                    URV_int5[UR_Max-2] = i;
                    URV_string[UR_Max-2] = Database->Page[Cpage].images[SelectedItem].Path;

                    UR_IndexCorrection = SelectedItem;
                    break;
                case 7:
                    URV_int1[UR_Max-2] = Database->Page[Cpage].images[SelectedItem].X;
                    URV_int2[UR_Max-2] = Database->Page[Cpage].images[SelectedItem].Y;
                    URV_int3[UR_Max-2] = Database->Page[Cpage].images[SelectedItem].Scale;
                    break;

            }
            break;
    }

}

void DiscWrapperFrame::NowOfRedoList(int URAct)  // Save after change
{
    int i, Cpage = GetCurrentPage();

    UR_Id[UR_Max-1] = SelectedItem;
    UR_Act[UR_Max-1] = URAct;

    UR_Page[UR_Max-1] = Cpage;
    switch(ActiveTool){
        case 1:
            UR_Tool[UR_Max-1] = 1;

            switch(URAct){
                case 0:
                    URV_string[UR_Max-1] = UR_stringT;
                    break;
                case 1:
                    URV_int1[UR_Max-1] = UR_int1T;
                    URV_int2[UR_Max-1] = UR_int2T;
                    break;
                case 2:
                    URV_int1[UR_Max-1] = Database->Page[Cpage].labels[SelectedItem].Class;
                    break;
                case 3:
                    URV_int1[UR_Max-1] = UR_int1T;
                    break;
                case 4:
                    URV_int1[UR_Max-1] = Database->Page[Cpage].labels[SelectedItem].Align;
                    break;
                case 5:
                    URV_font[UR_Max-1] = Database->Page[Cpage].labels[SelectedItem].Font;
                    break;
                case 6:
                    URV_colour[UR_Max-1] = Database->Page[Cpage].labels[SelectedItem].Colour;
                    break;
                case 7:
                    URV_int1[UR_Max-1] = Database->Page[Cpage].labels[SelectedItem].Bend;
                    URV_int2[UR_Max-1] = Database->Page[Cpage].labels[SelectedItem].Angle;
                    break;
                case 8:
                    URV_int1[UR_Max-1] = Database->Page[Cpage].labels[SelectedItem].X;
                    URV_int2[UR_Max-1] = Database->Page[Cpage].labels[SelectedItem].Y;
                    break;
                case 9:
                    URV_string[UR_Max-1] = Database->Page[Cpage].labels[SelectedItem].L;
                    URV_int1[UR_Max-1] = Database->Page[Cpage].labels[SelectedItem].X;
                    URV_int2[UR_Max-1] = Database->Page[Cpage].labels[SelectedItem].Y;
                    URV_int3[UR_Max-1] = Database->Page[Cpage].labels[SelectedItem].Class;
                    URV_int4[UR_Max-1] = Database->Page[Cpage].labels[SelectedItem].Angle;
                    URV_int5[UR_Max-1] = Database->Page[Cpage].labels[SelectedItem].Align;
                    URV_int6[UR_Max-1] = Database->Page[Cpage].labels[SelectedItem].Bend;
                    URV_font[UR_Max-1] = Database->Page[Cpage].labels[SelectedItem].Font;
                    URV_colour[UR_Max-1] = Database->Page[Cpage].labels[SelectedItem].Colour;

                    UR_IndexCorrection = SelectedItem;
                    break;
            }
            break;
        case 2:
            UR_Tool[UR_Max-1] = 2;

            switch(URAct){
                case 0:
                    //Unused
                    break;
                case 1:
                    URV_int1[UR_Max-1] = UR_int1T;
                    URV_int2[UR_Max-1] = UR_int2T;
                    break;
                case 2:
                    URV_string[UR_Max-1] = UR_stringT;
                    break;
                case 3:
                    URV_font[UR_Max-1] = Database->Page[Cpage].lists[SelectedItem].Font;
                    break;
                case 4:
                    URV_colour[UR_Max-1] = Database->Page[Cpage].lists[SelectedItem].Colour;
                    break;
                case 5:
                    URV_int1[UR_Max-1] = Database->Page[Cpage].lists[SelectedItem].X;
                    URV_int2[UR_Max-1] = Database->Page[Cpage].lists[SelectedItem].Y;
                    for ( i = 0 ; i < Database->Page[Cpage].lists[SelectedItem].L.GetCount() ; i++ )
                    {
                        if ( i != 0 )
                            URV_string[UR_Max-1] += _T("\n");
                        URV_string[UR_Max-1] += Database->Page[Cpage].lists[SelectedItem].L.Item(i);
                    }
                    break;
                case 6:
                    URV_int1[UR_Max-1] = Database->Page[Cpage].lists[SelectedItem].X;
                    URV_int2[UR_Max-1] = Database->Page[Cpage].lists[SelectedItem].Y;
                    URV_font[UR_Max-1] = Database->Page[Cpage].lists[SelectedItem].Font;
                    URV_colour[UR_Max-1] = Database->Page[Cpage].lists[SelectedItem].Colour;
                    for ( i = 0 ; i < Database->Page[Cpage].lists[SelectedItem].L.GetCount() ; i++ )
                    {
                        if ( i != 0 )
                            URV_string[UR_Max-1] += _T("\n");
                        URV_string[UR_Max-1] += Database->Page[Cpage].lists[SelectedItem].L.Item(i);
                    }

                    UR_IndexCorrection = SelectedItem;
                    break;
            }
            break;
        case 3:
            UR_Tool[UR_Max-1] = 3;

            switch(URAct){
                case 0:
                    URV_int1[UR_Max-1] = UR_int1T;
                    break;
                case 1:
                    URV_int1[UR_Max-1] = UR_int1T;
                    URV_int2[UR_Max-1] = UR_int2T;
                    break;
                case 2:
                    URV_int1[UR_Max-1] = UR_int1T;
                    break;
                case 3:
                    i = 0;
                    while ( Database->Page[Cpage].ImageOrder[i] != SelectedItem )
                        i++;
                    URV_int1[UR_Max-1] = i;
                    break;
                case 4:
                    i = 0;
                    while ( Database->Page[Cpage].ImageOrder[i] != SelectedItem )
                        i++;
                    URV_int1[UR_Max-1] = i;
                    break;
                case 5:
                    URV_int1[UR_Max-1] = Database->Page[Cpage].images[SelectedItem].X;
                    URV_int2[UR_Max-1] = Database->Page[Cpage].images[SelectedItem].Y;
                    URV_string[UR_Max-1] = Database->Page[Cpage].images[SelectedItem].Path;
                    break;
                case 6:
                    URV_int1[UR_Max-1] = Database->Page[Cpage].images[SelectedItem].X;
                    URV_int2[UR_Max-1] = Database->Page[Cpage].images[SelectedItem].Y;
                    URV_int3[UR_Max-1] = Database->Page[Cpage].images[SelectedItem].Scale;
                    URV_int4[UR_Max-1] = Database->Page[Cpage].images[SelectedItem].Rotate;
                    i = 0;
                    while ( Database->Page[Cpage].ImageOrder[i] != SelectedItem )
                        i++;
                    URV_int5[UR_Max-1] = i;
                    URV_string[UR_Max-1] = Database->Page[Cpage].images[SelectedItem].Path;

                    UR_IndexCorrection = SelectedItem;
                    break;
                case 7:
                    URV_int1[UR_Max-1] = Database->Page[Cpage].images[SelectedItem].X;
                    URV_int2[UR_Max-1] = Database->Page[Cpage].images[SelectedItem].Y;
                    URV_int3[UR_Max-1] = Database->Page[Cpage].images[SelectedItem].Scale;
                    break;
            }
            break;
    }

}

void DiscWrapperFrame::OnUndo(wxCommandEvent& event)    // Undo
{
    MenuItem12->Enable(true);

    int j, g, TempID, Cpage = GetCurrentPage();
    wxString Stemp = wxEmptyString;

    if ( UR_Current == 2 )
        MenuItem11->Enable(false);

    UR_Current -= 2;

    j = UR_Page[UR_Current];
    if ( j == 3 )
        j = Notebook1->GetPageCount()-1;
    if ( Notebook1->GetSelection() != j )
        Notebook1->SetSelection(j);

    switch(UR_Tool[UR_Current]){
        case 1:
            SetTextTool();
            SelectedItem = UR_Id[UR_Current];
            switch(UR_Act[UR_Current]){
                case 0:
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].L = URV_string[UR_Current];
                    if ( Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Class != 0 )
                    {
                        int Mpage, MItem;
                        for ( Mpage = 0 ; Mpage < 4 ; Mpage++ )
                            for ( MItem = 0 ; MItem < Database->Page[Mpage].labels.GetCount() ; MItem++ )
                                if ( Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Class == Database->Page[Mpage].labels[MItem].Class )
                                    Database->Page[Mpage].labels[MItem].L = Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].L;
                    }
                    break;
                case 1:
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].X = URV_int1[UR_Current];
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Y = URV_int2[UR_Current];
                    break;
                case 2:
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Class = URV_int1[UR_Current];
                    Choice1->SetSelection(URV_int1[UR_Current]);
                    break;
                case 3:
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Angle = URV_int1[UR_Current];
                    break;
                case 4:
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Align = URV_int1[UR_Current];
                    break;
                case 5:
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Font = URV_font[UR_Current];
                    break;
                case 6:
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Colour = URV_colour[UR_Current];
                    break;
                case 7:
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Bend = URV_int1[UR_Current];
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Angle = URV_int2[UR_Current];
                    ToggleButton1->SetValue(URV_int1[UR_Current]);
                    break;
                case 8:
                    DeleteLabel();
                    FixRedoIndex(UR_Id[UR_Current]);
                    break;
                case 9:
                    NewPlace = wxPoint(URV_int1[UR_Current], URV_int2[UR_Current]);
                    CreateLabel();
                    Database->Page[UR_Page[UR_Current]].labels[SelectedItem].L = URV_string[UR_Current];
                    Database->Page[UR_Page[UR_Current]].labels[SelectedItem].Class = URV_int3[UR_Current];
                    Choice1->SetSelection(URV_int3[UR_Current]);
                    Database->Page[UR_Page[UR_Current]].labels[SelectedItem].Angle = URV_int4[UR_Current];
                    Database->Page[UR_Page[UR_Current]].labels[SelectedItem].Align = URV_int5[UR_Current];
                    Database->Page[UR_Page[UR_Current]].labels[SelectedItem].Bend = URV_int6[UR_Current];
                    Database->Page[UR_Page[UR_Current]].labels[SelectedItem].Font = URV_font[UR_Current];
                    Database->Page[UR_Page[UR_Current]].labels[SelectedItem].Colour = URV_colour[UR_Current];

                    TempID = UR_Id[UR_Current];

                    for ( g = 0 ; g < UR_Max ; g += 2 )
                    {
                        if ( (UR_Id[g] == TempID) and (UR_Tool[g] == 1) )
                        {
                            wxString PageText;
                            switch(UR_Page[g]){
                                case 0:
                                    PageText = _("Front");
                                    break;
                                case 1:
                                    PageText = _("Inside");
                                    break;
                                case 2:
                                    PageText = _("Back");
                                    break;
                                case 3:
                                    PageText = _("Disc");
                                    break;
                            }
                            if ( Notebook1->GetPageText(Notebook1->GetSelection()) == PageText )   // Find selected pattern
                            {
                                UR_Id[g] = UR_Id[g+1] = SelectedItem;
                            }
                        }
                    }
                    break;
            }
            break;
        case 2:
            SetListTool();
            SelectedItem = UR_Id[UR_Current];
            switch(UR_Act[UR_Current]){
                case 0:
                    // Unused
                    break;
                case 1:
                    Database->Page[UR_Page[UR_Current]].lists[UR_Id[UR_Current]].X = URV_int1[UR_Current];
                    Database->Page[UR_Page[UR_Current]].lists[UR_Id[UR_Current]].Y = URV_int2[UR_Current];
                    break;
                case 2:
                    Database->Page[UR_Page[UR_Current]].lists[UR_Id[UR_Current]].L.Empty();
                    Stemp = wxEmptyString;
                    for ( j = 0 ; j < URV_string[UR_Current].Len() ; j++ )
                    {
                        if ( URV_string[UR_Current][j] == '\n' )
                        {
                            Database->Page[UR_Page[UR_Current]].lists[UR_Id[UR_Current]].L.Add(Stemp);
                            Stemp = wxEmptyString;
                        }
                        else
                            Stemp += URV_string[UR_Current][j];
                    }
                    Database->Page[UR_Page[UR_Current]].lists[UR_Id[UR_Current]].L.Add(Stemp);
                    break;
                case 3:
                    Database->Page[UR_Page[UR_Current]].lists[UR_Id[UR_Current]].Font = URV_font[UR_Current];
                    break;
                case 4:
                    Database->Page[UR_Page[UR_Current]].lists[UR_Id[UR_Current]].Colour = URV_colour[UR_Current];
                    break;
                case 5:
                    DeleteList();
                    FixRedoIndex(UR_Id[UR_Current]);
                    break;
                case 6:
                    NewPlace = wxPoint(URV_int1[UR_Current], URV_int2[UR_Current]);
                    CreateList(3, URV_string[UR_Current]);

                    Stemp = wxEmptyString;
                    Database->Page[UR_Page[UR_Current]].lists[SelectedItem].Font = URV_font[UR_Current];
                    Database->Page[UR_Page[UR_Current]].lists[SelectedItem].Colour = URV_colour[UR_Current];


                    TempID = UR_Id[UR_Current];

                    for ( g = 0 ; g < UR_Max ; g += 2 )
                    {
                        if ( (UR_Id[g] == TempID) and (UR_Tool[g] == 2) )
                        {
                            wxString PageText;
                            switch(UR_Page[g]){
                                case 0:
                                    PageText = _("Front");
                                    break;
                                case 1:
                                    PageText = _("Inside");
                                    break;
                                case 2:
                                    PageText = _("Back");
                                    break;
                                case 3:
                                    PageText = _("Disc");
                                    break;
                            }
                            if ( Notebook1->GetPageText(Notebook1->GetSelection()) == PageText )   // Find selected pattern
                            {
                                UR_Id[g] = UR_Id[g+1] = SelectedItem;
                            }
                        }
                    }
                    break;
            }
            break;
        case 3:
            SetImageTool();
            switch(UR_Act[UR_Current]){
                case 0:
                    Database->Page[UR_Page[UR_Current]].images[UR_Id[UR_Current]].Scale = URV_int1[UR_Current];
                    break;
                case 1:
                    Database->Page[UR_Page[UR_Current]].images[UR_Id[UR_Current]].X = URV_int1[UR_Current];
                    Database->Page[UR_Page[UR_Current]].images[UR_Id[UR_Current]].Y = URV_int2[UR_Current];
                    break;
                case 2:
                    Database->Page[UR_Page[UR_Current]].images[UR_Id[UR_Current]].Rotate = URV_int1[UR_Current];
                    break;
                case 3:
                    j = Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]);
                    Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]) = Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]+1);
                    Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]+1) = j;
                    SelectedItem = Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]);

                    BitmapButton6->Enable();
                    BitmapButton7->Enable();

                    if ( Database->Page[Cpage].ImageOrder[0] == SelectedItem )
                        BitmapButton7->Disable();
                    break;
                case 4:
                    j = Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]);
                    Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]) = Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]-1);
                    Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]-1) = j;
                    SelectedItem = Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]);

                    BitmapButton6->Enable();
                    BitmapButton7->Enable();

                    if ( Database->Page[Cpage].ImageOrder[Database->Page[Cpage].images.GetCount()-1] == SelectedItem )
                        BitmapButton6->Disable();
                    break;
                case 5:
                    SelectedItem = UR_Id[UR_Current];
                    DeleteImage();
                    FixRedoIndex(UR_Id[UR_Current]);
                    break;
                case 6:
                    NewPlace = wxPoint(URV_int1[UR_Current], URV_int2[UR_Current]);
                    On_IMAGE(URV_string[UR_Current]);
                    Database->Page[UR_Page[UR_Current]].images[SelectedItem].Scale = URV_int3[UR_Current];
                    Database->Page[UR_Page[UR_Current]].images[SelectedItem].Rotate = URV_int4[UR_Current];
                    Database->Page[UR_Page[UR_Current]].ImageOrder.Insert(SelectedItem, URV_int5[UR_Current]);
                    Database->Page[UR_Page[UR_Current]].ImageOrder.RemoveAt(Database->Page[UR_Page[UR_Current]].ImageOrder.GetCount()-1);

                    TempID = UR_Id[UR_Current];

                    for ( g = 0 ; g < UR_Max ; g += 2 )
                    {
                        if ( (UR_Id[g] == TempID) and (UR_Tool[g] == 3) )
                        {
                            wxString PageText;
                            switch(UR_Page[g]){
                                case 0:
                                    PageText = _("Front");
                                    break;
                                case 1:
                                    PageText = _("Inside");
                                    break;
                                case 2:
                                    PageText = _("Back");
                                    break;
                                case 3:
                                    PageText = _("Disc");
                                    break;
                            }
                            if ( Notebook1->GetPageText(Notebook1->GetSelection()) == PageText )   // Find selected pattern
                            {
                                UR_Id[g] = UR_Id[g+1] = SelectedItem;
                            }
                        }
                    }
                    break;
                case 7:
                    Database->Page[UR_Page[UR_Current]].images[UR_Id[UR_Current]].X = URV_int1[UR_Current];
                    Database->Page[UR_Page[UR_Current]].images[UR_Id[UR_Current]].Y = URV_int2[UR_Current];
                    Database->Page[UR_Page[UR_Current]].images[UR_Id[UR_Current]].Scale = URV_int3[UR_Current];
                    break;
            }
            break;
    }


    UpdPview = true;
    RDO();
}

void DiscWrapperFrame::OnRedo(wxCommandEvent& event)    // Redo
{
    MenuItem11->Enable(true);

    if ( UR_Current == UR_Max-2 )
        MenuItem12->Enable(false);

    wxString Stemp = wxEmptyString;
    int g, j, TempID, Cpage = GetCurrentPage();

    UR_Current++;

    j = UR_Page[UR_Current];
    if ( j == 3 )
        j = Notebook1->GetPageCount()-1;
    if ( Notebook1->GetSelection() != j )
        Notebook1->SetSelection(j);

    switch(UR_Tool[UR_Current]){
        case 1:
            SetTextTool();
            SelectedItem = UR_Id[UR_Current];
            switch(UR_Act[UR_Current]){
                case 0:
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].L = URV_string[UR_Current];
                    if ( Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Class != 0 )
                    {
                        int Mpage, MItem;
                        for ( Mpage = 0 ; Mpage < 4 ; Mpage++ )
                            for ( MItem = 0 ; MItem < Database->Page[Mpage].labels.GetCount() ; MItem++ )
                                if ( Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Class == Database->Page[Mpage].labels[MItem].Class )
                                    Database->Page[Mpage].labels[MItem].L = Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].L;
                    }
                    break;
                case 1:
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].X = URV_int1[UR_Current];
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Y = URV_int2[UR_Current];
                    break;
                case 2:
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Class = URV_int1[UR_Current];
                    Choice1->SetSelection(URV_int1[UR_Current]);
                    break;
                case 3:
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Angle = URV_int1[UR_Current];
                    break;
                case 4:
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Align = URV_int1[UR_Current];
                    break;
                case 5:
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Font = URV_font[UR_Current];
                    break;
                case 6:
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Colour = URV_colour[UR_Current];
                    break;
                case 7:
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Bend = URV_int1[UR_Current];
                    Database->Page[UR_Page[UR_Current]].labels[UR_Id[UR_Current]].Angle = URV_int2[UR_Current];
                    break;
                case 8:
                    NewPlace = wxPoint(URV_int1[UR_Current], URV_int2[UR_Current]);
                    CreateLabel();

                    TempID = UR_Id[UR_Current];

                    for ( g = 0 ; g < UR_Max ; g += 2 )
                    {
                        if ( (UR_Id[g] == TempID) and (UR_Tool[g] == 1) )
                        {
                            wxString PageText;
                            switch(UR_Page[g]){
                                case 0:
                                    PageText = _("Front");
                                    break;
                                case 1:
                                    PageText = _("Inside");
                                    break;
                                case 2:
                                    PageText = _("Back");
                                    break;
                                case 3:
                                    PageText = _("Disc");
                                    break;
                            }
                            if ( Notebook1->GetPageText(Notebook1->GetSelection()) == PageText )   // Find selected pattern
                            {
                                UR_Id[g] = UR_Id[g+1] = SelectedItem;
                            }
                        }
                    }
                    break;
                case 9:
                    DeleteLabel();
                    FixRedoIndex(UR_Id[UR_Current]);
                    break;
            }
            break;
        case 2:
            SetListTool();
            SelectedItem = UR_Id[UR_Current];
            switch(UR_Act[UR_Current]){
                case 0:
                    //Unused
                    break;
                case 1:
                    Database->Page[UR_Page[UR_Current]].lists[UR_Id[UR_Current]].X = URV_int1[UR_Current];
                    Database->Page[UR_Page[UR_Current]].lists[UR_Id[UR_Current]].Y = URV_int2[UR_Current];
                    break;
                case 2:
                    Database->Page[UR_Page[UR_Current]].lists[UR_Id[UR_Current]].L.Empty();
                    Stemp = wxEmptyString;
                    for ( j = 0 ; j < URV_string[UR_Current].Len() ; j++ )
                    {
                        if ( URV_string[UR_Current][j] == '\n' )
                        {
                            Database->Page[UR_Page[UR_Current]].lists[UR_Id[UR_Current]].L.Add(Stemp);
                            Stemp = wxEmptyString;
                        }
                        else
                            Stemp += URV_string[UR_Current][j];
                    }
                    Database->Page[UR_Page[UR_Current]].lists[UR_Id[UR_Current]].L.Add(Stemp);
                    break;
                case 3:
                    Database->Page[UR_Page[UR_Current]].lists[UR_Id[UR_Current]].Font = URV_font[UR_Current];
                    break;
                case 4:
                    Database->Page[UR_Page[UR_Current]].lists[UR_Id[UR_Current]].Colour = URV_colour[UR_Current];
                    break;
                case 5:
                    NewPlace = wxPoint(URV_int1[UR_Current], URV_int2[UR_Current]);
                    CreateList(3, URV_string[UR_Current]);

                    TempID = UR_Id[UR_Current];

                    for ( g = 0 ; g < UR_Max ; g += 2 )
                    {
                        if ( (UR_Id[g] == TempID) and (UR_Tool[g] == 2) )
                        {
                            wxString PageText;
                            switch(UR_Page[g]){
                                case 0:
                                    PageText = _("Front");
                                    break;
                                case 1:
                                    PageText = _("Inside");
                                    break;
                                case 2:
                                    PageText = _("Back");
                                    break;
                                case 3:
                                    PageText = _("Disc");
                                    break;
                            }
                            if ( Notebook1->GetPageText(Notebook1->GetSelection()) == PageText )   // Find selected pattern
                            {
                                UR_Id[g] = UR_Id[g+1] = SelectedItem;
                            }
                        }
                    }
                    break;
                case 6:
                    DeleteList();
                    FixRedoIndex(UR_Id[UR_Current]);
                    break;
            }
            break;
        case 3:
            SetImageTool();
            switch(UR_Act[UR_Current]){
                case 0:
                    Database->Page[UR_Page[UR_Current]].images[UR_Id[UR_Current]].Scale = URV_int1[UR_Current];
                    break;
                case 1:
                    Database->Page[UR_Page[UR_Current]].images[UR_Id[UR_Current]].X = URV_int1[UR_Current];
                    Database->Page[UR_Page[UR_Current]].images[UR_Id[UR_Current]].Y = URV_int2[UR_Current];
                    break;
                case 2:
                    Database->Page[UR_Page[UR_Current]].images[UR_Id[UR_Current]].Rotate = URV_int1[UR_Current];
                    break;
                case 3:
                    j = Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]-1);
                    Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]-1) = Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]);
                    Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]) = j;
                    SelectedItem = Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]);

                    BitmapButton6->Enable();
                    BitmapButton7->Enable();

                    if ( Database->Page[Cpage].ImageOrder[Database->Page[Cpage].images.GetCount()-1] == SelectedItem )
                        BitmapButton6->Disable();
                    break;
                case 4:
                    j = Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]+1);
                    Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]+1) = Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]);
                    Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]) = j;
                    SelectedItem = Database->Page[Cpage].ImageOrder.Item(URV_int1[UR_Current]);

                    BitmapButton6->Enable();
                    BitmapButton7->Enable();

                    if ( Database->Page[Cpage].ImageOrder[0] == SelectedItem )
                        BitmapButton7->Disable();
                    break;
                case 5:
                    NewPlace = wxPoint(URV_int1[UR_Current], URV_int2[UR_Current]);
                    On_IMAGE(URV_string[UR_Current]);

                    TempID = UR_Id[UR_Current];

                    for ( g = 0 ; g < UR_Max ; g += 2 )
                    {
                        if ( (UR_Id[g] == TempID) and (UR_Tool[g] == 3) )
                        {
                            wxString PageText;
                            switch(UR_Page[g]){
                                case 0:
                                    PageText = _("Front");
                                    break;
                                case 1:
                                    PageText = _("Inside");
                                    break;
                                case 2:
                                    PageText = _("Back");
                                    break;
                                case 3:
                                    PageText = _("Disc");
                                    break;
                            }
                            if ( Notebook1->GetPageText(Notebook1->GetSelection()) == PageText )   // Find selected pattern
                            {
                                UR_Id[g] = UR_Id[g+1] = SelectedItem;
                            }
                        }
                    }
                    break;
                case 6:
                    SelectedItem = UR_Id[UR_Current];
                    DeleteImage();
                    FixRedoIndex(UR_Id[UR_Current]);
                    break;
                case 7:
                    Database->Page[UR_Page[UR_Current]].images[UR_Id[UR_Current]].X = URV_int1[UR_Current];
                    Database->Page[UR_Page[UR_Current]].images[UR_Id[UR_Current]].Y = URV_int2[UR_Current];
                    Database->Page[UR_Page[UR_Current]].images[UR_Id[UR_Current]].Scale = URV_int3[UR_Current];
                    break;
            }
            break;
    }

    UpdPview = true;
    RDO();
    UR_Current++;
}

void DiscWrapperFrame::Clear_Tool_history()     // Set Undo/Redo to default state
{
    MenuItem11->Enable(false);
    MenuItem12->Enable(false);

    if (UR_Max != 0)
    {
        delete[] UR_Page;
        delete[] UR_Tool;
        delete[] UR_Id;
        delete[] UR_Act;
        delete[] URV_string;
        delete[] URV_int1;
        delete[] URV_int2;
        delete[] URV_int3;
        delete[] URV_int4;
        delete[] URV_int5;
        delete[] URV_int6;
        delete[] URV_font;
        delete[] URV_colour;
    }

    UR_Max = UR_Current = 0;
    UR_Drag = false;
}

void DiscWrapperFrame::FixRedoIndex(int IndexCorrection)
{
    int j, g, MaxOfItem, Cpage = GetCurrentPage();
    UR_WrongIndex--;

    if ( ActiveTool == 1 )
        MaxOfItem = Database->Page[Cpage].labels.GetCount();
    else if ( ActiveTool == 2 )
        MaxOfItem = Database->Page[Cpage].lists.GetCount();
    else
        MaxOfItem = Database->Page[Cpage].images.GetCount();


    for ( g = 0 ; g < UR_Max ; g += 2 )
    {
        if ( (UR_Id[g] == IndexCorrection) and (UR_Tool[g] == ActiveTool) )
        {
            wxString PageText;
            switch(UR_Page[g]){
                case 0:
                    PageText = _("Front");
                    break;
                case 1:
                    PageText = _("Inside");
                    break;
                case 2:
                    PageText = _("Back");
                    break;
                case 3:
                    PageText = _("Disc");
                    break;
            }
            if ( Notebook1->GetPageText(Notebook1->GetSelection()) == PageText )   // Find selected pattern
            {
                UR_Id[g] = UR_Id[g+1] = UR_WrongIndex;
            }
        }
    }


    if ( !( MaxOfItem < IndexCorrection ) )
    {
        for ( j = IndexCorrection + 1 ; j <= MaxOfItem ; j++ )
        {
            for ( g = 0 ; g < UR_Max ; g += 2 )
            {
                if ( (UR_Id[g] == j) and (UR_Tool[g] == ActiveTool) )
                {
                    wxString PageText;
                    switch(UR_Page[g]){
                        case 0:
                            PageText = _("Front");
                            break;
                        case 1:
                            PageText = _("Inside");
                            break;
                        case 2:
                            PageText = _("Back");
                            break;
                        case 3:
                            PageText = _("Disc");
                            break;
                    }
                    if ( Notebook1->GetPageText(Notebook1->GetSelection()) == PageText )   // Find selected pattern
                    {
                        UR_Id[g]--;
                        UR_Id[g+1]--;
                    }
                }
            }
        }
    }
}
