/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#include "DiscWrapperMain.h"
#include "EditListDialog.h"


void DiscWrapperFrame::OnLeftDown(wxMouseEvent& event)      // Mouse left click: Selecting item
{
    if ( TextCtrl->IsShown() )
        TextCtrlLoseFocus();

    int i, j, SameClick = 0;
    AlreadyS = 0;
    LastCatched = false;

    int Cpage = GetCurrentPage();

    wxPaintDC dc(GetCurrentPanel());

    float maxX = GetBackWidth(Cpage);   // Get the width and the height of the current pattern
    float maxY = GetBackHeight(Cpage);
    float marginX = 50;     // Set margins
    float marginY = 50;
    maxX += (2*marginX);    // Add margins to resolution
    maxY += (2*marginY);
    maxX = maxX * CurrentZoom;
    maxY = maxY * CurrentZoom;
    int w2, h2;
    dc.GetSize(&w2, &h2);     // Get the width and height of the selected panel

    float scaleX=(float)(w2/maxX);   // Calculate and set scale
    float scaleY=(float)(h2/maxY);
    float actualScale = wxMin(scaleX,scaleY);
    float posX = (float)((w2 - (GetBackWidth(Cpage)*actualScale))/2.0);
    float posY = (float)((h2 - (GetBackHeight(Cpage)*actualScale))/2.0);
    dc.SetUserScale(actualScale, actualScale);

    if ( FitDC == true )
    {
        PositionX = posX;
        PositionY = posY;
    }

    dc.SetDeviceOrigin( (long)PositionX, (long)PositionY );   // Prepare DC
    dc.SetBackground(*wxWHITE_BRUSH);
    dc.SetBackgroundMode(wxTRANSPARENT);

    wxPoint p, Firstp;
    Firstp = event.GetPosition();
    DCdragStartPos = Firstp;
    Firstp = event.GetLogicalPosition(dc);
    dragStartPos = Firstp;
    DcDragX = PositionX;
    DcDragY = PositionY;

    if ( Firstp == PrevCoord )
        Behind++;
    else
    {
        PrevCoord = Firstp;
        Behind = 0;
    }

    if ( SelectedItem != -1 )
    {
        if ( (ActiveTool == 1) )
        {
            dc.SetFont(Database->Page[Cpage].labels[SelectedItem].Font.GetChosenFont());           // Apply Font and Color then draw text with the chosen coordinates and angle
            dc.SetTextForeground(Database->Page[Cpage].labels[SelectedItem].Colour.GetColour());
            wxFont Xfont = Database->Page[Cpage].labels[SelectedItem].Font.GetChosenFont();
            wxCoord wi, he, xc = NULL;
            dc.GetMultiLineTextExtent(Database->Page[Cpage].labels[SelectedItem].L, & wi, & he, &xc, &Xfont);
            if ( wi == 0 )
                wi = he = 100;


            UR_int1T = Database->Page[Cpage].labels[SelectedItem].Angle;

            if ( Database->Page[Cpage].labels[SelectedItem].Angle == 0 )
            {
                if ( Database->Page[Cpage].labels[SelectedItem].Align == 0 )
                {
                    if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+12 ) )
                    {
                        AlreadyS = 10;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X+wi-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+wi+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+12 ) )
                    {
                        AlreadyS = 9;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X+wi-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+wi+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+he-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+he+12 ) )
                    {
                        AlreadyS = 9;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+he-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+he+12 ) )
                    {
                        AlreadyS = 10;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                }
                else if ( Database->Page[Cpage].labels[SelectedItem].Align == 1 )
                {
                    if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-(wi/2)-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X-(wi/2)+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+12 ) )
                    {
                        AlreadyS = 10;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X+(wi/2)-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+(wi/2)+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+12 ) )
                    {
                        AlreadyS = 9;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X+(wi/2)-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+(wi/2)+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+he-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+he+12 ) )
                    {
                        AlreadyS = 9;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-(wi/2)-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X-(wi/2)+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+he-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+he+12 ) )
                    {
                        AlreadyS = 10;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                }
                else if ( Database->Page[Cpage].labels[SelectedItem].Align == 2 )
                {
                    if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-wi-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X-wi+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+12 ) )
                    {
                        AlreadyS = 10;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+12 ) )
                    {
                        AlreadyS = 9;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+he-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+he+12 ) )
                    {
                        AlreadyS = 9;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-wi-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X-wi+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+he-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+he+12 ) )
                    {
                        AlreadyS = 10;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                }
            }
            else
            {
                if ( he > wi )
                    wi = he;

                if ( Database->Page[Cpage].labels[SelectedItem].Align != 1 )
                {
                    if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-wi-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X-wi+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-wi-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y-wi+12 ) )
                    {
                        AlreadyS = 10;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X+wi-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+wi+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-wi-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y-wi+12 ) )
                    {
                        AlreadyS = 9;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X+wi-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+wi+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+wi-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+wi+12 ) )
                    {
                        AlreadyS = 9;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-wi-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X-wi+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+wi-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+wi+12 ) )
                    {
                        AlreadyS = 10;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                }
                else if ( Database->Page[Cpage].labels[SelectedItem].Align == 1 )
                {
                    if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-(wi/2)-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X-(wi/2)+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-(wi/2)-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y-(wi/2)+12 ) )
                    {
                        AlreadyS = 10;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X+(wi/2)-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+(wi/2)+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-(wi/2)-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y-(wi/2)+12 ) )
                    {
                        AlreadyS = 9;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X+(wi/2)-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+(wi/2)+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+(wi/2)-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+(wi/2)+12 ) )
                    {
                        AlreadyS = 9;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-(wi/2)-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X-(wi/2)+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+(wi/2)-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+(wi/2)+12 ) )
                    {
                        AlreadyS = 10;
                        LastCatched = true;
                        RotateHelper = Database->Page[Cpage].labels[SelectedItem].Angle;
                    }
                }
            }

        }
        else if ( (ActiveTool == 2) )
        {
            int he = 0;
            dc.SetFont(Database->Page[Cpage].lists[SelectedItem].Font.GetChosenFont());
            dc.SetTextForeground(Database->Page[Cpage].lists[SelectedItem].Colour.GetColour());

            long Col = -1, *columns;
            wxString TempString = wxEmptyString;

            int g = 0;
            j = 0;
            while ( j < Database->Page[Cpage].lists[SelectedItem].L.Item(0).Len() )
            {
                if ( Database->Page[Cpage].lists[SelectedItem].L.Item(0)[j] != ';' )
                {
                    TempString += Database->Page[Cpage].lists[SelectedItem].L.Item(0)[j];
                    j++;
                }
                else if ( Col == -1 )
                {
                    TempString.ToLong(&Col);
                    TempString = wxEmptyString;
                    columns = new long[Col];
                    j++;
                }
                else
                {
                    TempString.ToLong(&columns[g++]);
                    TempString = wxEmptyString;
                    j++;
                }
            }

            he = ((Database->Page[Cpage].lists[SelectedItem].L.GetCount()-1)*Database->Page[Cpage].lists[SelectedItem].Font.GetChosenFont().GetPointSize()*1.5);

            g = Database->Page[Cpage].lists[SelectedItem].X;

            for ( j = -1 ; j < Col ; j++ )
            {
                if ( j != -1 )
                    g = g + columns[j];
                if ( ( Firstp.x > g-10 ) and ( Firstp.x < g+10 ) and ( Firstp.y > Database->Page[Cpage].lists[SelectedItem].Y ) and ( Firstp.y < Database->Page[Cpage].lists[SelectedItem].Y+he ) )
                {
                    DragX = Database->Page[Cpage].lists[SelectedItem].X;
                    DragY = Database->Page[Cpage].lists[SelectedItem].Y;

                    wxString wxSTemp = wxEmptyString;
                    int d;
                    for ( d = 0 ; d < Database->Page[Cpage].lists[SelectedItem].L.GetCount() ; d++ )
                    {
                        if ( d != 0 )
                            wxSTemp = wxSTemp + _T("\n");
                        wxSTemp = wxSTemp + Database->Page[Cpage].lists[SelectedItem].L.Item(d);
                    }
                    UR_stringT = wxSTemp;

                    if ( j == -1 )
                        AlreadyS = 14;
                    else
                        AlreadyS = 13;
                    LastCatched = true;
                    ListHelper = j;
                    j = Col;
                }
            }

            delete[] columns;
        }
        else
        {
            UR_int1T = Database->Page[Cpage].images[SelectedItem].Scale;
            UR_int2T = Database->Page[Cpage].images[SelectedItem].Rotate;

            int wi = Database->Page[Cpage].images[SelectedItem].Img.GetWidth()*Database->Page[Cpage].images[SelectedItem].Scale/100, he = Database->Page[Cpage].images[SelectedItem].Img.GetHeight()*Database->Page[Cpage].images[SelectedItem].Scale/100;
            ScaleCorrection = sqrt(pow(Firstp.x-Database->Page[Cpage].images[SelectedItem].X,2)+pow(Firstp.y-Database->Page[Cpage].images[SelectedItem].Y,2))/Database->Page[Cpage].images[SelectedItem].Scale;

            if ( (Database->Page[Cpage].images[SelectedItem].Rotate == 0) or (Database->Page[Cpage].images[SelectedItem].Rotate == 2) )
            {
                if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(wi/2))-12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(he/2))-12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+12 ) )
                {
                    AlreadyS = 1;
                    LastCatched = true;
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+wi-12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+wi+12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(he/2))-12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+12 ) )
                {
                    AlreadyS = 2;
                    LastCatched = true;
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+wi-12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+wi+12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+he-12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+he+12 ) )
                {
                    AlreadyS = 3;
                    LastCatched = true;
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(wi/2))-12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+he-12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+he+12 ) )
                {
                    AlreadyS = 4;
                    LastCatched = true;
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(wi/2))-36 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(wi/2))-12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(he/2))-36 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(he/2))-12 ) )
                {
                    AlreadyS = 6;
                    LastCatched = true;
                    RotateHelper = Database->Page[Cpage].images[SelectedItem].Rotate;
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+wi+12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+wi+36 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(he/2))-36 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(he/2))-12 ) )
                {
                    AlreadyS = 5;
                    LastCatched = true;
                    RotateHelper = Database->Page[Cpage].images[SelectedItem].Rotate;
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+wi+12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+wi+36 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+he+12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+he+36 ) )
                {
                    AlreadyS = 5;
                    LastCatched = true;
                    RotateHelper = Database->Page[Cpage].images[SelectedItem].Rotate;
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(wi/2))-36 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(wi/2))-12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+he+12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+he+36 ) )
                {
                    AlreadyS = 6;
                    LastCatched = true;
                    RotateHelper = Database->Page[Cpage].images[SelectedItem].Rotate;
                }
            }
            else if ( (Database->Page[Cpage].images[SelectedItem].Rotate == 1) or (Database->Page[Cpage].images[SelectedItem].Rotate == 3) )
            {
                if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(he/2))-12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(he/2))+12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))-12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+12 ) )
                {
                    AlreadyS = 1;
                    LastCatched = true;
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(he/2))+he-12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(he/2))+he+12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))-12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+12 ) )
                {
                    AlreadyS = 2;
                    LastCatched = true;
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(he/2))+he-12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(he/2))+he+12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+wi-12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+wi+12 ) )
                {
                    AlreadyS = 3;
                    LastCatched = true;
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(he/2))-12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(he/2))+12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+wi-12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+wi+12 ) )
                {
                    AlreadyS = 4;
                    LastCatched = true;
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(he/2))-36 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(he/2))-12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))-36 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))-12 ) )
                {
                    AlreadyS = 6;
                    LastCatched = true;
                    RotateHelper = Database->Page[Cpage].images[SelectedItem].Rotate;
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(he/2))+he+12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(he/2))+he+36 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))-36 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))-12 ) )
                {
                    AlreadyS = 5;
                    LastCatched = true;
                    RotateHelper = Database->Page[Cpage].images[SelectedItem].Rotate;
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(he/2))+he+12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(he/2))+he+36 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+wi+12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+wi+36 ) )
                {
                    AlreadyS = 5;
                    LastCatched = true;
                    RotateHelper = Database->Page[Cpage].images[SelectedItem].Rotate;
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(he/2))-36 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(he/2))-12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+wi+12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+wi+36 ) )
                {
                    AlreadyS = 6;
                    LastCatched = true;
                    RotateHelper = Database->Page[Cpage].images[SelectedItem].Rotate;
                }
            }
        }
    }

    if ( AlreadyS == 0 )
    {
        for ( i = Database->Page[Cpage].labels.GetCount()-1 ; i >= 0 ; i-- )
        {
            p = Firstp;
            dc.SetFont(Database->Page[Cpage].labels[i].Font.GetChosenFont());           // Apply Font and Color then draw text with the chosen coordinates and angle
            dc.SetTextForeground(Database->Page[Cpage].labels[i].Colour.GetColour());
            wxFont Xfont = Database->Page[Cpage].labels[i].Font.GetChosenFont();
            wxCoord w, h, xc = NULL;
            dc.GetMultiLineTextExtent(Database->Page[Cpage].labels[i].L, & w, & h, &xc, &Xfont);
            if ( w == 0 )
                w = h = 100 ;

            if ( Database->Page[Cpage].labels[i].Align == 0 )
                p.x = Firstp.x;
            else if ( Database->Page[Cpage].labels[i].Align == 1 )
                p.x = Firstp.x + (w/2);
            else if ( Database->Page[Cpage].labels[i].Align == 2 )
                p.x = Firstp.x + w;

           // wxMessageBox(wxString::Format(_("click: %i,%i\nstart: %i,%i\nPrev: %i,%i\nCurr: %i,%i\nBehind: %i\nSameCl: %i"), p.x, p.y, Database->Page[Cpage].labels[i].X, Database->Page[Cpage].labels[i].Y, PrevCoord.x, PrevCoord.y, p.x, p.y, Behind, SameClick), _("hy"));
            if ( Database->Page[Cpage].labels[i].Angle == 0 )
            {
                if ( ( p.x > Database->Page[Cpage].labels[i].X ) and ( p.x < Database->Page[Cpage].labels[i].X+w ) and ( p.y > Database->Page[Cpage].labels[i].Y ) and ( p.y < Database->Page[Cpage].labels[i].Y+h ) )
                {
                    if ( Behind == SameClick )
                    {
                        SetTextTool();
                        MenuItem10->Check();
                        SelectedItem = i;
                        LastCatched = true;
                        DragX = Database->Page[Cpage].labels[i].X;
                        DragY = Database->Page[Cpage].labels[i].Y;
                        RDO();
                        Choice1->SetSelection(Database->Page[Cpage].labels[i].Class);
                        ToggleButton1->SetValue(Database->Page[Cpage].labels[i].Bend);
                        return;
                    }
                    SameClick++;
                }
            }
            else
            {
                if ( ( Database->Page[Cpage].labels[i].Align == 0 ) and ( p.x > Database->Page[Cpage].labels[i].X-w ) and ( p.x < Database->Page[Cpage].labels[i].X+w ) and ( p.y > Database->Page[Cpage].labels[i].Y-w ) and ( p.y < Database->Page[Cpage].labels[i].Y+w ) )
                {
                    if ( Behind == SameClick )
                    {
                        SetTextTool();
                        MenuItem10->Check();
                        SelectedItem = i;
                        LastCatched = true;
                        DragX = Database->Page[Cpage].labels[i].X;
                        DragY = Database->Page[Cpage].labels[i].Y;
                        RDO();
                        Choice1->SetSelection(Database->Page[Cpage].labels[i].Class);
                        ToggleButton1->SetValue(Database->Page[Cpage].labels[i].Bend);
                        return;
                    }
                    SameClick++;
                }
                else if ( ( Database->Page[Cpage].labels[i].Align == 1 ) and ( p.x > Database->Page[Cpage].labels[i].X ) and ( p.x < Database->Page[Cpage].labels[i].X+w ) and ( p.y > Database->Page[Cpage].labels[i].Y-(w/2) ) and ( p.y < Database->Page[Cpage].labels[i].Y+(w/2) ) )
                {
                    if ( Behind == SameClick )
                    {
                        SetTextTool();
                        MenuItem10->Check();
                        SelectedItem = i;
                        LastCatched = true;
                        DragX = Database->Page[Cpage].labels[i].X;
                        DragY = Database->Page[Cpage].labels[i].Y;
                        RDO();
                        Choice1->SetSelection(Database->Page[Cpage].labels[i].Class);
                        ToggleButton1->SetValue(Database->Page[Cpage].labels[i].Bend);
                        return;
                    }
                    SameClick++;
                }
                else if ( ( Database->Page[Cpage].labels[i].Align == 2 ) and ( p.x > Database->Page[Cpage].labels[i].X ) and ( p.x < Database->Page[Cpage].labels[i].X+2*w ) and ( p.y > Database->Page[Cpage].labels[i].Y-w ) and ( p.y < Database->Page[Cpage].labels[i].Y+w ) )
                {
                    if ( Behind == SameClick )
                    {
                        SetTextTool();
                        MenuItem10->Check();
                        SelectedItem = i;
                        LastCatched = true;
                        DragX = Database->Page[Cpage].labels[i].X;
                        DragY = Database->Page[Cpage].labels[i].Y;
                        RDO();
                        Choice1->SetSelection(Database->Page[Cpage].labels[i].Class);
                        ToggleButton1->SetValue(Database->Page[Cpage].labels[i].Bend);
                        return;
                    }
                    SameClick++;
                }
            }
        }

        for ( i = Database->Page[Cpage].lists.GetCount()-1 ; i >= 0 ; i-- )
        {
            int h = 0, w = 0;
            dc.SetFont(Database->Page[Cpage].lists[i].Font.GetChosenFont());
            dc.SetTextForeground(Database->Page[Cpage].lists[i].Colour.GetColour());

            long Col = -1, *columns;
            wxString TempString = wxEmptyString;

            int g = 0;
            j = 0;
            while ( j < Database->Page[Cpage].lists[i].L.Item(0).Len() )
            {
                if ( Database->Page[Cpage].lists[i].L.Item(0)[j] != ';' )
                {
                    TempString += Database->Page[Cpage].lists[i].L.Item(0)[j];
                    j++;
                }
                else if ( Col == -1 )
                {
                    TempString.ToLong(&Col);
                    TempString = wxEmptyString;
                    columns = new long[Col];
                    j++;
                }
                else
                {
                    TempString.ToLong(&columns[g++]);
                    w += columns[g-1];
                    TempString = wxEmptyString;
                    j++;
                }
            }
            delete[] columns;

            h = ((Database->Page[Cpage].lists[i].L.GetCount()-1)*Database->Page[Cpage].lists[i].Font.GetChosenFont().GetPointSize()*1.5);
            if ( ( Firstp.x > Database->Page[Cpage].lists[i].X ) and ( Firstp.x < Database->Page[Cpage].lists[i].X+w ) and ( Firstp.y > Database->Page[Cpage].lists[i].Y ) and ( Firstp.y < Database->Page[Cpage].lists[i].Y+h ) )
            {
                if ( Behind == SameClick )
                {
                    SetListTool();
                    MenuItem17->Check();
                    SelectedItem = i;
                    LastCatched = true;
                    DragX = Database->Page[Cpage].lists[i].X;
                    DragY = Database->Page[Cpage].lists[i].Y;
                    RDO();
                    return;
                }
                SameClick++;
            }
        }

        for ( i = Database->Page[Cpage].images.GetCount()-1 ; i >= 0 ; i-- )
        {
            int oi = Database->Page[Cpage].ImageOrder[i];
            int w = Database->Page[Cpage].images[oi].Img.GetWidth()*Database->Page[Cpage].images[oi].Scale/100, h = Database->Page[Cpage].images[oi].Img.GetHeight()*Database->Page[Cpage].images[oi].Scale/100;

            if ( ( Firstp.x > Database->Page[Cpage].images[oi].X-(w/2) ) and ( Firstp.x < Database->Page[Cpage].images[oi].X+(w/2) ) and ( Firstp.y > Database->Page[Cpage].images[oi].Y-(h/2) ) and ( Firstp.y < Database->Page[Cpage].images[oi].Y+(h/2) ) and ( (Database->Page[Cpage].images[oi].Rotate == 0) or (Database->Page[Cpage].images[oi].Rotate == 2) ) )
            {
                if ( Behind == SameClick )
                {
                    SetImageTool();
                    MenuItem18->Check();
                    SelectedItem = oi;
                    AbleTool(3, true);
                    LastCatched = true;
                    DragX = Database->Page[Cpage].images[oi].X;
                    DragY = Database->Page[Cpage].images[oi].Y;
                    RDO();
                    return;
                }
                SameClick++;
            }
            else if ( ( Firstp.x > Database->Page[Cpage].images[oi].X-(h/2) ) and ( Firstp.x < Database->Page[Cpage].images[oi].X-(h/2)+h ) and ( Firstp.y > Database->Page[Cpage].images[oi].Y-(w/2) ) and ( Firstp.y < Database->Page[Cpage].images[oi].Y-(w/2)+w ) and ( (Database->Page[Cpage].images[oi].Rotate == 1) or (Database->Page[Cpage].images[oi].Rotate == 3) ) )
            {
                if ( Behind == SameClick )
                {
                    SetImageTool();
                    MenuItem18->Check();
                    SelectedItem = oi;
                    AbleTool(3, true);
                    LastCatched = true;
                    DragX = Database->Page[Cpage].images[oi].X;
                    DragY = Database->Page[Cpage].images[oi].Y;
                    RDO();
                    return;
                }
                SameClick++;
            }
        }

    }

}

void DiscWrapperFrame::OnDragging(wxMouseEvent& event)      // Mouse moving: Placing item
{
    int Cpage = GetCurrentPage();

    wxPaintDC dc(GetCurrentPanel());

    float maxX = GetBackWidth(Cpage);   // Get the width and the height of the current pattern
    float maxY = GetBackHeight(Cpage);
    float marginX = 50;     // Set margins
    float marginY = 50;
    maxX += (2*marginX);    // Add margins to resolution
    maxY += (2*marginY);
    maxX = maxX * CurrentZoom;
    maxY = maxY * CurrentZoom;
    int w2, h2;
    dc.GetSize(&w2, &h2);     // Get the width and height of the selected panel

    float scaleX=(float)(w2/maxX);   // Calculate and set scale
    float scaleY=(float)(h2/maxY);
    float actualScale = wxMin(scaleX,scaleY);
    float posX = (float)((w2 - (GetBackWidth(Cpage)*actualScale))/2.0);
    float posY = (float)((h2 - (GetBackHeight(Cpage)*actualScale))/2.0);
    dc.SetUserScale(actualScale, actualScale);

    if ( FitDC == true )
    {
        PositionX = posX;
        PositionY = posY;
    }

    dc.SetDeviceOrigin( (long)PositionX, (long)PositionY );   // Prepare DC
    dc.SetBackground(*wxWHITE_BRUSH);
    dc.SetBackgroundMode(wxTRANSPARENT);

    if ( event.Moving() and ( SelectedItem != -1 ) )   // Cursor
    {
        if ( ActiveTool == 1 )
        {
            wxPoint Firstp;
            Firstp = event.GetLogicalPosition(dc);

            dc.SetFont(Database->Page[Cpage].labels[SelectedItem].Font.GetChosenFont());           // Apply Font and Color then draw text with the chosen coordinates and angle
            dc.SetTextForeground(Database->Page[Cpage].labels[SelectedItem].Colour.GetColour());
            wxFont Xfont = Database->Page[Cpage].labels[SelectedItem].Font.GetChosenFont();
            wxCoord wi, he, xc = NULL;
            dc.GetMultiLineTextExtent(Database->Page[Cpage].labels[SelectedItem].L, & wi, & he, &xc, &Xfont);
            if ( wi == 0 )
                wi = he = 100;

            if ( Database->Page[Cpage].labels[SelectedItem].Angle == 0 )
            {
                if ( Database->Page[Cpage].labels[SelectedItem].Align == 0 )
                {
                    if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+12 ) )
                    {
                        if ( CurrentCursor != _T("EScursor") )
                        {
                            CurrentCursor = _T("EScursor");
                            GetCurrentPanel()->SetCursor(EScursor);
                        }
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X+wi-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+wi+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+12 ) )
                    {
                        if ( CurrentCursor != _T("SWcursor") )
                        {
                            CurrentCursor = _T("SWcursor");
                            GetCurrentPanel()->SetCursor(SWcursor);
                        }
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X+wi-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+wi+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+he-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+he+12 ) )
                    {
                        if ( CurrentCursor != _T("WNcursor") )
                        {
                            CurrentCursor = _T("WNcursor");
                            GetCurrentPanel()->SetCursor(WNcursor);
                        }
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+he-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+he+12 ) )
                    {
                        if ( CurrentCursor != _T("NEcursor") )
                        {
                            CurrentCursor = _T("NEcursor");
                            GetCurrentPanel()->SetCursor(NEcursor);
                        }
                    }
                    else if ( CurrentCursor != _T("wxNullCursor") )
                    {
                        CurrentCursor = _T("wxNullCursor");
                        GetCurrentPanel()->SetCursor(wxNullCursor);
                    }
                }
                else if ( Database->Page[Cpage].labels[SelectedItem].Align == 1 )
                {
                    if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-(wi/2)-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X-(wi/2)+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+12 ) )
                    {
                        if ( CurrentCursor != _T("EScursor") )
                        {
                            CurrentCursor = _T("EScursor");
                            GetCurrentPanel()->SetCursor(EScursor);
                        }
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X+(wi/2)-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+(wi/2)+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+12 ) )
                    {
                        if ( CurrentCursor != _T("SWcursor") )
                        {
                            CurrentCursor = _T("SWcursor");
                            GetCurrentPanel()->SetCursor(SWcursor);
                        }
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X+(wi/2)-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+(wi/2)+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+he-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+he+12 ) )
                    {
                        if ( CurrentCursor != _T("WNcursor") )
                        {
                            CurrentCursor = _T("WNcursor");
                            GetCurrentPanel()->SetCursor(WNcursor);
                        }
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-(wi/2)-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X-(wi/2)+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+he-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+he+12 ) )
                    {
                        if ( CurrentCursor != _T("NEcursor") )
                        {
                            CurrentCursor = _T("NEcursor");
                            GetCurrentPanel()->SetCursor(NEcursor);
                        }
                    }
                    else if ( CurrentCursor != _T("wxNullCursor") )
                    {
                        CurrentCursor = _T("wxNullCursor");
                        GetCurrentPanel()->SetCursor(wxNullCursor);
                    }
                }
                else if ( Database->Page[Cpage].labels[SelectedItem].Align == 2 )
                {
                    if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-wi-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X-wi+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+12 ) )
                    {
                        if ( CurrentCursor != _T("EScursor") )
                        {
                            CurrentCursor = _T("EScursor");
                            GetCurrentPanel()->SetCursor(EScursor);
                        }
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+12 ) )
                    {
                        if ( CurrentCursor != _T("SWcursor") )
                        {
                            CurrentCursor = _T("SWcursor");
                            GetCurrentPanel()->SetCursor(SWcursor);
                        }
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+he-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+he+12 ) )
                    {
                        if ( CurrentCursor != _T("WNcursor") )
                        {
                            CurrentCursor = _T("WNcursor");
                            GetCurrentPanel()->SetCursor(WNcursor);
                        }
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-wi-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X-wi+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+he-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+he+12 ) )
                    {
                        if ( CurrentCursor != _T("NEcursor") )
                        {
                            CurrentCursor = _T("NEcursor");
                            GetCurrentPanel()->SetCursor(NEcursor);
                        }
                    }
                    else if ( CurrentCursor != _T("wxNullCursor") )
                    {
                        CurrentCursor = _T("wxNullCursor");
                        GetCurrentPanel()->SetCursor(wxNullCursor);
                    }
                }
            }
            else
            {
                if ( he > wi )
                    wi = he;

                if ( Database->Page[Cpage].labels[SelectedItem].Align != 1 )
                {
                    if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-wi-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X-wi+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-wi-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y-wi+12 ) )
                    {
                        if ( CurrentCursor != _T("EScursor") )
                        {
                            CurrentCursor = _T("EScursor");
                            GetCurrentPanel()->SetCursor(EScursor);
                        }
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X+wi-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+wi+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-wi-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y-wi+12 ) )
                    {
                        if ( CurrentCursor != _T("SWcursor") )
                        {
                            CurrentCursor = _T("SWcursor");
                            GetCurrentPanel()->SetCursor(SWcursor);
                        }
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X+wi-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+wi+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+wi-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+wi+12 ) )
                    {
                        if ( CurrentCursor != _T("WNcursor") )
                        {
                            CurrentCursor = _T("WNcursor");
                            GetCurrentPanel()->SetCursor(WNcursor);
                        }
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-wi-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X-wi+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+wi-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+wi+12 ) )
                    {
                        if ( CurrentCursor != _T("NEcursor") )
                        {
                            CurrentCursor = _T("NEcursor");
                            GetCurrentPanel()->SetCursor(NEcursor);
                        }
                    }
                    else if ( CurrentCursor != _T("wxNullCursor") )
                    {
                        CurrentCursor = _T("wxNullCursor");
                        GetCurrentPanel()->SetCursor(wxNullCursor);
                    }
                }
                else if ( Database->Page[Cpage].labels[SelectedItem].Align == 1 )
                {
                    if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-(wi/2)-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X-(wi/2)+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-(wi/2)-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y-(wi/2)+12 ) )
                    {
                        if ( CurrentCursor != _T("EScursor") )
                        {
                            CurrentCursor = _T("EScursor");
                            GetCurrentPanel()->SetCursor(EScursor);
                        }
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X+(wi/2)-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+(wi/2)+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y-(wi/2)-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y-(wi/2)+12 ) )
                    {
                        if ( CurrentCursor != _T("SWcursor") )
                        {
                            CurrentCursor = _T("SWcursor");
                            GetCurrentPanel()->SetCursor(SWcursor);
                        }
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X+(wi/2)-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X+(wi/2)+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+(wi/2)-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+(wi/2)+12 ) )
                    {
                        if ( CurrentCursor != _T("WNcursor") )
                        {
                            CurrentCursor = _T("WNcursor");
                            GetCurrentPanel()->SetCursor(WNcursor);
                        }
                    }
                    else if ( ( Firstp.x > Database->Page[Cpage].labels[SelectedItem].X-(wi/2)-12 ) and ( Firstp.x < Database->Page[Cpage].labels[SelectedItem].X-(wi/2)+12 ) and ( Firstp.y > Database->Page[Cpage].labels[SelectedItem].Y+(wi/2)-12 ) and ( Firstp.y < Database->Page[Cpage].labels[SelectedItem].Y+(wi/2)+12 ) )
                    {
                        if ( CurrentCursor != _T("NEcursor") )
                        {
                            CurrentCursor = _T("NEcursor");
                            GetCurrentPanel()->SetCursor(NEcursor);
                        }
                    }
                    else if ( CurrentCursor != _T("wxNullCursor") )
                    {
                        CurrentCursor = _T("wxNullCursor");
                        GetCurrentPanel()->SetCursor(wxNullCursor);
                    }
                }
            }

        }
        else if ( ActiveTool == 2 )
        {
            wxPoint Firstp;
            Firstp = event.GetLogicalPosition(dc);

            int he = 0;
            dc.SetFont(Database->Page[Cpage].lists[SelectedItem].Font.GetChosenFont());
            dc.SetTextForeground(Database->Page[Cpage].lists[SelectedItem].Colour.GetColour());

            long Col = -1, *columns;
            wxString TempString = wxEmptyString;

            int g = 0, j = 0;
            while ( j < Database->Page[Cpage].lists[SelectedItem].L.Item(0).Len() )
            {
                if ( Database->Page[Cpage].lists[SelectedItem].L.Item(0)[j] != ';' )
                {
                    TempString += Database->Page[Cpage].lists[SelectedItem].L.Item(0)[j];
                    j++;
                }
                else if ( Col == -1 )
                {
                    TempString.ToLong(&Col);
                    TempString = wxEmptyString;
                    columns = new long[Col];
                    j++;
                }
                else
                {
                    TempString.ToLong(&columns[g++]);
                    TempString = wxEmptyString;
                    j++;
                }
            }

            he = ((Database->Page[Cpage].lists[SelectedItem].L.GetCount()-1)*Database->Page[Cpage].lists[SelectedItem].Font.GetChosenFont().GetPointSize()*1.5);

            g = Database->Page[Cpage].lists[SelectedItem].X;
            bool Switch = true;
            for ( j = -1 ; j < Col ; j++ )
            {
                if ( j != -1 )
                    g = g + columns[j];
                if ( ( Firstp.x > g-10 ) and ( Firstp.x < g+10 ) and ( Firstp.y > Database->Page[Cpage].lists[SelectedItem].Y ) and ( Firstp.y < Database->Page[Cpage].lists[SelectedItem].Y+he ) )
                {
                    if ( CurrentCursor != _T("WEcursor") )
                    {
                        CurrentCursor = _T("WEcursor");
                        GetCurrentPanel()->SetCursor(WEcursor);
                    }
                    Switch = false;
                }
            }

            if ( (CurrentCursor != _T("wxNullCursor")) and (Switch) )
            {
                CurrentCursor = _T("wxNullCursor");
                GetCurrentPanel()->SetCursor(wxNullCursor);
            }

            delete[] columns;



        }
        else if ( ActiveTool == 3 )
        {
            wxPoint Firstp;
            Firstp = event.GetLogicalPosition(dc);


            int wi = Database->Page[Cpage].images[SelectedItem].Img.GetWidth()*Database->Page[Cpage].images[SelectedItem].Scale/100, he = Database->Page[Cpage].images[SelectedItem].Img.GetHeight()*Database->Page[Cpage].images[SelectedItem].Scale/100;

            if ( (Database->Page[Cpage].images[SelectedItem].Rotate == 0) or (Database->Page[Cpage].images[SelectedItem].Rotate == 2) )
            {
                if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(wi/2))-12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(he/2))-12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+12 ) )
                {
                    if ( CurrentCursor != _T("NWSEcursor") )
                    {
                        CurrentCursor = _T("NWSEcursor");
                        GetCurrentPanel()->SetCursor(NWSEcursor);
                    }
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+wi-12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+wi+12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(he/2))-12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+12 ) )
                {
                    if ( CurrentCursor != _T("NESWcursor") )
                    {
                        CurrentCursor = _T("NESWcursor");
                        GetCurrentPanel()->SetCursor(NESWcursor);
                    }
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+wi-12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+wi+12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+he-12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+he+12 ) )
                {
                    if ( CurrentCursor != _T("NWSEcursor") )
                    {
                        CurrentCursor = _T("NWSEcursor");
                        GetCurrentPanel()->SetCursor(NWSEcursor);
                    }
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(wi/2))-12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+he-12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+he+12 ) )
                {
                    if ( CurrentCursor != _T("NESWcursor") )
                    {
                        CurrentCursor = _T("NESWcursor");
                        GetCurrentPanel()->SetCursor(NESWcursor);
                    }
                }

                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(wi/2))-36 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(wi/2))-12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(he/2))-36 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(he/2))-12 ) )
                {
                    if ( CurrentCursor != _T("EScursor") )
                    {
                        CurrentCursor = _T("EScursor");
                        GetCurrentPanel()->SetCursor(EScursor);
                    }
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+wi+12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+wi+36 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(he/2))-36 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(he/2))-12 ) )
                {
                    if ( CurrentCursor != _T("SWcursor") )
                    {
                        CurrentCursor = _T("SWcursor");
                        GetCurrentPanel()->SetCursor(SWcursor);
                    }
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+wi+12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(wi/2))+wi+36 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+he+12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+he+36 ) )
                {
                    if ( CurrentCursor != _T("WNcursor") )
                    {
                        CurrentCursor = _T("WNcursor");
                        GetCurrentPanel()->SetCursor(WNcursor);
                    }
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(wi/2))-36 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(wi/2))-12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+he+12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(he/2))+he+36 ) )
                {
                    if ( CurrentCursor != _T("NEcursor") )
                    {
                        CurrentCursor = _T("NEcursor");
                        GetCurrentPanel()->SetCursor(NEcursor);
                    }
                }
                else if ( ( Firstp.x > Database->Page[Cpage].images[SelectedItem].X-(wi/2) ) and ( Firstp.x < Database->Page[Cpage].images[SelectedItem].X+(wi/2) ) and (Firstp.y > Database->Page[Cpage].images[SelectedItem].Y-(he/2)) and (Firstp.y < Database->Page[Cpage].images[SelectedItem].Y+(he/2)) )
                {
                    if ( CurrentCursor != _T("NSWEcursor") )
                    {
                        CurrentCursor = _T("NSWEcursor");
                        GetCurrentPanel()->SetCursor(NSWEcursor);
                    }
                }
                else if ( CurrentCursor != _T("wxNullCursor") )
                {
                    CurrentCursor = _T("wxNullCursor");
                    GetCurrentPanel()->SetCursor(wxNullCursor);
                }
            }
            else if ( (Database->Page[Cpage].images[SelectedItem].Rotate == 1) or (Database->Page[Cpage].images[SelectedItem].Rotate == 3) )
            {
                if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(he/2))-12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(he/2))+12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))-12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+12 ) )
                {
                    if ( CurrentCursor != _T("NWSEcursor") )
                    {
                        CurrentCursor = _T("NWSEcursor");
                        GetCurrentPanel()->SetCursor(NWSEcursor);
                    }
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(he/2))+he-12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(he/2))+he+12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))-12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+12 ) )
                {
                    if ( CurrentCursor != _T("NESWcursor") )
                    {
                        CurrentCursor = _T("NESWcursor");
                        GetCurrentPanel()->SetCursor(NESWcursor);
                    }
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(he/2))+he-12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(he/2))+he+12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+wi-12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+wi+12 ) )
                {
                    if ( CurrentCursor != _T("NWSEcursor") )
                    {
                        CurrentCursor = _T("NWSEcursor");
                        GetCurrentPanel()->SetCursor(NWSEcursor);
                    }
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(he/2))-12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(he/2))+12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+wi-12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+wi+12 ) )
                {
                    if ( CurrentCursor != _T("NESWcursor") )
                    {
                        CurrentCursor = _T("NESWcursor");
                        GetCurrentPanel()->SetCursor(NESWcursor);
                    }
                }

                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(he/2))-36 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(he/2))-12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))-36 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))-12 ) )
                {
                    if ( CurrentCursor != _T("EScursor") )
                    {
                        CurrentCursor = _T("EScursor");
                        GetCurrentPanel()->SetCursor(EScursor);
                    }
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(he/2))+he+12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(he/2))+he+36 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))-36 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))-12 ) )
                {
                    if ( CurrentCursor != _T("SWcursor") )
                    {
                        CurrentCursor = _T("SWcursor");
                        GetCurrentPanel()->SetCursor(SWcursor);
                    }
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(he/2))+he+12 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(he/2))+he+36 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+wi+12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+wi+36 ) )
                {
                    if ( CurrentCursor != _T("WNcursor") )
                    {
                        CurrentCursor = _T("WNcursor");
                        GetCurrentPanel()->SetCursor(WNcursor);
                    }
                }
                else if ( ( Firstp.x > (Database->Page[Cpage].images[SelectedItem].X-(he/2))-36 ) and ( Firstp.x < (Database->Page[Cpage].images[SelectedItem].X-(he/2))-12 ) and ( Firstp.y > (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+wi+12 ) and ( Firstp.y < (Database->Page[Cpage].images[SelectedItem].Y-(wi/2))+wi+36 ) )
                {
                    if ( CurrentCursor != _T("NEcursor") )
                    {
                        CurrentCursor = _T("NEcursor");
                        GetCurrentPanel()->SetCursor(NEcursor);
                    }
                }
                else if ( ( Firstp.x > Database->Page[Cpage].images[SelectedItem].X-(he/2) ) and ( Firstp.x < Database->Page[Cpage].images[SelectedItem].X+(he/2) ) and (Firstp.y > Database->Page[Cpage].images[SelectedItem].Y-(wi/2)) and (Firstp.y < Database->Page[Cpage].images[SelectedItem].Y+(wi/2)) )
                {
                    if ( CurrentCursor != _T("NSWEcursor") )
                    {
                        CurrentCursor = _T("NSWEcursor");
                        GetCurrentPanel()->SetCursor(NSWEcursor);
                    }
                }
                else if ( CurrentCursor != _T("wxNullCursor") )
                {
                    CurrentCursor = _T("wxNullCursor");
                    GetCurrentPanel()->SetCursor(wxNullCursor);
                }
            }



        }
    }
    else if ( (event.Dragging() ) and ( event.m_leftDown ) and ( AlreadyS != 0 ) )  // Sizing / rotating
    {
        if ( SelectedItem != -1 )
        {
            if ( (ActiveTool == 1) )
            {
                if ( ( AlreadyS == 9 ) or ( AlreadyS == 10 ) )
                {
                    int i, Difference = (dragStartPos.y-event.GetLogicalPosition(dc).y)/2;

                    Database->Page[Cpage].labels[SelectedItem].Angle = RotateHelper;

                    for ( i = 0 ; i < (abs(Difference)) and (Database->Page[Cpage].labels[SelectedItem].Angle <= 359) and (Database->Page[Cpage].labels[SelectedItem].Angle >= 0) ; i++ )
                    {
                        if ( AlreadyS == 10 )
                        {
                            if ( Difference < 0 )
                            {
                                if ( Database->Page[Cpage].labels[SelectedItem].Angle == 359 )
                                    ;
                                else
                                    Database->Page[Cpage].labels[SelectedItem].Angle++;
                            }
                            else if ( Difference > 0 )
                            {
                                if ( Database->Page[Cpage].labels[SelectedItem].Angle == 0 )
                                    ;
                                else
                                    Database->Page[Cpage].labels[SelectedItem].Angle--;
                            }
                        }
                        else if ( AlreadyS == 9 )
                        {
                            if ( Difference > 0 )
                            {
                                if ( Database->Page[Cpage].labels[SelectedItem].Angle == 359 )
                                    ;
                                else
                                    Database->Page[Cpage].labels[SelectedItem].Angle++;
                            }
                            else if ( Difference < 0 )
                            {
                                if ( Database->Page[Cpage].labels[SelectedItem].Angle == 0 )
                                    ;
                                else
                                    Database->Page[Cpage].labels[SelectedItem].Angle--;
                            }
                        }
                    }

                    if ( ( long(Database->Page[Cpage].labels[SelectedItem].Angle) % 90 < 10 ) )    // This stuff makes the slider stuck a little at 0, 90, 180, 270 and 360, BUT ID_SLIDER3 must be wxEVT_COMMAND_SLIDER_UPDATED !!!
                    {
                        Database->Page[Cpage].labels[SelectedItem].Angle = Database->Page[Cpage].labels[SelectedItem].Angle-(long(Database->Page[Cpage].labels[SelectedItem].Angle) % 90);
                    }
                    else if ( long(Database->Page[Cpage].labels[SelectedItem].Angle) % 90 > 80 )
                    {
                        Database->Page[Cpage].labels[SelectedItem].Angle = Database->Page[Cpage].labels[SelectedItem].Angle+(90-(long(Database->Page[Cpage].labels[SelectedItem].Angle) % 90));
                    }
                    if ( (Database->Page[Cpage].labels[SelectedItem].Angle == 45) or (Database->Page[Cpage].labels[SelectedItem].Angle == 135) or (Database->Page[Cpage].labels[SelectedItem].Angle == 225) or (Database->Page[Cpage].labels[SelectedItem].Angle == 315) )
                        Database->Page[Cpage].labels[SelectedItem].Angle++;
                }

            }
            else if ( (ActiveTool == 2) )
            {
                if ( AlreadyS == 13 )
                {
                    long Col = -1, *columns;
                    wxString TempString = wxEmptyString;

                    int g = 0, j = 0, i;
                    while ( j < Database->Page[Cpage].lists[SelectedItem].L.Item(0).Len() )
                    {
                        if ( Database->Page[Cpage].lists[SelectedItem].L.Item(0)[j] != ';' )
                        {
                            TempString += Database->Page[Cpage].lists[SelectedItem].L.Item(0)[j];
                            j++;
                        }
                        else if ( Col == -1 )
                        {
                            TempString.ToLong(&Col);
                            TempString = wxEmptyString;
                            columns = new long[Col];
                            j++;
                        }
                        else
                        {
                            TempString.ToLong(&columns[g++]);
                            TempString = wxEmptyString;
                            j++;
                        }
                    }

                    wxString temp = wxEmptyString;
                    j = 0;
                    g = -1;
                    while ( (j < Database->Page[Cpage].lists[SelectedItem].L.Item(0).Len()) and (g < ListHelper) )
                    {
                        if ( Database->Page[Cpage].lists[SelectedItem].L.Item(0)[j] == ';' )
                            g++;
                        temp += Database->Page[Cpage].lists[SelectedItem].L.Item(0)[j++];
                    }
                    g = event.GetLogicalPosition(dc).x-Database->Page[Cpage].lists[SelectedItem].X;
                    for ( i = 0 ; i < ListHelper ; i++ )
                        g -= columns[i];

                    if ( g < 22 )
                        g = 22;

                    temp = temp + wxString::Format(_T("%i"), g) + _T(";");
                    while ( (j < Database->Page[Cpage].lists[SelectedItem].L.Item(0).Len()) and (Database->Page[Cpage].lists[SelectedItem].L.Item(0)[j] != ';') )
                        j++;
                    j++;
                    while ( j < Database->Page[Cpage].lists[SelectedItem].L.Item(0).Len() )
                        temp += Database->Page[Cpage].lists[SelectedItem].L.Item(0)[j++];

                    Database->Page[Cpage].lists[SelectedItem].L.Item(0) = temp;
                    delete[] columns;
                }
                else if ( AlreadyS == 14 )
                {
                    if ( event.GetLogicalPosition(dc).x < 0 )
                        Database->Page[Cpage].lists[SelectedItem].X = 0;
                    else if ( event.GetLogicalPosition(dc).x > GetBackWidth(Cpage) )
                        Database->Page[Cpage].lists[SelectedItem].X = GetBackWidth(Cpage);
                    else
                        Database->Page[Cpage].lists[SelectedItem].X = event.GetLogicalPosition(dc).x;
                }

            }
            else
            {
                if ( (AlreadyS >= 1) and (AlreadyS <= 4) )
                {
                    int tX = event.GetLogicalPosition(dc).x-Database->Page[Cpage].images[SelectedItem].X,
                        tY = event.GetLogicalPosition(dc).y-Database->Page[Cpage].images[SelectedItem].Y;

                    if ( AlreadyS == 1 )
                    {
                        if ( tX > 0 )
                            tX = 0;
                        if ( tY > 0 )
                            tY = 0;
                    }
                    else if ( AlreadyS == 2 )
                    {
                        if ( tX < 0 )
                            tX = 0;
                        if ( tY > 0 )
                            tY = 0;
                    }
                    else if ( AlreadyS == 3 )
                    {
                        if ( tX < 0 )
                            tX = 0;
                        if ( tY < 0 )
                            tY = 0;
                    }
                    else if ( AlreadyS == 4 )
                    {
                        if ( tX > 0 )
                            tX = 0;
                        if ( tY < 0 )
                            tY = 0;
                    }

                    Database->Page[Cpage].images[SelectedItem].Scale = sqrt(pow(tX,2)+pow(tY,2))/ScaleCorrection;


                    if ( Database->Page[Cpage].images[SelectedItem].Scale > 350 )
                        Database->Page[Cpage].images[SelectedItem].Scale = 350;
                    if ( Database->Page[Cpage].images[SelectedItem].Scale < 25 )
                        Database->Page[Cpage].images[SelectedItem].Scale = 25;
                }
                else if ( ( AlreadyS == 5 ) or ( AlreadyS == 6 ) )
                {
                    int i, Difference = (dragStartPos.y-event.GetLogicalPosition(dc).y)/220;

                    Database->Page[Cpage].images[SelectedItem].Rotate = RotateHelper;

                    for ( i = 0 ; i < abs(Difference) ; i++ )
                    {
                        if ( AlreadyS == 5 )
                        {
                            if ( Difference < 0 )
                            {
                                if ( Database->Page[Cpage].images[SelectedItem].Rotate == 3 )
                                    Database->Page[Cpage].images[SelectedItem].Rotate = 0;
                                else
                                    Database->Page[Cpage].images[SelectedItem].Rotate++;
                            }
                            else if ( Difference > 0 )
                            {
                                if ( Database->Page[Cpage].images[SelectedItem].Rotate == 0 )
                                    Database->Page[Cpage].images[SelectedItem].Rotate = 3;
                                else
                                    Database->Page[Cpage].images[SelectedItem].Rotate--;
                            }
                        }
                        else if ( AlreadyS == 6 )
                        {
                            if ( Difference > 0 )
                            {
                                if ( Database->Page[Cpage].images[SelectedItem].Rotate == 3 )
                                    Database->Page[Cpage].images[SelectedItem].Rotate = 0;
                                else
                                    Database->Page[Cpage].images[SelectedItem].Rotate++;
                            }
                            else if ( Difference < 0 )
                            {
                                if ( Database->Page[Cpage].images[SelectedItem].Rotate == 0 )
                                    Database->Page[Cpage].images[SelectedItem].Rotate = 3;
                                else
                                    Database->Page[Cpage].images[SelectedItem].Rotate--;
                            }
                        }
                    }
                }

            }
        }

        if ( STATUS != _("Unsaved") and STATUS !=  _("Modified") )
        {
            ToolBar1->EnableTool(ID_SAVE, true);
            MenuItem5->Enable();
            STATUS = _("Modified");
        }
        USB();    //Update Status Bar
        RDO();

    }
    else if ( (event.Dragging() ) and ( event.m_leftDown ) and ( LastCatched ) )    // Item placing
    {
        UR_Drag = true;


        if ( ActiveTool == 1 )
        {
            if ( dragStartPos.x > event.GetLogicalPosition(dc).x )
            {
                Database->Page[Cpage].labels[SelectedItem].X = DragX - (dragStartPos.x - event.GetLogicalPosition(dc).x);
                if ( Database->Page[Cpage].labels[SelectedItem].X < 0 )
                    Database->Page[Cpage].labels[SelectedItem].X = 0;
                UR_int1T = Database->Page[Cpage].labels[SelectedItem].X;
            }
            else
            {
                Database->Page[Cpage].labels[SelectedItem].X = DragX + abs(dragStartPos.x - event.GetLogicalPosition(dc).x);
                if ( Database->Page[Cpage].labels[SelectedItem].X > GetBackWidth(Cpage) )
                    Database->Page[Cpage].labels[SelectedItem].X = GetBackWidth(Cpage);
                UR_int1T = Database->Page[Cpage].labels[SelectedItem].X;
            }
            if ( dragStartPos.y > event.GetLogicalPosition(dc).y )
            {
                Database->Page[Cpage].labels[SelectedItem].Y = DragY - (dragStartPos.y - event.GetLogicalPosition(dc).y);
                if ( Database->Page[Cpage].labels[SelectedItem].Y < 0 )
                    Database->Page[Cpage].labels[SelectedItem].Y = 0;
                UR_int2T = Database->Page[Cpage].labels[SelectedItem].Y;
            }
            else
            {
                Database->Page[Cpage].labels[SelectedItem].Y = DragY + abs(dragStartPos.y - event.GetLogicalPosition(dc).y);
                if ( Database->Page[Cpage].labels[SelectedItem].Y > GetBackHeight(Cpage) )
                    Database->Page[Cpage].labels[SelectedItem].Y = GetBackHeight(Cpage);
                UR_int2T = Database->Page[Cpage].labels[SelectedItem].Y;
            }
        }
        else if ( ActiveTool == 2 )
        {
            if ( dragStartPos.x > event.GetLogicalPosition(dc).x )
            {
                Database->Page[Cpage].lists[SelectedItem].X = DragX - (dragStartPos.x - event.GetLogicalPosition(dc).x);
                if ( Database->Page[Cpage].lists[SelectedItem].X < 0 )
                    Database->Page[Cpage].lists[SelectedItem].X = 0;
                UR_int1T = Database->Page[Cpage].lists[SelectedItem].X;
            }
            else
            {
                Database->Page[Cpage].lists[SelectedItem].X = DragX + abs(dragStartPos.x - event.GetLogicalPosition(dc).x);
                if ( Database->Page[Cpage].lists[SelectedItem].X > GetBackWidth(Cpage) )
                    Database->Page[Cpage].lists[SelectedItem].X = GetBackWidth(Cpage);
                UR_int1T = Database->Page[Cpage].lists[SelectedItem].X;
            }
            if ( dragStartPos.y > event.GetLogicalPosition(dc).y )
            {
                Database->Page[Cpage].lists[SelectedItem].Y = DragY - (dragStartPos.y - event.GetLogicalPosition(dc).y);
                if ( Database->Page[Cpage].lists[SelectedItem].Y < 0 )
                    Database->Page[Cpage].lists[SelectedItem].Y = 0;
                UR_int2T = Database->Page[Cpage].lists[SelectedItem].Y;
            }
            else
            {
                Database->Page[Cpage].lists[SelectedItem].Y = DragY + abs(dragStartPos.y - event.GetLogicalPosition(dc).y);
                if ( Database->Page[Cpage].lists[SelectedItem].Y > GetBackHeight(Cpage) )
                    Database->Page[Cpage].lists[SelectedItem].Y = GetBackHeight(Cpage);
                UR_int2T = Database->Page[Cpage].lists[SelectedItem].Y;
            }
        }
        else
        {
            if ( dragStartPos.x > event.GetLogicalPosition(dc).x )
            {
                Database->Page[Cpage].images[SelectedItem].X = DragX - (dragStartPos.x - event.GetLogicalPosition(dc).x);
                if ( Database->Page[Cpage].images[SelectedItem].X < 0 )
                    Database->Page[Cpage].images[SelectedItem].X = 0;
                UR_int1T = Database->Page[Cpage].images[SelectedItem].X;
            }
            else
            {
                Database->Page[Cpage].images[SelectedItem].X = DragX + abs(dragStartPos.x - event.GetLogicalPosition(dc).x);
                if ( Database->Page[Cpage].images[SelectedItem].X > GetBackWidth(Cpage) )
                    Database->Page[Cpage].images[SelectedItem].X = GetBackWidth(Cpage);
                UR_int1T = Database->Page[Cpage].images[SelectedItem].X;
            }
            if ( dragStartPos.y > event.GetLogicalPosition(dc).y )
            {
                Database->Page[Cpage].images[SelectedItem].Y = DragY - (dragStartPos.y - event.GetLogicalPosition(dc).y);
                if ( Database->Page[Cpage].images[SelectedItem].Y < 0 )
                    Database->Page[Cpage].images[SelectedItem].Y = 0;
                UR_int2T = Database->Page[Cpage].images[SelectedItem].Y;
            }
            else
            {
                Database->Page[Cpage].images[SelectedItem].Y = DragY + abs(dragStartPos.y - event.GetLogicalPosition(dc).y);
                if ( Database->Page[Cpage].images[SelectedItem].Y > GetBackHeight(Cpage) )
                    Database->Page[Cpage].images[SelectedItem].Y = GetBackHeight(Cpage);
                UR_int2T = Database->Page[Cpage].images[SelectedItem].Y;
            }
        }



        if ( STATUS != _("Unsaved") and STATUS !=  _("Modified") )
        {
            ToolBar1->EnableTool(ID_SAVE, true);
            MenuItem5->Enable();
            STATUS = _("Modified");
        }
        USB();    //Update Status Bar
        RDO();
    }
    else if ( (event.Dragging() ) and (( event.m_middleDown ) or (( event.m_leftDown ) and ( !LastCatched )) ) ) // Preview placing
    {
        FitDC = false;

        if ( DCdragStartPos.x > event.GetPosition().x )
        {
            PositionX = DcDragX - (DCdragStartPos.x - event.GetPosition().x);
            if ( (PositionX+(GetBackWidth(Cpage)*actualScale)/2) < 0 )
                PositionX = 0-(GetBackWidth(Cpage)*actualScale)/2;
        }
        else
        {
            PositionX = DcDragX + abs(DCdragStartPos.x - event.GetPosition().x);
            if ( (PositionX+(GetBackWidth(Cpage)*actualScale)/2) > w2 )
                PositionX = w2-(GetBackWidth(Cpage)*actualScale)/2;
        }
        if ( DCdragStartPos.y > event.GetPosition().y )
        {
            PositionY = DcDragY - (DCdragStartPos.y - event.GetPosition().y);
            if ( (PositionY+(GetBackHeight(Cpage)*actualScale)/2) < 0 )
                PositionY = 0-(GetBackHeight(Cpage)*actualScale)/2;
        }
        else
        {
            PositionY = DcDragY + abs(DCdragStartPos.y - event.GetPosition().y);
            if ( (PositionY+(GetBackHeight(Cpage)*actualScale)/2) > h2 )
                PositionY = h2-(GetBackHeight(Cpage)*actualScale)/2;
        }
        RDO();
    }

}

void DiscWrapperFrame::OnRightDown(wxMouseEvent& event)     // Mouse right click: Call popup menu
{
    if ( TextCtrl->IsShown() )
        TextCtrlLoseFocus();

    ChangeTool = true;
    PopItem1->Enable(true);
    PopItem2->Enable(true);
    PopItem3->Enable(true);
    PopItem4->Enable(true);
    PopItem5->Enable(true);

    int Cpage = GetCurrentPage();

    wxPaintDC dc(GetCurrentPanel());

    float maxX = GetBackWidth(Cpage);   // Get the width and the height of the current pattern
    float maxY = GetBackHeight(Cpage);
    float marginX = 50;     // Set margins
    float marginY = 50;
    maxX += (2*marginX);    // Add margins to resolution
    maxY += (2*marginY);
    maxX = maxX * CurrentZoom;
    maxY = maxY * CurrentZoom;
    int w2, h2;
    dc.GetSize(&w2, &h2);     // Get the width and height of the selected panel

    float scaleX=(float)(w2/maxX);   // Calculate and set scale
    float scaleY=(float)(h2/maxY);
    float actualScale = wxMin(scaleX,scaleY);
    float posX = (float)((w2 - (GetBackWidth(Cpage)*actualScale))/2.0);
    float posY = (float)((h2 - (GetBackHeight(Cpage)*actualScale))/2.0);
    dc.SetUserScale(actualScale, actualScale);

    if ( FitDC == true )
    {
        PositionX = posX;
        PositionY = posY;
    }

    dc.SetDeviceOrigin( (long)PositionX, (long)PositionY );   // Prepare DC
    dc.SetBackground(*wxWHITE_BRUSH);
    dc.SetBackgroundMode(wxTRANSPARENT);

    NewPlace = event.GetLogicalPosition(dc);

    if ( Database->Page[Cpage].labels.GetCount() == 10 )
        PopItem1->Enable(false);

    if ( Database->Page[Cpage].lists.GetCount() == 3 )
        PopItem2->Enable(false);

    if ( Database->Page[Cpage].images.GetCount() == 5 )
    {
        PopItem3->Enable(false);
        PopItem4->Enable(false);
    }

    if ( ActiveTool == 1 )
    {
        Connect(ID_POPDEL,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::OnDelLabel);

        if ( Database->Page[Cpage].labels.GetCount() == 0 )
            PopItem5->Enable(false);

        PopupMenu(PopUp, wxDefaultPosition);

        Disconnect(ID_POPDEL,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::OnDelLabel);
    }
    else if ( ActiveTool == 2 )
    {
        Connect(ID_POPDEL,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::OnDeleteList);

        if ( Database->Page[Cpage].lists.GetCount() == 0 )
            PopItem5->Enable(false);

        PopupMenu(PopUp, wxDefaultPosition);

        Disconnect(ID_POPDEL,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::OnDeleteList);
    }
    else
    {
        Connect(ID_POPDEL,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::OnDeleteImage);

        if ( Database->Page[Cpage].images.GetCount() == 0 )
            PopItem5->Enable(false);

        PopupMenu(PopUp, wxDefaultPosition);

        Disconnect(ID_POPDEL,wxEVT_COMMAND_MENU_SELECTED,(wxObjectEventFunction)&DiscWrapperFrame::OnDeleteImage);
    }

    ChangeTool = false;
    RDO();
}

void DiscWrapperFrame::OnMiddleDown(wxMouseEvent& event)    // Mouse middle click: Move background
{
    if ( TextCtrl->IsShown() )
        TextCtrlLoseFocus();

    int Cpage = GetCurrentPage();

    wxPaintDC dc(GetCurrentPanel());

    float maxX = GetBackWidth(Cpage);   // Get the width and the height of the current pattern
    float maxY = GetBackHeight(Cpage);
    float marginX = 50;     // Set margins
    float marginY = 50;
    maxX += (2*marginX);    // Add margins to resolution
    maxY += (2*marginY);
    maxX = maxX * CurrentZoom;
    maxY = maxY * CurrentZoom;
    int w2, h2;
    dc.GetSize(&w2, &h2);     // Get the width and height of the selected panel

    float scaleX=(float)(w2/maxX);   // Calculate and set scale
    float scaleY=(float)(h2/maxY);
    float actualScale = wxMin(scaleX,scaleY);
    float posX = (float)((w2 - (GetBackWidth(Cpage)*actualScale))/2.0);
    float posY = (float)((h2 - (GetBackHeight(Cpage)*actualScale))/2.0);
    dc.SetUserScale(actualScale, actualScale);

    if ( FitDC == true )
    {
        PositionX = posX;
        PositionY = posY;
    }

    dc.SetDeviceOrigin( (long)PositionX, (long)PositionY );   // Prepare DC
    dc.SetBackground(*wxWHITE_BRUSH);
    dc.SetBackgroundMode(wxTRANSPARENT);

    DCdragStartPos = event.GetPosition();
    DcDragX = PositionX;
    DcDragY = PositionY;
}

void DiscWrapperFrame::OnLeftDouble(wxMouseEvent& event)
{
    if ( (SelectedItem == -1) or (ActiveTool == 3) )
        return;

    int Cpage = GetCurrentPage();

    wxPaintDC dc(GetCurrentPanel());

    float maxX = GetBackWidth(Cpage);   // Get the width and the height of the current pattern
    float maxY = GetBackHeight(Cpage);
    float marginX = 50;     // Set margins
    float marginY = 50;
    maxX += (2*marginX);    // Add margins to resolution
    maxY += (2*marginY);
    maxX = maxX * CurrentZoom;
    maxY = maxY * CurrentZoom;
    int w2, h2;
    dc.GetSize(&w2, &h2);     // Get the width and height of the selected panel

    float scaleX=(float)(w2/maxX);   // Calculate and set scale
    float scaleY=(float)(h2/maxY);
    float actualScale = wxMin(scaleX,scaleY);
    float posX = (float)((w2 - (GetBackWidth(Cpage)*actualScale))/2.0);
    float posY = (float)((h2 - (GetBackHeight(Cpage)*actualScale))/2.0);
    dc.SetUserScale(actualScale, actualScale);

    if ( FitDC == true )
    {
        PositionX = posX;
        PositionY = posY;
    }

    dc.SetDeviceOrigin( (long)PositionX, (long)PositionY );   // Prepare DC
    dc.SetBackground(*wxWHITE_BRUSH);
    dc.SetBackgroundMode(wxTRANSPARENT);

    if ( ActiveTool == 1 )
    {
        wxPoint p = event.GetLogicalPosition(dc);
        dc.SetFont(Database->Page[Cpage].labels[SelectedItem].Font.GetChosenFont());           // Apply Font and Color then draw text with the chosen coordinates and angle
        dc.SetTextForeground(Database->Page[Cpage].labels[SelectedItem].Colour.GetColour());
        wxFont Xfont = Database->Page[Cpage].labels[SelectedItem].Font.GetChosenFont();
        wxCoord wi, he, xc = NULL;
        dc.GetMultiLineTextExtent(Database->Page[Cpage].labels[SelectedItem].L, & wi, & he, &xc, &Xfont);
        if ( wi == 0 )
            wi = he = 100;


       // wxMessageBox(wxString::Format(_("click: %i,%i\nstart: %i,%i\nPrev: %i,%i\nCurr: %i,%i\nBehind: %i\nSameCl: %i"), p.x, p.y, F_TextX[i], F_TextY[i], PrevCoord.x, PrevCoord.y, p.x, p.y, Behind, SameClick), _("hy"));
        if ( Database->Page[Cpage].labels[SelectedItem].Angle == 0 )
        {
            if ( (Database->Page[Cpage].labels[SelectedItem].Align == 0) and (p.x > Database->Page[Cpage].labels[SelectedItem].X) and (p.x < Database->Page[Cpage].labels[SelectedItem].X+wi) and (p.y > Database->Page[Cpage].labels[SelectedItem].Y) and (p.y < Database->Page[Cpage].labels[SelectedItem].Y+he) )
            {
                TextCtrl->SetValue(Database->Page[Cpage].labels[SelectedItem].L);
                TextCtrl->Move(CalcTCplace(dc.LogicalToDeviceX(Database->Page[Cpage].labels[SelectedItem].X), dc.LogicalToDeviceY(Database->Page[Cpage].labels[SelectedItem].Y)));
                TextCtrl->Show();
                TextCtrl->SetFocus();
            }
            else if ( (Database->Page[Cpage].labels[SelectedItem].Align == 1) and (p.x > Database->Page[Cpage].labels[SelectedItem].X-(wi/2)) and (p.x < Database->Page[Cpage].labels[SelectedItem].X+(wi/2)) and (p.y > Database->Page[Cpage].labels[SelectedItem].Y) and (p.y < Database->Page[Cpage].labels[SelectedItem].Y+he) )
            {
                TextCtrl->SetValue(Database->Page[Cpage].labels[SelectedItem].L);
                TextCtrl->Move(CalcTCplace(dc.LogicalToDeviceX(Database->Page[Cpage].labels[SelectedItem].X-(wi/2)), dc.LogicalToDeviceY(Database->Page[Cpage].labels[SelectedItem].Y)));
                TextCtrl->Show();
                TextCtrl->SetFocus();
            }
            else if ( (Database->Page[Cpage].labels[SelectedItem].Align == 2) and (p.x > Database->Page[Cpage].labels[SelectedItem].X-wi) and (p.x < Database->Page[Cpage].labels[SelectedItem].X) and (p.y > Database->Page[Cpage].labels[SelectedItem].Y) and (p.y < Database->Page[Cpage].labels[SelectedItem].Y+he) )
            {
                TextCtrl->SetValue(Database->Page[Cpage].labels[SelectedItem].L);
                TextCtrl->Move(CalcTCplace(dc.LogicalToDeviceX(Database->Page[Cpage].labels[SelectedItem].X-wi), dc.LogicalToDeviceY(Database->Page[Cpage].labels[SelectedItem].Y)));
                TextCtrl->Show();
                TextCtrl->SetFocus();
            }
        }
        else
        {
            if ( he > wi )
                wi = he;
            if ( (Database->Page[Cpage].labels[SelectedItem].Align == 0) and (p.x > Database->Page[Cpage].labels[SelectedItem].X-wi) and (p.x < Database->Page[Cpage].labels[SelectedItem].X+wi) and (p.y > Database->Page[Cpage].labels[SelectedItem].Y-wi) and (p.y < Database->Page[Cpage].labels[SelectedItem].Y+wi) )
            {
                TextCtrl->SetValue(Database->Page[Cpage].labels[SelectedItem].L);
                TextCtrl->Move(CalcTCplace(dc.LogicalToDeviceX(Database->Page[Cpage].labels[SelectedItem].X), dc.LogicalToDeviceY(Database->Page[Cpage].labels[SelectedItem].Y)));
                TextCtrl->Show();
                TextCtrl->SetFocus();
            }
            if ( (Database->Page[Cpage].labels[SelectedItem].Align == 1) and (p.x > Database->Page[Cpage].labels[SelectedItem].X-(wi/2)) and (p.x < Database->Page[Cpage].labels[SelectedItem].X+(wi/2)) and (p.y > Database->Page[Cpage].labels[SelectedItem].Y-(wi/2)) and (p.y < Database->Page[Cpage].labels[SelectedItem].Y+(wi/2)) )
            {
                TextCtrl->SetValue(Database->Page[Cpage].labels[SelectedItem].L);
                TextCtrl->Move(CalcTCplace(dc.LogicalToDeviceX(Database->Page[Cpage].labels[SelectedItem].X), dc.LogicalToDeviceY(Database->Page[Cpage].labels[SelectedItem].Y)));
                TextCtrl->Show();
                TextCtrl->SetFocus();
            }
            if ( (Database->Page[Cpage].labels[SelectedItem].Align == 2) and (p.x > Database->Page[Cpage].labels[SelectedItem].X-wi) and (p.x < Database->Page[Cpage].labels[SelectedItem].X+wi) and (p.y > Database->Page[Cpage].labels[SelectedItem].Y-wi) and (p.y < Database->Page[Cpage].labels[SelectedItem].Y+wi) )
            {
                TextCtrl->SetValue(Database->Page[Cpage].labels[SelectedItem].L);
                TextCtrl->Move(CalcTCplace(dc.LogicalToDeviceX(Database->Page[Cpage].labels[SelectedItem].X), dc.LogicalToDeviceY(Database->Page[Cpage].labels[SelectedItem].Y)));
                TextCtrl->Show();
                TextCtrl->SetFocus();
            }
        }

        UR_stringT = TextCtrl->GetValue();

    }
    else
    {
        wxPoint p = event.GetLogicalPosition(dc);
        int h = 0, w = 0;
        dc.SetFont(Database->Page[Cpage].lists[SelectedItem].Font.GetChosenFont());
        dc.SetTextForeground(Database->Page[Cpage].lists[SelectedItem].Colour.GetColour());

        long Col = -1, longtemp;
        wxString TempString = wxEmptyString;

        int j = 0;
        while ( j < Database->Page[Cpage].lists[SelectedItem].L.Item(0).Len() )
        {
            if ( Database->Page[Cpage].lists[SelectedItem].L.Item(0)[j] != ';' )
            {
                TempString += Database->Page[Cpage].lists[SelectedItem].L.Item(0)[j];
                j++;
            }
            else if ( Col == -1 )
            {
                TempString.ToLong(&Col);
                TempString = wxEmptyString;
                j++;
            }
            else
            {
                TempString.ToLong(&longtemp);
                w += longtemp;
                TempString = wxEmptyString;
                j++;
            }
        }

        h = ((Database->Page[Cpage].lists[SelectedItem].L.GetCount()-1)*Database->Page[Cpage].lists[SelectedItem].Font.GetChosenFont().GetPointSize()*1.5);

        if ( ( p.x > Database->Page[Cpage].lists[SelectedItem].X ) and ( p.x < Database->Page[Cpage].lists[SelectedItem].X+w ) and ( p.y > Database->Page[Cpage].lists[SelectedItem].Y ) and ( p.y < Database->Page[Cpage].lists[SelectedItem].Y+h ) )
        {
            EditListDialog dialog(this, wxID_ANY);

            dialog.SetTableData(Col, Database->Page[Cpage].lists[SelectedItem].L.GetCount()-1, &Database->Page[Cpage].lists[SelectedItem].L);

            wxString wxSTemp = wxEmptyString;
            int i;
            for ( i = 0 ; i < Database->Page[Cpage].lists[SelectedItem].L.GetCount() ; i++ )
            {
                if ( i != 0 )
                    wxSTemp = wxSTemp + _T("\n");
                wxSTemp = wxSTemp + Database->Page[Cpage].lists[SelectedItem].L.Item(i);
            }
            UR_stringT = wxSTemp;

            if ( dialog.ShowModal() == wxID_OK )
            {
                Database->Page[Cpage].lists[SelectedItem].L = dialog.GetData();

                AddToRedoList(2);

                wxSTemp = wxEmptyString;
                for ( i = 0 ; i < Database->Page[Cpage].lists[SelectedItem].L.GetCount() ; i++ )
                {
                    if ( i != 0 )
                        wxSTemp = wxSTemp + _T("\n");
                    wxSTemp = wxSTemp + Database->Page[Cpage].lists[SelectedItem].L.Item(i);
                }
                UR_stringT = wxSTemp;

                NowOfRedoList(2);

                RDO();
            }

        }

    }
}

void DiscWrapperFrame::OnLeftUp(wxMouseEvent& event)      // Mouse left button up
{
    int Cpage = GetCurrentPage();

    if ( UR_Drag )
    {
        UR_Drag = false;
        if ( (DragX != UR_int1T) or (DragY != UR_int2T) )
        {
            int x = UR_int1T, y = UR_int2T;
            UR_int1T = DragX;
            UR_int2T = DragY;
            AddToRedoList(1);
            UR_int1T = x;
            UR_int2T = y;
            NowOfRedoList(1);

            if ( ActiveTool == 3 )
            {
                UpdPview = true;
                RDO();
            }
        }
    }
    else if ( (AlreadyS >= 1) and (AlreadyS <= 4) )
    {
        if ( UR_int1T != Database->Page[Cpage].images[SelectedItem].Scale )
        {
            AddToRedoList(0);
            UR_int1T = Database->Page[Cpage].images[SelectedItem].Scale;
            NowOfRedoList(0);
        }

        UpdPview = true;
        RDO();
    }
    else if ( (AlreadyS >= 5) and (AlreadyS <= 6) )
    {
        if ( UR_int2T != Database->Page[Cpage].images[SelectedItem].Rotate )
        {
            UR_int1T = UR_int2T;
            AddToRedoList(2);
            UR_int1T = Database->Page[Cpage].images[SelectedItem].Rotate;
            NowOfRedoList(2);
        }

        UpdPview = true;
        RDO();
    }
    else if ( (AlreadyS >= 9) and (AlreadyS <= 10) and (UR_int1T != Database->Page[Cpage].labels[SelectedItem].Angle) )
    {
        AddToRedoList(3);
        UR_int1T = Database->Page[Cpage].labels[SelectedItem].Angle;
        NowOfRedoList(3);
    }
    else if ( AlreadyS == 13 )
    {
        AddToRedoList(2);

        wxString wxSTemp = wxEmptyString;
        int i;
        for ( i = 0 ; i < Database->Page[Cpage].lists[SelectedItem].L.GetCount() ; i++ )
        {
            if ( i != 0 )
                wxSTemp = wxSTemp + _T("\n");
            wxSTemp = wxSTemp + Database->Page[Cpage].lists[SelectedItem].L.Item(i);
        }
        UR_stringT = wxSTemp;

        NowOfRedoList(2);
    }
    else if ( AlreadyS == 14 )
    {
        UR_int1T = DragX;
        UR_int2T = DragY;
        AddToRedoList(1);
        UR_int1T = Database->Page[Cpage].lists[SelectedItem].X;
        UR_int2T = Database->Page[Cpage].lists[SelectedItem].Y;
        NowOfRedoList(1);
    }

}

void DiscWrapperFrame::On_MouseWheel(wxMouseEvent& event)       // Mouse wheel: Zoom in or out
{
    if ( event.GetWheelRotation() > 0 )
    {
        if ( CurrentZoom > 0.5 )
            CurrentZoom = CurrentZoom - 0.1;
        else
            return;
    }
    else
    {
        if ( CurrentZoom < 1.5 )
            CurrentZoom = CurrentZoom + 0.1;
        else
            return;
    }

    UpdPview = true;
    RDO();
}

wxPoint DiscWrapperFrame::CalcTCplace(int x, int y)
{
    int Px, Py;//wxMessageBox(wxString::Format(_("%i, %i"), x, y));

    if ( Notebook1->GetPageText(Notebook1->GetSelection()) == _("Front") )   // Find selected pattern
    {
        PanelF->GetSize(&Px, &Py);
    }
    else if ( Notebook1->GetPageText(Notebook1->GetSelection()) == _("Inside") )
    {
        PanelI->GetSize(&Px, &Py);
    }
    else if ( Notebook1->GetPageText(Notebook1->GetSelection()) == _("Back") )
    {
        PanelB->GetSize(&Px, &Py);
    }
    else
    {
        PanelD->GetSize(&Px, &Py);
    }

    if ( Py - y < 120 )
        y = Py - 121;
    if ( Px - x < 200 )
        x = Px - 201;

    wxPoint point(x, y);
    return(point);
}
