/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/
#ifndef IMAGESTOREDIALOG_H
#define IMAGESTOREDIALOG_H

#include "CommonFunctions.h"

//(*Headers(ImageStoreDialog)
#include <wx/listctrl.h>
#include <wx/sizer.h>
#include <wx/statline.h>
#include <wx/panel.h>
#include <wx/button.h>
#include <wx/dialog.h>
//*)

class ImageStoreDialog: public wxDialog
{
	public:

		ImageStoreDialog(wxWindow* parent,wxWindowID id=wxID_ANY,wxString DefPath=wxEmptyString,const wxPoint& pos=wxDefaultPosition,const wxSize& size=wxDefaultSize);
		virtual ~ImageStoreDialog();

		//(*Declarations(ImageStoreDialog)
		wxListCtrl* ListCtrl1;
		wxButton* Button1;
		wxPanel* Panel1;
		wxButton* Button2;
		wxButton* Button5;
		wxStaticLine* StaticLine1;
		//*)

		bool Apply() const { return apply; }
		wxString GetPath() const { return path; }

	protected:

		//(*Identifiers(ImageStoreDialog)
		static const long ID_LISTCTRL1;
		static const long ID_STATICLINE1;
		static const long ID_BUTTON5;
		static const long ID_BUTTON1;
		static const long ID_BUTTON2;
		static const long ID_PANEL1;
		//*)

		bool apply;
		wxString path;
        wxImageList *imageList2;
        wxArrayString Images, Directories;
        int Selected;

	private:

		//(*Handlers(ImageStoreDialog)
		void On_Cancel(wxCommandEvent& event);
		void On_OK(wxCommandEvent& event);
		void OnListCtrl1ItemSelect(wxListEvent& event);
		void On_right(wxCommandEvent& event);
		void On_left(wxCommandEvent& event);
		void OnListCtrl1ItemActivated(wxListEvent& event);
		void OnEdit(wxCommandEvent& event);
		//*)
		void On_OKey();
        void ScanFolder(int one);
        wxString ScanMasks(int state);

        CommonFunctions CFs;

		DECLARE_EVENT_TABLE()
};

#endif
