/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/
#include "ImageStoreDialog.h"
#include "ManageImageStoreDialog.h"

//(*InternalHeaders(ImageStoreDialog)
#include <wx/intl.h>
#include <wx/string.h>
//*)

#include <wx/dir.h>
#include <wx/file.h>
#include <wx/filedlg.h>
#include <wx/msgdlg.h>
#include <wx/imaglist.h>
#include <wx/bitmap.h>
#include <wx/image.h>
#include <wx/dcmemory.h>
#include <wx/font.h>
#include <wx/cmndata.h>
#include <wx/log.h>
#include <wx/textfile.h>

//(*IdInit(ImageStoreDialog)
const long ImageStoreDialog::ID_LISTCTRL1 = wxNewId();
const long ImageStoreDialog::ID_STATICLINE1 = wxNewId();
const long ImageStoreDialog::ID_BUTTON5 = wxNewId();
const long ImageStoreDialog::ID_BUTTON1 = wxNewId();
const long ImageStoreDialog::ID_BUTTON2 = wxNewId();
const long ImageStoreDialog::ID_PANEL1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(ImageStoreDialog,wxDialog)
	//(*EventTable(ImageStoreDialog)
	//*)
END_EVENT_TABLE()

ImageStoreDialog::ImageStoreDialog(wxWindow* parent,wxWindowID id,wxString DefPath,const wxPoint& pos,const wxSize& size)
{
    CFs.DWLog(_T(">>>> Creating dialog\n"));
	//(*Initialize(ImageStoreDialog)
	wxBoxSizer* BoxSizer2;
	wxBoxSizer* BoxSizer1;
	wxBoxSizer* BoxSizer3;

	Create(parent, wxID_ANY, _("Image store"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	BoxSizer1 = new wxBoxSizer(wxHORIZONTAL);
	Panel1 = new wxPanel(this, ID_PANEL1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL1"));
	BoxSizer2 = new wxBoxSizer(wxVERTICAL);
	ListCtrl1 = new wxListCtrl(Panel1, ID_LISTCTRL1, wxDefaultPosition, wxSize(650,460), wxLC_ICON|wxLC_SINGLE_SEL, wxDefaultValidator, _T("ID_LISTCTRL1"));
	BoxSizer2->Add(ListCtrl1, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	StaticLine1 = new wxStaticLine(Panel1, ID_STATICLINE1, wxDefaultPosition, wxSize(10,-1), wxLI_HORIZONTAL, _T("ID_STATICLINE1"));
	BoxSizer2->Add(StaticLine1, 0, wxLEFT|wxRIGHT|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer3 = new wxBoxSizer(wxHORIZONTAL);
	Button5 = new wxButton(Panel1, ID_BUTTON5, _("Manage store"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON5"));
	BoxSizer3->Add(Button5, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer3->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button1 = new wxButton(Panel1, ID_BUTTON1, _("Cancel"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	BoxSizer3->Add(Button1, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button2 = new wxButton(Panel1, ID_BUTTON2, _("OK"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	Button2->Disable();
	BoxSizer3->Add(Button2, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer2->Add(BoxSizer3, 0, wxBOTTOM|wxLEFT|wxRIGHT|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Panel1->SetSizer(BoxSizer2);
	BoxSizer2->Fit(Panel1);
	BoxSizer2->SetSizeHints(Panel1);
	BoxSizer1->Add(Panel1, 1, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(BoxSizer1);
	BoxSizer1->Fit(this);
	BoxSizer1->SetSizeHints(this);
	Center();

	Connect(ID_LISTCTRL1,wxEVT_COMMAND_LIST_ITEM_SELECTED,(wxObjectEventFunction)&ImageStoreDialog::OnListCtrl1ItemSelect);
	Connect(ID_LISTCTRL1,wxEVT_COMMAND_LIST_ITEM_ACTIVATED,(wxObjectEventFunction)&ImageStoreDialog::OnListCtrl1ItemActivated);
	Connect(ID_BUTTON5,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ImageStoreDialog::OnEdit);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ImageStoreDialog::On_Cancel);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ImageStoreDialog::On_OK);
	//*)

	apply = false;
	path = wxEmptyString;
	int i;
	wxLogNull notlog;
	Directories.Empty();
	Images.Empty();

    CFs.DWLog(_T(">>>> Loading images"));

    wxTextFile file(CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("imagestore.conf"));

    if ( !file.Open() )
    {
        Directories.Add(CFs.DataPath()+_T("imagestore/"));
        if ( !file.Create() )
            CFs.DWLog(_T(" can't reach config file "));
        else
        {
            file.AddLine(CFs.DataPath()+_T("imagestore/"));
            file.Write();
        }
    }
    else
    {
        wxString line = file.GetFirstLine();
        while ( !file.Eof() )
        {
            if ( wxDir::Exists(line) )
                Directories.Add(line);
            line = file.GetNextLine();
        }
        file.Close();
    }

    for ( i = 0 ; i < Directories.GetCount() ; i++ )
        ScanFolder(i);

    imageList2 = new wxImageList(200, 200, true, Images.GetCount());

    for ( i = 0 ; i < Images.GetCount() ; i++ )
    {
        wxImage TempImage(Images.Item(i));
        double j, g;
        j = TempImage.GetWidth();
        g = 200 / j;
        if ( TempImage.GetHeight()*g > 200 )
        {
            j = TempImage.GetHeight();
            g = 200 / j;
        }
        TempImage.Rescale(g*TempImage.GetWidth(), g*TempImage.GetHeight(), wxIMAGE_QUALITY_HIGH);

        wxMemoryDC memDC;
        wxBitmap bmp;
        bmp = wxBitmap(200, 200);
        memDC.SelectObject(bmp);
        //memDC.SetBackground(*wxTRANSPARENT_BRUSH);
        memDC.SetBackgroundMode(wxTRANSPARENT);
        memDC.Clear();
        memDC.SetBrush(*wxTRANSPARENT_BRUSH);  //Draw bounders
        memDC.SetPen(*wxGREY_PEN);
        memDC.DrawBitmap(wxBitmap(TempImage), (200-TempImage.GetWidth())/2, (200-TempImage.GetHeight())/2, 0);
        memDC.SelectObject(wxNullBitmap);

        imageList2->Add(bmp, wxNullBitmap);
        CFs.DWLog(_T("."));
    }

    ListCtrl1->AssignImageList(imageList2, wxIMAGE_LIST_NORMAL);
    for ( i = 0 ; i < Images.GetCount() ; i++ )
    {
        ListCtrl1->InsertItem(i, wxEmptyString, i);
    }

    CFs.DWLog(_T("OK\n"));

}

wxString std2wx_4(std::string s)    // Convert a std::string to wxString
{
    wxString wx;
    const char* my_string=s.c_str();
    wxMBConvUTF8 *wxconv= new wxMBConvUTF8();
    wx=wxString(wxconv->cMB2WC(my_string),wxConvUTF8);
    delete wxconv;
    // test if conversion works of not. In case it fails convert from Ascii
    if(wx.length()==0)
        wx=wxString(wxString::FromAscii(s.c_str()));
    return wx;
}

ImageStoreDialog::~ImageStoreDialog()
{
	//(*Destroy(ImageStoreDialog)
	//*)
}

void ImageStoreDialog::On_Cancel(wxCommandEvent& event)
{
	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_CANCEL); // If modal
        else
        {
             SetReturnCode(wxID_CANCEL);
             this->Show(false); // If modeless
        }
    }
}

void ImageStoreDialog::On_OK(wxCommandEvent& event)
{
    On_OKey();
}

void ImageStoreDialog::On_OKey()
{
    path = Images.Item(Selected);

	apply = true;
	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_OK); // If modal
        else
        {
             SetReturnCode(wxID_OK);
             this->Show(false); // If modeless
        }
    }
}

void ImageStoreDialog::OnListCtrl1ItemSelect(wxListEvent& event)
{
    Selected = event.GetIndex();
    Button2->Enable();
}

void ImageStoreDialog::OnListCtrl1ItemActivated(wxListEvent& event)
{
    Selected = event.GetIndex();
    On_OKey();
}

void ImageStoreDialog::ScanFolder(int one)
{
    int i, j;
    wxArrayString Files;

    if ( wxDir::Exists(Directories.Item(one)) )
        wxDir::GetAllFiles(Directories.Item(one), &Files, wxEmptyString, wxDIR_FILES);



    for ( i = 0 ; i < Files.GetCount() ; i++ )
    {
        for ( j = 0 ; j < 6 ; j++ )
        {
            if ( Files.Item(i).Matches(ScanMasks(j)) )
                Images.Add(Files.Item(i));
        }
    }
}

wxString ImageStoreDialog::ScanMasks(int state)
{
    switch(state){
        case 0:
            return(_T("*.jpg"));
        case 1:
            return(_T("*.JPG"));
        case 2:
            return(_T("*.bmp"));
        case 3:
            return(_T("*.BMP"));
        case 4:
            return(_T("*.png"));
        case 5:
            return(_T("*.PNG"));/*
        case 6:
            return(_T("*.gif"));
        case 7:
            return(_T("*.GIF"));*/
    }
}

void ImageStoreDialog::OnEdit(wxCommandEvent& event)
{
    ManageImageStoreDialog dialog(this, wxID_ANY);
    wxString newlist = wxEmptyString;
    int i;

    for ( i = 0 ; i < Directories.GetCount() ; i++ )
    {
        if ( i != 0 )
            newlist = newlist + _T("\n");
        newlist = newlist + Directories.Item(i);
    }

    dialog.SetList(newlist);

    if ( dialog.ShowModal() == wxID_OK )
    {
        Directories.Empty();
        //Images.Empty();

        newlist = dialog.GetList();

        wxString strtemp = wxEmptyString;
        for ( i = 0 ; i < newlist.Len() ; i++ )
        {
            if ( newlist[i] == '\n' )
            {
                Directories.Add(strtemp);
                strtemp = wxEmptyString;
            }
            else
                strtemp += newlist[i];
        }
        Directories.Add(strtemp);

        wxTextFile file(CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("imagestore.conf"));

        if ( !file.Open() )
        {
            if ( !file.Create() )
                wxMessageDialog(this, _("Couldn\'t save changes."), _("Error"), wxICON_ERROR , wxDefaultPosition).ShowModal();
        }

        if ( file.IsOpened() )
        {
            file.Clear();
            for ( i = 0 ; i < Directories.GetCount() ; i++ )
                file.AddLine(Directories.Item(i));
            file.Write();
        }


        wxMessageBox(_("Changes won't take affect until the Image Store is reopened."));
    }
}
