/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#include "EnterStringDialog.h"

//(*InternalHeaders(EnterStringDialog)
#include <wx/intl.h>
#include <wx/string.h>
//*)

//(*IdInit(EnterStringDialog)
const long EnterStringDialog::ID_STATICTEXT1 = wxNewId();
const long EnterStringDialog::ID_TEXTCTRL1 = wxNewId();
const long EnterStringDialog::ID_BUTTON1 = wxNewId();
const long EnterStringDialog::ID_BUTTON2 = wxNewId();
const long EnterStringDialog::ID_PANEL1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(EnterStringDialog,wxDialog)
	//(*EventTable(EnterStringDialog)
	//*)
END_EVENT_TABLE()

EnterStringDialog::EnterStringDialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(EnterStringDialog)
	wxBoxSizer* BoxSizer2;
	wxBoxSizer* BoxSizer1;
	wxBoxSizer* BoxSizer3;

	Create(parent, id, _("New printer model list item"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("id"));
	SetClientSize(wxDefaultSize);
	Move(wxDefaultPosition);
	BoxSizer1 = new wxBoxSizer(wxHORIZONTAL);
	Panel1 = new wxPanel(this, ID_PANEL1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL1"));
	BoxSizer2 = new wxBoxSizer(wxVERTICAL);
	StaticText1 = new wxStaticText(Panel1, ID_STATICTEXT1, _("Enter the name of the new model: (for example: CANON PIXMA MP160)"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	BoxSizer2->Add(StaticText1, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	TextCtrl1 = new wxTextCtrl(Panel1, ID_TEXTCTRL1, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxTE_PROCESS_ENTER, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	TextCtrl1->SetFocus();
	BoxSizer2->Add(TextCtrl1, 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer3 = new wxBoxSizer(wxHORIZONTAL);
	Button1 = new wxButton(Panel1, ID_BUTTON1, _("Cancel"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	BoxSizer3->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button2 = new wxButton(Panel1, ID_BUTTON2, _("Ok"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	BoxSizer3->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer2->Add(BoxSizer3, 1, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL, 5);
	Panel1->SetSizer(BoxSizer2);
	BoxSizer2->Fit(Panel1);
	BoxSizer2->SetSizeHints(Panel1);
	BoxSizer1->Add(Panel1, 1, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(BoxSizer1);
	BoxSizer1->Fit(this);
	BoxSizer1->SetSizeHints(this);

	Connect(ID_TEXTCTRL1,wxEVT_COMMAND_TEXT_ENTER,(wxObjectEventFunction)&EnterStringDialog::OnButton2Click);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&EnterStringDialog::OnButton1Click);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&EnterStringDialog::OnButton2Click);
	//*)
}

EnterStringDialog::~EnterStringDialog()
{
	//(*Destroy(EnterStringDialog)
	//*)
}


void EnterStringDialog::OnButton2Click(wxCommandEvent& event)
{
    ex_s = TextCtrl1->GetValue();
	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_OK); // If modal
        else
        {
             SetReturnCode(wxID_OK);
             this->Show(false); // If modeless
        }
    }
}

void EnterStringDialog::OnButton1Click(wxCommandEvent& event)
{
	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_CANCEL); // If modal
        else
        {
             SetReturnCode(wxID_CANCEL);
             this->Show(false); // If modeless
        }
    }
}
