/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#ifndef DISCWRAPPERMAIN_H
#define DISCWRAPPERMAIN_H

#include "Database.h"
#include "DWPrintout.h"
#include "CommonFunctions.h"

//(*Headers(DiscWrapperFrame)
#include <wx/bmpbuttn.h>
#include <wx/toolbar.h>
#include <wx/sizer.h>
#include <wx/notebook.h>
#include <wx/menu.h>
#include <wx/panel.h>
#include <wx/statusbr.h>
#include <wx/statline.h>
#include <wx/frame.h>
#include <wx/tglbtn.h>
#include <wx/choice.h>
//*)

#include <wx/textctrl.h>
#include <wx/stattext.h>
#include <wx/cmndata.h>
#include <wx/checkbox.h>
#include <wx/panel.h>

class DiscWrapperFrame: public wxFrame
{
    //friend class CommonFunctions;

    DWPrintout *myprint;
    wxPrinter printer;

    public:

        DiscWrapperFrame(wxWindow* parent,wxChar *Project = _T(""),bool IsProject = false,wxWindowID id = -1);
        virtual ~DiscWrapperFrame();


        virtual void GiveLanguge(int LANGUAGE = wxLANGUAGE_ENGLISH)
        {
            m_ProjectL = LANGUAGE;
        }

    protected:

        int m_ProjectL;

        wxString STATUS;    // Project/program tatus

        int rec;    // Number of recent projects
        wxString *recs; // Paths of recent projects

        wxString SPATH;     // Path of project file of current project (opened project)
        wxString LastDir;   // Last path... This is obsolete since 1.1.1

        int ActiveTool;     // 1: Label, 2: List, 3: Image

        bool IsDatabasePresent;

        wxPanel *PanelF, *PanelI, *PanelB, *PanelD;  // Panels to draw on

        wxString ImportPath, ExportPath, ProjectPath; // Default paths
        wxFont Dfont;           // Default font
        wxColour DColour;       // Default lolour
        int DClass;      // Default class of label
        bool FilesOnly, Hidden, Listing1, Listing2, Listing3; // Listing switches

        bool DontLog;   // Switch logging off

    //Preview preferences:
        bool FitDC;
        float PositionX, PositionY, CurrentZoom;

    //Mouse event handling:
        wxPoint PrevCoord, NewPlace, dragStartPos, DCdragStartPos;
        int DragX, DragY, DcDragX, DcDragY, Behind;
        bool LastCatched;
        int SelectedItem;//, AlreadyS;
        bool ChangeTool, FitHorizontal;

    //On-design item controlling variables:
        float ScaleCorrection;
        int AlreadyS, RotateHelper, ListHelper;
        wxString CurrentCursor;

        //Undo/Redo variables:
        int UR_Max, UR_Current, UR_IndexCorrection, UR_WrongIndex;
        int *UR_Page, *UR_Tool, *UR_Id, *UR_Act;
        wxString UR_stringT;
        bool UR_Drag;
        int UR_int1T, UR_int2T;

        wxString *URV_string;
        int *URV_int1, *URV_int2, *URV_int3, *URV_int4, *URV_int5, *URV_int6;
        wxFontData *URV_font;
        wxColourData *URV_colour;

    private:

        //(*Handlers(DiscWrapperFrame)
        void OnQuit(wxCommandEvent& event);
        void OnAbout(wxCommandEvent& event);
        void OnTool_New_Clicked(wxCommandEvent& event);
        void OnToolBar_Refresh_Clicked(wxCommandEvent& event);
        void On_Import_Selected(wxCommandEvent& event);
        void OnPaint(wxPaintEvent& event);
        void OnFontClick(wxCommandEvent& event);
        void OnColorClick(wxCommandEvent& event);
        void OnNotebook1PageChanged(wxNotebookEvent& event);
        void On_TOOLBAR_Selected(wxCommandEvent& event);
        void On_Close_Selected(wxCommandEvent& event);
        void On_SAVE_AS(wxCommandEvent& event);
        void On_SAVE(wxCommandEvent& event);
        void On_OPEN(wxCommandEvent& event);
        void On_Export(wxCommandEvent& event);
        void OnClassSelect(wxCommandEvent& event);
        void On_PREFERENCES(wxCommandEvent& event);
        void On_PRINT(wxCommandEvent& event);
        void On_ListDir(wxCommandEvent& event);
        void On_AddImage(wxCommandEvent& event);
        void On_TEXT_TOOL(wxCommandEvent& event);
        void On_LIST_TOOL(wxCommandEvent& event);
        void On_IMAGE_TOOL(wxCommandEvent& event);
        void On_Background(wxCommandEvent& event);
        void OnClose(wxCloseEvent& event);
        void On_Text_Align(wxCommandEvent& event);
        void OnLeftDown(wxMouseEvent& event);
        void OnRightDown(wxMouseEvent& event);
        void OnDragging(wxMouseEvent& event);
        void OnMiddleDown(wxMouseEvent& event);
        void On_Zoom_In(wxCommandEvent& event);
        void On_Zoom_Out(wxCommandEvent& event);
        void On_Zoom_Fit(wxCommandEvent& event);
        void On_MouseWheel(wxMouseEvent& event);
        void OnBendClick(wxCommandEvent& event);
        void OnUndo(wxCommandEvent& event);
        void OnRedo(wxCommandEvent& event);
        void OnSelectNext(wxCommandEvent& event);
        //*)
        void DrawDC();
        void RDO();
        void USB();
        void Saving(wxString path);
        void OpenProject(wxString path);
        void OpenTemplate(wxString path, int Casetype);
        void DeleteTool();
        void On_NewList(wxCommandEvent& event);
        void OnDeleteList(wxCommandEvent& event);
        void On_NewImage(wxCommandEvent& event);
        void On_ImageS(wxCommandEvent& event);
        void OnDeleteImage(wxCommandEvent& event);
        void On_ImageUp(wxCommandEvent& event);
        void On_ImageDown(wxCommandEvent& event);
        void SetTextTool();
        void SetListTool();
        void SetImageTool();
        void UpdateRecents();
        void Recents1(wxCommandEvent& event);
        void Recents2(wxCommandEvent& event);
        void Recents3(wxCommandEvent& event);
        void Recents4(wxCommandEvent& event);
        void Recents5(wxCommandEvent& event);
        void On_IMAGE(wxString path);
        void OnNewLabel(wxCommandEvent& event);
        void OnDelLabel(wxCommandEvent& event);
        void OnCheckBox1Click(wxCommandEvent& event);
        void OnCheckBox2Click(wxCommandEvent& event);
        bool ConfirmClose();
        void AddToRedoList(int URAct);
        void NowOfRedoList(int URAct);
        void OnLeftUp(wxMouseEvent& event);
        void DeleteLabel();
        void CreateLabel();
        void DeleteList();
        bool CreateList(int type, wxString path);
        void DeleteImage();
        void PlaceImageDown();
        void PlaceImageUp();
        void Clear_Tool_history();
        void On_ImageFitIt(wxCommandEvent& event);
        void FixRedoIndex(int IndexCorrection);
        void UnloadProject();
        double RoateCoordinationOnX(int input);
        double RoateCoordinationOnY(int input);
        double RoateCoordinationOnX2(int input, int input2, int input3);
        double RoateCoordinationOnY2(int input, int input2, int input3);
        void RealiseTool();
        void ShowTool(int toolnumber);
        void AbleTool(int toolnumber, bool statetoset);
        void OnLeftDouble(wxMouseEvent& event);
        wxPoint CalcTCplace(int x, int y);
        void TextCtrlLoseFocus();
        void OnTextCtrlKillFocus(wxFocusEvent& event);
        int GetCurrentPage();
        wxPanel* GetCurrentPanel();
        void OpenProjectV5(wxString path);
        void OpenProjectV6(wxString path);
        void DrawLabels(wxDC &dc, int Cpage, bool preview = false);
        void DrawLists(wxDC &dc, int Cpage, bool preview = false);
        void DrawImages(wxDC &dc, int Cpage, bool preview = false);
        void DrawPreImages(wxDC &dc, int Cpage);
        void SelectNextLabel(int place);
        void SelectNextList(int place);
        void SelectNextImage(int place);
        int GetBackWidth(int Cpage);
        int GetBackHeight(int Cpage);
        void UpdatePrj5To6();
        void UpdatePrj6To7();

        //(*Identifiers(DiscWrapperFrame)
        static const long ID_TOGGLEBUTTON1;
        static const long ID_CHOICE1;
        static const long ID_STATICLINE1;
        static const long ID_BITMAPBUTTON1;
        static const long ID_BITMAPBUTTON2;
        static const long ID_BITMAPBUTTON3;
        static const long ID_STATICLINE2;
        static const long ID_BITMAPBUTTON4;
        static const long ID_BITMAPBUTTON5;
        static const long ID_BITMAPBUTTON6;
        static const long ID_BITMAPBUTTON7;
        static const long ID_STATICLINE3;
        static const long ID_BITMAPBUTTON8;
        static const long ID_PANEL3;
        static const long ID_NOTEBOOK1;
        static const long ID_PANEL1;
        static const long ID_MENUITEM13;
        static const long ID_MENUITEM7;
        static const long ID_MENUITEM5;
        static const long ID_MENUITEM8;
        static const long ID_MENUITEM9;
        static const long ID_MENUITEM6;
        static const long ID_MENUITEM4;
        static const long ID_MENUITEM3;
        static const long ID_MENUITEM1;
        static const long ID_MENUITEM2;
        static const long ID_STATUSBAR1;
        static const long ID_NEW;
        static const long ID_OPEN;
        static const long ID_SAVE;
        static const long ID_PRINT;
        static const long ID_TOOL_ZIN;
        static const long ID_TOOL_ZOUT;
        static const long ID_TOOL_FIT;
        static const long ID_TOOLBAR1;
        //*)
        static const long ID_PANELF;
        static const long ID_PANELI;
        static const long ID_PANELB;
        static const long ID_PANELD;

        static const long ID_TEXTCTRL;

        static const long ID_RECENT1;
        static const long ID_RECENT2;
        static const long ID_RECENT3;
        static const long ID_RECENT4;
        static const long ID_RECENT5;

        static const long ID_POPNEW1;
        static const long ID_POPNEW2;
        static const long ID_POPNEW3;
        static const long ID_POPNEW4;
        static const long ID_POPDEL;

        //(*Declarations(DiscWrapperFrame)
        wxBitmapButton* BitmapButton2;
        wxBitmapButton* BitmapButton8;
        wxToggleButton* ToggleButton1;
        wxToolBarToolBase* ToolBarItem5;
        wxPanel* Panel1;
        wxBitmapButton* BitmapButton3;
        wxMenu* Menu5;
        wxStaticLine* StaticLine2;
        wxMenu* Menu1;
        wxStatusBar* StatusBar1;
        wxMenuItem* MenuItem16;
        wxMenuItem* MenuItem12;
        wxToolBarToolBase* ToolBarItem6;
        wxMenu* Menu3;
        wxMenuItem* MenuItem15;
        wxToolBarToolBase* ToolBarItem7;
        wxToolBarToolBase* ToolBarItem2;
        wxMenuItem* MenuItem17;
        wxMenuItem* MenuItem3;
        wxStaticLine* StaticLine1;
        wxChoice* Choice1;
        wxMenuItem* MenuItem9;
        wxMenu* Menu4;
        wxBitmapButton* BitmapButton5;
        wxBitmapButton* BitmapButton4;
        wxStaticLine* StaticLine3;
        wxToolBar* ToolBar1;
        wxMenuItem* MenuItem11;
        wxPanel* Panel3;
        wxToolBarToolBase* ToolBarItem4;
        wxMenuItem* MenuItem5;
        wxToolBarToolBase* ToolBarItem1;
        wxMenuItem* MenuItem10;
        wxNotebook* Notebook1;
        wxBitmapButton* BitmapButton7;
        wxMenuItem* MenuItem18;
        wxToolBarToolBase* ToolBarItem3;
        wxMenuItem* MenuItem6;
        wxMenuItem* MenuItem4;
        wxMenuItem* MenuItem13;
        wxBitmapButton* BitmapButton1;
        wxMenuItem* MenuItem8;
        wxMenuItem* MenuItem14;
        wxBitmapButton* BitmapButton6;
        //*)

        wxMenuItem* Recent1;
        wxMenuItem* Recent2;
        wxMenuItem* Recent3;
        wxMenuItem* Recent4;
        wxMenuItem* Recent5;

        wxTextCtrl* TextCtrl;

        wxMenuItem *PopItem1;
        wxMenuItem *PopItem2;
        wxMenuItem *PopItem3;
        wxMenuItem *PopItem4;
        wxMenuItem *PopItem5;
        wxMenu *PopUp;

        wxCursor SWcursor, WNcursor, NEcursor, EScursor, NESWcursor, NWSEcursor, NSWEcursor, WEcursor;

        wxBitmap Pview;

        bool UpdPview;

        wxSize UpdSize;

        DiscWrapperDatabase *Database;

        CommonFunctions CFs;

        DECLARE_EVENT_TABLE()

};

#endif // DiscWrapperMAIN_H
