/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#include "DiscWrapperApp.h"

//(*AppHeaders
#include "DiscWrapperMain.h"
#include <wx/image.h>
//*)
#include <wx/intl.h>
#include <wx/file.h>
#include <wx/dir.h>
#include <wx/tipdlg.h>

IMPLEMENT_APP(DiscWrapperApp);

bool DiscWrapperApp::OnInit()
{
    HaveProjectOrNot = false;

    //(*AppInitialize
    bool wxsOK = true;
    wxInitAllImageHandlers();
    if ( wxsOK )
    {
        wxFile file;
        wxString path, tipsdir;
        int LANG = wxLANGUAGE_DEFAULT;
        switch(wxLocale::GetSystemLanguage()){
            case wxLANGUAGE_GERMAN:
            case wxLANGUAGE_GERMAN_AUSTRIAN:
            case wxLANGUAGE_GERMAN_BELGIUM:
            case wxLANGUAGE_GERMAN_LIECHTENSTEIN:
            case wxLANGUAGE_GERMAN_LUXEMBOURG:
            case wxLANGUAGE_GERMAN_SWISS:
                LANG = wxLANGUAGE_GERMAN;
                break;
            case wxLANGUAGE_ENGLISH:
            case wxLANGUAGE_HUNGARIAN:
            case wxLANGUAGE_DANISH:
            case wxLANGUAGE_SPANISH:
            case wxLANGUAGE_SWEDISH:
            case wxLANGUAGE_POLISH:
                LANG = wxLANGUAGE_GERMAN;
                break;
            default:
                LANG = wxLANGUAGE_ENGLISH;
                break;
        }


        CFs.LocalDir();

        path = CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("language");
        if ( wxFile::Exists(path) == true )
        {
            file.Open(path, wxFile::read);

            file.Read(&LANG, sizeof(int));

            file.Close();
        }
        else
        {
            file.Create(path, true, wxS_DEFAULT);

            file.Write(&LANG, sizeof(int));

            file.Close();
        }


        m_locale = new wxLocale( LANG );

#if defined(__UNIX__)
        if ( wxFile::Exists(_T("/usr/local/share/discwrapper/printermodels")) == true )
            path = _T("/usr/local/share/discwrapper/po");
        else
            path = _T("/usr/share/discwrapper/po");
#elif defined(__WXMSW__)
        path = _T("data/po");
#endif

        m_locale->AddCatalogLookupPathPrefix(path);

        if ( m_locale->AddCatalog(_T("discwrapper")) == false )
        {
           // wxMessageBox(_("Can\'t load selected language."), _("Error"));
            LANG = wxLANGUAGE_ENGLISH;
        }
        //wxMessageBox(wxString::Format(_("Value of language: %i"), wxLocale::GetSystemLanguage() ), _("Development"));

        //wxMessageBox(wxString::Format(_("Value of argc: %i"), wxApp::argc), _("Development"));

        switch(LANG){
            case wxLANGUAGE_ENGLISH:
                tipsdir = _T("/en");
                break;
            case wxLANGUAGE_HUNGARIAN:
                tipsdir = _T("/hu");
                break;
            case wxLANGUAGE_GERMAN:
                tipsdir = _T("/de");
                break;
            case wxLANGUAGE_DANISH:
                tipsdir = _T("/da");
                break;
            case wxLANGUAGE_SPANISH:
                tipsdir = _T("/es");
                break;
            case wxLANGUAGE_POLISH:
                tipsdir = _T("/pl");
                break;
            case wxLANGUAGE_SWEDISH:
                tipsdir = _T("/sv");
                break;
            default:
                tipsdir = _T("/en");
                break;
        }

        if ( wxApp::argc >= 2 )
        {
            HaveProjectOrNot = true;
            HaveProject = wxApp::argv[wxApp::argc-1];
        }

    	DiscWrapperFrame* Frame = new DiscWrapperFrame(0,HaveProject,HaveProjectOrNot);
    	Frame->GiveLanguge( LANG );
    	Frame->Show();
    	SetTopWindow(Frame);

        int Ctip = 0;
        bool RunTip = true;
        path = CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("tip");
        if ( wxFile::Exists(path) == true )
        {
            file.Open(path, wxFile::read);

            file.Read(&RunTip, sizeof(bool));

            file.Read(&Ctip, sizeof(int));

            file.Close();
        }

#if defined(__UNIX__)
        if ( wxFile::Exists(_T("/usr/local/share/discwrapper/printermodels")) == true )
            path = _T("/usr/local/share/discwrapper");
        else
            path = _T("/usr/share/discwrapper");
#elif defined(__WXMSW__)
        path = _T("data");
#endif
    	if ( RunTip )
        {
            wxTipProvider *tipProvider = wxCreateFileTipProvider(path+_T("/po")+tipsdir+_T("/tips.txt"), Ctip);
            bool ShowTip = wxShowTip(Frame, tipProvider);
            Ctip = tipProvider->GetCurrentTip();
            delete tipProvider;

            path = CFs.std2wx(CFs.oFolder_userM)+CFs.PathCoordination+_T("tip");
            file.Create(path, true, wxS_DEFAULT);

            file.Write(&ShowTip, sizeof(bool));

            file.Write(&Ctip, sizeof(int));

            file.Close();
        }

    }
    //*)
    return wxsOK;

}
