/**
 **   DiscWrapper - Cover designer for homemade discs.
 **   Copyright (C) 2008-2009  Nándor Mátravölgyi
 **
 **   This program is free software: you can redistribute it and/or modify
 **   it under the terms of the GNU General Public License as published by
 **   the Free Software Foundation, either version 3 of the License, or
 **   (at your option) any later version.
 **
 **   This program is distributed in the hope that it will be useful,
 **   but WITHOUT ANY WARRANTY; without even the implied warranty of
 **   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 **   GNU General Public License for more details.
 **
 **   You should have received a copy of the GNU General Public License
 **   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **
 **   Contact:
 **   e-mail: nmatra@citromail.hu
 **
 **/

#include "ConfirmCloseDialog.h"

//(*InternalHeaders(ConfirmCloseDialog)
#include <wx/intl.h>
#include <wx/string.h>
//*)
#include <wx/artprov.h>
#include <wx/bitmap.h>
#include <wx/image.h>
#include <wx/dcclient.h>

//(*IdInit(ConfirmCloseDialog)
const long ConfirmCloseDialog::ID_PANEL2 = wxNewId();
const long ConfirmCloseDialog::ID_STATICTEXT1 = wxNewId();
const long ConfirmCloseDialog::ID_BUTTON1 = wxNewId();
const long ConfirmCloseDialog::ID_BUTTON2 = wxNewId();
const long ConfirmCloseDialog::ID_BUTTON3 = wxNewId();
const long ConfirmCloseDialog::ID_PANEL1 = wxNewId();
//*)

BEGIN_EVENT_TABLE(ConfirmCloseDialog,wxDialog)
	//(*EventTable(ConfirmCloseDialog)
	//*)
END_EVENT_TABLE()

ConfirmCloseDialog::ConfirmCloseDialog(wxWindow* parent,wxWindowID id,const wxPoint& pos,const wxSize& size)
{
	//(*Initialize(ConfirmCloseDialog)
	wxBoxSizer* BoxSizer4;
	wxBoxSizer* BoxSizer2;
	wxBoxSizer* BoxSizer1;
	wxBoxSizer* BoxSizer3;

	Create(parent, wxID_ANY, _T("DiscWrapper"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	BoxSizer1 = new wxBoxSizer(wxHORIZONTAL);
	Panel1 = new wxPanel(this, ID_PANEL1, wxDefaultPosition, wxDefaultSize, wxTAB_TRAVERSAL, _T("ID_PANEL1"));
	BoxSizer2 = new wxBoxSizer(wxVERTICAL);
	BoxSizer3 = new wxBoxSizer(wxHORIZONTAL);
	Panel2 = new wxPanel(Panel1, ID_PANEL2, wxDefaultPosition, wxSize(48,48), wxTAB_TRAVERSAL, _T("ID_PANEL2"));
	BoxSizer3->Add(Panel2, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 15);
	StaticText1 = new wxStaticText(Panel1, ID_STATICTEXT1, _("The current project has been changed.\nSave the changes\?"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	BoxSizer3->Add(StaticText1, 1, wxTOP|wxBOTTOM|wxRIGHT|wxEXPAND|wxALIGN_LEFT|wxALIGN_TOP, 15);
	BoxSizer2->Add(BoxSizer3, 1, wxTOP|wxLEFT|wxRIGHT|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer4 = new wxBoxSizer(wxHORIZONTAL);
	Button1 = new wxButton(Panel1, ID_BUTTON1, _("&Save"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	Button1->SetFocus();
	BoxSizer4->Add(Button1, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button2 = new wxButton(Panel1, ID_BUTTON2, _("&Discard"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	BoxSizer4->Add(Button2, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Button3 = new wxButton(Panel1, ID_BUTTON3, _("&Cancel"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON3"));
	BoxSizer4->Add(Button3, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	BoxSizer2->Add(BoxSizer4, 0, wxBOTTOM|wxLEFT|wxRIGHT|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	Panel1->SetSizer(BoxSizer2);
	BoxSizer2->Fit(Panel1);
	BoxSizer2->SetSizeHints(Panel1);
	BoxSizer1->Add(Panel1, 1, wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	SetSizer(BoxSizer1);
	BoxSizer1->Fit(this);
	BoxSizer1->SetSizeHints(this);
	Center();

	Panel2->Connect(wxEVT_PAINT,(wxObjectEventFunction)&ConfirmCloseDialog::OnIconPaint,0,this);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ConfirmCloseDialog::OnSave);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ConfirmCloseDialog::OnDiscard);
	Connect(ID_BUTTON3,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ConfirmCloseDialog::OnCancel);
	//*)

	choice = 3;
}

ConfirmCloseDialog::~ConfirmCloseDialog()
{
	//(*Destroy(ConfirmCloseDialog)
	//*)
}


void ConfirmCloseDialog::OnSave(wxCommandEvent& event)
{
	choice = 1;

	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_OK); // If modal
        else
        {
             SetReturnCode(wxID_OK);
             this->Show(false); // If modeless
        }
    }
}

void ConfirmCloseDialog::OnDiscard(wxCommandEvent& event)
{
	choice = 2;

	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_OK); // If modal
        else
        {
             SetReturnCode(wxID_OK);
             this->Show(false); // If modeless
        }
    }
}

void ConfirmCloseDialog::OnCancel(wxCommandEvent& event)
{
    choice = 3;

	if ( Validate() && TransferDataFromWindow() )
    {
        if ( IsModal() )
             EndModal(wxID_OK); // If modal
        else
        {
             SetReturnCode(wxID_OK);
             this->Show(false); // If modeless
        }
    }
}

void ConfirmCloseDialog::OnIconPaint(wxPaintEvent& event)
{
    wxPaintDC dc(Panel2);
    dc.DrawBitmap(wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("wxART_QUESTION")),wxART_MAKE_CLIENT_ID_FROM_STR(wxString(_T("wxART_MESSAGE_BOX")))), 0, 0, 0);
}
