Building with CMake {#occt_dev_guides__building_cmake}
===================

@tableofcontents

This file describes the steps to build OCCT libraries from a complete source package
with **CMake**. CMake is free software that can create GNU Makefiles, KDevelop, 
XCode, Eclipse and Visual Studio project files. **CMake** version 3.0 or above is 
required.

If you build OCCT from bare sources (as in Git repository) or make some 
changes affecting CDL files, you need to use WOK to re-generate header files
and build scripts / projects. See \ref occt_dev_guides__building_wok for instructions.

Before building OCCT, you need to install the required third-party libraries; see the
instructions for your platform in @ref occt_dev_guides__building.

## Define the location of build and install directories.

The build directory is where intermediate files (projects / makefiles, objects, binaries) will be created. Each built configuration should have its own build directory.

The install directory is where binaries will be installed after build, along with header files and resources required for OCCT use in applications. 
It is possible to install several configurations of OCCT (differentiated by platform, bitness, compiler, and build type) into the same directory.

It is recommended to separate build and install directories from OCCT source directory, for example:

       /user/home/occt/                           - sources
       /user/home/tmp/occt-build-vc10-x64-release - intermediate files
       /user/home/occt-install                    - installed binaries

## CMake usage

Run CMake indicating the path to OCCT sources <i>($CASROOT)</i> and selected build directory.

It is recommended to use GUI tools provided by CMake: *cmake-gui* on Windows, Mac and Linux (*ccmake* also can be used on Linux).

### Windows:

Specify the root folder of OCCT (<i>$CASROOT</i>, which contains *CMakelists.txt* file) by clicking **Browse Source**.

@figure{/dev_guides/building/cmake/images/cmake_image001.png}

Specify the location (build folder) for Cmake generated project files by clicking **Browse Build**.

Each configuration of the project should be built in its own directory. When building multiple configurations it is recommended to indicate in the name of build directories the system, bitness, compiler, and build type (e.g., <i>d:/occt/build/win32-vc9-debug</i> ).

**Configure** opens the window with a drop-down list of generators supported by CMake project. Select the required generator (e.g., Visual Studio 2008) and click **Finish**.

@figure{/dev_guides/building/cmake/images/cmake_image002.png}

### Linux (ccmake variant):

In the console, change to the build directory and call *ccmake* with the path to the source directory of the project:

       > cd ~/occt/build/debug
       > ccmake ~/occt

@figure{/dev_guides/building/cmake/images/cmake_image003.png}

Press *c* to configure.

*cmake-gui* is used in the same way as described above for Windows.

### Mac OS:

Use *cmake-gui* **Applications -> CMake 2.8-10.app** to generate project files for the chosen build environment (e.g., XCode).

@figure{/dev_guides/building/cmake/images/cmake_image004.png}

## OCCT Configuration

The error message, which appears at the end of configuration process, informs you about the required variables, 
which need to be defined. This error will appear until all required variables are defined correctly.

Note: In *cmake-gui* there is "grouped" option, which groups variables with a common prefix.

### Selection of the components to be built

The variables with <i>BUILD_</i> prefix allow specifying OCCT components and
configuration to be built:

* *BUILD_CONFIGURATION* - defines configuration to be built (Release by default).
* <i>BUILD_<MODULE></i>      - specifies whether the corresponding OCCT module should be 
                        built (all toolkits). Note that even if the whole module is not 
                        selected for build, its toolkits used by other toolkits 
                        selected for build will be included automatically.
* *BUILD_TOOLKITS*      - allows including additional toolkits from non-selected 
                        modules (should be list of toolkit names separated by a 
                        space or a semicolon).
* *BUILD_SAMPLES*       - specifies whether OCCT MFC samples should be built.
* *BUILD_PATCH_DIR*     - optionally specifies additional folder containing patched OCCT source files.
                        The patch may contain arbitrary subset of OCCT source files (including CMake scripts, templates, etc.), organized in the same structure of folders as OCCT.
                        The projects generated by CMake will use files found in the patch folder instead of the corresponding files of OCCT.

Check variables with <i>USE_</i> prefix (<i>USE_FREEIMAGE, USE_GL2PS, USE_TBB,</i> and 
<i>USE_OPENCL</i>) if you want to enable use of the corresponding optional 3rd-party 
library.

### 3rd-party configuration (The variables with <i>3RDPARTY_</i> prefix)

If you have 3rd-party libraries in a non-default location 
(e.g., on Windows, binaries downloaded from http://www.opencascade.org/getocc/download/3rdparty/") 
*3RDPARTY_DIR* variable should be specified with the path to the folders where required 3rd-party libraries will be sought

The results of search for 3rd-party directories will be stored in *3RDPARTY_\<LIBRARY\>_DIR* variables. If *3RDPARTY_DIR* directory is defined, required libraries are sought in *3RDPARTY_DIR* location.

The procedure expects to find binary and header files of each 3rd-party library in its own sub-directory: *bin*, *lib* and *include*.

Press **Configure** (**c** key for ccmake).

The result of the search are recorded in the corresponding variables:

* *3RDPARTY_\<PRODUCT\>_DIR* - path to the 3rdparty directory (with directory name) (e.g. <i>D:/3rdparty/tcltk-86-32</i>)
* *3RDPARTY_\<PRODUCT\>_LIBRARY_DIR* - path to directory containing a library (e.g. <i>D:/3rdparty/tcltk-86-32/lib</i>). 
* *3RDPARTY_\<PRODUCT\>_INCLUDE_DIR* - path to the directory containing a header file (e.g., <i>D:/3rdparty/tcltk-86-32/include</i>)
* *3RDPARTY_\<PRODUCT\>_DLL_DIR* - path to the directory containing a shared library (e.g., <i>D:/3rdparty/tcltk-86-32/bin</i>) This variable is able just in windows case


Note: a libraries and include directories should be the children of product directory if the last one is defined.

The search process is as follows:

1. Common path: *3RDPARTY_DIR*
2. Path to a particular 3rd-party library: *3RDPARTY_\<PRODUCT\>_DIR*
3. Paths to headers and binaries:
   1. *3RDPARTY_\<PRODUCT\>_INCLUDE_DIR*
   2. *3RDPARTY_\<PRODUCT\>_LIBRARY_DIR*
   3. *3RDPARTY_\<PRODUCT\>_DLL_DIR*

If a variable of any level is not defined (empty or <i> \<variable name\>-NOTFOUND </i>) 
and the upper level variable is defined, the content of the non-defined variable 
will be sought at the next configuration step. If search process at level 3 does not find the required files, it seeks in default places.

Important: If *BUILD_CONFIGURATION* variable is changed, at the next configuration 
*3RDPARTY_ variables* will be replaced by the search process result, except for the *3RDPARTY_DIR* variable.

**Note** : CMake will produce an error after the configuration step until all required variables are defined correctly.
If the search result (include path, or library path, or dll path) does not meet your expectations, 
you can  change *3RDPARTY_\<PRODUCT\>_*_DIR variable*, clear (if they are not empty) 
*3RDPARTY_\<PRODUCT\>_DLL_DIR, 3RDPARTY_\<PRODUCT\>_INCLUDE_DIR* and 3RDPARTY_\<PRODUCT\>_LIBRARY_DIR variables 
(or clear one of them) and run the configuration process again. 

At this time the search will be performed in the newly identified directory 
and the result will be recorded to corresponding variables (replace old value if it is necessary).

For example, (Linux case) *3RDPARTY_FREETYPE_DIR* variable 

    /PRODUCTS/maintenance/Mandriva2010/freetype-2.4.10

can be changed to 

    /PRODUCTS/maintenance/Mandriva2010/freetype-2.5.3

During the configuration process and the related variables (*3RDPARTY_FREETYPE_DLL_DIR*, *3RDPARTY_FREETYPE_INCLUDE_DIR* and *3RDPARTY_FREETYPE_LIBRARY_DIR*) will be filled with new found values

**Note**: The names of searched libraries and header files are hard-coded. If there is the need to change their names,
change appropriate cmake variables (edit CMakeCache.txt file or edit in cmake-gui in advance mode) without reconfiguration: *3RDPARTY_\<PRODUCT\>_INCLUDE* for include, *3RDPARTY_\<PRODUCT\>_LIB* for library and *3RDPARTY_\<PRODUCT\>_DLL* for shared library.

###The variables with INSTALL_ prefix:

Define *INSTALL_DIR* variable as the path will be contain the built OCCT files (libraries, executables and headers)
If <i>INSTALL_\<PRODUCT\></i> variable is checked, 3rd-party products will be copied to the install directory.

At the end of the configuration process "configuring done" message will be shown and the generation process can be started.

## OCCT Generation

This procedure will create makefiles or project files for your build system.

### Windows

Click **Generate** button and wait until the generation process is finished. 
Then the project files will appear in the build folder (e.g. <i> d:/occt/build/win32-vc9-release </i>). 

### Linux

Click **Generate** button (if you use cmake-gui) or press **g** (for ccmake) to start the generation process.

### Mac OS X

Click **Generate** button and wait until the generation process is finished. 
Then the project files will appear in the build folder (e.g. <i> /Developer/occt/build/XCode </i>).

## OCCT Building

The install folder contains the scripts to run *DRAWEXE* (*draw.bat* or *draw.sh*) and samples (if its were built; (see below **MFC samples**)); the directory structure is follow:
* **data**    - data files for OCCT (brep, iges, stp)
* **inc**     - header files
* **samples** - tcl sample files
* **src**     - all required source files for OCCT
* **tests**   - OCCT test suite
* **win32/vc10/bind**> - example relative directory tree of binary files (3rdparty and occt)
* **win32/vc9/lib**>   - example relative directory tree of libraries (3rdparty and occt)

### Windows (Visual studio)

Go to the build folder, start the Visual Studio solution *OCCT.sln* and build it by clicking **Build -> Build Solution**.

When the building process is finished, build the *INSTALL* project (by default the build solution process skips the building of the INSTALL project) to move the above files to *INSTALL_DIR*. 

For this, right-click on the *INSTALL* project and select **Project Only -> Build Only** -> *INSTALL* in the solution explorer. 

### Linux (make)

Change directory to the directory with binaries and run *make* command

       > make 

To copy all libraries, executables and chosen 3rd-party libraries run *make* command with *install* argument

       > make install

This command will move the above files to *INSTALL_DIR*.

### Mac OS X (XCode)

Go to the build folder, start XCode solution *OCCT.xcodeproj* and build it by clicking **Build -> Build**. 
Please notice that XCode may lag because it processes sources at the first start.

When the building process has finished, build the *INSTALL* project (by default the build solution process skips the building of *INSTALL* project) to move the above files to *INSTALL_DIR*. 
Notice that *env.sh* (which configures *PATH* and *DYLD_LIBRARY_PATH* environment variables 
as well as Draw Harness extra variables) and *draw.sh* (to launch *DRAWEXE* ) will be created in the target directory. 

### MFC samples

On Windows you can also build binaries of MFC samples together with OCCT. For this, activate **BUILD_Samples** check-box in CMake configuration dialog.

@figure{/dev_guides/building/cmake/images/cmake_image007.png}

Please take into account that MFC sample binaries will be installed  in the same folder as OCCT binaries during building of *INSTALL* project.
To run an MFC sample use *sample.bat* launcher. The command format is: <i>sample.bat *SampleName*</i> (e.g. <i>sample.bat ImportExport</i>).
