/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg" on Fri May 16 09:57:30 2014

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_43 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def (filter, first, last, 32205, "epsg", 32205,
        "WGS 72 / UTM zone 5N");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.55");
    add_proj4text (p, 1,
        "4,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 5N\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "153],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32205\"]]");
    p = add_epsg_def (filter, first, last, 32206, "epsg", 32206,
        "WGS 72 / UTM zone 6N");
    add_proj4text (p, 0,
        "+proj=utm +zone=6 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.55");
    add_proj4text (p, 1,
        "4,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 6N\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "147],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32206\"]]");
    p = add_epsg_def (filter, first, last, 32207, "epsg", 32207,
        "WGS 72 / UTM zone 7N");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.55");
    add_proj4text (p, 1,
        "4,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 7N\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "141],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32207\"]]");
    p = add_epsg_def (filter, first, last, 32208, "epsg", 32208,
        "WGS 72 / UTM zone 8N");
    add_proj4text (p, 0,
        "+proj=utm +zone=8 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.55");
    add_proj4text (p, 1,
        "4,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 8N\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "135],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32208\"]]");
    p = add_epsg_def (filter, first, last, 32209, "epsg", 32209,
        "WGS 72 / UTM zone 9N");
    add_proj4text (p, 0,
        "+proj=utm +zone=9 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.55");
    add_proj4text (p, 1,
        "4,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 9N\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "129],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32209\"]]");
    p = add_epsg_def (filter, first, last, 32210, "epsg", 32210,
        "WGS 72 / UTM zone 10N");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 10N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-123],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 11,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"32210\"]]");
    p = add_epsg_def (filter, first, last, 32211, "epsg", 32211,
        "WGS 72 / UTM zone 11N");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 11N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-117],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 11,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"32211\"]]");
    p = add_epsg_def (filter, first, last, 32212, "epsg", 32212,
        "WGS 72 / UTM zone 12N");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 12N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-111],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 11,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"32212\"]]");
    p = add_epsg_def (filter, first, last, 32213, "epsg", 32213,
        "WGS 72 / UTM zone 13N");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 13N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-105],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"East");
    add_srs_wkt (p, 11,
        "ing\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"32213\"]]");
    p = add_epsg_def (filter, first, last, 32214, "epsg", 32214,
        "WGS 72 / UTM zone 14N");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 14N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-99],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32214\"]]");
    p = add_epsg_def (filter, first, last, 32215, "epsg", 32215,
        "WGS 72 / UTM zone 15N");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 15N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-93],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32215\"]]");
    p = add_epsg_def (filter, first, last, 32216, "epsg", 32216,
        "WGS 72 / UTM zone 16N");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 16N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-87],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32216\"]]");
    p = add_epsg_def (filter, first, last, 32217, "epsg", 32217,
        "WGS 72 / UTM zone 17N");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 17N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32217\"]]");
    p = add_epsg_def (filter, first, last, 32218, "epsg", 32218,
        "WGS 72 / UTM zone 18N");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 18N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32218\"]]");
    p = add_epsg_def (filter, first, last, 32219, "epsg", 32219,
        "WGS 72 / UTM zone 19N");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 19N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32219\"]]");
    p = add_epsg_def (filter, first, last, 32220, "epsg", 32220,
        "WGS 72 / UTM zone 20N");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 20N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32220\"]]");
    p = add_epsg_def (filter, first, last, 32221, "epsg", 32221,
        "WGS 72 / UTM zone 21N");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 21N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32221\"]]");
    p = add_epsg_def (filter, first, last, 32222, "epsg", 32222,
        "WGS 72 / UTM zone 22N");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 22N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32222\"]]");
    p = add_epsg_def (filter, first, last, 32223, "epsg", 32223,
        "WGS 72 / UTM zone 23N");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 23N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32223\"]]");
    p = add_epsg_def (filter, first, last, 32224, "epsg", 32224,
        "WGS 72 / UTM zone 24N");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 24N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-39],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32224\"]]");
    p = add_epsg_def (filter, first, last, 32225, "epsg", 32225,
        "WGS 72 / UTM zone 25N");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 25N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-33],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32225\"]]");
    p = add_epsg_def (filter, first, last, 32226, "epsg", 32226,
        "WGS 72 / UTM zone 26N");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 26N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-27],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32226\"]]");
    p = add_epsg_def (filter, first, last, 32227, "epsg", 32227,
        "WGS 72 / UTM zone 27N");
    add_proj4text (p, 0,
        "+proj=utm +zone=27 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 27N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-21],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32227\"]]");
    p = add_epsg_def (filter, first, last, 32228, "epsg", 32228,
        "WGS 72 / UTM zone 28N");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 28N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32228\"]]");
    p = add_epsg_def (filter, first, last, 32229, "epsg", 32229,
        "WGS 72 / UTM zone 29N");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 29N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32229\"]]");
    p = add_epsg_def (filter, first, last, 32230, "epsg", 32230,
        "WGS 72 / UTM zone 30N");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 30N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32230\"]]");
    p = add_epsg_def (filter, first, last, 32231, "epsg", 32231,
        "WGS 72 / UTM zone 31N");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 31N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 12,
        "2231\"]]");
    p = add_epsg_def (filter, first, last, 32232, "epsg", 32232,
        "WGS 72 / UTM zone 32N");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 32N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting");
    add_srs_wkt (p, 11,
        "\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"3");
    add_srs_wkt (p, 12,
        "2232\"]]");
    p = add_epsg_def (filter, first, last, 32233, "epsg", 32233,
        "WGS 72 / UTM zone 33N");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 33N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32233\"]]");
    p = add_epsg_def (filter, first, last, 32234, "epsg", 32234,
        "WGS 72 / UTM zone 34N");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 34N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",21],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32234\"]]");
    p = add_epsg_def (filter, first, last, 32235, "epsg", 32235,
        "WGS 72 / UTM zone 35N");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 35N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",27],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32235\"]]");
    p = add_epsg_def (filter, first, last, 32236, "epsg", 32236,
        "WGS 72 / UTM zone 36N");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 36N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",33],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32236\"]]");
    p = add_epsg_def (filter, first, last, 32237, "epsg", 32237,
        "WGS 72 / UTM zone 37N");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 37N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",39],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32237\"]]");
    p = add_epsg_def (filter, first, last, 32238, "epsg", 32238,
        "WGS 72 / UTM zone 38N");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 38N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32238\"]]");
    p = add_epsg_def (filter, first, last, 32239, "epsg", 32239,
        "WGS 72 / UTM zone 39N");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 39N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32239\"]]");
    p = add_epsg_def (filter, first, last, 32240, "epsg", 32240,
        "WGS 72 / UTM zone 40N");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 40N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32240\"]]");
    p = add_epsg_def (filter, first, last, 32241, "epsg", 32241,
        "WGS 72 / UTM zone 41N");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 41N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32241\"]]");
    p = add_epsg_def (filter, first, last, 32242, "epsg", 32242,
        "WGS 72 / UTM zone 42N");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 42N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32242\"]]");
    p = add_epsg_def (filter, first, last, 32243, "epsg", 32243,
        "WGS 72 / UTM zone 43N");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 43N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32243\"]]");
    p = add_epsg_def (filter, first, last, 32244, "epsg", 32244,
        "WGS 72 / UTM zone 44N");
    add_proj4text (p, 0,
        "+proj=utm +zone=44 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 44N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32244\"]]");
    p = add_epsg_def (filter, first, last, 32245, "epsg", 32245,
        "WGS 72 / UTM zone 45N");
    add_proj4text (p, 0,
        "+proj=utm +zone=45 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 45N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",87],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32245\"]]");
    p = add_epsg_def (filter, first, last, 32246, "epsg", 32246,
        "WGS 72 / UTM zone 46N");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 46N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",93],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32246\"]]");
    p = add_epsg_def (filter, first, last, 32247, "epsg", 32247,
        "WGS 72 / UTM zone 47N");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 47N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",99],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32247\"]]");
    p = add_epsg_def (filter, first, last, 32248, "epsg", 32248,
        "WGS 72 / UTM zone 48N");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 48N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",105],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32248\"]]");
    p = add_epsg_def (filter, first, last, 32249, "epsg", 32249,
        "WGS 72 / UTM zone 49N");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 49N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",111],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32249\"]]");
    p = add_epsg_def (filter, first, last, 32250, "epsg", 32250,
        "WGS 72 / UTM zone 50N");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 50N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",117],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32250\"]]");
    p = add_epsg_def (filter, first, last, 32251, "epsg", 32251,
        "WGS 72 / UTM zone 51N");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 51N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",123],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32251\"]]");
    p = add_epsg_def (filter, first, last, 32252, "epsg", 32252,
        "WGS 72 / UTM zone 52N");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 52N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",129],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32252\"]]");
    p = add_epsg_def (filter, first, last, 32253, "epsg", 32253,
        "WGS 72 / UTM zone 53N");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 53N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",135],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32253\"]]");
    p = add_epsg_def (filter, first, last, 32254, "epsg", 32254,
        "WGS 72 / UTM zone 54N");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 54N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",141],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32254\"]]");
    p = add_epsg_def (filter, first, last, 32255, "epsg", 32255,
        "WGS 72 / UTM zone 55N");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 55N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",147],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32255\"]]");
    p = add_epsg_def (filter, first, last, 32256, "epsg", 32256,
        "WGS 72 / UTM zone 56N");
    add_proj4text (p, 0,
        "+proj=utm +zone=56 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 56N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",153],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32256\"]]");
    p = add_epsg_def (filter, first, last, 32257, "epsg", 32257,
        "WGS 72 / UTM zone 57N");
    add_proj4text (p, 0,
        "+proj=utm +zone=57 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 57N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",159],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32257\"]]");
    p = add_epsg_def (filter, first, last, 32258, "epsg", 32258,
        "WGS 72 / UTM zone 58N");
    add_proj4text (p, 0,
        "+proj=utm +zone=58 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 58N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",165],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32258\"]]");
    p = add_epsg_def (filter, first, last, 32259, "epsg", 32259,
        "WGS 72 / UTM zone 59N");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 59N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",171],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32259\"]]");
    p = add_epsg_def (filter, first, last, 32260, "epsg", 32260,
        "WGS 72 / UTM zone 60N");
    add_proj4text (p, 0,
        "+proj=utm +zone=60 +ellps=WGS72 +towgs84=0,0,4.5,0,0,0.5");
    add_proj4text (p, 1,
        "54,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 60N\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",177],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 10,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easti");
    add_srs_wkt (p, 11,
        "ng\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "32260\"]]");
    p = add_epsg_def (filter, first, last, 32301, "epsg", 32301,
        "WGS 72 / UTM zone 1S");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +south +ellps=WGS72 +towgs84=0,0,4.5,0");
    add_proj4text (p, 1,
        ",0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 1S\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "177],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32301\"]]");
    p = add_epsg_def (filter, first, last, 32302, "epsg", 32302,
        "WGS 72 / UTM zone 2S");
    add_proj4text (p, 0,
        "+proj=utm +zone=2 +south +ellps=WGS72 +towgs84=0,0,4.5,0");
    add_proj4text (p, 1,
        ",0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 2S\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "171],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32302\"]]");
    p = add_epsg_def (filter, first, last, 32303, "epsg", 32303,
        "WGS 72 / UTM zone 3S");
    add_proj4text (p, 0,
        "+proj=utm +zone=3 +south +ellps=WGS72 +towgs84=0,0,4.5,0");
    add_proj4text (p, 1,
        ",0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 3S\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "165],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32303\"]]");
    p = add_epsg_def (filter, first, last, 32304, "epsg", 32304,
        "WGS 72 / UTM zone 4S");
    add_proj4text (p, 0,
        "+proj=utm +zone=4 +south +ellps=WGS72 +towgs84=0,0,4.5,0");
    add_proj4text (p, 1,
        ",0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 4S\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "159],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32304\"]]");
    p = add_epsg_def (filter, first, last, 32305, "epsg", 32305,
        "WGS 72 / UTM zone 5S");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +south +ellps=WGS72 +towgs84=0,0,4.5,0");
    add_proj4text (p, 1,
        ",0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 5S\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "153],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32305\"]]");
    p = add_epsg_def (filter, first, last, 32306, "epsg", 32306,
        "WGS 72 / UTM zone 6S");
    add_proj4text (p, 0,
        "+proj=utm +zone=6 +south +ellps=WGS72 +towgs84=0,0,4.5,0");
    add_proj4text (p, 1,
        ",0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 6S\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "147],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32306\"]]");
    p = add_epsg_def (filter, first, last, 32307, "epsg", 32307,
        "WGS 72 / UTM zone 7S");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +south +ellps=WGS72 +towgs84=0,0,4.5,0");
    add_proj4text (p, 1,
        ",0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 7S\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "141],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32307\"]]");
    p = add_epsg_def (filter, first, last, 32308, "epsg", 32308,
        "WGS 72 / UTM zone 8S");
    add_proj4text (p, 0,
        "+proj=utm +zone=8 +south +ellps=WGS72 +towgs84=0,0,4.5,0");
    add_proj4text (p, 1,
        ",0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 8S\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "135],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32308\"]]");
    p = add_epsg_def (filter, first, last, 32309, "epsg", 32309,
        "WGS 72 / UTM zone 9S");
    add_proj4text (p, 0,
        "+proj=utm +zone=9 +south +ellps=WGS72 +towgs84=0,0,4.5,0");
    add_proj4text (p, 1,
        ",0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 9S\",GEOGCS[\"WGS 72\",DATUM[");
    add_srs_wkt (p, 1,
        "\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "129],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32309\"]]");
    p = add_epsg_def (filter, first, last, 32310, "epsg", 32310,
        "WGS 72 / UTM zone 10S");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 10S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-123],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",10000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"32310\"]]");
    p = add_epsg_def (filter, first, last, 32311, "epsg", 32311,
        "WGS 72 / UTM zone 11S");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 11S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-117],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",10000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"32311\"]]");
    p = add_epsg_def (filter, first, last, 32312, "epsg", 32312,
        "WGS 72 / UTM zone 12S");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 12S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-111],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",10000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"32312\"]]");
    p = add_epsg_def (filter, first, last, 32313, "epsg", 32313,
        "WGS 72 / UTM zone 13S");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 13S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-105],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fa");
    add_srs_wkt (p, 9,
        "lse_easting\",500000],PARAMETER[\"false_northing\",10000");
    add_srs_wkt (p, 10,
        "000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS");
    add_srs_wkt (p, 11,
        "[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"32313\"]]");
    p = add_epsg_def (filter, first, last, 32314, "epsg", 32314,
        "WGS 72 / UTM zone 14S");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 14S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-99],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32314\"]]");
    p = add_epsg_def (filter, first, last, 32315, "epsg", 32315,
        "WGS 72 / UTM zone 15S");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 15S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-93],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32315\"]]");
    p = add_epsg_def (filter, first, last, 32316, "epsg", 32316,
        "WGS 72 / UTM zone 16S");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 16S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-87],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32316\"]]");
    p = add_epsg_def (filter, first, last, 32317, "epsg", 32317,
        "WGS 72 / UTM zone 17S");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 17S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32317\"]]");
    p = add_epsg_def (filter, first, last, 32318, "epsg", 32318,
        "WGS 72 / UTM zone 18S");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 18S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32318\"]]");
    p = add_epsg_def (filter, first, last, 32319, "epsg", 32319,
        "WGS 72 / UTM zone 19S");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 19S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32319\"]]");
    p = add_epsg_def (filter, first, last, 32320, "epsg", 32320,
        "WGS 72 / UTM zone 20S");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 20S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32320\"]]");
    p = add_epsg_def (filter, first, last, 32321, "epsg", 32321,
        "WGS 72 / UTM zone 21S");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 21S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32321\"]]");
    p = add_epsg_def (filter, first, last, 32322, "epsg", 32322,
        "WGS 72 / UTM zone 22S");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 22S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32322\"]]");
    p = add_epsg_def (filter, first, last, 32323, "epsg", 32323,
        "WGS 72 / UTM zone 23S");
    add_proj4text (p, 0,
        "+proj=utm +zone=23 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 23S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32323\"]]");
    p = add_epsg_def (filter, first, last, 32324, "epsg", 32324,
        "WGS 72 / UTM zone 24S");
    add_proj4text (p, 0,
        "+proj=utm +zone=24 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 24S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-39],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32324\"]]");
    p = add_epsg_def (filter, first, last, 32325, "epsg", 32325,
        "WGS 72 / UTM zone 25S");
    add_proj4text (p, 0,
        "+proj=utm +zone=25 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 25S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-33],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32325\"]]");
    p = add_epsg_def (filter, first, last, 32326, "epsg", 32326,
        "WGS 72 / UTM zone 26S");
    add_proj4text (p, 0,
        "+proj=utm +zone=26 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 26S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-27],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32326\"]]");
    p = add_epsg_def (filter, first, last, 32327, "epsg", 32327,
        "WGS 72 / UTM zone 27S");
    add_proj4text (p, 0,
        "+proj=utm +zone=27 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 27S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-21],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32327\"]]");
    p = add_epsg_def (filter, first, last, 32328, "epsg", 32328,
        "WGS 72 / UTM zone 28S");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 28S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"32328\"]]");
    p = add_epsg_def (filter, first, last, 32329, "epsg", 32329,
        "WGS 72 / UTM zone 29S");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 29S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32329\"]]");
    p = add_epsg_def (filter, first, last, 32330, "epsg", 32330,
        "WGS 72 / UTM zone 30S");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 30S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32330\"]]");
    p = add_epsg_def (filter, first, last, 32331, "epsg", 32331,
        "WGS 72 / UTM zone 31S");
    add_proj4text (p, 0,
        "+proj=utm +zone=31 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 31S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32331\"]]");
    p = add_epsg_def (filter, first, last, 32332, "epsg", 32332,
        "WGS 72 / UTM zone 32S");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 32S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false");
    add_srs_wkt (p, 9,
        "_easting\",500000],PARAMETER[\"false_northing\",10000000");
    add_srs_wkt (p, 10,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32332\"]]");
    p = add_epsg_def (filter, first, last, 32333, "epsg", 32333,
        "WGS 72 / UTM zone 33S");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 33S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",15],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32333\"]]");
    p = add_epsg_def (filter, first, last, 32334, "epsg", 32334,
        "WGS 72 / UTM zone 34S");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 34S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",21],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32334\"]]");
    p = add_epsg_def (filter, first, last, 32335, "epsg", 32335,
        "WGS 72 / UTM zone 35S");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 35S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",27],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32335\"]]");
    p = add_epsg_def (filter, first, last, 32336, "epsg", 32336,
        "WGS 72 / UTM zone 36S");
    add_proj4text (p, 0,
        "+proj=utm +zone=36 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 36S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",33],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32336\"]]");
    p = add_epsg_def (filter, first, last, 32337, "epsg", 32337,
        "WGS 72 / UTM zone 37S");
    add_proj4text (p, 0,
        "+proj=utm +zone=37 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 37S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",39],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32337\"]]");
    p = add_epsg_def (filter, first, last, 32338, "epsg", 32338,
        "WGS 72 / UTM zone 38S");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 38S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",45],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32338\"]]");
    p = add_epsg_def (filter, first, last, 32339, "epsg", 32339,
        "WGS 72 / UTM zone 39S");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 39S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",51],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32339\"]]");
    p = add_epsg_def (filter, first, last, 32340, "epsg", 32340,
        "WGS 72 / UTM zone 40S");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 40S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",57],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32340\"]]");
    p = add_epsg_def (filter, first, last, 32341, "epsg", 32341,
        "WGS 72 / UTM zone 41S");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 41S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",63],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32341\"]]");
    p = add_epsg_def (filter, first, last, 32342, "epsg", 32342,
        "WGS 72 / UTM zone 42S");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 42S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32342\"]]");
    p = add_epsg_def (filter, first, last, 32343, "epsg", 32343,
        "WGS 72 / UTM zone 43S");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 43S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",75],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32343\"]]");
    p = add_epsg_def (filter, first, last, 32344, "epsg", 32344,
        "WGS 72 / UTM zone 44S");
    add_proj4text (p, 0,
        "+proj=utm +zone=44 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 44S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",81],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32344\"]]");
    p = add_epsg_def (filter, first, last, 32345, "epsg", 32345,
        "WGS 72 / UTM zone 45S");
    add_proj4text (p, 0,
        "+proj=utm +zone=45 +south +ellps=WGS72 +towgs84=0,0,4.5,");
    add_proj4text (p, 1,
        "0,0,0.554,0.2263 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72 / UTM zone 45S\",GEOGCS[\"WGS 72\",DATUM");
    add_srs_wkt (p, 1,
        "[\"WGS_1972\",SPHEROID[\"WGS 72\",6378135,298.26,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7043\"]],TOWGS84[0,0,4.5,0,0,0.554,0.2263]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6322\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4322\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",87],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",1000000");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"32345\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

