/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ast;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.text.Document;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AstCodeGeneration {
    private final AstEditor m_editor;
    private String endOfLine = null;
    public static final String DEFAULT_END_OF_LINE = System.getProperty("line.separator", "\n");

    public AstCodeGeneration(AstEditor editor) {
        this.m_editor = editor;
    }

    private ICompilationUnit getModelUnit() {
        return this.m_editor.getModelUnit();
    }

    public String getIndentation(int levels) {
        int count;
        String indentationChar;
        Assert.isTrue((levels >= 0 ? 1 : 0) != 0);
        if (levels == 0) {
            return "";
        }
        String tabChar = this.getTabChar();
        if (tabChar != null && tabChar.toLowerCase().equals("space")) {
            indentationChar = " ";
            count = 4;
            try {
                String tabSize = this.getTabSize();
                count = Integer.parseInt(tabSize);
            }
            catch (Throwable throwable) {}
        } else {
            indentationChar = "\t";
            count = 1;
        }
        return StringUtils.repeat((String)indentationChar, (int)(count * levels));
    }

    public String getEndOfLine() throws Exception {
        if (this.endOfLine == null) {
            this.endOfLine = DEFAULT_END_OF_LINE;
            this.endOfLine = AstCodeGeneration.getEndOfLineForBuffer(this.m_editor.getBuffer());
        }
        return this.endOfLine;
    }

    public String getMethodBraceSeparator(String prefix) throws Exception {
        if (this.getInsertEndOfLineBeforeOpeningBrace()) {
            return String.valueOf(this.getEndOfLine()) + prefix;
        }
        return " ";
    }

    private static String getEndOfLineForBuffer(Document document) throws Exception {
        Set existingMarkers = Sets.newTreeSet();
        int numberOfLines = document.getNumberOfLines();
        int i = 0;
        while (i < numberOfLines) {
            String delimiter = document.getLineDelimiter(i);
            if (delimiter != null) {
                existingMarkers.add(delimiter);
            }
            ++i;
        }
        if (existingMarkers.isEmpty() || existingMarkers.contains(DEFAULT_END_OF_LINE)) {
            return DEFAULT_END_OF_LINE;
        }
        return (String)existingMarkers.iterator().next();
    }

    public boolean getInsertEndOfLineBeforeOpeningBrace() {
        Map<String, String> javaOptions = this.getJavaOptions();
        String value = javaOptions.get("org.eclipse.jdt.core.formatter.brace_position_for_method_declaration");
        return value != null && value.equals("next_line");
    }

    public String getTabChar() {
        Map<String, String> javaOptions = this.getJavaOptions();
        return javaOptions.get("org.eclipse.jdt.core.formatter.tabulation.char");
    }

    public String getTabSize() {
        Map<String, String> javaOptions = this.getJavaOptions();
        return javaOptions.get("org.eclipse.jdt.core.formatter.tabulation.size");
    }

    public boolean getUseCompactAssignment() {
        Map<String, String> javaOptions = this.getJavaOptions();
        String value = javaOptions.get("org.eclipse.jdt.core.formatter.insert_space_before_assignment_operator");
        return value != null && !value.equals("insert");
    }

    private Map<String, String> getJavaOptions() {
        return ProjectUtils.getOptions(this.getModelUnit().getJavaProject());
    }
}

