/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jarjar.com.google.common.collect;

import org.gradle.jarjar.com.google.common.annotations.GwtCompatible;
import org.gradle.jarjar.com.google.common.annotations.GwtIncompatible;
import org.gradle.jarjar.com.google.common.collect.ImmutableAsList;
import org.gradle.jarjar.com.google.common.collect.ImmutableCollection;
import org.gradle.jarjar.com.google.common.collect.ImmutableList;
import org.gradle.jarjar.com.google.common.collect.UnmodifiableListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
class RegularImmutableAsList<E>
extends ImmutableAsList<E> {
    private final ImmutableCollection<E> delegate;
    private final ImmutableList<? extends E> delegateList;

    RegularImmutableAsList(ImmutableCollection<E> delegate, ImmutableList<? extends E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate, Object[] array) {
        this(delegate, ImmutableList.asImmutableList(array));
    }

    @Override
    ImmutableCollection<E> delegateCollection() {
        return this.delegate;
    }

    ImmutableList<? extends E> delegateList() {
        return this.delegateList;
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return this.delegateList.listIterator(index);
    }

    @Override
    @GwtIncompatible(value="not present in emulated superclass")
    int copyIntoArray(Object[] dst, int offset) {
        return this.delegateList.copyIntoArray(dst, offset);
    }

    @Override
    public E get(int index) {
        return this.delegateList.get(index);
    }
}

