/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.configuration.internal;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.gradleware.tooling.toolingmodel.Path;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.util.collections.CollectionsUtils;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.core.util.gradle.GradleDistributionSerializer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

final class ProjectConfigurationPersistence {
    private static final String PROJECT_PATH = "project_path";
    private static final String PROJECT_DIR = "project_dir";
    private static final String CONNECTION_PROJECT_DIR = "connection_project_dir";
    private static final String CONNECTION_GRADLE_USER_HOME = "connection_gradle_user_home";
    private static final String CONNECTION_GRADLE_DISTRIBUTION = "connection_gradle_distribution";
    private static final String CONNECTION_JAVA_HOME = "connection_java_home";
    private static final String CONNECTION_JVM_ARGUMENTS = "connection_jvm_arguments";
    private static final String CONNECTION_ARGUMENTS = "connection_arguments";
    private static final String ECLIPSE_SETTINGS_FOLDER = ".settings";
    private static final String GRADLE_PREFERENCES_FILE = "gradle.prefs";
    private static final String GRADLE_PREFERENCES_FILE_WITHOUT_EXTENSION = "gradle.prefs".substring(0, "gradle.prefs".indexOf(46));

    ProjectConfigurationPersistence() {
    }

    public void saveProjectConfiguration(ProjectConfiguration projectConfiguration, IProject workspaceProject) {
        LinkedHashMap projectConfig = Maps.newLinkedHashMap();
        projectConfig.put(PROJECT_PATH, projectConfiguration.getProjectPath().getPath());
        projectConfig.put(PROJECT_DIR, projectConfiguration.getProjectDir().getAbsolutePath());
        projectConfig.put(CONNECTION_PROJECT_DIR, projectConfiguration.getRequestAttributes().getProjectDir().getAbsolutePath());
        projectConfig.put(CONNECTION_GRADLE_USER_HOME, FileUtils.getAbsolutePath(projectConfiguration.getRequestAttributes().getGradleUserHome()).orNull());
        projectConfig.put(CONNECTION_GRADLE_DISTRIBUTION, GradleDistributionSerializer.INSTANCE.serializeToString(projectConfiguration.getRequestAttributes().getGradleDistribution()));
        projectConfig.put(CONNECTION_JAVA_HOME, FileUtils.getAbsolutePath(projectConfiguration.getRequestAttributes().getJavaHome()).orNull());
        projectConfig.put(CONNECTION_JVM_ARGUMENTS, CollectionsUtils.joinWithSpace(projectConfiguration.getRequestAttributes().getJvmArguments()));
        projectConfig.put(CONNECTION_ARGUMENTS, CollectionsUtils.joinWithSpace(projectConfiguration.getRequestAttributes().getArguments()));
        LinkedHashMap config = Maps.newLinkedHashMap();
        config.put("1.0", projectConfig);
        Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        String json = gson.toJson((Object)config, this.createMapTypeToken());
        try {
            IFile configFile = this.createConfigFile(workspaceProject);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(json.getBytes(Charsets.UTF_8));
            if (configFile.exists()) {
                configFile.setContents((InputStream)inputStream, true, false, null);
            } else {
                configFile.create((InputStream)inputStream, true, null);
            }
        }
        catch (CoreException e) {
            String message = String.format("Cannot persist Gradle configuration for project %s.", workspaceProject.getName());
            CorePlugin.logger().error(message, e);
            throw new GradlePluginsRuntimeException(message, (Exception)((Object)e));
        }
    }

    private IFile createConfigFile(IProject workspaceProject) throws CoreException {
        IFolder folder = workspaceProject.getFolder(ECLIPSE_SETTINGS_FOLDER);
        FileUtils.ensureFolderHierarchyExists(folder);
        return folder.getFile(GRADLE_PREFERENCES_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectConfiguration readProjectConfiguration(IProject workspaceProject) {
        String json;
        try {
            IFile configFile = this.getConfigFile(workspaceProject);
            InputStream inputStream = configFile.getContents(true);
            try {
                json = CharStreams.toString((Readable)new InputStreamReader(inputStream, Charsets.UTF_8));
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
        catch (Exception e) {
            String message = String.format("Cannot read Gradle configuration for project %s.", workspaceProject.getName());
            CorePlugin.logger().error(message, e);
            throw new GradlePluginsRuntimeException(message, e);
        }
        Gson gson = new GsonBuilder().create();
        Map config = (Map)gson.fromJson(json, this.createMapTypeToken());
        Map<String, String> projectConfig = this.getProjectConfigForVersion(config);
        FixedRequestAttributes requestAttributes = new FixedRequestAttributes(new File(projectConfig.get(CONNECTION_PROJECT_DIR)), (File)FileUtils.getAbsoluteFile(projectConfig.get(CONNECTION_GRADLE_USER_HOME)).orNull(), GradleDistributionSerializer.INSTANCE.deserializeFromString(projectConfig.get(CONNECTION_GRADLE_DISTRIBUTION)), (File)FileUtils.getAbsoluteFile(projectConfig.get(CONNECTION_JAVA_HOME)).orNull(), CollectionsUtils.splitBySpace(projectConfig.get(CONNECTION_JVM_ARGUMENTS)), CollectionsUtils.splitBySpace(projectConfig.get(CONNECTION_ARGUMENTS)));
        return ProjectConfiguration.from(requestAttributes, Path.from((String)projectConfig.get(PROJECT_PATH)), new File(projectConfig.get(PROJECT_DIR)));
    }

    private IFile getConfigFile(IProject workspaceProject) throws CoreException {
        return workspaceProject.getFolder(ECLIPSE_SETTINGS_FOLDER).getFile(GRADLE_PREFERENCES_FILE);
    }

    private Type createMapTypeToken() {
        return new TypeToken<Map<String, Object>>(){}.getType();
    }

    private Map<String, String> getProjectConfigForVersion(Map<String, Object> config) {
        return (Map)config.get("1.0");
    }

    public void deleteProjectConfiguration(IProject workspaceProject) {
        try {
            IFile configFile = this.getConfigFile(workspaceProject);
            ProjectConfigurationPersistence.ensureNoProjectPreferencesLoadedFrom(workspaceProject, GRADLE_PREFERENCES_FILE_WITHOUT_EXTENSION);
            ProjectConfigurationPersistence.deleteConfigFileIfExistsAndSettingsFolderIfEmpty(configFile);
        }
        catch (Exception e) {
            String message = String.format("Cannot delete Gradle configuration for project %s.", workspaceProject.getName());
            CorePlugin.logger().error(message, e);
            throw new GradlePluginsRuntimeException(message, e);
        }
    }

    private static void ensureNoProjectPreferencesLoadedFrom(IProject project, String preferenceNodeName) throws BackingStoreException {
        ProjectScope projectScope = new ProjectScope(project);
        IEclipsePreferences node = projectScope.getNode(preferenceNodeName);
        if (node != null) {
            node.removeNode();
        }
    }

    private static void deleteConfigFileIfExistsAndSettingsFolderIfEmpty(IFile configFile) throws CoreException {
        if (configFile.exists()) {
            configFile.delete(true, false, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

